/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.signmgt;

import java.util.Date;
import java.util.Locale;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.common.enums.ElectricSignFormIdEnum;
import kd.hr.hlcm.common.enums.PaperSignFormIdEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.utils.DateUtil;

public class SignCommonListPlugin
extends HRDataBaseList {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object primaryKeyValue = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        DynamicObject signDy = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_signmanagebase", (String)"signway,empname,protocoltype,businessstatus", (Object)primaryKeyValue);
        if (signDy == null) {
            return;
        }
        String businessStatus = signDy.getString("businessstatus");
        String name = signDy.getString("empname");
        String protocolType = signDy.getString("protocoltype");
        String signWay = signDy.getString("signway");
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId(primaryKeyValue);
        String caption = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u7b7e\u7f72\uff1a%2$s", (String)"SignCommonListPlugin_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), ProtocolTypeEnum.loadKDStringByKey((String)protocolType), name);
        billShowParameter.setCaption(caption);
        if (HRStringUtils.equals((String)"2", (String)signWay)) {
            billShowParameter.setFormId(PaperSignFormIdEnum.getFormIdByStatus((String)businessStatus));
        } else {
            billShowParameter.setFormId(ElectricSignFormIdEnum.getFormIdByStatus((String)businessStatus));
        }
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String pageId = String.format(Locale.ROOT, "%s_%s_%d_%d", this.getView().getPageId(), billShowParameter.getFormId(), primaryKeyValue.hashCode(), RequestContext.get().getCurrUserId());
        billShowParameter.setPageId(pageId);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void packageData(PackageDataEvent event) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"remaintime")) {
            DynamicObject rowDy = event.getRowData();
            Date deadLine = rowDy.getDate("deadline");
            String status = null;
            try {
                status = rowDy.getString("handlestatus");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (deadLine != null && HRStringUtils.equals((String)"2", (String)status)) {
                event.setFormatValue((Object)DateUtil.getDateDiff((Date)new Date(), (Date)deadLine));
            } else {
                event.setFormatValue((Object)"");
            }
        }
    }
}

