/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.signmgt;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.business.service.ContractTplService;
import kd.hr.hlcm.business.utils.AttachmentUtils;
import kd.hr.hlcm.business.utils.ProxyUtils;
import kd.hr.hlcm.business.utils.SignListPermissionUtils;
import kd.hr.hlcm.common.enums.ActivityStatusEnum;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.ProbationUnitEnum;
import kd.hr.hlcm.common.enums.ProcessStatusEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.common.utils.HeadCardUtil;
import kd.hr.hlcm.formplugin.signmgt.SignActivityHelper;
import kd.hr.hlcm.formplugin.utils.CardInfoHelper;

public class SignManageBasePlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(SignManageBasePlugin.class);
    private static final String OLD_CONTRACTPANEL = "oldcontractpanelap";
    private static final String PANEL_NEW = "newpanel";
    private static final String PANEL_RENEW = "renewpanel";
    private static final String PANEL_CHANGE = "changepanel";
    private static final String PANEL_TOSIGN = "tosignpanelap";
    private static final String PANEL_MAINCON = "mianconpanelap";
    private static final String STOPINFO_PANELAP = "stopinfopanelap";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IFormView formView = this.getView();
        CardInfoHelper.getInstance().setMainConInfo(dataEntity, formView);
        this.setDefaultViewValue();
        AttachmentUtils.bindAttachment((IFormView)formView);
        this.setButtonVisible();
        this.setStopFlexView();
    }

    private void setStopFlexView() {
        String handleStatus = (String)this.getModel().getValue("handlestatus");
        if (HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.PROCESSEND.getCombKey())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{STOPINFO_PANELAP});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{STOPINFO_PANELAP});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        HeadCardUtil.showBillHeadView((IFormView)view, (DynamicObject)model.getDataEntity(), (String)"3");
        try {
            String showway = (String)this.getView().getFormShowParameter().getCustomParam("showway");
            if (HRStringUtils.equals((String)"hstc", (String)showway)) {
                view.setVisible(Boolean.FALSE, new String[]{"titlepanel"});
            }
        }
        catch (Exception exe) {
            LOGGER.error("SignManageBasePlugin.afterBindData", (Throwable)exe);
        }
        this.setConTempBtnView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String proStatus;
        Object customParam;
        DynamicObject activityDy;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (!this.checkPermission(operateKey, this.getModel().getDataEntity().getPkValue())) {
            args.setCancel(true);
            return;
        }
        if ("stopsign".equals(operateKey) && (activityDy = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_activity", (String)"processstatus", (Object)(customParam = this.getView().getFormShowParameter().getCustomParam("activity")))) != null && (HRStringUtils.equals((String)(proStatus = activityDy.getString("processstatus")), (String)"1") || HRStringUtils.equals((String)proStatus, (String)"2"))) {
            String comboStr = SignActivityHelper.getComboStr(this.getView().getParentView(), proStatus);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u53ef\u7ec8\u6b62\u7b7e\u7f72\u3002", (String)"SignActivityComListPlugin_4", (String)"hr-hlcm-formplugin", (Object[])new Object[]{comboStr}));
            args.setCancel(true);
        }
    }

    private boolean checkPermission(String operateKey, Object pkValue) {
        String entityId = this.getView().getEntityId();
        String listFormId = SignTabEnum.getListFormIdByFormId((String)entityId);
        String tableName = SignTabEnum.getTableNameByListFormId((String)listFormId);
        String operateName = "";
        boolean permissionResult = true;
        boolean dataRuleResult = true;
        if ("stopsign".equals(operateKey)) {
            operateName = ResManager.loadKDString((String)"\u7ec8\u6b62\u7b7e\u7f72", (String)"SignManageBasePlugin_12", (String)"hr-hlcm-formplugin", (Object[])new Object[]{tableName});
            permissionResult = SignListPermissionUtils.checkStopSignPermission((String)listFormId);
            dataRuleResult = SignListPermissionUtils.checkStopSignDataRulePermission((String)listFormId, (Object)pkValue);
        } else if ("beginsign".equals(operateKey)) {
            operateName = ResManager.loadKDString((String)"\u53d1\u8d77\u7b7e\u7f72", (String)"SignManageBasePlugin_13", (String)"hr-hlcm-formplugin", (Object[])new Object[]{tableName});
            permissionResult = SignListPermissionUtils.checkBeginSignPermission((String)listFormId);
            dataRuleResult = SignListPermissionUtils.checkBeginSignDataRulePermission((String)listFormId, (Object)pkValue);
        } else {
            LOGGER.warn("operateKey|{}", (Object)operateKey);
        }
        if (!permissionResult) {
            this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SignManageBasePlugin_14", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), tableName, operateName));
            return false;
        }
        if (!dataRuleResult) {
            this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u201c%1$s\u201d\u201c%2$s\u201d\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SignManageBasePlugin_15", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), operateName, tableName));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String attachmentUrl;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        boolean empty = !HRObjectUtils.isEmpty((Object)operationResult);
        boolean equals = HRStringUtils.equals((String)"stopsign", (String)operateKey);
        if (equals && empty && operationResult.isSuccess()) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hlcm_stopsign");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "stop");
            formShowParameter.setCloseCallBack(closeCallBack);
            formShowParameter.setCustomParam("id", this.getModel().getDataEntity().getPkValue());
            formShowParameter.setCustomParam("activity", this.getView().getFormShowParameter().getCustomParam("activity"));
            this.getView().showForm(formShowParameter);
        }
        if (HRStringUtils.equals((String)operateKey, (String)"topcontractdownload")) {
            attachmentUrl = this.getContractAttachmentUrl(true);
            if (HRStringUtils.isEmpty((String)attachmentUrl)) {
                return;
            }
            String downloadRealUrl = ProxyUtils.attachmentDownloadRealUrl((String)attachmentUrl);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getModel().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)downloadRealUrl);
        } else if (HRStringUtils.equals((String)operateKey, (String)"topcontractpreview")) {
            attachmentUrl = this.getContractAttachmentUrl(false);
            String previewRealUrl = ProxyUtils.attachmentPreviewRealUrl((String)attachmentUrl);
            this.getView().openUrl(previewRealUrl);
        }
    }

    private String getContractAttachmentUrl(boolean downloadOrPreview) {
        String attachmentUrl = "";
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryEntities = dataModel.getEntryEntity("entryentity");
        for (int index = 0; index < entryEntities.size(); ++index) {
            DynamicObject entryEntity = (DynamicObject)entryEntities.get(index);
            if (!this.isContractType(entryEntity)) continue;
            attachmentUrl = ContractTplService.getPreviewOrDownloadUrl((int)index, (boolean)downloadOrPreview, (IFormView)this.getView(), (IDataModel)this.getModel());
        }
        return attachmentUrl;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (HRStringUtils.equals((String)"stop", (String)actionId) && returnData != null && HRStringUtils.equals((String)"success", (String)returnData.toString())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u7b7e\u7f72\u6210\u529f\u3002", (String)"SignManageBasePlugin_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private void setButtonVisible() {
        IFormView formView = this.getView();
        String handleStatus = this.getModel().getDataEntity().getString("handlestatus");
        if (HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.PROCESSEND.getCombKey())) {
            formView.setVisible(Boolean.FALSE, new String[]{"companysign", "beginsign", "compsign", "stopsign", "confirmarchive"});
            return;
        }
        String formId = formView.getFormShowParameter().getFormId();
        List<String> excludeForm = Arrays.asList(SignTabEnum.P_STOP.getSourceListFormId(), SignTabEnum.P_ARCHIVE.getSourceListFormId(), SignTabEnum.E_STOP.getSourceListFormId(), SignTabEnum.E_ARCHIVE.getSourceListFormId());
        if (excludeForm.contains(formId)) {
            return;
        }
        SignTabEnum signEnum = SignTabEnum.getSignEnum((String)formId);
        String listFormId = signEnum.getListFormId();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        QFilter[] filters = new QFilter[]{new QFilter("activity.id", "=", (Object)signEnum.getActivityId()), new QFilter("signapply.id", "=", (Object)dataEntity.getLong("id"))};
        DynamicObject activity = CommonRepository.queryOne((String)"hlcm_activity", (String)"processstatus", (QFilter[])filters);
        if (activity == null) {
            return;
        }
        String processStatus = activity.getString("processstatus");
        switch (signEnum) {
            case E_BEGIN: 
            case P_BEGIN: {
                boolean beginSignVisible;
                this.stopButtonVisible(formView, listFormId, processStatus);
                ActivityStatusEnum activityStatusEnum = ISignManageService.getInstance().getActivityStatusEnum(dataEntity);
                boolean bl = beginSignVisible = ISignManageService.getInstance().isAbleBeginSign(activityStatusEnum) && SignListPermissionUtils.checkBeginSignPermission((String)listFormId);
                if (beginSignVisible) break;
                formView.setVisible(Boolean.FALSE, new String[]{"beginsign"});
                break;
            }
            case E_CONFIRM: 
            case E_ESIGN: {
                this.stopButtonVisible(formView, listFormId, processStatus);
                break;
            }
            case E_CSIGN: {
                boolean companySignVisible;
                this.stopButtonVisible(formView, listFormId, processStatus);
                boolean bl = companySignVisible = HRStringUtils.equals((String)processStatus, (String)ProcessStatusEnum.PENDING.getValue()) && SignListPermissionUtils.checkCSignSignPermission((String)listFormId);
                if (companySignVisible) break;
                formView.setVisible(Boolean.FALSE, new String[]{"companysign"});
                break;
            }
            case E_CHECK: 
            case P_CHECK: {
                boolean archiveVisible;
                boolean bl = archiveVisible = HRStringUtils.equals((String)processStatus, (String)ProcessStatusEnum.PENDING.getValue()) && SignListPermissionUtils.checkArchiveSignPermission((String)listFormId);
                if (archiveVisible) break;
                formView.setVisible(Boolean.FALSE, new String[]{"confirmarchive"});
                break;
            }
            case P_COMP: {
                boolean compSignVisible;
                this.stopButtonVisible(formView, listFormId, processStatus);
                boolean bl = compSignVisible = HRStringUtils.equals((String)processStatus, (String)ProcessStatusEnum.PENDING.getValue()) && SignListPermissionUtils.checkCompSignPermission((String)listFormId);
                if (compSignVisible) break;
                formView.setVisible(Boolean.FALSE, new String[]{"compsign"});
                break;
            }
        }
    }

    private void setConTempBtnView() {
        if (ProtocolTypeEnum.CON.getCombKey().equals(this.getModel().getDataEntity().getString("protocoltype")) && Arrays.asList(BusinessTypeEnum.NEW.getCombKey(), BusinessTypeEnum.RENEW.getCombKey(), BusinessTypeEnum.CHANGE.getCombKey()).contains(this.getModel().getDataEntity().getString("businesstype"))) {
            DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
            for (int index = 0; index < entryEntities.size(); ++index) {
                DynamicObject entryEntity = (DynamicObject)entryEntities.get(index);
                if (!this.isContractType(entryEntity)) continue;
                Object contractTemplate = entryEntity.get("contracttemplate");
                if (HRObjectUtils.isEmpty((Object)contractTemplate)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"templatebtnflex", "sidecontractflex", "sidecontractflex1"});
                    continue;
                }
                String fileName = entryEntity.getString("attachmentfield1");
                this.getView().setVisible(Boolean.valueOf(HRStringUtils.isNotEmpty((String)fileName)), new String[]{"templatebtnflex", "sidecontractflex", "sidecontractflex1"});
            }
        }
        if (!ProtocolTypeEnum.CON.getCombKey().equals(this.getModel().getDataEntity().getString("protocoltype"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"templatebtnflex", "sidecontractflex", "sidecontractflex1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"empsignstatus", "compsignstatus", "issignother", "otherprotocol", "contractremark", "contractemplatehis"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryempsignstatus", "entryattachment", "entrycompsignstatus", "entrycontractnumber", "entrycontracttype", "entryperiodtype", "entrystartdate", "entryperiod", "entryperiodunit", "entryenddate"});
            HashMap<String, String> nameValueMap = new HashMap<String, String>();
            String containerName = ResManager.loadKDString((String)"\u5408\u540c\u7b7e\u7f72\u6a21\u677f", (String)"SignManageBasePlugin_20", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
            nameValueMap.put("zh_CN", containerName);
            nameValueMap.put("en_US", containerName);
            HashMap<String, HashMap<String, String>> controlConfigMap = new HashMap<String, HashMap<String, String>>();
            controlConfigMap.put("text", nameValueMap);
            this.getView().updateControlMetadata("contractsigntemp", controlConfigMap);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"contempnumber", "contempnumberhis", "contemptype", "contemptypehis", "contracttypecat", "signwaytemp", "signwaytemphis", "econfig", "econfighis"});
        }
    }

    private boolean isContractType(DynamicObject entryEntity) {
        DynamicObject entryContractType = entryEntity.getDynamicObject("entrycontracttype");
        if (HRObjectUtils.isEmpty((Object)entryContractType)) {
            LOGGER.info("entryContractType is empty");
            return false;
        }
        return ContractTypeCatEnum.CON.getPkId() == entryContractType.getLong("group.id");
    }

    private void stopButtonVisible(IFormView formView, String listFormId, String processStatus) {
        String handleStatus = (String)this.getModel().getValue("handlestatus");
        boolean handleStatusBoolean = HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.PROCESSEND.getCombKey());
        if (handleStatusBoolean) {
            formView.setVisible(Boolean.FALSE, new String[]{"companysign", "beginsign", "compsign"});
        }
        boolean processStatusBoolean = HRStringUtils.equals((String)processStatus, (String)ProcessStatusEnum.PROCESSED.getValue());
        boolean permissionBoolean = SignListPermissionUtils.checkStopSignPermission((String)listFormId);
        if (handleStatusBoolean || processStatusBoolean || !permissionBoolean) {
            formView.setVisible(Boolean.FALSE, new String[]{"stopsign"});
        }
    }

    private void setDefaultViewValue() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject dataEntity = model.getDataEntity();
        String businessType = dataEntity.getString("businesstype");
        String protocolType = dataEntity.getString("protocoltype");
        switch (businessType) {
            case "1": {
                if (HRStringUtils.equals((String)"1", (String)protocolType)) {
                    view.setVisible(Boolean.FALSE, new String[]{OLD_CONTRACTPANEL, PANEL_RENEW, PANEL_CHANGE, PANEL_NEW, PANEL_MAINCON});
                    view.setVisible(Boolean.FALSE, new String[]{"signreason"});
                    BigDecimal probationPeriod = dataEntity.getBigDecimal("probationperiod");
                    String probationUnit = dataEntity.getString("probationunit");
                    if (probationPeriod.compareTo(BigDecimal.ZERO) == 0 || !HRStringUtils.isNotEmpty((String)probationUnit)) break;
                    String probationPeriodUnit = probationPeriod.setScale(0, RoundingMode.HALF_UP) + ProbationUnitEnum.getValueByKey((String)probationUnit);
                    model.setValue("probationperiodunit", (Object)probationPeriodUnit);
                    break;
                }
                if (HRStringUtils.equals((String)"3", (String)protocolType)) {
                    view.setVisible(Boolean.FALSE, new String[]{OLD_CONTRACTPANEL, PANEL_RENEW, PANEL_CHANGE, PANEL_NEW});
                    view.setVisible(Boolean.FALSE, new String[]{"probationstartdate", "probationenddate", "probationperiodunit"});
                    break;
                }
                if (HRStringUtils.equals((String)"2", (String)protocolType)) {
                    view.setVisible(Boolean.FALSE, new String[]{OLD_CONTRACTPANEL, PANEL_RENEW, PANEL_CHANGE, PANEL_NEW, PANEL_MAINCON});
                    view.setVisible(Boolean.FALSE, new String[]{"probationstartdate", "probationenddate", "probationperiodunit"});
                    break;
                }
                LOGGER.warn("protocolType|{}", (Object)protocolType);
                break;
            }
            case "2": {
                view.setVisible(Boolean.FALSE, new String[]{OLD_CONTRACTPANEL, PANEL_NEW, PANEL_CHANGE, PANEL_TOSIGN, PANEL_MAINCON});
                CardInfoHelper.getInstance().setRenewConInfo(model, view);
                break;
            }
            case "3": {
                view.setVisible(Boolean.FALSE, new String[]{OLD_CONTRACTPANEL, PANEL_NEW, PANEL_RENEW, PANEL_TOSIGN, PANEL_MAINCON});
                CardInfoHelper.getInstance().setChangeConInfo(model, view);
                break;
            }
            case "4": 
            case "5": 
            case "6": {
                view.setVisible(Boolean.FALSE, new String[]{PANEL_CHANGE, PANEL_NEW, PANEL_RENEW, PANEL_TOSIGN, PANEL_MAINCON});
                this.setCSPView();
                break;
            }
        }
    }

    private void setCSPView() {
        String businessType;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (businessType = dataEntity.getString("businesstype")) {
            case "4": {
                this.setTitleByStatus(ResManager.loadKDString((String)"\u89e3\u9664\u5408\u540c\u4fe1\u606f", (String)"SignManageBasePlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"SignManageBasePlugin_17", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u89e3\u9664\u65e5\u671f", (String)"SignManageBasePlugin_8", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("signeddateforcancel", dataEntity.get("signeddate"));
                this.getModel().setValue("contracttypeforcancel", dataEntity.get("contracttype"));
                this.getModel().setValue("signwayforcancel", dataEntity.get("signway"));
                HashMap<String, LocaleString> propsFlex = new HashMap<String, LocaleString>(1);
                propsFlex.put("text", new LocaleString(String.format(ResManager.loadKDString((String)"\u5f85\u65b0\u7b7e\u7684%1$s\u89e3\u9664\u534f\u8bae", (String)"SignManageBasePlugin_16", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), ProtocolTypeEnum.loadKDStringByKey((String)dataEntity.getString("protocoltype")))));
                IFormView view = this.getView();
                view.updateControlMetadata("contractsigntemp", propsFlex);
                BasedataEdit textCtl = (BasedataEdit)view.getControl("cancelreasontype");
                textCtl.setCaption(new LocaleString(ResManager.loadKDString((String)"\u89e3\u9664\u539f\u56e0", (String)"SignManageBasePlugin_18", (String)"hr-hlcm-formplugin", (Object[])new Object[0])));
                break;
            }
            case "5": {
                this.setTitleByStatus(ResManager.loadKDString((String)"\u7ec8\u6b62\u5408\u540c\u4fe1\u606f", (String)"SignManageBasePlugin_4", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"SignManageBasePlugin_17", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u7ec8\u6b62\u65e5\u671f", (String)"SignManageBasePlugin_9", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                BasedataEdit textCtlStop = (BasedataEdit)this.getView().getControl("cancelreasontype");
                textCtlStop.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7ec8\u6b62\u539f\u56e0", (String)"SignManageBasePlugin_19", (String)"hr-hlcm-formplugin", (Object[])new Object[0])));
                break;
            }
            case "6": {
                this.setTitleByStatus(ResManager.loadKDString((String)"\u987a\u5ef6\u5408\u540c\u4fe1\u606f", (String)"SignManageBasePlugin_6", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"SignManageBasePlugin_17", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u987a\u5ef6\u7ed3\u675f\u65e5\u671f", (String)"SignManageBasePlugin_10", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void setTitleByStatus(String flexCaption, String markCaption, String dateCaption) {
        HashMap<String, LocaleString> propsFlex = new HashMap<String, LocaleString>(1);
        propsFlex.put("text", new LocaleString(flexCaption));
        IFormView view = this.getView();
        view.updateControlMetadata(OLD_CONTRACTPANEL, propsFlex);
        TextEdit textCtl = (TextEdit)view.getControl("cancelreason");
        textCtl.setCaption(new LocaleString(markCaption));
        DateEdit control = (DateEdit)view.getControl("canceldate");
        control.setCaption(new LocaleString(dateCaption));
    }
}

