/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.signmgt;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.BosUserRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.activity.ISignActivity;
import kd.hr.hlcm.business.mq.MsgCollaborationProducer;
import kd.hr.hlcm.business.prewarn.SyncStartStatusService;
import kd.hr.hlcm.business.utils.SignListPermissionUtils;
import kd.hr.hlcm.common.enums.AuditStatusEnum;
import kd.hr.hlcm.common.enums.BillStatusEnum;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.EmpCompSignStatusEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.ProcessStatusEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.enums.SignStatusEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.formplugin.signmgt.SignActivityHelper;

public class StopSignDynamicPlugin
extends HRDataBaseEdit {
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String STOPREASON_ID = "stopreason.id";
    private static final String REMARK = "remark";
    private static final Log LOGGER = LogFactory.getLog(StopSignDynamicPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click(EventObject evt) {
        super.click(evt);
        Object object = evt.getSource();
        if (!(object instanceof Button)) {
            return;
        }
        Button button = (Button)object;
        String key = button.getKey();
        if (HRStringUtils.equals((String)BTN_CONFIRM, (String)key)) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            Object customParam = view.getFormShowParameter().getCustomParam("id");
            String showWay = (String)view.getFormShowParameter().getCustomParam("showway");
            String entityId = (String)view.getFormShowParameter().getCustomParam("entityId");
            Long pkValue = HRJSONUtils.getLongValOfCustomParam((Object)customParam);
            String keyLock = "hlcm_stopsign/" + pkValue;
            DLock dl = DLock.create((String)keyLock);
            dl.lock();
            try {
                if (this.stopStatusValidate() || this.stopReasonValidate()) {
                    return;
                }
                boolean isHstc = HRStringUtils.equals((String)"hstc", (String)showWay);
                LOGGER.info("showway|{},entityId|{}", (Object)showWay, (Object)entityId);
                if (isHstc && !this.sscStopSignProcession(entityId) || !isHstc && !this.stopSignProcession()) {
                    return;
                }
                DynamicObject signDy = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_signmanagebase", (String)"employee,person,postype,empnumber,protocoltype,businesstype,empname,terminatereason,terminatereasondesc,terminatedate,terminateperson,businessstatus,auditstatus,billstatus,handlestatus,signstatus,empsignstatus,compsignstatus,entryentity.entryempsignstatus,entryentity.entrycompsignstatus", (Object)pkValue);
                try (TXHandle txHandle = TX.required();){
                    signDy.set("terminatereason", model.getDataEntity().get(STOPREASON_ID));
                    signDy.set("handlestatus", (Object)HandleStatusEnum.PROCESSEND.getCombKey());
                    signDy.set("terminatedate", (Object)new Date());
                    signDy.set("terminatereasondesc", model.getValue(REMARK));
                    signDy.set("terminateperson", (Object)RequestContext.get().getCurrUserId());
                    signDy.set("businessstatus", (Object)"6");
                    signDy.set("billstatus", (Object)BillStatusEnum.STATUS_DEPRECATED.getCode());
                    signDy.set("auditstatus", (Object)AuditStatusEnum.STATUS_DEPRECATED.getCode());
                    signDy.set("signstatus", (Object)SignStatusEnum.STOP_SIGNED.getCombKey());
                    signDy.set("empsignstatus", (Object)EmpCompSignStatusEnum.STOPPED.getValue());
                    signDy.set("compsignstatus", (Object)EmpCompSignStatusEnum.STOPPED.getValue());
                    for (DynamicObject entryEntityDy : signDy.getDynamicObjectCollection("entryentity")) {
                        entryEntityDy.set("entryempsignstatus", (Object)EmpCompSignStatusEnum.STOPPED.getValue());
                        entryEntityDy.set("entrycompsignstatus", (Object)EmpCompSignStatusEnum.STOPPED.getValue());
                    }
                    HLCMCommonRepository.updateDynamicObject((String)"hlcm_signmanagebase", (DynamicObject)signDy);
                    DynamicObject activity = CommonRepository.queryOne((String)"hlcm_activity", (String)"processstatus", (QFilter[])new QFilter[]{new QFilter("signapply.id", "=", (Object)pkValue), new QFilter("processstatus", "=", (Object)ProcessStatusEnum.PENDING.getValue())});
                    if (!HRObjectUtils.isEmpty((Object)activity)) {
                        activity.set("processstatus", (Object)ProcessStatusEnum.TERMINATED.getValue());
                        HLCMCommonRepository.updateDynamicObject((String)"hlcm_activity", (DynamicObject)activity);
                    }
                }
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"hlcm_signbill_tobase");
                dynamicObject.set("id", signDy.getPkValue());
                BaseDataServiceHelper.clearCache((DynamicObject)dynamicObject);
                LOGGER.info("StopSignDynamicPlugin.click.entityId={}", (Object)entityId);
                ISignActivity.getInstance().terminateOrDeleteTask(signDy, entityId, showWay);
                ISignActivity.getInstance().terminateActivity(signDy);
                this.sendMessage(signDy);
                SyncStartStatusService.getInstance().syncSignBillHandleStatusToPreWarn(signDy);
                SyncStartStatusService.getInstance().syncHirePersonStartStatus(new DynamicObject[]{signDy});
                MsgCollaborationProducer.getInstance().releaseMessage(signDy);
                view.returnDataToParent((Object)"success");
                view.close();
            }
            finally {
                dl.unlock();
            }
        }
    }

    private boolean sscStopSignProcession(String entityId) {
        LOGGER.info("entityId|{}", (Object)entityId);
        if (!SignListPermissionUtils.checkPermission((String)"40A+670S4LST", (String)entityId, (String)"2BEGMIB+UGLX")) {
            String tableName = SignTabEnum.getTableNameByListFormId((String)entityId);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u7ec8\u6b62\u7b7e\u7f72\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"StopSignDynamicPlugin_7", (String)"hr-hlcm-formplugin", (Object[])new Object[]{tableName}));
            return false;
        }
        return true;
    }

    private boolean stopReasonValidate() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject stopReason = dataEntity.getDynamicObject("stopreason");
        if (stopReason != null && !HRStringUtils.equals((String)"1", (String)stopReason.getString("enable"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u6240\u9009\u62e9\u7684\u7ec8\u6b62\u539f\u56e0\u201c%s\u201d\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"StopSignDynamicPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[]{stopReason.getString("name")}));
            return true;
        }
        return false;
    }

    private boolean stopStatusValidate() {
        String proStatus;
        Object customParam = this.getView().getFormShowParameter().getCustomParam("activity");
        DynamicObject activityDy = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_activity", (String)"processstatus", (Object)customParam);
        if (activityDy != null && (HRStringUtils.equals((String)(proStatus = activityDy.getString("processstatus")), (String)"1") || HRStringUtils.equals((String)proStatus, (String)"2"))) {
            String showWay = (String)this.getView().getFormShowParameter().getCustomParam("showway");
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
            String comboStr = "";
            comboStr = HRStringUtils.equals((String)"hstc", (String)showWay) ? SignActivityHelper.getComboStr(entityId, proStatus) : SignActivityHelper.getComboStr(this.getView().getParentView(), proStatus);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u53ef\u7ec8\u6b62\u7b7e\u7f72\u3002", (String)"SignActivityComListPlugin_4", (String)"hr-hlcm-formplugin", (Object[])new Object[]{comboStr}));
            return true;
        }
        return false;
    }

    private boolean stopSignProcession() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            if (parentView instanceof ListView) {
                ListView listView = (ListView)parentView;
                String billFormId = listView.getBillFormId();
                if (!SignListPermissionUtils.checkStopSignPermission((String)billFormId)) {
                    String tableName = SignTabEnum.getTableNameByListFormId((String)billFormId);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u7ec8\u6b62\u7b7e\u7f72\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"StopSignDynamicPlugin_7", (String)"hr-hlcm-formplugin", (Object[])new Object[]{tableName}));
                    return false;
                }
            } else if (parentView instanceof BillView) {
                BillView billView = (BillView)parentView;
                String formId = billView.getFormId();
                SignTabEnum signEnum = SignTabEnum.getSignEnum((String)formId);
                String listFormId = signEnum.getListFormId();
                if (!SignListPermissionUtils.checkStopSignPermission((String)listFormId)) {
                    String tableName = SignTabEnum.getTableNameByListFormId((String)formId);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u7ec8\u6b62\u7b7e\u7f72\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"StopSignDynamicPlugin_7", (String)"hr-hlcm-formplugin", (Object[])new Object[]{tableName}));
                    return false;
                }
            } else {
                LOGGER.warn("parentView is not instanceof ListView or BillView");
            }
        }
        return true;
    }

    private void sendMessage(DynamicObject signDy) {
        try {
            String empNumber = signDy.getString("empnumber");
            Long bosUserId = BosUserRepository.getBosUserId((String)empNumber);
            if (bosUserId == 0L) {
                LOGGER.error("can not find bos uer by emp number {}", (Object)empNumber);
                return;
            }
            MessageInfo message = new MessageInfo();
            message.setType("message");
            String protocolType = ProtocolTypeEnum.loadKDStringByKey((String)signDy.getString("protocoltype"));
            String businessType = BusinessTypeEnum.getValueByKey((String)signDy.getString("businesstype"));
            message.setMessageTitle((ILocaleString)new LocaleString(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7ec8\u6b62\u7b7e\u7f72-%1$s%2$s\u7533\u8bf7", (String)"StopSignDynamicPlugin_3", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), protocolType, businessType)));
            message.setMessageContent((ILocaleString)new LocaleString(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u7684\"%1$s%2$s\"\u7533\u8bf7\u6d41\u7a0b\u5df2\u7ec8\u6b62\uff0c\u8bf7\u77e5\u6089\u3002", (String)"StopSignDynamicPlugin_4", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), protocolType, businessType)));
            message.setUserIds(Collections.singletonList(bosUserId));
            message.setSendTime(new Date());
            message.setMessageTag((ILocaleString)ResManager.getLocaleString((String)"\u901a\u77e5", (String)"StopSignDynamicPlugin_6", (String)"hr-hlcm-formplugin"));
            MessageCenterServiceHelper.batchSendMessages((List)Lists.newArrayList((Object[])new MessageInfo[]{message}));
        }
        catch (Exception exception) {
            LOGGER.error("StopSignDynamicPlugin sendMsg error", (Throwable)exception);
        }
    }
}

