/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.signmgt.paper;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.PaperSignFormIdEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;

public class UploadAttDynamicPlugin
extends HRDataBaseEdit
implements UploadListener {
    private static final String CONFIRM = "confirm";
    private static final Log LOGGER = LogFactory.getLog(UploadAttDynamicPlugin.class);

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        DateEdit actualSignDate = (DateEdit)this.getControl("actualsigndate");
        try {
            this.handleOtherProtocolEntryShow();
            String date = (String)this.getView().getFormShowParameter().getCustomParam("signeddate");
            if (date != null) {
                this.getModel().setValue("actualsigndate", (Object)HRDateTimeUtils.parseDate((String)((String)this.getView().getFormShowParameter().getCustomParam("signeddate"))));
            }
            actualSignDate.setMaxDate(HRDateTimeUtils.parseDate((String)((String)this.getView().getFormShowParameter().getCustomParam("enddate"))));
        }
        catch (Exception exp) {
            LOGGER.error("ParseException error", (Throwable)exp);
        }
    }

    private void handleOtherProtocolEntryShow() {
        DynamicObjectCollection dys;
        DynamicObject dynamicObject = this.getDynamicObject(null);
        String protocolType = dynamicObject.getString("protocoltype");
        boolean has = false;
        if (ProtocolTypeEnum.CON.getCombKey().equals(protocolType) && (dynamicObject.getBoolean("issignother") || dynamicObject.getBoolean("issignprotocol")) && (dys = dynamicObject.getDynamicObjectCollection("entryentity")) != null && dys.size() > 0) {
            DynamicObjectCollection entry = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            for (int index = 0; index < dys.size(); ++index) {
                if (Objects.equals(ContractTypeCatEnum.CON.getPkId(), ((DynamicObject)dys.get(index)).get("entrycontracttype.group.id"))) continue;
                DynamicObject row = entry.addNew();
                row.set("contracttype", ((DynamicObject)dys.get(index)).get("entrycontracttype"));
                row.set("contractemplate", ((DynamicObject)dys.get(index)).get("texthis"));
                has = true;
            }
        }
        if (!has) {
            LOGGER.info("hide entity");
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
        }
    }

    private DynamicObject getDynamicObject(DynamicObject dynamicObject) {
        IFormView parentView = this.getParentView();
        if (parentView != null && ContractSignUtils.isContractNotStop((String)parentView.getEntityId())) {
            return parentView.getModel().getDataEntity(true);
        }
        if (dynamicObject != null) {
            return dynamicObject;
        }
        return this.queryDynamicObject();
    }

    private IFormView getParentView() {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (HRStringUtils.isNotEmpty((String)parentPageId)) {
            return this.getView().getViewNoPlugin(parentPageId);
        }
        return null;
    }

    private DynamicObject queryDynamicObject() {
        Object billId = this.getView().getFormShowParameter().getCustomParam("id");
        QFilter qFilter = new QFilter("id", "in", billId);
        return CommonRepository.queryOne((String)"hlcm_contractapplybase", null, (QFilter[])new QFilter[]{qFilter});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)CONFIRM)) {
            IFormView view = this.getView();
            FormShowParameter formShowParameter = view.getFormShowParameter();
            Object billId = formShowParameter.getCustomParam("id");
            if (billId == null) {
                this.failMessage(view);
                return;
            }
            IPageCache pageCache = view.getPageCache();
            String uploadingAttJson = pageCache.get("UploadingAtt" + view.getPageId());
            if (HRStringUtils.isNotEmpty((String)uploadingAttJson)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u4e0a\u4f20\u5b8c\u6210\u540e\u91cd\u8bd5\u3002", (String)"UploadAttDynamicPlugin_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dynamicObject = CommonRepository.queryById((String)"hlcm_contractapplybase", null, (Long)((Long)billId));
            if (!this.handleOtherProtocol(dynamicObject)) {
                return;
            }
            AttachmentPanel attachment = (AttachmentPanel)view.getControl("paperattachment");
            List attachmentData = attachment.getAttachmentData();
            if (!attachmentData.isEmpty()) {
                HashMap<String, List> attachmentMap = new HashMap<String, List>(1);
                attachmentMap.put("paperattachment", attachmentData);
                DynamicObjectCollection successAttCol = AttachmentServiceHelper.saveTempAttachments((String)PaperSignFormIdEnum.COMP.getFormId(), (Object)billId, (String)"hlcm", attachmentMap);
                if (successAttCol.isEmpty()) {
                    this.failMessage(view);
                    return;
                }
            }
            dynamicObject.set("actualsigndate", this.getModel().getValue("actualsigndate"));
            CommonRepository.saveOne((String)"hlcm_contractapplybase", (DynamicObject)dynamicObject);
            view.returnDataToParent((Object)Boolean.TRUE);
            view.close();
        }
    }

    private boolean handleOtherProtocol(DynamicObject dbDy) {
        DynamicObject dynamicObject = this.getDynamicObject(dbDy);
        DynamicObjectCollection dynamicObjects = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        if (dynamicObjects != null && dynamicObjects.size() > 0 && (dynamicObject.getBoolean("issignother") || dynamicObject.getBoolean("issignprotocol"))) {
            IFormView parentView;
            DynamicObjectCollection dys = dynamicObject.getDynamicObjectCollection("entryentity");
            if (dys != null && dys.size() > 0) {
                int length = 0;
                for (int index = 0; index < dys.size(); ++index) {
                    if (Objects.equals(ContractTypeCatEnum.CON.getPkId(), ((DynamicObject)dys.get(index)).get("entrycontracttype.group.id"))) continue;
                    ((DynamicObject)dys.get(index)).set("entryattachment", ((DynamicObject)dynamicObjects.get(length++)).get("entryattachment"));
                }
            }
            if ((parentView = this.getParentView()) != null && ContractSignUtils.isContractNotStop((String)parentView.getEntityId())) {
                parentView.getModel().updateEntryCache(dys);
            }
        }
        return true;
    }

    private void failMessage(IFormView view) {
        view.showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u5173\u95ed\u5f53\u524d\u9875\u9762\u91cd\u65b0\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"UploadAttDynamicPlugin_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
    }
}

