/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.template;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSKeywordMappingService;
import kd.hr.hlcm.business.service.ContractTplService;

public class TemplateFormListPlugin
extends HRDataBaseList {
    private static final Set<String> setStrs = new HashSet<String>(16);
    private static final String PAGE_COMMON_VARIABLE = "hrcs_commonvariable";

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        QFilter billFilter = new QFilter("id", "=", (Object)1555680070209637376L);
        if (!CollectionUtils.isEmpty((Collection)filters)) {
            this.buildPreDataFilter(filters, billFilter);
        }
    }

    private void buildPreDataFilter(List<QFilter> filters, QFilter billFilter) {
        for (QFilter filter : filters) {
            if (!"ctrlstrategy".equals(filter.getProperty()) || !"5".equals(filter.getValue())) continue;
            filter.or(billFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operKey = operate.getOperateKey();
        if ("tbltpval".equals(operKey)) {
            ListShowParameter listShowParameter = new ListShowParameter();
            HashMap params = Maps.newHashMapWithExpectedSize((int)16);
            Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
            params.putAll(originalCustParams);
            params.put("formnumber", "hlcm_contracttemplate");
            HashMap<String, String> mainEntity = new HashMap<String, String>();
            mainEntity.put("hlcm_contractapplybase", ResManager.loadKDString((String)"\u7b7e\u7f72\u7533\u8bf7\u5355", (String)"TemplateFormPlugin_19", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            params.put("mappingEntity", mainEntity);
            listShowParameter.setCustomParams((Map)params);
            listShowParameter.setBillFormId(PAGE_COMMON_VARIABLE);
            listShowParameter.setPageId(this.getView().getPageId().hashCode() + PAGE_COMMON_VARIABLE);
            listShowParameter.setCustomParam("ServiceAppId", (Object)"hrcs");
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (!evt.isCancel()) {
            String itemKey = evt.getItemKey().toLowerCase();
            ListView listView = (ListView)this.getView();
            if ("tbldel".equals(itemKey) && this.checkIsDelPreData(evt, listView)) {
                return;
            }
            if (setStrs.contains(itemKey)) {
                this.checkSelRows(evt, listView);
            }
        }
    }

    private boolean checkIsDelPreData(BeforeItemClickEvent evt, ListView listView) {
        Long pkId;
        Object primaryKeyValue;
        ListSelectedRowCollection seldRows = listView.getSelectedRows();
        if (seldRows.size() == 1 && (primaryKeyValue = listView.getSelectedRows().get(0).getPrimaryKeyValue()) instanceof Long && ContractTplService.checkTplIsPreData((long)(pkId = (Long)primaryKeyValue))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u7684\u5408\u540c\u6a21\u677f\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"TemplateFormPlugin_15", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return true;
        }
        return false;
    }

    private void checkSelRows(BeforeItemClickEvent evt, ListView listView) {
        ListSelectedRowCollection seldRows = listView.getSelectedRows();
        if (seldRows != null && seldRows.size() > 0 && this.checkPreData(seldRows)) {
            evt.setCancel(true);
        }
    }

    private boolean checkPreData(ListSelectedRowCollection seldRows) {
        for (ListSelectedRow selRow : seldRows) {
            Long pkId;
            Object primaryKeyValue = selRow.getPrimaryKeyValue();
            if (!(primaryKeyValue instanceof Long) || !ContractTplService.checkTplIsPreData((long)(pkId = (Long)primaryKeyValue))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u7cfb\u7edf\u9884\u7f6e\u7684\u5408\u540c\u6a21\u677f\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"TemplateFormPlugin_14", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), selRow.getNumber()));
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"delete")) {
            List successPkIds = args.getOperationResult().getSuccessPkIds();
            successPkIds.forEach(successPkId -> IHRCSKeywordMappingService.getInstance().deleteKeyMapping(Long.parseLong(successPkId.toString())));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        if ("number".equals(args.getFieldName())) {
            BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            Object pkId = hyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue();
            BillList billList = (BillList)hyperLinkClickEvent.getSource();
            String formId = billList.getBillFormId();
            BillShowParameter parameter = new BillShowParameter();
            parameter.setPkId(pkId);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setBillStatus(BillOperationStatus.VIEW);
            parameter.setFormId(formId);
            parameter.setPageId(this.getView().getPageId() + pkId);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    static {
        setStrs.add("bar_individuation");
        setStrs.add("bdctrlchange");
        setStrs.add("orgpermchange");
        setStrs.add("tblassign");
        setStrs.add("btn_bd_unassign");
    }
}

