/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.terminate;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.EventObject;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.prewarn.SyncStartStatusService;

public class ConfirmTerminatePlugins
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(ConfirmTerminatePlugins.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        IFormView parentView = this.getView().getParentView();
        String billFormId = "";
        if (parentView instanceof IListView) {
            billFormId = ((IListView)parentView).getBillFormId();
        } else if (parentView instanceof BillView) {
            billFormId = parentView.getFormShowParameter().getFormId();
        } else {
            LOGGER.warn("billFormId is not instanceof IListView or BillView");
        }
        if (operateKey.equals("terminate")) {
            JSONArray selectedRowIDs = (JSONArray)this.getView().getFormShowParameter().getCustomParam("terminateIDs");
            if (CollectionUtils.isEmpty((Collection)selectedRowIDs)) {
                args.setCancel(true);
            }
            Object[] ids = (Long[])selectedRowIDs.toArray((Object[])new Long[selectedRowIDs.size()]);
            OperateOption operateOption = OperateOption.create();
            DynamicObject terminateDy = this.getModel().getDataEntity();
            DynamicObject reasonTerminate = terminateDy.getDynamicObject("terminatereason");
            if (HRObjectUtils.isEmpty((Object)reasonTerminate)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7ec8\u6b62\u6d41\u7a0b\u539f\u56e0\u201d\u3002", (String)"ConfirmTerminatePlugins_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            }
            String reasonTerminateDesc = terminateDy.getString("terminatereasondesc");
            operateOption.setVariableValue("terminateReason", reasonTerminate.getString("id"));
            operateOption.setVariableValue("terminateReasonDesc", reasonTerminateDesc);
            IFormView parentViewNoPlugin = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            String appId = parentViewNoPlugin.getFormShowParameter().getAppId();
            LOGGER.info("appId |{}", (Object)appId);
            operateOption.setVariableValue("currbizappid", appId);
            OperationResult terminate = OperationServiceHelper.executeOperate((String)"terminate", (String)billFormId, (Object[])ids, (OperateOption)operateOption);
            if (terminate.isSuccess()) {
                DynamicObject[] reloadSignBills = HLCMCommonRepository.queryDynamicObjectByPks((String)"hlcm_contractapplybase", (String)String.join((CharSequence)",", "id", "businesstype", "person.id", "employee"), (Object[])ids);
                SyncStartStatusService.getInstance().syncHirePersonStartStatus(reloadSignBills);
            }
            this.getView().returnDataToParent((Object)terminate);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Label labelap = (Label)this.getControl("labelap");
        String tip = (String)this.getView().getFormShowParameter().getCustomParam("tip");
        if (HRStringUtils.isNotEmpty((String)tip)) {
            labelap.setText(tip);
        }
    }
}

