/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.workbench;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hlcm.common.enums.LabRelTypeEnum;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class HirePersonTabFormPlugin
extends AbstractFormPlugin {
    private static final String CONTRACT_TAB = "contract_tab";
    private static final String EMP_TAB = "emp_tab";
    private static final String FILTER_PROPERTY = "empentrel.laborreltype.laborreltypecls";
    private static final Map<String, ImmutablePair<Supplier<String>, QFilter>> FILTER_MAP = new HashMap<String, ImmutablePair<Supplier<String>, QFilter>>();

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadList(CONTRACT_TAB);
        this.loadList(EMP_TAB);
    }

    private void loadList(String tabKey) {
        ListShowParameter listShowParameter = new ListShowParameter();
        ImmutablePair<Supplier<String>, QFilter> pair = FILTER_MAP.get(tabKey);
        listShowParameter.setCaption((String)((Supplier)pair.getLeft()).get());
        listShowParameter.setBillFormId("hlcm_hiredperson");
        listShowParameter.getOpenStyle().setTargetKey(tabKey);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getListFilterParameter().getQFilters().add(pair.getRight());
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    static {
        FILTER_MAP.put(CONTRACT_TAB, (ImmutablePair<Supplier<String>, QFilter>)ImmutablePair.of(() -> ResManager.loadKDString((String)"\u5df2\u5165\u804c\u672a\u7b7e\u7f72\u52b3\u52a8\u5408\u540c\u5458\u5de5", (String)"HirePersonTabFormPlugin_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), (Object)new QFilter(FILTER_PROPERTY, "=", (Object)LabRelTypeEnum.EMPLOYMENT.getCombKey())));
        ArrayList empList = Lists.newArrayList((Object[])new Long[]{LabRelTypeEnum.INTERNSHIP.getCombKey(), LabRelTypeEnum.LABORSERVICE.getCombKey(), LabRelTypeEnum.REEMPLOYMENT.getCombKey(), LabRelTypeEnum.OUTERCLASS.getCombKey()});
        FILTER_MAP.put(EMP_TAB, (ImmutablePair<Supplier<String>, QFilter>)ImmutablePair.of(() -> ResManager.loadKDString((String)"\u5df2\u5165\u804c\u672a\u7b7e\u7f72\u7528\u5de5\u534f\u8bae\u5458\u5de5", (String)"HirePersonTabFormPlugin_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), (Object)new QFilter(FILTER_PROPERTY, "in", (Object)empList)));
    }
}

