/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.workbench;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.common.enums.StartStatusEnum;
import kd.hr.hlcm.formplugin.utils.WorkBenchHelper;

public class HiredUnsignedList
extends HRDataBaseList {
    private static final String CXQ = "cxq";
    private static final String YXQ = "yxq";
    private static final ArrayList<String> signelDataOpKeys = Lists.newArrayList((Object[])new String[]{"cxq", "yxq"});
    private static final Log LOGGER = LogFactory.getLog(HiredUnsignedList.class);

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.setOrderBy("startstatus asc,empentrel.startdate asc,empnumber asc");
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        String targetKey = this.getView().getFormShowParameter().getOpenStyle().getTargetKey();
        if (HRStringUtils.equals((String)targetKey, (String)"contract_tab")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblyxq"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblcxq"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"close")) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getModel().getService(IClientViewProxy.class);
            LinkedHashMap param = Maps.newLinkedHashMap();
            param.put("pageId", this.getView().getParentView().getPageId());
            clientViewProxy.addAction("closeWindow", (Object)Lists.newArrayList((Object[])new Map[]{param}));
            this.getView().close();
            return;
        }
        if (!signelDataOpKeys.contains(operateKey)) {
            return;
        }
        if (this.getSelectedRows().size() > 1) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u5904\u7406\u4e00\u6761\u6570\u636e\u3002", (String)"HiredUnsignedList_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        }
        this.validateBeforeOperation(args, operateKey);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "cxq": {
                this.openPage("hlcm_contractapplynew");
                break;
            }
            case "yxq": {
                this.openPage("hlcm_empprotocolnew");
                break;
            }
        }
    }

    private void validateBeforeOperation(BeforeDoOperationEventArgs args, String operateKey) {
        ListSelectedRow listSelectedRow = this.getSelectedRows().get(0);
        DynamicObject hiredPerson = CommonRepository.queryDynamicObjectByPk((String)"hlcm_hiredperson", (String)"startstatus,personname", (Object)listSelectedRow.getPrimaryKeyValue());
        ArrayList unPassedStatus = Lists.newArrayList((Object[])new String[]{StartStatusEnum.TOSUBMIT.getCombKey(), StartStatusEnum.PROCESSIN.getCombKey(), StartStatusEnum.ARCHIVE.getCombKey()});
        String startStatus = hiredPerson.getString("startstatus");
        String personName = hiredPerson.getString("personname");
        if (unPassedStatus.contains(startStatus)) {
            args.setCancel(true);
            String msg = "";
            if (HRStringUtils.equals((String)startStatus, (String)StartStatusEnum.TOSUBMIT.getCombKey())) {
                switch (operateKey) {
                    default: {
                        msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%s\u5b58\u5728\u5f85\u63d0\u4ea4\u7533\u8bf7\u7684\u5355\u636e\uff0c\u8bf7\u81f3\u52b3\u52a8\u5408\u540c\u65b0\u7b7e\u9875\u9762\u64cd\u4f5c\u3002", (String)"HiredUnsignedList_2", (String)"hr-hlcm-formplugin", (Object[])new Object[]{personName});
                        break;
                    }
                    case "yxq": {
                        msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%s\u5b58\u5728\u5f85\u63d0\u4ea4\u7533\u8bf7\u7684\u5355\u636e\uff0c\u8bf7\u81f3\u7528\u5de5\u534f\u8bae\u65b0\u7b7e\u9875\u9762\u64cd\u4f5c\u3002", (String)"HiredUnsignedList_3", (String)"hr-hlcm-formplugin", (Object[])new Object[]{personName});
                        break;
                    }
                }
            } else if (HRStringUtils.equals((String)startStatus, (String)StartStatusEnum.PROCESSIN.getCombKey())) {
                switch (operateKey) {
                    default: {
                        msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%s\u5b58\u5728\u6d41\u7a0b\u8fdb\u884c\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u81f3\u52b3\u52a8\u5408\u540c\u65b0\u7b7e\u9875\u9762\u64cd\u4f5c\u3002", (String)"HiredUnsignedList_4", (String)"hr-hlcm-formplugin", (Object[])new Object[]{personName});
                        break;
                    }
                    case "yxq": {
                        msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%s\u5b58\u5728\u6d41\u7a0b\u8fdb\u884c\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u81f3\u7528\u5de5\u534f\u8bae\u65b0\u7b7e\u9875\u9762\u64cd\u4f5c\u3002", (String)"HiredUnsignedList_5", (String)"hr-hlcm-formplugin", (Object[])new Object[]{personName});
                        break;
                    }
                }
            } else if (HRStringUtils.equals((String)startStatus, (String)StartStatusEnum.ARCHIVE.getCombKey())) {
                switch (operateKey) {
                    default: {
                        msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%s\u5b58\u5728\u5df2\u5f52\u6863\u7684\u52b3\u52a8\u5408\u540c\u65b0\u7b7e\u7533\u8bf7\u5355\uff0c\u4e0d\u53ef\u518d\u6b21\u53d1\u8d77\u7533\u8bf7\u3002", (String)"HiredUnsignedList_6", (String)"hr-hlcm-formplugin", (Object[])new Object[]{personName});
                        break;
                    }
                    case "yxq": {
                        msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%s\u5b58\u5728\u5df2\u5f52\u6863\u7684\u7528\u5de5\u534f\u8bae\u65b0\u7b7e\u7533\u8bf7\u5355\uff0c\u4e0d\u53ef\u518d\u6b21\u53d1\u8d77\u7533\u8bf7\u3002", (String)"HiredUnsignedList_7", (String)"hr-hlcm-formplugin", (Object[])new Object[]{personName});
                        break;
                    }
                }
            } else {
                LOGGER.info("startStatus|{}", (Object)startStatus);
            }
            this.getView().showErrorNotification(msg);
        }
    }

    private void openPage(String formId) {
        Optional<Object> selectRowPrimaryKeyValue = WorkBenchHelper.getSelectRowPrimaryKeyValue((IListView)this.getView(), formId);
        if (!selectRowPrimaryKeyValue.isPresent()) {
            LOGGER.info("openPage.selectRowPrimaryKeyValue.is.not.present.");
            return;
        }
        Object primaryKeyValue = selectRowPrimaryKeyValue.get();
        DynamicObject hiredPerson = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_hiredperson", (String)"empposrel.postype.id,person.id", (Object)primaryKeyValue);
        Long personId = hiredPerson.getLong("person.id");
        Long posTypeId = hiredPerson.getLong("empposrel.postype.id");
        WorkBenchHelper.open(personId, posTypeId, formId, this.getView(), primaryKeyValue);
    }
}

