/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.workflow;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.common.utils.ComboUtils;

public class ArchiveWorkFlowPlugin
implements IWorkflowPlugin {
    private static final Log LOGGER = LogFactory.getLog(ArchiveWorkFlowPlugin.class);
    private static final String OLD_CONTRACT_CONTRACT_STATUS = "oldcontract.contractstatus";
    private static final String OLD_CONTRACT_CONTRACT_NUMBER = "oldcontract.number";

    public void notify(AgentExecution execution) {
        String oldContractStatus;
        long businessKey = Long.parseLong(execution.getBusinessKey());
        LOGGER.info("archive notify begin businessKey|{}", (Object)businessKey);
        DynamicObject signBill = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_contractapplybase", null, (Object)businessKey);
        if (HRObjectUtils.isEmpty((Object)signBill)) {
            LOGGER.error("archive notify signBill|{} is not exist", (Object)businessKey);
            return;
        }
        String businessType = signBill.getString("businesstype");
        HashSet effectOldContract = Sets.newHashSet((Object[])new String[]{BusinessTypeEnum.STOP.getCombKey(), BusinessTypeEnum.CANCEL.getCombKey()});
        if (effectOldContract.contains(businessType) && !HRStringUtils.equals((String)(oldContractStatus = signBill.getString(OLD_CONTRACT_CONTRACT_STATUS)), (String)ContractStatusEnum.STATUS_IN_EFFECT.getCode())) {
            String oldContractNumber = signBill.getString(OLD_CONTRACT_CONTRACT_NUMBER);
            LOGGER.error("oldContractNumber|{} oldContract status is not  effect", (Object)oldContractNumber);
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d%1$s\uff08\u5408\u540c\u7f16\u53f7\u4e3a%2$s\uff09\u5df2\u5931\u6548\uff0c%1$s%3$s\u751f\u6548\u5931\u8d25\u3002", (String)"ArchiveWorkFlowPlugin_1", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), ComboUtils.getComboOptionLocaleName((DynamicObject)signBill, (String)"protocoltype"), oldContractNumber, ComboUtils.getComboOptionLocaleName((DynamicObject)signBill, (String)"businesstype"));
            throw new KDBizException(errorMsg);
        }
        try (TXHandle required = TX.required();){
            ISignManageService.getInstance().confirmArchiveHandler(signBill);
            ISignManageService.getInstance().archiveAfterTransaction(new DynamicObject[]{signBill});
            LOGGER.info("businessKey|{} archive notify success", (Object)businessKey);
        }
    }
}

