/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.mservice;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.api.IOnbrdCalendarService;
import kd.hr.hom.business.application.impl.onbrd.OnbrdWorkTableServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdWorkTableService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.util.DateUtils;

public class OnbrdCalendarService
implements IOnbrdCalendarService {
    private static final Log LOGGER = LogFactory.getLog(OnbrdCalendarService.class);
    private static final IOnbrdWorkTableService WORK_TABLE_SERVICE = new OnbrdWorkTableServiceImpl();

    public Map<String, List<Map<String, String>>> getCalendarData(Date rangeStart, Date rangeEnd, Map<String, Object> params) {
        LOGGER.info("OnbrdCalendarService_getCalendarData_params:{1}", params);
        HashMap<String, List<Map<String, String>>> resultMap = new HashMap<String, List<Map<String, String>>>();
        Map<String, List<DynamicObject>> dataMap = this.getDataMap(rangeStart, rangeEnd, params);
        if (dataMap == null || dataMap.isEmpty()) {
            return resultMap;
        }
        dataMap.forEach((key, value) -> {
            HashMap<String, String> map = new HashMap<String, String>();
            String msg = ResManager.loadKDString((String)"{0}\u4eba\u5165\u804c", (String)"OnbrdCalendarService_0", (String)"hr-hom-mservice", (Object[])new Object[0]);
            map.put("name", MessageFormat.format(msg, value.size()));
            map.put("description", this.getDescription((List<DynamicObject>)value));
            map.put("startTime", "-1");
            map.put("addressOrLink", this.getUrl((String)key, params));
            map.put("endTime", "-1");
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
            list.add(map);
            resultMap.put((String)key, (List<Map<String, String>>)list);
        });
        return resultMap;
    }

    private Map<String, List<DynamicObject>> getDataMap(Date rangeStart, Date rangeEnd, Map<String, Object> params) {
        DynamicObject[] dynamicObjects;
        if (!IOnbrdCommonAppService.getInstance().checkPermissionByNum("hom_personwaitonbrd", "QXX0001")) {
            return new HashMap<String, List<DynamicObject>>(0);
        }
        QFilter qFilter = new QFilter("effectdate", ">=", (Object)rangeStart);
        qFilter = qFilter.and(new QFilter("effectdate", "<=", (Object)rangeEnd));
        qFilter = qFilter.and(new QFilter("enrollstatus", "=", (Object)OnbrdStatusEnum.WAIT_ONBRD.toString()));
        qFilter = qFilter.and(((IOnbrdWorkTableService)ServiceFactory.getService(IOnbrdWorkTableService.class)).getDataPermissionFilter());
        QFilter perFilter = WORK_TABLE_SERVICE.getPermQFilter("hom_personwaitonbrd", "QXX0001");
        if (HRObjectUtils.isEmpty((Object)perFilter)) {
            qFilter = qFilter.and(perFilter);
        }
        if (params != null) {
            List adminorgids;
            List hrbuids = params.get("hrbuids") == null ? null : (List)params.get("hrbuids");
            List list = adminorgids = params.get("adminorgids") == null ? null : (List)params.get("adminorgids");
            if (hrbuids != null) {
                qFilter = qFilter.and(new QFilter("hrbu", "in", (Object)hrbuids));
            }
            if (adminorgids != null) {
                qFilter = qFilter.and(new QFilter("aadminorg", "in", (Object)adminorgids));
            }
        }
        LOGGER.info("OnbrdCalendarService_getDataMap_datasize:{}", (Object)((dynamicObjects = HomCommonRepository.queryDynamicObjects((String)"hom_onbrdpersonbilltpl", (String)"effectdate,aadminorg.name", (QFilter[])new QFilter[]{qFilter})) == null ? 0 : dynamicObjects.length));
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return new HashMap<String, List<DynamicObject>>();
        }
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>();
        Arrays.stream(dynamicObjects).forEach(dy -> {
            Date date = dy.getDate("effectdate");
            String dateStr = DateUtils.getDateString((String)"yyyy-MM-dd", (Date)date);
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)resultMap.get(dateStr);
            if (list == null) {
                list = new ArrayList<DynamicObject>();
                resultMap.put(dateStr, list);
            }
            list.add((DynamicObject)dy);
        });
        return resultMap;
    }

    private String getUrl(String dateStr, Map<String, Object> params) {
        String contentUrl = UrlService.getDomainContextUrl();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("effectdate", dateStr);
        parameterMap.put("type", "9");
        parameterMap.put("formId", "hom_onbrdpersonlist");
        if (params != null) {
            List adminorgids;
            List hrbuids = params.get("hrbuids") == null ? null : (List)params.get("hrbuids");
            List list = adminorgids = params.get("adminorgids") == null ? null : (List)params.get("adminorgids");
            if (hrbuids != null) {
                parameterMap.put("hrbuids", hrbuids.toString());
            }
            if (adminorgids != null) {
                parameterMap.put("adminorgids", adminorgids.toString());
            }
        }
        String paramString = parameterMap.entrySet().stream().map(entry -> String.format(Locale.ROOT, "%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
        return String.format(Locale.ROOT, "%s/?%s", contentUrl, paramString);
    }

    private String getDescription(List<DynamicObject> list) {
        if (list == null || list.size() == 0) {
            return " ";
        }
        HashMap<String, List> countMap = new HashMap<String, List>();
        list.stream().forEach(dy -> {
            ArrayList<DynamicObject> dyList = (ArrayList<DynamicObject>)countMap.get(dy.getString("aadminorg.name"));
            if (dyList == null) {
                dyList = new ArrayList<DynamicObject>();
                dyList.add((DynamicObject)dy);
                countMap.put(dy.getString("aadminorg.name"), dyList);
            } else {
                dyList.add((DynamicObject)dy);
            }
        });
        StringBuilder builder = new StringBuilder();
        countMap.forEach((key, value) -> {
            String msg = ResManager.loadKDString((String)"{0}: {1}\u4eba;", (String)"OnbrdCalendarService_1", (String)"hr-hom-mservice", (Object[])new Object[]{key, value.size()});
            builder.append(msg);
        });
        return builder.toString();
    }
}

