/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.mservice.onbrd;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.validation.Valid;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hpfs.IPersonFileIntegrateService;
import kd.hr.hom.business.application.impl.hpfs.helper.DirectLeaderHelper;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.application.rule.IOnbrdCommonValidator;
import kd.hr.hom.business.application.utils.RuleCodeUtils;
import kd.hr.hom.business.domain.repository.common.BaseDataRepository;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.impl.hcf.HcfDataDomainService;
import kd.hr.hom.business.domain.service.impl.onbrd.OnbrdInfoInitService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdInfoInitService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdService;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.constant.HcfCanCreConstants;
import kd.hr.hom.common.entity.HomCommonWrapper;
import kd.hr.hom.common.entity.IDCardInfo;
import kd.hr.hom.common.enums.InitTypeEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.common.util.IDCardUtils;
import kd.hr.hom.mservice.common.BackgroundField;
import kd.hr.hom.mservice.common.BaseDataField;
import kd.hr.hom.mservice.common.ChildModelField;
import kd.hr.hom.mservice.model.OnbrdBaseInfoModel;
import kd.hr.hom.mservice.model.OnbrdModel;
import org.springframework.validation.annotation.Validated;

@ApiController(value="hom", desc="\u521b\u5efa\u5165\u804c\u5355")
@ApiMapping(value="/openapi/onbrd")
public class OnbrdController
implements IBillWebApiPlugin {
    private static final Set<String> IGNORE_FIELD = Sets.newHashSet((Object[])new String[]{"id", "sourcevid"});
    private static final String BOOLEAN_METHOD_KEY = "is";
    private static final Map<String, String> hcfBaseInfoFieldMap = ImmutableMap.builder().put((Object)"name", (Object)"name").put((Object)"gender", (Object)"gender").put((Object)"nationality", (Object)"nationality").build();
    public static final String GET = "get";
    private static final Log LOG = LogFactory.getLog(OnbrdController.class);
    private static final Table<String, String, DynamicObject> BASEDATA_VALUE_TABLE = HashBasedTable.create();
    private static final Set<String> IGNORE_FIELD_LIST = ImmutableSet.of((Object)"serialVersionUID");
    private static final Integer DEFAULT_MAX_SIZE = 100;
    private static final Map<String, String> hcfContactinfoFieldMap = ImmutableMap.builder().put((Object)"phone", (Object)"phone").put((Object)"peremail", (Object)"peremail").build();
    private static final Map<String, String> hcfCretificateFieldMap = ImmutableMap.builder().put((Object)"certificatetype", (Object)"credentialstype").put((Object)"certificatenumber", (Object)"number").build();
    protected static final Map<String, Map<String, String>> HCF_ENTITY_FIELD_MAP = ImmutableMap.builder().put((Object)"hcf_canbaseinfo", hcfBaseInfoFieldMap).put((Object)"hcf_cancontactinfo", hcfContactinfoFieldMap).put((Object)"hcf_cancre", hcfCretificateFieldMap).build();

    @ApiPostMapping(value="/create")
    @Validated(value={OnbrdModel.Insert.class})
    public CustomApiResult<@ApiResponseBody(value="data") Map<Integer, String>> createOnbrds(@ApiParam(value="onbrdModelList") @Valid @ApiParam(value="onbrdModelList") @Valid List<OnbrdModel> onbrdModelList) {
        try {
            Optional<Tuple<String, String>> preValid = this.preValidOnbrd(onbrdModelList, false);
            if (preValid.isPresent()) {
                return CustomApiResult.fail((String)((String)preValid.get().item1), (String)((String)preValid.get().item2));
            }
            this.initOnbrdData(onbrdModelList, false);
            this.cacheBaseData(onbrdModelList);
            List<HomCommonWrapper> homCommonWrappers = this.buildOnbrdWrapper(onbrdModelList, false);
            this.initOnbrdDataAfter(homCommonWrappers);
            this.validOnbrdList(homCommonWrappers, false);
            this.saveOnbrdList(homCommonWrappers, false);
            HashMap result = new HashMap();
            homCommonWrappers.stream().filter(warp -> warp.getErrorMsgNum() > 0).forEach(warp -> result.put(warp.getRowIndex(), String.join((CharSequence)",", warp.getErrorMsgs())));
            return CustomApiResult.success(result);
        }
        catch (Exception e) {
            LOG.error("createOnbrds", (Throwable)e);
            return CustomApiResult.fail((String)"10001", (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnbrdController_2", (String)"hr-hom-mservice", (Object[])new Object[0]));
        }
    }

    @ApiPostMapping(value="/update")
    @Validated(value={OnbrdModel.Update.class})
    public CustomApiResult<@ApiResponseBody(value="data") Map<Integer, String>> updateOnbrds(@ApiParam(value="onbrdModelList") @Valid @ApiParam(value="onbrdModelList") @Valid List<OnbrdModel> onbrdModelList) {
        try {
            Optional<Tuple<String, String>> preValid = this.preValidOnbrd(onbrdModelList, true);
            if (preValid.isPresent()) {
                return CustomApiResult.fail((String)((String)preValid.get().item1), (String)((String)preValid.get().item2));
            }
            this.initOnbrdData(onbrdModelList, true);
            this.cacheBaseData(onbrdModelList);
            List<HomCommonWrapper> homCommonWrappers = this.buildOnbrdWrapper(onbrdModelList, true);
            this.initOnbrdDataAfter(homCommonWrappers);
            this.validOnbrdList(homCommonWrappers, true);
            this.saveOnbrdList(homCommonWrappers, true);
            HashMap result = new HashMap();
            homCommonWrappers.stream().filter(warp -> warp.getErrorMsgNum() > 0).forEach(warp -> result.put(warp.getRowIndex(), String.join((CharSequence)",", warp.getErrorMsgs())));
            return CustomApiResult.success(result);
        }
        catch (Exception e) {
            LOG.error("updateOnbrds error", (Throwable)e);
            return CustomApiResult.fail((String)"10001", (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnbrdController_2", (String)"hr-hom-mservice", (Object[])new Object[0]));
        }
    }

    @ApiPostMapping(value="/query")
    public CustomApiResult<@ApiResponseBody(value="data") List<OnbrdModel>> queryOnbrds(@ApiParam(value="ids", required=true) @Valid @ApiParam(value="ids", required=true) @Valid Long[] ids) {
        try {
            DynamicObject[] onBrdBillDynArr = HomCommonRepository.queryDynamicObjectByPks((String)"hom_onbrdbilltpl", (String)"", (Object[])ids);
            Map<DynamicObject, Long> dynVsIdMap = Arrays.stream(onBrdBillDynArr).collect(Collectors.toMap(dyn -> dyn, dyn -> dyn.getLong("id")));
            List infInParamList = DirectLeaderHelper.buildParamMap((DynamicObject[])onBrdBillDynArr, dynVsIdMap);
            Map idVsLeaderListMap = IPersonFileIntegrateService.getInstance().getLeaderByRuleFromHRPI(infInParamList);
            List collect = Arrays.stream(onBrdBillDynArr).map(dynamicObject -> {
                OnbrdModel onbrdModel = new OnbrdModel();
                this.convertDynToModel(onbrdModel, (DynamicObject)dynamicObject);
                List orgList = IPersonFileIntegrateService.getInstance().getMainChargeInfoByOrg(new DynamicObject[]{dynamicObject});
                String aPositionType = dynamicObject.getString("apositiontype");
                Object[] objs = orgList.stream().map(map -> map.get("name")).toArray();
                onbrdModel.getOrgInfoModel().setResponsible(Arrays.toString(objs));
                long id = dynamicObject.getLong("id");
                List leaderList = idVsLeaderListMap.getOrDefault(id, Lists.newArrayListWithExpectedSize((int)0));
                objs = leaderList.stream().map(map -> map.get("superior.name")).toArray();
                if (!CollectionUtils.isEmpty((Collection)leaderList)) {
                    onbrdModel.getJobInfoModel().setLeader(Arrays.toString(objs));
                }
                String apositionvalue = "";
                apositionvalue = HRStringUtils.equals((String)aPositionType, (String)"0") ? dynamicObject.getString("stdposition.name") : (HRStringUtils.equals((String)"1", (String)aPositionType) ? dynamicObject.getString("aposition.name") : dynamicObject.getString("ajob.name"));
                onbrdModel.getJobInfoModel().setApositionvalue(apositionvalue);
                if (!HRObjectUtils.isEmpty((Object)dynamicObject.get("teacher"))) {
                    onbrdModel.getTutorInfoModel().setTeachernumber(dynamicObject.getString("teacher.number"));
                }
                return onbrdModel;
            }).collect(Collectors.toList());
            return CustomApiResult.success(collect);
        }
        catch (Exception e) {
            LOG.error("updateOnbrds error", (Throwable)e);
            return CustomApiResult.fail((String)"10001", (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnbrdController_2", (String)"hr-hom-mservice", (Object[])new Object[0]));
        }
    }

    @ApiPostMapping(value="/createOnboardBill")
    public CustomApiResult<@ApiResponseBody Map<String, Object>> createOnboardBill(@ApiRequestBody Map<String, Object> requestMap) {
        try {
            return CustomApiResult.success((Object)((IOnbrdService)ServiceFactory.getService(IOnbrdService.class)).createOnboardBill(requestMap));
        }
        catch (Exception e) {
            LOG.error("createOnboardBill error", (Throwable)e);
            return CustomApiResult.fail((String)"10001", (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnbrdController_2", (String)"hr-hom-mservice", (Object[])new Object[0]));
        }
    }

    @ApiPostMapping(value="/updateOnboardBillStatus")
    public CustomApiResult<@ApiResponseBody Map<String, Object>> updateOnboardBillStatus(@ApiParam(value="onbrdId") @ApiParam(value="onbrdId") Long onbrdId, @Valid @ApiParam(value="status") @Valid @ApiParam(value="status") String status, @ApiParam(value="remark") @ApiParam(value="remark") String remark) {
        try {
            return CustomApiResult.success((Object)((IOnbrdService)ServiceFactory.getService(IOnbrdService.class)).updateOnboardBillStatus(onbrdId, status, remark));
        }
        catch (Exception e) {
            LOG.error("updateOnboardBill error", (Throwable)e);
            return CustomApiResult.fail((String)"10001", (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnbrdController_2", (String)"hr-hom-mservice", (Object[])new Object[0]));
        }
    }

    private void cacheBaseData(List<OnbrdModel> onbrdModelList) {
        LOG.info("start cache basedata");
        HashMap<String, Set<Object>> map = new HashMap<String, Set<Object>>();
        this.preSetBaseData(map);
        onbrdModelList.forEach(onbrdModel -> this.covertNumberToDyn(onbrdModel, map));
        for (Map.Entry stringListEntry : map.entrySet()) {
            DynamicObject[] dynamicObjects;
            if (CollectionUtils.isEmpty((Collection)((Collection)stringListEntry.getValue()))) continue;
            ArrayList qFilters = Lists.newArrayListWithCapacity((int)3);
            qFilters.add(new QFilter("number", "in", stringListEntry.getValue()));
            DataEntityPropertyCollection properties = MetadataServiceHelper.getDataEntityType((String)((String)stringListEntry.getKey())).getProperties();
            if (properties.containsKey((Object)"iscurrentversion")) {
                qFilters.add(new QFilter("datastatus", "=", (Object)"1"));
                qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
            }
            if (properties.containsKey((Object)"enable")) {
                qFilters.add(new QFilter("enable", "=", (Object)"1"));
            }
            for (DynamicObject dynamicObject : dynamicObjects = HomCommonRepository.queryDynamicObjects((String)((String)stringListEntry.getKey()), (String)"", (QFilter[])qFilters.toArray(new QFilter[0]))) {
                BASEDATA_VALUE_TABLE.put(stringListEntry.getKey(), (Object)dynamicObject.getString("number"), (Object)dynamicObject);
            }
        }
        LOG.info("end cache basedata");
    }

    private void covertNumberToDyn(Object object, Map<String, Set<Object>> map) {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            String name = field.getName();
            if (IGNORE_FIELD_LIST.contains(name)) continue;
            String methodName = this.getFieldMethod(name, GET);
            try {
                Object obj = object.getClass().getMethod(methodName, new Class[0]).invoke(object, new Object[0]);
                ChildModelField childModelField = field.getType().getAnnotation(ChildModelField.class);
                if (childModelField == null) {
                    BaseDataField annotation = field.getAnnotation(BaseDataField.class);
                    if (annotation == null || obj == null) continue;
                    Set orDefault = map.getOrDefault(annotation.value(), new HashSet());
                    orDefault.add(obj);
                    map.put(annotation.value(), orDefault);
                    continue;
                }
                this.covertNumberToDyn(obj, map);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private void convertModelToDyn(OnbrdModel onbrdModel, DynamicObject dynamicObject, List<String> errorMsgList) {
        this.setModelValue(onbrdModel, dynamicObject, errorMsgList);
    }

    private void convertDynToModel(Object onbrdModel, DynamicObject dynamicObject) {
        try {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = onbrdModel.getClass().getDeclaredFields()) {
                String name = declaredField.getName();
                if (IGNORE_FIELD_LIST.contains(name) || "apositionvalue".equals(name)) continue;
                ChildModelField annotation = declaredField.getType().getAnnotation(ChildModelField.class);
                if (annotation == null) {
                    Method setMethod = onbrdModel.getClass().getMethod(this.getFieldMethod(name, "set"), declaredField.getType());
                    if (dynamicObject.get(name) instanceof DynamicObject) {
                        setMethod.invoke(onbrdModel, dynamicObject.getString(name + ".name"));
                        continue;
                    }
                    if (dynamicObject.get(name) instanceof OrmLocaleValue) {
                        ILocaleString localeString = dynamicObject.getLocaleString(name);
                        if (HRObjectUtils.isEmpty((Object)localeString)) {
                            setMethod.invoke(onbrdModel, "");
                            continue;
                        }
                        setMethod.invoke(onbrdModel, localeString.getLocaleValue());
                        continue;
                    }
                    if (dynamicObject.get(name) instanceof MulBasedataDynamicObjectCollection) {
                        setMethod.invoke(onbrdModel, dynamicObject.getString(name));
                        continue;
                    }
                    setMethod.invoke(onbrdModel, dynamicObject.get(name));
                    continue;
                }
                Method getMethod = onbrdModel.getClass().getMethod(this.getFieldMethod(name, GET), new Class[0]);
                Object childModel = getMethod.invoke(onbrdModel, new Object[0]);
                this.convertDynToModel(childModel, dynamicObject);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void setModelValue(Object object, DynamicObject dynamicObject, List<String> errorMsgList) {
        Field[] declaredFields;
        for (Field field : declaredFields = object.getClass().getDeclaredFields()) {
            String name = field.getName();
            if (IGNORE_FIELD_LIST.contains(name)) continue;
            String methodName = this.getFieldMethod(name, GET);
            try {
                Object obj = object.getClass().getMethod(methodName, new Class[0]).invoke(object, new Object[0]);
                BackgroundField backgroundField = field.getAnnotation(BackgroundField.class);
                if (backgroundField != null) continue;
                ChildModelField annotation = field.getType().getAnnotation(ChildModelField.class);
                if (annotation == null) {
                    this.setDataVal(field, obj, dynamicObject, errorMsgList);
                    continue;
                }
                this.setModelValue(obj, dynamicObject, errorMsgList);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private void setDataVal(Field field, Object obj, DynamicObject dynamicObject, List<String> errorMsgList) {
        BaseDataField annotation = field.getAnnotation(BaseDataField.class);
        if (annotation != null) {
            DynamicObject baseDataVal = (DynamicObject)BASEDATA_VALUE_TABLE.get((Object)annotation.value(), (Object)obj.toString());
            if (HRObjectUtils.isEmpty((Object)baseDataVal) && HOMObjectUtils.isNotEmpty((Object)obj)) {
                String fieldName = field.getName();
                if ("aposition".equals(fieldName) || "stdposition".equals(fieldName) || "ajob".equals(fieldName)) {
                    fieldName = "apositionvalue";
                }
                errorMsgList.add(ResManager.loadKDString((String)"{0}\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a{1}\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"OnbrdController_4", (String)"hr-hom-mservice", (Object[])new Object[]{fieldName, obj.toString()}));
            }
            dynamicObject.set(field.getName(), (Object)baseDataVal);
        } else {
            dynamicObject.set(field.getName(), obj);
        }
    }

    private String getFieldMethod(String fieldName, String key) {
        if (fieldName.startsWith(BOOLEAN_METHOD_KEY) && key.equals(GET)) {
            return BOOLEAN_METHOD_KEY + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        }
        return key + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private Optional<Tuple<String, String>> preValidOnbrd(List<OnbrdModel> onbrdModelList, boolean isUpdate) {
        if (onbrdModelList.size() > DEFAULT_MAX_SIZE) {
            return Optional.of(Tuple.create((Object)"10002", (Object)ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u91cf\u8d85\u8fc7\u6700\u5927\u9650\u5236\uff0c\u4e00\u6b21\u6700\u591a\u540c\u6b65100\u6761\u6570\u636e\u3002", (String)"OnbrdController_0", (String)"hr-hom-mservice", (Object[])new Object[0])));
        }
        if (!isUpdate) {
            LOG.info("start verify cert count");
            Map verifyResult = HRCertCommonHelper.verifyCertCount((String)"1WXB5G9/BL46", (String)"hom_onbrdpersonlist", (int)1);
            String verifyCertInfoType = (String)verifyResult.get("infoType");
            if (HRStringUtils.equals((String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName(), (String)verifyCertInfoType)) {
                String errorMsg = ResManager.loadKDString((String)"\u8d85\u8fc7\u53ef\u7528\u8bb8\u53ef\u6570\u91cf\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CreateOnbrdBillService_1", (String)"hr-hom-business", (Object[])new Object[0]);
                return Optional.of(Tuple.create((Object)"10003", (Object)errorMsg));
            }
            LOG.info("end verify cert count");
        }
        return Optional.empty();
    }

    private List<HomCommonWrapper> buildOnbrdWrapper(List<OnbrdModel> onbrdModelList, boolean isUpdate) {
        LOG.info("start build warp entity");
        AtomicInteger atomicInteger = new AtomicInteger(0);
        ArrayList onbrdList = new ArrayList();
        if (isUpdate) {
            onbrdModelList.forEach(onbrdModel -> onbrdList.add(onbrdModel.getId()));
        }
        DynamicObject[] dynamicObjects = HomCommonRepository.queryDynamicObjectByPks((String)"hom_onbrdinfo", (String)"", (Object[])onbrdList.toArray());
        Map<Long, DynamicObject> canMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        ArrayList list = Lists.newArrayListWithExpectedSize((int)3);
        List<HomCommonWrapper> rowDataWrapperList = onbrdModelList.stream().map(onbrdModel -> {
            DynamicObject onbrdBill = (DynamicObject)canMap.get(onbrdModel.getId());
            ArrayList errorMsgList = Lists.newArrayListWithCapacity((int)3);
            if (HRStringUtils.isEmpty((String)onbrdModel.getBaseInfoModel().getCandidatenumber())) {
                errorMsgList.add(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u5df2\u7981\u7528\uff0c\u8bf7\u586b\u5199\u5019\u9009\u4eba\u7f16\u53f7\u3002", (String)"OnbrdController_8", (String)"hr-hom-mservice", (Object[])new Object[0]));
            }
            if (HRObjectUtils.isEmpty((Object)onbrdBill)) {
                onbrdBill = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hom_onbrdinfo"));
            } else {
                OnbrdBaseInfoModel baseInfoModel = onbrdModel.getBaseInfoModel();
                if (!HRObjectUtils.isEmpty((Object)baseInfoModel)) {
                    String candidatenumber = baseInfoModel.getCandidatenumber();
                    String certificatetype = baseInfoModel.getCertificatetype();
                    String certificatenumber = baseInfoModel.getCertificatenumber();
                    if (!(candidatenumber.equals(onbrdBill.getString("candidatenumber")) && certificatetype.equals(onbrdBill.getString("certificatetype.number")) && certificatenumber.equals(onbrdBill.getString("certificatenumber")))) {
                        errorMsgList.add(ResManager.loadKDString((String)"\u4e0d\u80fd\u66f4\u65b0\u5019\u9009\u4eba\u7f16\u7801\u3001\u8bc1\u4ef6\u7c7b\u578b\u4ee5\u53ca\u8bc1\u4ef6\u53f7\u7801\u3002", (String)"OnbrdController_7", (String)"hr-hom-mservice", (Object[])new Object[0]));
                    }
                }
            }
            this.convertModelToDyn((OnbrdModel)onbrdModel, onbrdBill, errorMsgList);
            if (!isUpdate) {
                onbrdBill.set("id", (Object)onbrdModel.getId());
                String billNo = new OnbrdInfoInitService().getNumberByCodeRule("hom_onbrdbillbase", "", onbrdBill);
                onbrdBill.set("billno", (Object)billNo);
                onbrdBill.set("processstatus", (Object)"1");
                onbrdBill.set("creator", (Object)1L);
                onbrdBill.set("modifier", (Object)1L);
                onbrdBill.set("auditstatus", (Object)"A");
                onbrdBill.set("billstatus", (Object)"A");
            }
            onbrdBill.set("leadertype", (Object)"0");
            list.add(onbrdBill);
            this.reSetJobLevelGradeValue(onbrdBill);
            HomCommonWrapper homCommonWrapper = new HomCommonWrapper(onbrdBill, onbrdModel, atomicInteger.addAndGet(1));
            if (HRCollUtil.isNotEmpty((Collection)errorMsgList)) {
                errorMsgList.forEach(arg_0 -> ((HomCommonWrapper)homCommonWrapper).addErrMsg(arg_0));
            }
            return homCommonWrapper;
        }).collect(Collectors.toList());
        LOG.info("end build warp entity");
        LOG.info("start set entity org");
        Map hrBuOrgMapNew = IOnbrdInfoInitService.getInstance().getHRBuOrgMapNew((List)list);
        list.forEach(dynamicObject -> dynamicObject.set("org", hrBuOrgMapNew.get(dynamicObject.getString("aadminorg.number"))));
        LOG.info("end set entity org");
        return rowDataWrapperList;
    }

    private void validOnbrdList(List<HomCommonWrapper> rowDataWrapperList, boolean isUpdate) {
        Map<Long, DynamicObject> canMap = rowDataWrapperList.stream().map(HomCommonWrapper::getBizData).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        LOG.info("start validate number duplate");
        this.validateNumberDuplate(isUpdate, canMap, rowDataWrapperList);
        LOG.info("end validate number duplate");
        LOG.info("start validate candidate number duplate");
        this.validateCandidateNumberDuplate(isUpdate, rowDataWrapperList);
        LOG.info("end validate candidate number duplate");
        List collect = rowDataWrapperList.stream().filter(warp -> warp.getErrorMsgNum() == 0).collect(Collectors.toList());
        IOnbrdCommonValidator onbrdCommonValidator = IOnbrdCommonValidator.getInstance();
        onbrdCommonValidator.validateImportMustInput(collect);
        onbrdCommonValidator.validateDataFormat(collect);
        onbrdCommonValidator.checkChgevent(collect);
        onbrdCommonValidator.checkEmpgroup(collect);
        onbrdCommonValidator.validPreOnbrd(collect);
        onbrdCommonValidator.validateVirtuallyOrg(collect);
        onbrdCommonValidator.validateDepartPerson(collect);
        if (isUpdate) {
            IOnbrdInfoInitService.getInstance().initBillInfo(collect, InitTypeEnum.ONBRD_UPDATE_IMPORT.getValue());
        } else {
            IOnbrdInfoInitService.getInstance().initBillInfo(collect, InitTypeEnum.ONBRD_NEW_INTEGERATE_THIRDSYS.getValue());
        }
        IValidEntryDateService.getInstance().validEntryDateOfQuitDateByMultiEntity(collect);
    }

    private void reSetJobLevelGradeValue(DynamicObject onbrdBill) {
        QFilter filter;
        Object[] baseDataInfos;
        String ajoblevel = onbrdBill.getString("ajoblevel.number");
        Long joblevelscm = onbrdBill.getLong("joblevelscm.id");
        String ajobgrade = onbrdBill.getString("ajobgrade.number");
        Long jobgradescm = onbrdBill.getLong("jobgradescm.id");
        if (HRStringUtils.isNotEmpty((String)ajoblevel) && joblevelscm != 0L && HRArrayUtils.isNotEmpty((Object[])(baseDataInfos = BaseDataRepository.getBaseDataInfoByNumber((String)"hbjm_joblevelhr", (String)"", (QFilter[])new QFilter[]{filter = new QFilter("joblevelscm.id", "=", (Object)joblevelscm).and(new QFilter("number", "=", (Object)ajoblevel))})))) {
            onbrdBill.set("ajoblevel", baseDataInfos[0]);
        }
        if (HRStringUtils.isNotEmpty((String)ajobgrade) && jobgradescm != 0L && HRArrayUtils.isNotEmpty((Object[])(baseDataInfos = BaseDataRepository.getBaseDataInfoByNumber((String)"hbjm_jobgradehr", (String)"", (QFilter[])new QFilter[]{filter = new QFilter("jobgradescm.id", "=", (Object)jobgradescm).and(new QFilter("number", "=", (Object)ajobgrade))})))) {
            onbrdBill.set("ajobgrade", baseDataInfos[0]);
        }
    }

    private void validateNumberDuplate(boolean isUpdate, Map<Long, DynamicObject> canMap, List<HomCommonWrapper> rowDataWrapperList) {
        if (isUpdate) {
            rowDataWrapperList.forEach(warp -> {
                DynamicObject bizData = warp.getBizData();
                if (!canMap.containsKey(bizData.getLong("id"))) {
                    warp.addErrMsg(ResManager.loadKDString((String)"\u539f\u59cb\u5165\u804c\u5355\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"OnbrdController_1", (String)"hr-hom-mservice", (Object[])new Object[0]));
                }
                String enrollstatus = bizData.getString("enrollstatus");
                if (OnbrdStatusEnum.HAS_ONBRD.getValue().equals(enrollstatus) || OnbrdStatusEnum.BREAK_UP.getValue().equals(enrollstatus) || OnbrdStatusEnum.WAIT_ONBRD.getValue().equals(enrollstatus)) {
                    warp.addErrMsg(ResManager.loadKDString((String)"\u5df2\u542f\u52a8\u5165\u804c\u3001\u5df2\u5165\u804c\u3001\u5df2\u7ec8\u6b62\u7684\u5165\u804c\u5355\u4e0d\u80fd\u66f4\u65b0\u3002", (String)"OnbrdController_5", (String)"hr-hom-mservice", (Object[])new Object[0]));
                }
                DynamicObject certificatetype = bizData.getDynamicObject("certificatetype");
                String certificatenumber = bizData.getString("certificatenumber");
                if (HRObjectUtils.isEmpty((Object)certificatetype) ^ HRStringUtils.isEmpty((String)certificatenumber)) {
                    warp.addErrMsg(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u5165\u804c\u5355\u4e2d\u7684\u8bc1\u4ef6\u7c7b\u578b\u548c\u8bc1\u4ef6\u53f7\u7801\u3002", (String)"OnbrdController_6", (String)"hr-hom-mservice", (Object[])new Object[0]));
                }
            });
        }
        HashMap candidateMap = new HashMap();
        rowDataWrapperList.forEach(rowdata -> {
            String candidateNum;
            Integer recordFromExcel;
            DynamicObject certificatetype = rowdata.getBizData().getDynamicObject("certificatetype");
            if (HRObjectUtils.isEmpty((Object)certificatetype)) {
                rowdata.addErrMsg(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u7a7a", (String)"OnbrdController_3", (String)"hr-hom-mservice", (Object[])new Object[0]));
            }
            if ((recordFromExcel = (Integer)candidateMap.get(candidateNum = rowdata.getBizData().getString("candidatenumber"))) != null) {
                rowdata.addErrMsg(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u7f16\u53f7\u91cd\u590d;", (String)"OnbrdImportInitServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]));
            } else {
                candidateMap.put(candidateNum, rowdata.getRowIndex());
            }
        });
    }

    private void validateCandidateNumberDuplate(boolean isUpdate, List<HomCommonWrapper> rowDataWrapperList) {
        if (isUpdate) {
            return;
        }
        List candidateMap = rowDataWrapperList.stream().map(datawarp -> datawarp.getBizData().getString("candidatenumber")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("number", "in", candidateMap);
        Map candidateFromDBMap = IHcfDataDomainService.getInstance().queryCandidate("number", new QFilter[]{qFilter});
        if (candidateFromDBMap.isEmpty()) {
            return;
        }
        rowDataWrapperList.forEach(datawarp -> {
            String candidatenumber = datawarp.getBizData().getString("candidatenumber");
            DynamicObject dynamicObject = (DynamicObject)candidateFromDBMap.get(candidatenumber);
            if (!HRObjectUtils.isEmpty((Object)dynamicObject)) {
                datawarp.addErrMsg(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u7f16\u53f7\u91cd\u590d;", (String)"OnbrdImportInitServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]));
            }
        });
    }

    private void initOnbrdData(List<OnbrdModel> onbrdModelList, boolean isUpdate) {
        onbrdModelList.forEach(onbrdModel -> {
            if (!isUpdate) {
                onbrdModel.setId(0L);
            }
            if (HRStringUtils.isEmpty((String)onbrdModel.getBaseInfoModel().getCandidatenumber())) {
                ArrayList codeList = new ArrayList(1);
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_candidatenumber");
                DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                RuleCodeUtils.codeRuleHandler((DynamicObject)dynamicObject, codeList, (int)1, (int)1);
                if (!HRCollUtil.isEmpty(codeList)) {
                    onbrdModel.getBaseInfoModel().setCandidatenumber((String)codeList.get(0));
                }
            }
            if (!onbrdModel.getBaseInfoModel().getPhone().contains("-")) {
                onbrdModel.getBaseInfoModel().setPhone("+86-" + onbrdModel.getBaseInfoModel().getPhone());
            }
            switch (onbrdModel.getJobInfoModel().getApositiontype()) {
                case "0": {
                    onbrdModel.getJobInfoModel().setStdposition(onbrdModel.getJobInfoModel().getApositionvalue());
                    break;
                }
                case "1": {
                    onbrdModel.getJobInfoModel().setAposition(onbrdModel.getJobInfoModel().getApositionvalue());
                    break;
                }
                case "2": {
                    onbrdModel.getJobInfoModel().setAjob(onbrdModel.getJobInfoModel().getApositionvalue());
                    break;
                }
            }
        });
    }

    private void initOnbrdDataAfter(List<HomCommonWrapper> onbrdModelList) {
        onbrdModelList.forEach(onbrdModel -> {
            DynamicObject bizData = onbrdModel.getBizData();
            DynamicObject dynamicObject = bizData.getDynamicObject("affaction");
            if (!HRObjectUtils.isEmpty((Object)dynamicObject)) {
                String affactionNumber;
                switch (affactionNumber = dynamicObject.getString("number")) {
                    case "101010_S": {
                        bizData.set("laborreltype", BASEDATA_VALUE_TABLE.get((Object)"hbss_laborreltype", (Object)"1010_S"));
                        bizData.set("postype", BASEDATA_VALUE_TABLE.get((Object)"hbss_postype", (Object)"1010_S"));
                        bizData.set("posstatus", BASEDATA_VALUE_TABLE.get((Object)"hbss_poststate", (Object)"1020_S"));
                        break;
                    }
                    case "101030_S": {
                        bizData.set("laborreltype", BASEDATA_VALUE_TABLE.get((Object)"hbss_laborreltype", (Object)"1020_S"));
                        bizData.set("postype", BASEDATA_VALUE_TABLE.get((Object)"hbss_postype", (Object)"1010_S"));
                        bizData.set("laborrelstatus", BASEDATA_VALUE_TABLE.get((Object)"hbss_laborrelstatus", (Object)"1030_S"));
                        bizData.set("posstatus", BASEDATA_VALUE_TABLE.get((Object)"hbss_poststate", (Object)"1020_S"));
                        break;
                    }
                }
            }
        });
    }

    private void preSetBaseData(Map<String, Set<Object>> map) {
        this.addBaseDataNumber(map, "hbss_laborreltype", "1010_S", "1020_S");
        this.addBaseDataNumber(map, "hbss_postype", "1010_S");
        this.addBaseDataNumber(map, "hbss_laborrelstatus", "1030_S");
        this.addBaseDataNumber(map, "hbss_poststate", "1020_S");
    }

    private void addBaseDataNumber(Map<String, Set<Object>> map, String key, String ... baseNumber) {
        Set orDefault = map.getOrDefault(key, new HashSet());
        orDefault.addAll(Arrays.asList(baseNumber));
        map.put(key, orDefault);
    }

    private void saveOnbrdList(List<HomCommonWrapper> homCommonWrappers, boolean isUpdate) {
        List<HomCommonWrapper> onbrdBillWrapperList = homCommonWrappers.stream().filter(rowData -> rowData.getErrorMsgNum() == 0).collect(Collectors.toList());
        List<DynamicObject> collect = onbrdBillWrapperList.stream().filter(warp -> warp.getErrorMsgNum() == 0).map(HomCommonWrapper::getBizData).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        this.saveHcfData(onbrdBillWrapperList, isUpdate);
        collect = onbrdBillWrapperList.stream().filter(warp -> warp.getErrorMsgNum() == 0).map(HomCommonWrapper::getBizData).collect(Collectors.toList());
        HomCommonRepository.updateDynamicObjects((String)"hom_onbrdinfo", (DynamicObject[])collect.toArray(new DynamicObject[0]));
    }

    private void saveHcfData(List<HomCommonWrapper> onbrdBillWrapperList, boolean isUpdate) {
        try {
            List<DynamicObject> collect = onbrdBillWrapperList.stream().filter(warp -> warp.getErrorMsgNum() == 0).map(HomCommonWrapper::getBizData).collect(Collectors.toList());
            LOG.info("start build base candidate");
            Map saveResult = new HashMap();
            if (!isUpdate) {
                ArrayList candidateNewList = new ArrayList();
                collect.forEach(dynamicObject -> {
                    DynamicObject candidateNew = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_candidate"));
                    candidateNew.set("name", (Object)dynamicObject.getString("name"));
                    candidateNew.set("number", (Object)dynamicObject.getString("candidatenumber"));
                    candidateNewList.add(candidateNew);
                });
                if (!CollectionUtils.isEmpty(candidateNewList)) {
                    saveResult = IHcfDataDomainService.getInstance().saveCandidate(candidateNewList.toArray(new DynamicObject[0]));
                }
            } else {
                Set candidateNumSet = collect.stream().map(candidate -> candidate.getDynamicObject("candidate").getLong("boid")).collect(Collectors.toSet());
                QFilter qFilter = new QFilter("boid", "in", candidateNumSet);
                Map map = IHcfDataDomainService.getInstance().queryCandidate("boid,number", new QFilter[]{qFilter});
                Map<Long, DynamicObject> candidateMap = map.values().stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("boid"), dynamicObject -> dynamicObject));
                ArrayList candidateUpdatelist = new ArrayList();
                collect.forEach(dynamicObject -> {
                    DynamicObject candidateNew = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_candidate"));
                    HRDynamicObjectUtils.copy((DynamicObject)((DynamicObject)candidateMap.get(dynamicObject.getLong("candidate.id"))), (DynamicObject)candidateNew, IGNORE_FIELD);
                    candidateNew.set("name", (Object)dynamicObject.getString("name"));
                    candidateNew.set("number", (Object)dynamicObject.getString("candidatenumber"));
                    candidateUpdatelist.add(candidateNew);
                });
                if (!CollectionUtils.isEmpty(candidateUpdatelist)) {
                    saveResult = IHcfDataDomainService.getInstance().saveCandidate(candidateUpdatelist.toArray(new DynamicObject[0]));
                }
            }
            LOG.info("end build base candidate");
            LOG.info("sync onbrd candidate info");
            for (DynamicObject onbrdBill : collect) {
                long candidateId = onbrdBill.getLong("candidate.id");
                if (candidateId != 0L) continue;
                DynamicObject dynamicObject2 = (DynamicObject)saveResult.get(onbrdBill.getString("candidatenumber"));
                onbrdBill.set("candidate", (Object)dynamicObject2);
            }
            if (isUpdate) {
                IOnbrdInfoInitService.getInstance().initFieldValue(onbrdBillWrapperList, InitTypeEnum.ONBRD_UPDATE_IMPORT.getValue());
            } else {
                IOnbrdInfoInitService.getInstance().initFieldValue(onbrdBillWrapperList, InitTypeEnum.ONBRD_NEW_INTEGERATE_THIRDSYS.getValue());
            }
            this.setValueByCertNumber(onbrdBillWrapperList);
            LOG.info("sync onbrd candidate info success");
            this.syncCandidateInfo(onbrdBillWrapperList, isUpdate);
        }
        catch (Exception e) {
            LOG.error("sync candidate error", (Throwable)e);
        }
    }

    private void syncCandidateInfo(List<HomCommonWrapper> onbrdBillWrapperList, boolean isUpdate) {
        LOG.info("start sync candidate info");
        for (Map.Entry<String, Map<String, String>> entry : HCF_ENTITY_FIELD_MAP.entrySet()) {
            this.saveSingleRowEntity(isUpdate, onbrdBillWrapperList, entry.getKey(), entry.getValue());
        }
        this.saveCanAddressInfo(onbrdBillWrapperList);
        LOG.info("end sync candidate info");
    }

    private void saveCanAddressInfo(List<HomCommonWrapper> validatePassList) {
        Set candidateIds = validatePassList.stream().map(rowData -> rowData.getBizData().getLong("candidate.id")).collect(Collectors.toSet());
        HcfDataDomainService hcfDataDomainService = new HcfDataDomainService();
        StringBuilder properties = new StringBuilder("id").append(",").append("addresstype").append(",").append("countrycode").append(',').append("candidate").append(",").append("addressinfo");
        Map multiRowEntityMap = hcfDataDomainService.queryMultiRowEntity(candidateIds, "hcf_canaddress", properties.toString());
        Map<String, DynamicObject> addressTypeMap = this.getAddressTypeMap();
        ArrayList addressSaveList = new ArrayList(3);
        for (HomCommonWrapper rowData2 : validatePassList) {
            DynamicObject regresidenceAddressDy;
            DynamicObject liveAddressDy;
            DynamicObject commuAddressDy;
            DynamicObject onbrdBill = rowData2.getBizData();
            Long candidateId = onbrdBill.getLong("candidate.id");
            DynamicObjectCollection multiRowEntity = (DynamicObjectCollection)multiRowEntityMap.get(candidateId);
            Map<Object, Object> addressMap = Maps.newHashMapWithExpectedSize((int)3);
            if (!CollectionUtils.isEmpty((Collection)multiRowEntity)) {
                addressMap = multiRowEntity.stream().collect(Collectors.toMap(rowEntity -> rowEntity.getString("addresstype.number"), rowEntity -> rowEntity, (oldValue, newValue) -> newValue));
            }
            if (HRObjectUtils.isEmpty((Object)(commuAddressDy = (DynamicObject)addressMap.get("1010_S")))) {
                commuAddressDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_canaddress"));
                commuAddressDy.set("candidate", (Object)candidateId);
                commuAddressDy.set("addresstype", (Object)addressTypeMap.get("1010_S"));
            }
            if (HRObjectUtils.isEmpty((Object)(liveAddressDy = (DynamicObject)addressMap.get("1030_S")))) {
                liveAddressDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_canaddress"));
                liveAddressDy.set("candidate", (Object)candidateId);
                liveAddressDy.set("addresstype", (Object)addressTypeMap.get("1030_S"));
            }
            if (!HRObjectUtils.isEmpty((Object)(regresidenceAddressDy = (DynamicObject)addressMap.get("1020_S")))) continue;
            regresidenceAddressDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_canaddress"));
            regresidenceAddressDy.set("candidate", (Object)candidateId);
            regresidenceAddressDy.set("addresstype", (Object)addressTypeMap.get("1020_S"));
        }
        hcfDataDomainService.saveHcfAttachedData("hcf_canaddress", addressSaveList.toArray(new DynamicObject[addressSaveList.size()]));
    }

    private void setValueByCertNumber(List<HomCommonWrapper> onbrdBillWrapperList) {
        DynamicObject nationalityChina = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_nationality", BaseDataIdConstants.HBSS_NATIONALITY_1010, "number");
        DynamicObject sexMan = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_sex", BaseDataIdConstants.HBSS_SEX_1010, "number");
        DynamicObject sexWoman = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_sex", BaseDataIdConstants.HBSS_SEX_1020, "number");
        for (HomCommonWrapper onbrdBillWrapper : onbrdBillWrapperList) {
            long cerTypeId;
            DynamicObject onbrdBill = onbrdBillWrapper.getBizData();
            DynamicObject certificateType = onbrdBill.getDynamicObject("certificatetype");
            IDCardInfo idCardInfo = null;
            if (!HRObjectUtils.isEmpty((Object)certificateType) && HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD.equals(cerTypeId = certificateType.getLong("id"))) {
                idCardInfo = IDCardUtils.parse((String)onbrdBill.getString("certificatenumber"));
            }
            if (idCardInfo == null) continue;
            HOMObjectUtils.setFieldValueIfEmpty((DynamicObject)onbrdBill, (String)"nationality", (Object)nationalityChina);
            HOMObjectUtils.setFieldValueIfEmpty((DynamicObject)onbrdBill, (String)"gender", (Object)(idCardInfo.getGender() ? sexMan : sexWoman));
            HOMObjectUtils.setFieldValueIfEmpty((DynamicObject)onbrdBill, (String)"birthday", (Object)idCardInfo.getBirthDay());
        }
    }

    private void saveSingleRowEntity(boolean isUpdate, List<HomCommonWrapper> validatePassList, String entityName, Map<String, String> hcfFieldMap) {
        Set candidateIds = validatePassList.stream().map(rowData -> rowData.getBizData().getLong("candidate.id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> singleRowEntityMap = Maps.newHashMapWithExpectedSize((int)candidateIds.size());
        HcfDataDomainService hcfDataDomainService = new HcfDataDomainService();
        StringBuilder properties = new StringBuilder("id");
        if (!CollectionUtils.isEmpty(hcfFieldMap)) {
            properties.append(',').append("candidate");
            hcfFieldMap.values().forEach(fieldName -> properties.append(',').append((String)fieldName));
        }
        if (isUpdate) {
            singleRowEntityMap = hcfDataDomainService.querySingleRowEntity(candidateIds, entityName, properties.toString());
        }
        for (HomCommonWrapper rowData2 : validatePassList) {
            DynamicObject certificateType;
            DynamicObject onbrdBill = rowData2.getBizData();
            Long candidateId = onbrdBill.getLong("candidate.id");
            DynamicObject origDyn = (DynamicObject)singleRowEntityMap.get(candidateId);
            DynamicObject singleRowEntity = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
            if (HRObjectUtils.isEmpty((Object)origDyn)) {
                singleRowEntity.set("candidate", (Object)candidateId);
            } else {
                HRDynamicObjectUtils.copy((DynamicObject)origDyn, (DynamicObject)singleRowEntity, IGNORE_FIELD);
            }
            for (Map.Entry<String, String> entry : hcfFieldMap.entrySet()) {
                singleRowEntity.set(entry.getValue(), onbrdBill.get(entry.getKey()));
            }
            if (HRStringUtils.equals((String)"hcf_cancre", (String)entityName)) {
                singleRowEntity.set("ismajor", (Object)Boolean.TRUE);
            }
            if (HRStringUtils.equals((String)"hcf_canbaseinfo", (String)entityName) && !HRObjectUtils.isEmpty((Object)(certificateType = onbrdBill.getDynamicObject("certificatetype"))) && HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD.equals(certificateType.getLong("id"))) {
                IDCardInfo idCardInfo = IDCardUtils.parse((String)onbrdBill.getString("certificatenumber"));
                singleRowEntity.set("birthday", (Object)idCardInfo.getBirthDay());
            }
            singleRowEntityMap.put(candidateId, singleRowEntity);
        }
        hcfDataDomainService.saveHcfAttachedData(entityName, singleRowEntityMap.values().toArray(new DynamicObject[singleRowEntityMap.size()]));
    }

    private Map<String, DynamicObject> getAddressTypeMap() {
        HashMap<String, DynamicObject> addressTypeMap = new HashMap<String, DynamicObject>();
        IHcfDataDomainService instance = IHcfDataDomainService.getInstance();
        addressTypeMap.put("1010_S", instance.getAddressType("1010_S"));
        addressTypeMap.put("1030_S", instance.getAddressType("1030_S"));
        addressTypeMap.put("1020_S", instance.getAddressType("1020_S"));
        return addressTypeMap;
    }
}

