/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.mservice.upgrade;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMetaDataServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.common.constant.InfoGroupFieldConstants;

public class CollectTemplateCertUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(CollectTemplateCertUpgradeService.class);
    private static final Long CERT_INFO_GROUP_ID = 1247809374760493056L;
    private static final Long CERT_ISIDENTITY_ID = 1592895928929368065L;
    private static final Long CERT_ISMAJOR_ID = 1592895928929368064L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        boolean flag;
        block24: {
            logger.info("Start CollectTemplateUpgrade");
            flag = true;
            try (TXHandle required = TX.required();){
                if (this.isDeploy()) {
                    DynamicObject[] dynamicObjects;
                    for (DynamicObject dynamicObject : dynamicObjects = HomCommonRepository.queryDynamicObjects((String)"hom_infocollectconfig", (String)"", (QFilter[])new QFilter[]{QFilter.isNotNull((String)"number")})) {
                        this.initCollectTemplate(dynamicObject);
                    }
                    break block24;
                }
                try (BufferedReader bd = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/upgrade/collect_template_cert_upgrade0302.sql")));){
                    String line = "";
                    DBRoute dbRoute = new DBRoute("hrb.hom");
                    while ((line = bd.readLine()) != null) {
                        if (HRStringUtils.isEmpty((String)line)) continue;
                        HRDBUtil.execute((DBRoute)dbRoute, (String)line, null);
                    }
                }
                catch (IOException io) {
                    logger.error("CollectTemplateUpgrade exception:", (Throwable)io);
                }
            }
        }
        logger.info("End Start CollectTemplateUpgrade");
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        if (flag) {
            result.setLog("CollectTemplateUpgrade Success");
        } else {
            result.setLog("CollectTemplateUpgrade Fail");
        }
        result.setSuccess(flag);
        return result;
    }

    private boolean isDeploy() {
        if (HRStringUtils.isEmpty((String)HRMetaDataServiceHelper.getFormMetaId((String)"hom_infocollectconfig", (String)"1WXB5G9/BL46"))) {
            return false;
        }
        DBRoute dbRoute = new DBRoute("hrb.hom");
        String sql = "select fid,fvid from t_hom_infocollectconfig;";
        DataSet dataSet = HRDBUtil.queryDataSet((String)"PreStartDateUpgradeService", (DBRoute)dbRoute, (String)sql, null);
        if (dataSet.isEmpty()) {
            return false;
        }
        ArrayList<String> strlist = new ArrayList<String>(){
            {
                this.add("1418346573317963776_1512348423276214272");
                this.add("1418375810309586944_1512348424391900160");
            }
        };
        for (Row next : dataSet) {
            String id = next.getString("fid");
            String vid = next.getString("fvid");
            if (strlist.contains(id + "_" + vid)) continue;
            return true;
        }
        return false;
    }

    private void initCollectTemplate(DynamicObject dynamicObject) {
        boolean result = this.addField(dynamicObject);
        if (!result) {
            return;
        }
        this.saveNewDyn(dynamicObject);
    }

    private void saveNewDyn(DynamicObject collectDyn) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hom_infocollectconfighis");
        DynamicObject dynamicObject = hrBaseServiceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)collectDyn, (DynamicObject)dynamicObject);
        dynamicObject.set("vid", (Object)collectDyn.getLong("id"));
        dynamicObject = (DynamicObject)hrBaseServiceHelper.saveOne(dynamicObject);
        collectDyn.set("vid", (Object)dynamicObject.getLong("id"));
        HomCommonRepository.updateDynamicObject((String)"hom_infocollectconfig", (DynamicObject)collectDyn);
    }

    private boolean addField(DynamicObject collectDyn) {
        Optional<DynamicObject> certMajorField;
        Optional<DynamicObject> certIdentityField;
        Optional<DynamicObject> infogroupentity = collectDyn.getDynamicObjectCollection("infogroupentity").stream().filter(dynamicObject -> CERT_INFO_GROUP_ID.equals(dynamicObject.getLong("infogroup.id"))).findFirst();
        if (!infogroupentity.isPresent()) {
            return false;
        }
        DynamicObject certInfoGroup = infogroupentity.get();
        DynamicObjectCollection infofieldentity = certInfoGroup.getDynamicObjectCollection("infofieldentity");
        Optional<DynamicObject> permanentField = infofieldentity.stream().filter(dynamicObject -> InfoGroupFieldConstants.CERT_CARDLOCATION_ID.equals(dynamicObject.getLong("field.id"))).findFirst();
        if (!permanentField.isPresent()) {
            DynamicObject dynamicObject2 = infofieldentity.addNew();
            dynamicObject2.set("field_id", (Object)InfoGroupFieldConstants.CERT_CARDLOCATION_ID);
            dynamicObject2.set("fieldmustinput", (Object)Boolean.FALSE);
            dynamicObject2.set("fieldapprove", (Object)Boolean.FALSE);
            dynamicObject2.set("fieldrecheck", (Object)Boolean.FALSE);
            dynamicObject2.set("seq", (Object)Integer.MAX_VALUE);
        }
        if (!(certIdentityField = infofieldentity.stream().filter(dynamicObject -> CERT_ISIDENTITY_ID.equals(dynamicObject.getLong("field.id"))).findFirst()).isPresent()) {
            DynamicObject dynamicObject3 = infofieldentity.addNew();
            dynamicObject3.set("field_id", (Object)CERT_ISIDENTITY_ID);
            dynamicObject3.set("fieldmustinput", (Object)Boolean.FALSE);
            dynamicObject3.set("fieldapprove", (Object)Boolean.FALSE);
            dynamicObject3.set("fieldrecheck", (Object)Boolean.FALSE);
            dynamicObject3.set("seq", (Object)Integer.MAX_VALUE);
        }
        if (!(certMajorField = infofieldentity.stream().filter(dynamicObject -> CERT_ISMAJOR_ID.equals(dynamicObject.getLong("field.id"))).findFirst()).isPresent()) {
            DynamicObject dynamicObject4 = infofieldentity.addNew();
            dynamicObject4.set("field_id", (Object)CERT_ISMAJOR_ID);
            dynamicObject4.set("fieldmustinput", (Object)Boolean.FALSE);
            dynamicObject4.set("fieldapprove", (Object)Boolean.FALSE);
            dynamicObject4.set("fieldrecheck", (Object)Boolean.FALSE);
            dynamicObject4.set("seq", (Object)Integer.MAX_VALUE);
        }
        return true;
    }
}

