/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.mservice.upgrade;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMetaDataServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;

public class CollectTemplateUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(CollectTemplateUpgradeService.class);
    private static final Long CERT_INFO_GROUP_ID = 1247809374760493056L;
    private static final Long EDU_INFO_GROUP_ID = 1247809451256209408L;
    private static final Long PERMANENT_FIELD_ID = 1452929340546243584L;
    private static final Long CERT_ATTACHMENT_ID = 1452929340546243585L;
    private static final String EDU_ORDER_STR = "1249297648691749899,1249297648691749900,1249297648691749891,1249297648691749892,1249297648691749888,1249297648691749889,1249297648691749890,1249297648691749893,1249297648691749898,1249297648691749902,1249297648691749901,1249297648691749903,1249297648691749906,1249297648691749904,1255753217539722240,1249297648691749905,1408187915879632897,1249297648691749896,1249297648691749894,1408187915879632900";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        boolean flag;
        block23: {
            logger.info("Start CollectTemplateUpgrade");
            flag = true;
            try (TXHandle required = TX.required();){
                if (this.isDeploy()) {
                    this.initCollectTemplate("1010_s", 1419610723138432000L);
                    this.initCollectTemplate("1020_s", 1419610132085496832L);
                    break block23;
                }
                try (BufferedReader bd = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/upgrade/collect_template_upgrade.sql")));){
                    String line = "";
                    DBRoute dbRoute = new DBRoute("hrb.hom");
                    while ((line = bd.readLine()) != null) {
                        if (HRStringUtils.isEmpty((String)line)) continue;
                        HRDBUtil.execute((DBRoute)dbRoute, (String)line, null);
                    }
                }
                catch (IOException io) {
                    logger.error("CollectTemplateUpgrade exception:", (Throwable)io);
                }
            }
        }
        logger.info("End Start CollectTemplateUpgrade");
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        if (flag) {
            result.setLog("CollectTemplateUpgrade Success");
        } else {
            result.setLog("CollectTemplateUpgrade Fail");
        }
        result.setSuccess(flag);
        return result;
    }

    private boolean isDeploy() {
        if (HRStringUtils.isEmpty((String)HRMetaDataServiceHelper.getFormMetaId((String)"hom_infocollectconfig", (String)"1WXB5G9/BL46"))) {
            return false;
        }
        DBRoute dbRoute = new DBRoute("hrb.hom");
        String sql = "select fid from  t_hom_infocollectconfig where  fid in (1418346573317963776,1418375810309586944) and fvid in (1419610723138432000,1419610132085496832);";
        DataSet dataSet = HRDBUtil.queryDataSet((String)"PreStartDateUpgradeService", (DBRoute)dbRoute, (String)sql, null);
        if (dataSet.isEmpty()) {
            return true;
        }
        int fid = dataSet.count("fid", true);
        return fid != 2;
    }

    private void initCollectTemplate(String templateNumber, Long lastVid) {
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByNumber((String)"hom_infocollectconfig", (String)"", (Object)templateNumber);
        this.addField(dynamicObject);
        Long currentId = dynamicObject.getLong("vid");
        if (HRObjectUtils.equals((Object)currentId, (Object)lastVid)) {
            this.changeFieldOrder(dynamicObject);
        }
        this.saveNewDyn(dynamicObject);
    }

    private void changeFieldOrder(DynamicObject collectDyn) {
        Optional<DynamicObject> infogroupentity = collectDyn.getDynamicObjectCollection("infogroupentity").stream().filter(dynamicObject -> EDU_INFO_GROUP_ID.equals(dynamicObject.getLong("infogroup.id"))).findFirst();
        if (!infogroupentity.isPresent()) {
            return;
        }
        String[] split = EDU_ORDER_STR.split(",");
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        Integer index = 0;
        for (String str : split) {
            map.put(Long.parseLong(str), index);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        DynamicObject certInfoGroup = infogroupentity.get();
        DynamicObjectCollection infofieldentity = certInfoGroup.getDynamicObjectCollection("infofieldentity");
        infofieldentity.forEach(dynamicObject -> dynamicObject.set("seq", (Object)map.getOrDefault(dynamicObject.getLong("field.id"), Integer.MAX_VALUE)));
    }

    private void saveNewDyn(DynamicObject collectDyn) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hom_infocollectconfighis");
        DynamicObject dynamicObject = hrBaseServiceHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)collectDyn, (DynamicObject)dynamicObject);
        dynamicObject.set("vid", (Object)collectDyn.getLong("id"));
        dynamicObject = (DynamicObject)hrBaseServiceHelper.saveOne(dynamicObject);
        collectDyn.set("vid", (Object)dynamicObject.getLong("id"));
        HomCommonRepository.updateDynamicObject((String)"hom_infocollectconfig", (DynamicObject)collectDyn);
    }

    private void addField(DynamicObject collectDyn) {
        Optional<DynamicObject> certAttField;
        Optional<DynamicObject> infogroupentity = collectDyn.getDynamicObjectCollection("infogroupentity").stream().filter(dynamicObject -> CERT_INFO_GROUP_ID.equals(dynamicObject.getLong("infogroup.id"))).findFirst();
        if (!infogroupentity.isPresent()) {
            return;
        }
        DynamicObject certInfoGroup = infogroupentity.get();
        DynamicObjectCollection infofieldentity = certInfoGroup.getDynamicObjectCollection("infofieldentity");
        Optional<DynamicObject> permanentField = infofieldentity.stream().filter(dynamicObject -> PERMANENT_FIELD_ID.equals(dynamicObject.getLong("field.id"))).findFirst();
        if (!permanentField.isPresent()) {
            DynamicObject dynamicObject2 = infofieldentity.addNew();
            dynamicObject2.set("field_id", (Object)PERMANENT_FIELD_ID);
            dynamicObject2.set("fieldmustinput", (Object)Boolean.FALSE);
            dynamicObject2.set("fieldapprove", (Object)Boolean.TRUE);
            dynamicObject2.set("fieldrecheck", (Object)Boolean.FALSE);
            dynamicObject2.set("seq", (Object)Integer.MAX_VALUE);
        }
        if (!(certAttField = infofieldentity.stream().filter(dynamicObject -> CERT_ATTACHMENT_ID.equals(dynamicObject.getLong("field.id"))).findFirst()).isPresent()) {
            DynamicObject dynamicObject3 = infofieldentity.addNew();
            dynamicObject3.set("field_id", (Object)CERT_ATTACHMENT_ID);
            dynamicObject3.set("fieldmustinput", (Object)Boolean.TRUE);
            dynamicObject3.set("fieldapprove", (Object)Boolean.TRUE);
            dynamicObject3.set("fieldrecheck", (Object)Boolean.TRUE);
            dynamicObject3.set("fieldrecheckstand", (Object)ResManager.getLocaleString((String)"\u4e3a\u672c\u4eba\u8bc1\u4ef6\uff0c\u4e14\u8bc1\u4ef6\u6e05\u6670\uff0c\u5e76\u5728\u6709\u6548\u671f\u4ee5\u5185", (String)"CollectTemplateUpgradeService_0", (String)"hr-hom-mservice"));
            dynamicObject3.set("seq", (Object)Integer.MAX_VALUE);
            dynamicObject3.set("fieldcount", (Object)1);
        }
    }
}

