/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.mservice.upgrade;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRObjectUtils;

public class OnbrdNationalityUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(OnbrdNationalityUpgradeService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info("Start Updating Nationality of OnbrdBill HRDBUtil");
        boolean flag = true;
        DataSet hcfDataSet = this.getHcfBaseinfoData();
        try (TXHandle required = TX.required();){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
            while (hcfDataSet.hasNext()) {
                Row row = hcfDataSet.next();
                Long candidateId = row.getLong("FCANDIDATEID");
                Object nationalityid = row.get("fnationalityid");
                if (HRObjectUtils.isEmpty((Object)candidateId) || HRObjectUtils.isEmpty((Object)nationalityid)) continue;
                Object[] paramArr = new Object[]{nationalityid, candidateId};
                paramsList.add(paramArr);
            }
            if (!paramsList.isEmpty()) {
                DBRoute dbRoute = new DBRoute("hrb.hom");
                HRDBUtil.executeBatch((DBRoute)dbRoute, (String)this.updateSql(), paramsList);
            }
        }
        logger.info("End Updating Nationality of OnbrdBill HRDBUtil");
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        if (flag) {
            result.setLog("Updating Nationality of OnbrdBill Success");
        } else {
            result.setLog("Updating Nationality of OnbrdBill Fail");
        }
        result.setSuccess(flag);
        return result;
    }

    private DataSet getHcfBaseinfoData() {
        DBRoute dbRoute = new DBRoute("hcf");
        String sql = "select FID,FCANDIDATEID,fnationalityid,fdatastatus,fiscurrentversion from t_hcf_canbaseinfo where fiscurrentversion = '1'";
        return HRDBUtil.queryDataSet((String)"OnbrdNationalityUpgradeService", (DBRoute)dbRoute, (String)sql, null);
    }

    private String updateSql() {
        return "update t_hom_onbrdbill_b set fnationalityid = ? where fid in (select fid from t_hom_onbrdbill where fcandidateid = ?)";
    }
}

