/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.mservice.upgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;

public class ReasonAndTypeUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(ReasonAndTypeUpgradeService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        LOGGER.info("Start Updating Datasource of ReasonAndType ");
        boolean flag = true;
        try (TXHandle required = TX.required();){
            this.upgradeReason();
            this.upgradeReasonLan();
            this.upgradeType();
            this.upgradeTypeLan();
        }
        LOGGER.info("End Updating Datasource of ReasonAndTypeUpgradeService ");
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        if (flag) {
            result.setLog("Updating Datasource of ReasonAndType Success");
        } else {
            result.setLog("Updating Datasource of ReasonAndType Fail");
        }
        result.setSuccess(flag);
        return result;
    }

    private void upgradeReason() {
        DataSet homDataSet = this.getData("t_hom_breakupreason");
        DataSet hbssDataSet = this.getData("t_hbss_breakupreason");
        ArrayList<Object> idsList = new ArrayList<Object>();
        while (hbssDataSet.hasNext()) {
            Row row = hbssDataSet.next();
            idsList.add(row.get("fid"));
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        while (homDataSet.hasNext()) {
            Row row = homDataSet.next();
            Object fid = row.get("fid");
            if (idsList.contains(fid)) continue;
            Object fnumber = row.get("fnumber");
            Object fcreatorid = row.get("fcreatorid");
            Object fcreatetime = row.get("fcreatetime");
            Object fmodifierid = row.get("fmodifierid");
            Object fmodifytime = row.get("fmodifytime");
            Object fenable = row.get("fenable");
            Object fstatus = row.get("fstatus");
            Object fdisablerid = row.get("fdisablerid");
            Object fdisabledate = row.get("fdisabledate");
            Object findex = row.get("findex");
            Object fissyspreset = row.get("fissyspreset");
            Object fmasterid = row.get("fmasterid");
            Object fdescription = row.get("fdescription");
            Object fsimplename = row.get("fsimplename");
            Object fname = row.get("fname");
            Object fbreakuptypeid = row.get("fbreakuptypeid");
            paramsList.add(new Object[]{fid, fnumber, fcreatorid, fcreatetime, fmodifierid, fmodifytime, fenable, fstatus, fdisablerid, fdisabledate, findex, fissyspreset, fmasterid, fdescription, fsimplename, fname, fbreakuptypeid});
        }
        this.execute(paramsList, this.insertReasonSql());
    }

    private void upgradeReasonLan() {
        DataSet dataSet = this.getData("t_hom_breakupreason_l");
        DataSet hbssDataSet = this.getData("t_hbss_breakupreason_l");
        ArrayList idsList = Lists.newArrayListWithCapacity((int)8);
        while (hbssDataSet.hasNext()) {
            Row row = hbssDataSet.next();
            idsList.add(row.get("fpkid"));
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Object fpkid = row.get("fpkid");
            if (idsList.contains(fpkid)) continue;
            Object fid = row.get("fid");
            Object flocaleid = row.get("flocaleid");
            Object fdescription = row.get("fdescription");
            Object fsimplename = row.get("fsimplename");
            Object fname = row.get("fname");
            paramsList.add(new Object[]{fpkid, fid, flocaleid, fdescription, fsimplename, fname});
        }
        this.execute(paramsList, this.insertReasonLanguageTableSql());
    }

    private void upgradeTypeLan() {
        DataSet dataSet = this.getData("t_hom_breakuptype_l");
        DataSet hbssDataSet = this.getData("t_hbss_breakuptype_l");
        ArrayList idsList = Lists.newArrayListWithCapacity((int)8);
        while (hbssDataSet.hasNext()) {
            Row row = hbssDataSet.next();
            idsList.add(row.get("fpkid"));
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Object fpkid = row.get("fpkid");
            if (idsList.contains(fpkid)) continue;
            Object fid = row.get("fid");
            Object flocaleid = row.get("flocaleid");
            Object fdescription = row.get("fdescription");
            Object fsimplename = row.get("fsimplename");
            Object fname = row.get("fname");
            Object fsysdescription = row.get("fsysdescription");
            paramsList.add(new Object[]{fpkid, fid, flocaleid, fdescription, fsimplename, fname, fsysdescription});
        }
        this.execute(paramsList, this.insertTypeLanguageTableSql());
    }

    private void upgradeType() {
        DataSet dataSet = this.getData("t_hom_breakuptype");
        DataSet hbssDataSet = this.getData("t_hbss_breakuptype");
        ArrayList<Object> idsList = new ArrayList<Object>();
        while (hbssDataSet.hasNext()) {
            Row row = hbssDataSet.next();
            idsList.add(row.get("fid"));
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Object fid = row.get("fid");
            if (idsList.contains(fid)) continue;
            Object fnumber = row.get("fnumber");
            Object fcreatorid = row.get("fcreatorid");
            Object fcreatetime = row.get("fcreatetime");
            Object fmodifierid = row.get("fmodifierid");
            Object fmodifytime = row.get("fmodifytime");
            Object fenable = row.get("fenable");
            Object fstatus = row.get("fstatus");
            Object fdisablerid = row.get("fdisablerid");
            Object fdisabledate = row.get("fdisabledate");
            Object findex = row.get("findex");
            Object fissyspreset = row.get("fissyspreset");
            Object fmasterid = row.get("fmasterid");
            Object fname = row.get("fname");
            Object fdescription = row.get("fdescription");
            Object fsimplename = row.get("fsimplename");
            Object fsysdescription = row.get("fsysdescription");
            paramsList.add(new Object[]{fid, fnumber, fcreatorid, fcreatetime, fmodifierid, fmodifytime, fenable, fstatus, fdisablerid, fdisabledate, findex, fissyspreset, fmasterid, fdescription, fsimplename, fname, fsysdescription});
        }
        this.execute(paramsList, this.insertTypeSql());
    }

    private void execute(List<Object[]> paramsList, String sql) {
        if (!paramsList.isEmpty()) {
            LOGGER.info("paramsList.size():{}", (Object)paramsList.size());
            DBRoute dbRoute = new DBRoute("hmp.hbss");
            HRDBUtil.executeBatch((DBRoute)dbRoute, (String)sql, paramsList);
        }
    }

    private DataSet getData(String tableName) {
        String route = "";
        route = tableName.contains("hbss") ? "hmp.hbss" : "hrb.hom";
        DBRoute dbRoute = new DBRoute(route);
        String props = "";
        props = tableName.endsWith("breakupreason") ? "fid, fnumber, fcreatorid, fcreatetime, fmodifierid, fmodifytime, fenable,\n        fstatus, fdisablerid, fdisabledate, findex, fissyspreset, fmasterid, fdescription, fsimplename, fname, fbreakuptypeid" : (tableName.endsWith("breakuptype") ? "fid, fnumber, fcreatorid, fcreatetime, fmodifierid, fmodifytime, fenable, fstatus, fdisablerid, fdisabledate, findex,\n         fissyspreset, fmasterid, fname, fdescription, fsimplename, fsysdescription" : (tableName.endsWith("breakuptype_l") ? "fpkid, fid, flocaleid, fdescription, fsimplename, fname,fsysdescription" : "fpkid, fid, flocaleid, fdescription, fsimplename, fname"));
        String sql = "select " + props + " from " + tableName;
        return HRDBUtil.queryDataSet((String)"ReasonAndTypeUpgradeService", (DBRoute)dbRoute, (String)sql, null);
    }

    private String insertReasonSql() {
        return "INSERT INTO t_hbss_breakupreason\n(fid, fnumber, fcreatorid, fcreatetime, fmodifierid, fmodifytime, fenable, fstatus, fdisablerid, fdisabledate, findex, fissyspreset, fmasterid, fdescription, fsimplename, fname, fbreakuptypeid)\nVALUES(?,? , ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    private String insertTypeSql() {
        return "INSERT INTO t_hbss_breakuptype\n(fid, fnumber, fcreatorid, fcreatetime, fmodifierid, fmodifytime, fenable, fstatus, fdisablerid, fdisabledate, findex, fissyspreset, fmasterid, fname, fdescription, fsimplename, fsysdescription)\nVALUES(?,? , ?, ?, ?,? ,? , ?, ?, ?,? , ?, ?, ?, ?,?,? );";
    }

    private String insertReasonLanguageTableSql() {
        return "INSERT INTO t_hbss_breakupreason_l (fpkid, fid, flocaleid, fdescription, fsimplename, fname)\nVALUES(?, ?, ?, ?,?, ?)";
    }

    private String insertTypeLanguageTableSql() {
        return "INSERT INTO t_hbss_breakuptype_l (fpkid, fid, flocaleid, fdescription, fsimplename, fname,fsysdescription)\nVALUES(?, ?, ?, ?,?, ?,?)";
    }
}

