/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.invite.IOnbrdInviteDomainService;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.InviteMessageSendStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.SendStatusEnum;
import kd.hr.hom.common.enums.WelcomeLetterSendStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class InviteHelper {
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"InviteHelper", (int)5, (int)1000);
    private static final Log LOGGER = LogFactory.getLog(InviteHelper.class);

    public static Optional<String> sendShortAndEmail(DynamicObject inviteSendBillObj) {
        return IOnbrdInviteDomainService.getInstance().sendShortAndEmail(inviteSendBillObj);
    }

    public static void updateInviteDatas(DynamicObject[] inviteSendBillObjs) {
        IOnbrdInviteDomainService onbrdInviteDomainService = IOnbrdInviteDomainService.getInstance();
        boolean validEmail = onbrdInviteDomainService.validEmail(new StringBuilder());
        boolean validSms = onbrdInviteDomainService.validSms(new StringBuilder());
        Map<Long, String> messageTypeMap = Arrays.stream(inviteSendBillObjs).collect(Collectors.toMap(item -> item.getLong("id"), item -> Optional.ofNullable(item.getString("sendinvitemessagetpl.msgchannel")).orElse("")));
        for (DynamicObject inviteSendBillObj : inviteSendBillObjs) {
            boolean validMessageConfigIsSuccess;
            inviteSendBillObj.set("sendstatus", (Object)SendStatusEnum.HAS_SEND.getValue());
            inviteSendBillObj.set("sendtime", (Object)new Date());
            boolean validEmailIsSuccessNew = onbrdInviteDomainService.validEmailIsSuccessNew(inviteSendBillObj, validEmail);
            boolean validSmsIsSuccessNew = onbrdInviteDomainService.validSmsIsSuccessNew(inviteSendBillObj, validSms);
            if (validEmailIsSuccessNew) {
                inviteSendBillObj.set("welcomelettersendstatus", (Object)WelcomeLetterSendStatusEnum.HAS_SEND.getValue());
            }
            if (!(validMessageConfigIsSuccess = onbrdInviteDomainService.validMessageConfig(messageTypeMap, inviteSendBillObj, validSmsIsSuccessNew, validEmailIsSuccessNew))) continue;
            inviteSendBillObj.set("invitemessagesendstatus", (Object)InviteMessageSendStatusEnum.HAS_SEND.getValue());
        }
        HomCommonRepository.updateDynamicObjects((String)"hom_invitesendbill", (DynamicObject[])inviteSendBillObjs);
    }

    public static void sendInvite(DynamicObject onbrdObj, DynamicObject inviteSendBillObj, IFormView view, boolean isList) {
        InviteHelper.updateInviteDatas(new DynamicObject[]{inviteSendBillObj});
        if (isList) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u9080\u7ea6\u6210\u529f", (String)"OnbrdInviteOperateListPlugin_17", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            view.invokeOperation("refresh");
        } else {
            InviteHelper.closeOrRefreshPage(view);
        }
        InviteHelper.sendShortAndEmail(inviteSendBillObj);
        threadPool.execute(() -> IActivityDomainService.getInstance().batchConsentTask(Collections.singletonList(onbrdObj.getLong("id")), ActivityNumberEnum.INDUCTIONINVITATION), RequestContext.get());
    }

    public static void closeOrRefreshPage(IFormView view) {
        if (view.getParentView() != null && "hom_activityoverview".equals(view.getParentView().getEntityId())) {
            view.close();
            IFormView parentView = view.getParentView();
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u9080\u7ea6\u6210\u529f", (String)"OnbrdInviteOperateListPlugin_17", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            view.sendFormAction(parentView);
        } else {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u9080\u7ea6\u6210\u529f", (String)"OnbrdInviteOperateListPlugin_17", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            view.invokeOperation("refresh");
        }
    }

    public static void showInvite(Long pkId, IFormView view) {
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk((String)"hom_invitesendbill", (String)"onbrd,onbrd.name", (Object)pkId);
        if (dynamicObject == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"OnbrdInviteOperateListPlugin_24", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        DynamicObject onbrdObj = dynamicObject.getDynamicObject("onbrd");
        String name = onbrdObj.getString("name");
        showParameter.setPkId((Object)pkId);
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u5165\u804c\u9080\u7ea6-%s", (String)"OnbrdInviteListPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), name));
        showParameter.setPageId(view.getPageId() + "_" + "hom_invitesendbill" + "_" + pkId);
        showParameter.setFormId("hom_invitesendbill");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        String enrollStatus = onbrdObj.getString("enrollstatus");
        String appId = view.getFormShowParameter().getAppId();
        if (OnbrdStatusEnum.WAIT_ONBRD.getValue().equals(enrollStatus) && onbrdCommonAppService.checkPermission("hom_invitesendbill", "4715a0df000000ac", appId)) {
            showParameter.setStatus(OperationStatus.EDIT);
        } else {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        showParameter.setCustomParam("onbrdid", (Object)dynamicObject.getLong("onbrd.id"));
        showParameter.setCustomParam("id", (Object)pkId);
        view.showForm((FormShowParameter)showParameter);
    }

    public static boolean sendInviteOne(DynamicObject inviteSendBillObj, IFormView view) {
        if (IOnbrdInviteDomainService.getInstance().isEndOnbrd(inviteSendBillObj)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6b64\u5f85\u5165\u804c\u4eba\u5458\u5df2\u5165\u804c/\u5df2\u7ec8\u6b62\u5165\u804c\uff0c\u4e0d\u53ef\u53d1\u9001\u5165\u804c\u9080\u7ea6\u3002", (String)"OnbrdInviteOperateListPlugin_11", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return false;
        }
        HashMap messageMap = Maps.newHashMapWithExpectedSize((int)1);
        IOnbrdInviteDomainService.getInstance().notFitData((List)ImmutableList.of((Object)inviteSendBillObj), (Map)messageMap);
        String message = (String)messageMap.get(inviteSendBillObj.getLong("id"));
        if (StringUtils.isNotBlank((CharSequence)message)) {
            view.showConfirm(message, MessageBoxOptions.OK);
            return false;
        }
        return true;
    }
}

