/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.common;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.cvp.IHomToCvpAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.InfoGroupFieldConstants;
import kd.hr.hom.common.entity.ocr.CertificateOfDegreeResult;
import kd.hr.hom.common.entity.ocr.CertificateOfResignationResult;
import kd.hr.hom.common.entity.ocr.DiplomaResult;
import kd.hr.hom.common.entity.ocr.OcrBankCardResult;
import kd.hr.hom.common.entity.ocr.OcrIdCardResult;
import kd.hr.hom.common.util.DateUtils;

public class OcrToBusinessUtils {
    private static final int OCR_RESULT_TIME = 5000;

    public static void ocrToPerWorkResult(CertificateOfResignationResult certificateOfResignationResult, DataEntityPropertyCollection properties, IFormView view) {
        String company = certificateOfResignationResult.getCompany();
        OcrToBusinessUtils.setProperties(properties, company, InfoGroupFieldConstants.UNITNAME, view);
        String entryDate = certificateOfResignationResult.getEntryDate();
        OcrToBusinessUtils.setProperties(properties, DateUtils.parseDate((String)entryDate), InfoGroupFieldConstants.WORK_STARTDATE, view);
        String leaveDate = certificateOfResignationResult.getLeaveDate();
        OcrToBusinessUtils.setProperties(properties, DateUtils.parseDate((String)leaveDate), InfoGroupFieldConstants.WORK_ENDDATE, view);
        String position = certificateOfResignationResult.getPosition();
        OcrToBusinessUtils.setProperties(properties, position, InfoGroupFieldConstants.POSITION, view);
        String leaveReason = certificateOfResignationResult.getLeaveReason();
        OcrToBusinessUtils.setProperties(properties, leaveReason, InfoGroupFieldConstants.QUITREASON, view);
    }

    public static void ocrToDegreeResult(CertificateOfDegreeResult certificateOfDegreeResult, DataEntityPropertyCollection properties, IFormView view) {
        String degreeCertificationId = certificateOfDegreeResult.getDegreeCertificationId();
        OcrToBusinessUtils.setProperties(properties, degreeCertificationId, InfoGroupFieldConstants.EDU_DEGREE_NUMBER, view);
        String education = certificateOfDegreeResult.getEducation();
        DynamicObject diplomaObject = HomCommonRepository.queryDynamicObject((String)"hbss_diploma", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)education)});
        if (diplomaObject != null) {
            OcrToBusinessUtils.setProperties(properties, diplomaObject.getLong("id"), InfoGroupFieldConstants.EDUCATIONID, view);
        }
        String discipline = certificateOfDegreeResult.getDiscipline();
        OcrToBusinessUtils.setProperties(properties, discipline, InfoGroupFieldConstants.MAJOR, view);
        String degree = certificateOfDegreeResult.getDegree();
        DynamicObject degreeObject = HomCommonRepository.queryDynamicObject((String)"hbss_degree", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)degree)});
        if (degreeObject != null) {
            OcrToBusinessUtils.setProperties(properties, degreeObject.getLong("id"), InfoGroupFieldConstants.DEGREEID, view);
        }
        String school = certificateOfDegreeResult.getSchool();
        DynamicObject schoolObject = HomCommonRepository.queryDynamicObject((String)"hbss_college", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)school)});
        if (schoolObject != null) {
            OcrToBusinessUtils.setProperties(properties, schoolObject.getLong("id"), InfoGroupFieldConstants.EDU_SCHOOLNAME, view);
        }
    }

    public static void ocrToEduResult(DiplomaResult diplomaResult, DataEntityPropertyCollection properties, IFormView view) {
        String diplomaId = diplomaResult.getDiplomaId();
        OcrToBusinessUtils.setProperties(properties, diplomaId, InfoGroupFieldConstants.EDU_GRA_NUMBER, view);
        String startYear = diplomaResult.getStartYear();
        OcrToBusinessUtils.setProperties(properties, DateUtils.parseDate((String)startYear), InfoGroupFieldConstants.EDU_STARTTIME, view);
        String endYear = diplomaResult.getEndYear();
        OcrToBusinessUtils.setProperties(properties, DateUtils.parseDate((String)endYear), InfoGroupFieldConstants.EDU_ENDTIME, view);
        String discipline = diplomaResult.getDiscipline();
        OcrToBusinessUtils.setProperties(properties, discipline, InfoGroupFieldConstants.MAJOR, view);
        String education = diplomaResult.getEducation();
        DynamicObject diplomaObject = HomCommonRepository.queryDynamicObject((String)"hbss_diploma", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)education)});
        if (diplomaObject != null) {
            OcrToBusinessUtils.setProperties(properties, diplomaObject.getLong("id"), InfoGroupFieldConstants.EDUCATIONID, view);
        }
        String school = diplomaResult.getSchool();
        DynamicObject schoolObject = HomCommonRepository.queryDynamicObject((String)"hbss_college", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)school)});
        if (schoolObject != null) {
            OcrToBusinessUtils.setProperties(properties, schoolObject.getLong("id"), InfoGroupFieldConstants.EDU_SCHOOLNAME, view);
        }
    }

    public static void setProperties(DataEntityPropertyCollection properties, Object value, Long field, IFormView view) {
        String id = "field" + field;
        if (StringUtils.isNotBlank((Object)value) && properties.containsKey((Object)id)) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)id);
            if (iDataEntityProperty instanceof BasedataProp) {
                view.getModel().setItemValueByID(id, value);
                view.getModel().getDataEntity().set(id + "_id", value);
            } else {
                view.getModel().setValue(id, value);
            }
        }
    }

    public static void setProperties(DataEntityPropertyCollection properties, Object value, Long field, IFormView view, String page, String column) {
        String id = "field" + field;
        if (StringUtils.isNotBlank((Object)value) && properties.containsKey((Object)id)) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)id);
            if (iDataEntityProperty instanceof BasedataProp) {
                DynamicObject basedataObj = HomCommonRepository.queryDynamicObject((String)page, (String)"id", (QFilter[])new QFilter[]{new QFilter(column, "=", value)});
                if (basedataObj != null) {
                    view.getModel().setItemValueByID(id, value);
                    view.getModel().setValue(id, (Object)basedataObj);
                    view.getModel().getDataEntity().set(id + "_id", (Object)basedataObj.getLong("id"));
                }
            } else {
                view.getModel().setValue(id, value);
            }
        }
    }

    public static void ocrToIdCard(OcrIdCardResult ocrIdCardResult, DataEntityPropertyCollection properties, IFormView view) {
        OcrToBusinessUtils.setProperties(properties, ocrIdCardResult.getName(), InfoGroupFieldConstants.CERT_NAME, view);
        OcrToBusinessUtils.setProperties(properties, ocrIdCardResult.getSex(), InfoGroupFieldConstants.CERT_GENDER, view, "hbss_sex", "name");
        String nation = ocrIdCardResult.getNation();
        if (!HRStringUtils.equals((String)nation, (String)"\u7a7f\u9752\u4eba")) {
            nation = String.format(ResManager.loadKDString((String)"%s\u65cf", (String)"OcrToBusinessUtils_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), ocrIdCardResult.getNation());
        }
        OcrToBusinessUtils.setProperties(properties, nation, InfoGroupFieldConstants.CERT_NATION, view, "hbss_flok", "name");
        OcrToBusinessUtils.setProperties(properties, ocrIdCardResult.getBirth(), InfoGroupFieldConstants.CERT_BIR, view);
        OcrToBusinessUtils.setProperties(properties, ocrIdCardResult.getIdNum(), InfoGroupFieldConstants.CERT_NUMBER, view);
        OcrToBusinessUtils.setProperties(properties, ocrIdCardResult.getAuthority(), InfoGroupFieldConstants.CERT_ISSUINGAUTHORITY, view);
        OcrToBusinessUtils.setProperties(properties, ocrIdCardResult.getAddress(), InfoGroupFieldConstants.CERT_CARDLOCATION_ID, view);
        OcrToBusinessUtils.setProperties(properties, ocrIdCardResult.getIssuedate(), InfoGroupFieldConstants.CERT_ISSUEDATE, view);
        OcrToBusinessUtils.setProperties(properties, ocrIdCardResult.getExpirationdate(), InfoGroupFieldConstants.CERT_EXPIRATIONDATE, view);
    }

    public static void ocrToBankCard(OcrBankCardResult result, DataEntityPropertyCollection properties, IFormView view) {
        OcrToBusinessUtils.setProperties(properties, result.getCardNo(), InfoGroupFieldConstants.BANK_ACCOUNT, view);
    }

    public static void ocrWithData(Object[] urls, String businessObject, String templateNumber, IFormView view, String type) {
        if ("H5".equals(type)) {
            view.showTipNotification(ResManager.loadKDString((String)"OCR\u6587\u672c\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"InfoGroupDynViewMobilePlugin_10", (String)"hr-hom-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        } else {
            view.showLoading(ResManager.getLocaleString((String)"OCR\u6587\u672c\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"InfoGroupDynViewMobilePlugin_10", (String)"hr-hom-formplugin"));
        }
        if (HRStringUtils.isEmpty((String)templateNumber)) {
            return;
        }
        IHomToCvpAppService.getInstance().algoResultData(urls, businessObject, templateNumber, view);
        view.addClientCallBack(templateNumber, Integer.valueOf(5000));
    }

    public static void ocrWithData(Object[] urls, String businessObject, String templateNumber, IFormView view) {
        if (IHomToCvpAppService.getInstance().isEnableOcr().booleanValue()) {
            OcrToBusinessUtils.ocrWithData(urls, businessObject, templateNumber, view, "PC");
        }
    }

    public static void ocrWithDataH5(Object[] urls, String businessObject, String templateNumber, IFormView view) {
        if (OcrToBusinessUtils.getEnableOCR(view)) {
            OcrToBusinessUtils.ocrWithData(urls, businessObject, templateNumber, view, "H5");
        }
    }

    public static boolean getEnableOCR(IFormView view) {
        Object onboardId = view.getFormShowParameter().getCustomParam("onbrdid");
        DynamicObject onbrd = IOnbrdBillDomainService.getInstance().findOnbrdBillById("org", (Object)Long.parseLong(onboardId + ""));
        long org = onbrd.getLong("org.id");
        if (org == 0L) {
            return false;
        }
        return IHomToCvpAppService.getInstance().isEnableOcr(view, org);
    }
}

