/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.common;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.utils.PreOnbrdUtil;
import kd.hr.hom.business.application.utils.RuleCodeUtils;
import kd.hr.hom.business.domain.service.impl.onbrd.OnbrdInfoInitService;
import kd.hr.hom.business.domain.service.preonbrd.IPreOnBrdService;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.PreOnBrdCommonUtil;
import kd.hr.impt.common.dto.ImportBillData;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PreOnBrdHelper {
    private static final Log LOGGER = LogFactory.getLog(PreOnBrdHelper.class);
    public static final String SELECT_PROPERTIES = "id,billno,pbillno,entryentity,entryentity.certificatetype,entryentity.certificatenumber,entryentity.phone,entryentity.name,entryentity.peremail";

    public static List<String> generateBillNo(int size) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_candidatenumber");
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        ArrayList<String> numberList = new ArrayList<String>(size);
        RuleCodeUtils.codeRuleHandler((DynamicObject)dynamicObject, numberList, (int)size, (int)size);
        return numberList;
    }

    public static List<DynamicObject> buildOnbrdInfo(DynamicObjectCollection preOnBrdEntities, DynamicObject preOnBrd) {
        ArrayList onBrdList = Lists.newArrayListWithCapacity((int)3);
        long[] onbrdIds = ORM.create().genLongIds("hom_onbrdinfo", preOnBrdEntities.size());
        for (int i = 0; i < preOnBrdEntities.size(); ++i) {
            DynamicObject preOnBrdEntry = (DynamicObject)preOnBrdEntities.get(i);
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hom_onbrdinfo");
            DynamicObject onbrdInfo2 = hrBaseServiceHelper.generateEmptyDynamicObject();
            long id = preOnBrdEntry.getLong("id");
            onbrdInfo2.set("preentryonbrd", (Object)id);
            onbrdInfo2.set("preonbrd", (Object)preOnBrd.getLong("id"));
            long onbrdId = onbrdIds[i];
            onbrdInfo2.set("id", (Object)onbrdId);
            onbrdInfo2.set("auditstatus", (Object)"A");
            onbrdInfo2.set("billstatus", (Object)"A");
            onbrdInfo2.set("enrollstatus", (Object)OnbrdStatusEnum.WAIT_START.getValue());
            onbrdInfo2.set("org", preOnBrd.get("org"));
            onbrdInfo2.set("creator", (Object)RequestContext.get().getCurrUserId());
            onbrdInfo2.set("modifier", (Object)RequestContext.get().getCurrUserId());
            onbrdInfo2.set("createtime", (Object)new Date());
            onbrdInfo2.set("modifytime", (Object)new Date());
            onbrdInfo2.set("viewtype", (Object)ViewTypeEnum.ROUTINE.getCode());
            PreOnBrdHelper.setValue("pbillno", "candidatenumber", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("aadminorg", "aadminorg", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("name", "name", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("gender", "gender", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("certificatetype", "certificatetype", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("certificatenumber", "certificatenumber", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("phone", "phone", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("peremail", "peremail", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("nationality", "nationality", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("employeeno", "employeeno", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("enterprise", "enterprise", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("managementscope", "managementscope", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("acompany", "acompany", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("baselocation", "baselocation", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("contractlocation", "contractlocation", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("workcalendar", "workcalendar", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("apositiontype", "apositiontype", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("ajob", "ajob", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("jobgradescm", "jobgradescm", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("jobgrade", "ajobgrade", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("joblevel", "ajoblevel", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("onbrdtype", "onbrdtype", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("paffaction", "affaction", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("plaborreltype", "laborreltype", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("plaborrelstatus", "laborrelstatus", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("pposstatus", "posstatus", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("onbrdtcity", "onbrdtcity", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("dependency", "dependency", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("dependencytype", "dependencytype", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("empgroup", "empgroup", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("effectdate", "effectdate", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("validuntil", "validuntil", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("handler", "handler", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("isprobation", "isprobation", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("probationtime", "probationtime", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("perprobationtime", "perprobationtime", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("ppostype", "postype", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("recruittype", "recruittype", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("recruitsource", "recruitsource", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("resumeno", "resumeno", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("offernumber", "offernumber", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("teacher", "teacher", preOnBrdEntry, onbrdInfo2);
            PreOnBrdHelper.setValue("joblevelscm", "joblevelscm", preOnBrdEntry, onbrdInfo2);
            if (HRObjectUtils.isEmpty((Object)onbrdInfo2.get("org"))) {
                onbrdInfo2.set("org", preOnBrd.get("org"));
            }
            if (HRObjectUtils.isEmpty((Object)onbrdInfo2.get("ajobscmorg"))) {
                onbrdInfo2.set("ajobscmorg", preOnBrd.get("org"));
            }
            Long onbrdBillId = onbrdInfo2.getLong("id");
            onbrdInfo2.set("affiliateadminorg", onbrdInfo2.get("aadminorg"));
            onBrdList.add(onbrdInfo2);
        }
        OnbrdInfoInitService onbrdInfoInitService = new OnbrdInfoInitService();
        Map hrBuOrgMap = onbrdInfoInitService.getHRBuOrgMap(onBrdList.toArray(new DynamicObject[0]));
        onBrdList.forEach(onbrdInfo -> {
            Long onbrdBillId = onbrdInfo.getLong("id");
            onbrdInfo.set("hrbu", hrBuOrgMap.get(onbrdBillId));
        });
        return onBrdList;
    }

    private static void setValue(String orignKey, String targetKey, DynamicObject orignOnbrdInfo, DynamicObject targetOnbrdInfo) {
        if (!targetOnbrdInfo.containsProperty(targetKey)) {
            LOGGER.error("targetOnbrdInfo don't has property" + targetKey);
            return;
        }
        targetOnbrdInfo.set(targetKey, orignOnbrdInfo.get(orignKey));
    }

    private static void setValue(String orignKey, String targetKey, JSONObject orignOnbrdInfo, DynamicObject targetOnbrdInfo) {
        if (!targetOnbrdInfo.containsProperty(targetKey)) {
            LOGGER.error("targetOnbrdInfo don't has property" + targetKey);
            return;
        }
        targetOnbrdInfo.set(targetKey, orignOnbrdInfo.get((Object)orignKey));
    }

    public static Optional<String> validPersonIsExistByHspm(List<DynamicObject> onBrdList, String keyName) {
        ImmutableList fieldNames = HRStringUtils.isEmpty((String)keyName) ? ImmutableList.of((Object)"phone", (Object)"certificatenumber", (Object)"peremail") : ImmutableList.of((Object)keyName);
        Map checkResultMap = IHomToHrpiAppService.getInstance().checkAndTipByPersonFieldsForPre(onBrdList, (List)fieldNames);
        LOGGER.info("validPersonIsExistByHspm.checkResultMap:{}", (Object)checkResultMap);
        String errMsg = "";
        for (int i = 0; i < onBrdList.size(); ++i) {
            DynamicObject onbrdBillInfo = onBrdList.get(i);
            String validPersonResult = (String)checkResultMap.get(String.valueOf(onbrdBillInfo.getLong("id")));
            if (!HRStringUtils.isNotEmpty((String)validPersonResult)) continue;
            errMsg = String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c:%3$s", (String)"PreOnBrdHelper_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), errMsg, i + 1, validPersonResult);
            if (i >= onBrdList.size()) continue;
            errMsg = String.format(ResManager.loadKDString((String)"%s\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u3002", (String)"PreOnBrdHelper_3", (String)"hr-hom-formplugin", (Object[])new Object[]{errMsg}), new Object[0]);
            errMsg = ResManager.loadKDString((String)(errMsg + "\n"), (String)"", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            return Optional.of(errMsg);
        }
        return Optional.empty();
    }

    public static Optional<String> preUniqueValidate(List<DynamicObject> entryData, DynamicObject preOnBrd) {
        List perCerNos = entryData.stream().map(e -> e.getString("certificatenumber")).collect(Collectors.toList());
        DynamicObject[] dyByCerNos = IPreOnBrdService.getInstance().queryByCerNos(SELECT_PROPERTIES, perCerNos);
        String errMsg = "";
        for (int i = 0; i < entryData.size(); ++i) {
            DynamicObject entry = entryData.get(i);
            DynamicObject cerType = entry.getDynamicObject("certificatetype");
            String cerNo = entry.getString("certificatenumber");
            String name = entry.getString("name");
            for (DynamicObject dyByCerNo : dyByCerNos) {
                DynamicObjectCollection entryentity = dyByCerNo.getDynamicObjectCollection("entryentity");
                List isExist = entryentity.stream().filter(dy -> dy.getDynamicObject("certificatetype").equals(cerType) && dy.getString("certificatenumber").equals(cerNo)).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(isExist)) continue;
                String bigBillNo = preOnBrd.getString("billno");
                String repeatBillNo = dyByCerNo.getString("billno");
                if (!HRStringUtils.isNotEmpty((String)bigBillNo) || !HRStringUtils.isNotEmpty((String)repeatBillNo) || bigBillNo.equals(repeatBillNo)) continue;
                errMsg = String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\uff1a\u68c0\u6d4b\u5230%3$s\u5df2\u6709\u5728\u9014\u7684\u9884\u5165\u804c\u7533\u8bf7\u5355\uff08\u5355\u636e\u7f16\u53f7\uff1a%4$s\uff09\uff0c\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\u5458\u91cd\u590d\u53d1\u8d77\u3002", (String)"PreOnBrdHelper_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), errMsg, i + 1, name, dyByCerNo.getString("billno"));
                LOGGER.info("PreOnBrdBillEdit.preUniqueValidate:{}", isExist);
                if (i >= entryData.size()) continue;
                errMsg = ResManager.loadKDString((String)(errMsg + "\n"), (String)"", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            }
        }
        if (StringUtils.isEmpty((CharSequence)errMsg)) {
            return Optional.empty();
        }
        return Optional.of(errMsg);
    }

    public static Set<DynamicObject> onBrdUniqueValidate(List<DynamicObject> onBrdList) {
        ArrayList<String> validateFields = new ArrayList<String>();
        validateFields.add("certificatenumber");
        validateFields.add("peremail");
        validateFields.add("phone");
        return IOnbrdCommonAppService.getInstance().validSameFieldByHomForPre(validateFields, onBrdList);
    }

    public static List<DynamicObject> importBillDataToOnBrdData(List<ImportBillData> billDataList) {
        List jsonObjects = billDataList.stream().map(ImportBillData::getData).collect(Collectors.toList());
        List entryEntities = jsonObjects.stream().map(e -> e.getJSONObject("entryentity")).collect(Collectors.toList());
        long preOnBrdPkId = ORM.create().genLongId("hom_preonbrdbasebill");
        long[] onbrdIds = ORM.create().genLongIds("hom_onbrdinfo", entryEntities.size());
        ArrayList<DynamicObject> onBrdList = new ArrayList<DynamicObject>(1);
        for (int i = 0; i < entryEntities.size(); ++i) {
            JSONObject preOnBrdEntry = (JSONObject)entryEntities.get(i);
            String locationCode = preOnBrdEntry.getString("locationcode");
            if (HRStringUtils.isNotEmpty((String)locationCode) && !locationCode.startsWith("+")) {
                locationCode = "+" + locationCode;
            }
            String phoneCode = preOnBrdEntry.getString("phonecode");
            preOnBrdEntry.put("phone", (Object)(locationCode + "-" + phoneCode));
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hom_onbrdinfo");
            DynamicObject onbrdInfo = hrBaseServiceHelper.generateEmptyDynamicObject();
            long onbrdId = onbrdIds[i];
            onbrdInfo.set("id", (Object)onbrdId);
            preOnBrdEntry.put("prepkid", (Object)onbrdId);
            preOnBrdEntry.put("preuniqueid", (Object)preOnBrdPkId);
            onbrdInfo.set("auditstatus", (Object)"A");
            onbrdInfo.set("billstatus", (Object)"A");
            onbrdInfo.set("enrollstatus", (Object)OnbrdStatusEnum.WAIT_START.getValue());
            onbrdInfo.set("creator", (Object)RequestContext.get().getCurrUserId());
            onbrdInfo.set("modifier", (Object)RequestContext.get().getCurrUserId());
            onbrdInfo.set("createtime", (Object)new Date());
            onbrdInfo.set("modifytime", (Object)new Date());
            onbrdInfo.set("viewtype", (Object)ViewTypeEnum.ROUTINE.getCode());
            PreOnBrdHelper.setValue("pbillno", "candidatenumber", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("aadminorg", "aadminorg", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("name", "name", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("gender", "gender", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("certificatetype", "certificatetype", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("certificatenumber", "certificatenumber", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("phone", "phone", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("peremail", "peremail", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("nationality", "nationality", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("employeeno", "employeeno", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("enterprise", "enterprise", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("managementscope", "managementscope", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("acompany", "acompany", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("baselocation", "baselocation", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("contractlocation", "contractlocation", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("workcalendar", "workcalendar", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("apositiontype", "apositiontype", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("ajob", "ajob", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("jobgradescm", "jobgradescm", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("jobgrade", "ajobgrade", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("joblevel", "ajoblevel", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("onbrdtype", "onbrdtype", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("paffaction", "affaction", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("plaborreltype", "laborreltype", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("plaborrelstatus", "laborrelstatus", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("pposstatus", "posstatus", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("onbrdtcity", "onbrdtcity", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("dependency", "dependency", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("dependencytype", "dependencytype", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("empgroup", "empgroup", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("effectdate", "effectdate", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("validuntil", "validuntil", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("handler", "handler", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("isprobation", "isprobation", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("probationtime", "probationtime", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("perprobationtime", "perprobationtime", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("ppostype", "postype", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("recruittype", "recruittype", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("recruitsource", "recruitsource", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("resumeno", "resumeno", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("offernumber", "offernumber", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("teacher", "teacher", preOnBrdEntry, onbrdInfo);
            PreOnBrdHelper.setValue("joblevelscm", "joblevelscm", preOnBrdEntry, onbrdInfo);
            onBrdList.add(onbrdInfo);
        }
        return onBrdList;
    }

    public static Optional<String> formatValidate(List<DynamicObject> onBrdList) {
        List phones = onBrdList.stream().map(onBrd -> onBrd.getString("phone")).distinct().collect(Collectors.toList());
        Map telephoneVerifyMap = PreOnbrdUtil.getInstance().telephoneVerify(phones);
        StringBuilder errMsg = new StringBuilder();
        for (int i = 0; i < onBrdList.size(); ++i) {
            DynamicObject onBrdDy = onBrdList.get(i);
            String phone = onBrdDy.getString("phone");
            Boolean verifyResult = telephoneVerifyMap.getOrDefault(phone, Boolean.FALSE);
            String checkFormat = PreOnbrdUtil.getInstance().checkFormat(onBrdDy, verifyResult.booleanValue());
            if (!HRStringUtils.isNotEmpty((String)checkFormat)) continue;
            errMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c:%2$s", (String)"PreOnBrdHelper_1", (String)"hr-hom-formplugin", (Object[])new Object[0]), i + 1, checkFormat)).append("\n");
        }
        if (ObjectUtils.isNotEmpty((Object)errMsg)) {
            return Optional.of(errMsg.toString());
        }
        return Optional.empty();
    }

    public static Optional<String> fieldUniqueValidate(List<DynamicObject> onBrdList) {
        Set<DynamicObject> onBrdRepeatDys = PreOnBrdHelper.onBrdUniqueValidate(onBrdList);
        ImmutableList fieldNames = ImmutableList.of((Object)"phone", (Object)"certificatenumber", (Object)"peremail");
        Map checkResultMap = IHomToHrpiAppService.getInstance().checkAndTipByPersonFieldsForPre(onBrdList, (List)fieldNames);
        LOGGER.info("validPersonIsExistByHspm.checkResultMap:{}", (Object)checkResultMap);
        String repeatErrorMessage = PreOnBrdCommonUtil.getRepeatErrorMessage(onBrdRepeatDys, onBrdList, (Map)checkResultMap);
        if (StringUtils.isNotBlank((CharSequence)repeatErrorMessage)) {
            return Optional.of(repeatErrorMessage);
        }
        return Optional.empty();
    }

    public static Optional<String> mustInputValidate(List<DynamicObject> onBrdList) {
        String mustInputErrorMessage = PreOnBrdCommonUtil.getMustInputErrorMessage(onBrdList);
        if (StringUtils.isNotBlank((CharSequence)mustInputErrorMessage)) {
            return Optional.of(mustInputErrorMessage);
        }
        return Optional.empty();
    }
}

