/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.mobile.onbrd;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.events.LocateEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MobLocation;
import kd.bos.ext.form.control.MapControl;
import kd.bos.ext.form.dto.MapSelectPointOption;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hom.business.application.mobile.IMobCommonAppService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.common.PointUtil;

public class InMapMobilePlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(InMapMobilePlugin.class);
    private static final String COME = "come";
    private static final String IS_COME = "flexpanelapin";
    private static final String NO_COME = "flexpanelapnotin";
    private static final HRBaseServiceHelper HOM_PLACEENTRY_HELPER = new HRBaseServiceHelper("hom_placeentry");
    private static final String YES = "Yes";
    private static final String ERROR_TYPE2 = "2";
    private static final String ERROR_TYPE3 = "3";
    private static final String ERROR_TYPE4 = "04";
    private static final String GPS_STATUS = "1";
    private static final String ERROR_STATUS = "ERROR_TYPE";
    private static final String GPS = "GPS_STATUS";

    public void afterCreateNewData(EventObject e) {
        this.initView();
    }

    private void initView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{IS_COME});
        this.getView().setVisible(Boolean.FALSE, new String[]{NO_COME});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().addClientCallBack("selectPoint", Integer.valueOf(500));
        this.getView().addClientCallBack("showGPSInfo", Integer.valueOf(3500));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        LOGGER.info("\u8fdb\u5165\u56de\u8c03clientCallBack");
        if ("selectPoint".equals(e.getName())) {
            this.setCompLoc();
        }
        if ("showGPSInfo".equals(e.getName())) {
            this.showGPSInfo();
        }
    }

    private void setCompLoc() {
        LOGGER.info("clientCallBack_setCompLoc");
        Long onbrdBillId = this.getOnbrdBillId();
        this.initLoc(onbrdBillId);
    }

    private void showGPSInfo() {
        String gpsStatus = this.getView().getPageCache().get(GPS);
        LOGGER.info("showGPSInfo_gpsStatus:{}", (Object)(gpsStatus == null ? "null" : gpsStatus));
        if (StringUtils.isEmpty((CharSequence)gpsStatus) || !GPS_STATUS.equals(gpsStatus)) {
            LOGGER.info("\u8bbe\u7f6e\u4e3a\u573a\u666f2_2");
            this.getView().getPageCache().put(ERROR_STATUS, ERROR_TYPE2);
            this.getView().setVisible(Boolean.TRUE, new String[]{NO_COME});
            String tip = ResManager.loadKDString((String)"\u60a8\u7684\u8bbe\u5907\u672a\u5f00\u542fGPS\u5b9a\u4f4d\u670d\u52a1\uff0c\u70b9\u51fb\u201c\u63d0\u4ea4\u62a5\u5230\u7533\u8bf7\u201d\u540e\u8fd8\u9700\u540e\u53f0\u5de5\u4f5c\u4eba\u5458\u786e\u8ba4\u3002", (String)"MapMobilePlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tip);
        }
    }

    public void locate(LocateEvent e) {
        LOGGER.info("InMapMobilePlugin_locate");
        super.locate(e);
        MobLocation location = e.getMobLocation();
        LOGGER.info("locate_Lat:" + location.getLatitude() + "Lng:" + location.getLongitude());
        this.getView().getPageCache().put(GPS, GPS_STATUS);
        this.getView().getPageCache().put("Latitude", String.valueOf(location.getLatitude()));
        this.getView().getPageCache().put("Longitude", String.valueOf(location.getLongitude()));
        Long onbrdBillId = this.getOnbrdBillId();
        this.isInside(onbrdBillId, location);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "come": {
                this.come();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (ERROR_TYPE3.equals(messageBoxClosedEvent.getCallBackId()) && YES.equals(messageBoxClosedEvent.getResultValue())) {
            this.comeWithType();
        }
    }

    private void come() {
        LOGGER.info("\u8fdb\u5165come");
        String errorStatus = this.getView().getPageCache().get(ERROR_STATUS);
        LOGGER.info("ERROR_TYPE:" + errorStatus);
        switch (errorStatus) {
            case "3": {
                String tip = ResManager.loadKDString((String)"\u6839\u636e\u5b9a\u4f4d\u4fe1\u606f\uff0c\u60a8\u5c1a\u672a\u5230\u8fbe\u62a5\u5230\u5730\u5740\u9644\u8fd1\u3002\u8bf7\u8fdb\u884c\u81ea\u52a9\u62a5\u5230\uff0c\u5e76\u7b49\u5f85\u540e\u53f0\u5de5\u4f5c\u4eba\u5458\u786e\u8ba4\u3002", (String)"MapMobilePlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ERROR_TYPE3, (IFormPlugin)this));
                break;
            }
            default: {
                this.comeWithType();
            }
        }
    }

    private void comeWithType() {
        Long onbrdBillId = this.getOnbrdBillId();
        LOGGER.info("error_status:" + this.getView().getPageCache().get(ERROR_STATUS));
        IMobCommonAppService.getInstance().doCheckinConfirm(this.getView(), onbrdBillId, this.getView().getPageCache().get(ERROR_STATUS));
    }

    private DynamicObject getOnbrdtCity(Long onbrdBillId) {
        if (Objects.isNull(onbrdBillId)) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdBillId);
        DynamicObject onbrdBillInfo = IOnbrdBillDomainService.getInstance().findOnbrdBill("onbrdtcity", new QFilter[]{qFilter});
        if (Objects.isNull(onbrdBillInfo)) {
            LOGGER.info("onbrdBillInfo_null");
            return null;
        }
        DynamicObject onbrdtCity = onbrdBillInfo.getDynamicObject("onbrdtcity");
        if (Objects.isNull(onbrdtCity)) {
            LOGGER.info("onbrdtCity_null");
            return null;
        }
        QFilter qFilter1 = new QFilter("id", "=", (Object)onbrdtCity.getLong("id"));
        return HOM_PLACEENTRY_HELPER.loadDynamicObject(qFilter1);
    }

    private void isInside(Long onbrdBillId, MobLocation location) {
        DynamicObject onbrdtCity = this.getOnbrdtCity(onbrdBillId);
        if (Objects.isNull(location) || Objects.isNull(onbrdtCity)) {
            LOGGER.info("MapMobilePlugin_not_loc");
            return;
        }
        this.calculateDistance(onbrdtCity, location);
    }

    private Boolean calculateDistance(DynamicObject onbrdtCity, MobLocation location) {
        LOGGER.info("come_in_calculateDistance");
        double longitude1 = onbrdtCity.getBigDecimal("longitude").doubleValue();
        double longitude2 = location.getLongitude();
        double latitude1 = onbrdtCity.getBigDecimal("latitude").doubleValue();
        double latitude2 = location.getLatitude();
        Double s = PointUtil.getDistance(latitude1, longitude1, latitude2, longitude2);
        LOGGER.info("calculateDistance\uff1a{}", (Object)s);
        BigDecimal bigDecimal = onbrdtCity.getBigDecimal("effectradius");
        if (bigDecimal.compareTo(BigDecimal.valueOf(s)) >= 0) {
            LOGGER.info("calculateDistance_in");
            this.getView().getPageCache().put(ERROR_STATUS, ERROR_TYPE4);
            this.getView().setVisible(Boolean.FALSE, new String[]{NO_COME});
            this.getView().setVisible(Boolean.TRUE, new String[]{IS_COME});
            return Boolean.TRUE;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{NO_COME});
        this.getView().getPageCache().put(ERROR_STATUS, ERROR_TYPE3);
        LOGGER.info("calculateDistance_not_in");
        return Boolean.FALSE;
    }

    private void initLoc(Long onbrdBillId) {
        MapControl control = (MapControl)this.getView().getControl("mapcontrolap");
        MapSelectPointOption mapSelectPointOption = new MapSelectPointOption();
        mapSelectPointOption.setTitle(ResManager.loadKDString((String)"\u53f8", (String)"MapMobilePlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        if (Objects.isNull(onbrdBillId)) {
            control.selectPoint(mapSelectPointOption);
            return;
        }
        DynamicObject dynamicObject = this.getOnbrdtCity(onbrdBillId);
        if (!Objects.isNull(dynamicObject)) {
            LOGGER.info("\u8bbe\u7f6e\u516c\u53f8\u7ecf\u7eac\u5ea6");
            mapSelectPointOption.setLng(dynamicObject.getBigDecimal("longitude").doubleValue());
            mapSelectPointOption.setLat(dynamicObject.getBigDecimal("latitude").doubleValue());
        }
        control.getAddress();
        control.selectPoint(mapSelectPointOption);
    }

    private Long getOnbrdBillId() {
        Long onbrdBillId = (Long)this.getView().getFormShowParameter().getCustomParam("onbrdid");
        return onbrdBillId;
    }
}

