/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.mobile.onbrd;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.common.util.LanguageUtils;

public class LanguageMobPlugin
extends AbstractMobFormPlugin {
    public static final String INTE_SYSLANG = "inte_syslang";

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        ComboEdit sysLangEdit = (ComboEdit)this.getControl(INTE_SYSLANG);
        List comboItemList = LanguageUtils.getLangComboItemList();
        sysLangEdit.setComboItems(comboItemList);
        this.showCurrentLang();
    }

    private void showCurrentLang() {
        this.getModel().beginInit();
        this.getModel().setValue(INTE_SYSLANG, (Object)LanguageUtils.getCurrentSysLangNumber());
        this.getView().updateView(INTE_SYSLANG);
        this.getModel().endInit();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        if (HRStringUtils.equals((String)INTE_SYSLANG, (String)args.getProperty().getName())) {
            Object sysLang = this.getModel().getValue(INTE_SYSLANG);
            if (sysLang == null || HRStringUtils.isEmpty((String)sysLang.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u79cd\u8bed\u8a00\u3002", (String)"LanguageMobPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("hom_moblanguage", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u62e9\u5176\u4ed6\u8bed\u8a00\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"LanguageMobPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            Object sysLang = this.getModel().getValue(INTE_SYSLANG);
            if (sysLang != null) {
                LanguageUtils.switchLanguage((String)sysLang.toString());
            }
            this.getView().close();
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
            }
        } else {
            this.showCurrentLang();
        }
    }
}

