/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.mobile.onbrd;

import com.alibaba.fastjson.JSONObject;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.mobile.IMobCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.impl.common.SendMessageServiceImpl;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.util.LanguageUtils;

public class LoginMobilePlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(LoginMobilePlugin.class);
    private static final String OPKEY_LOGIN = "login";
    private static final String OPKEY_PRIVACYSHOW = "privacyshow";
    private static final String OPKEY_GETCODE = "getcode";
    private static final String INTE_SYSLANG = "inte_syslang";
    private static final String SELECTSTATUS = "selectstatus";
    private static final String VERIFYCODE = "verifycode";
    private static final String APPCACHE_KEY_LOGIN = "hom:SendMessage:login";
    private static final String APPCACHE_KEY_LOGIN_VERIFYCODE = "verifyCode";

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        ComboEdit sysLangEdit = (ComboEdit)this.getControl(INTE_SYSLANG);
        List comboItemList = LanguageUtils.getLangComboItemList();
        sysLangEdit.setComboItems(comboItemList);
        this.showCurrentLang();
    }

    private void showCurrentLang() {
        this.getModel().beginInit();
        this.getModel().setValue(INTE_SYSLANG, (Object)LanguageUtils.getCurrentSysLangNumber());
        this.getView().updateView(INTE_SYSLANG);
        this.getModel().endInit();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        if (HRStringUtils.equals((String)INTE_SYSLANG, (String)propertyName)) {
            Object sysLang = this.getModel().getValue(INTE_SYSLANG);
            if (sysLang == null || HRStringUtils.isEmpty((String)sysLang.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u79cd\u8bed\u8a00\u3002", (String)"LoginMobilePlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("hom_login", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u62e9\u5176\u4ed6\u8bed\u8a00\uff0c\u5207\u6362\u540e\u5c06\u4f1a\u5237\u65b0\u9875\u9762\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"LoginMobilePlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBackListener);
        } else if (HRStringUtils.equals((String)VERIFYCODE, (String)propertyName) || HRStringUtils.equals((String)SELECTSTATUS, (String)propertyName)) {
            // empty if block
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            Object sysLang = this.getModel().getValue(INTE_SYSLANG);
            if (sysLang != null) {
                LanguageUtils.switchLanguage((String)sysLang.toString());
            }
            this.getView().getPageCache().expireAfter(1);
            IMobCommonAppService.getInstance().showPageNoBackWithOnbrdId(this.getView(), null, "hom_login", null);
        } else {
            this.showCurrentLang();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)OPKEY_LOGIN, (String)operateKey)) {
            DynamicObject onbrdBill;
            DynamicObject pageInfo = this.getModel().getDataEntity();
            String phone = pageInfo.getString("phone");
            if (HRStringUtils.isEmpty((String)phone)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u624b\u673a\u53f7\u7801\u3002", (String)"LoginMobilePlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!phone.contains("-")) {
                phone = phone.replace("+86", "+86-");
            }
            if (HRObjectUtils.isEmpty((Object)(onbrdBill = this.getOnbrdInfoByPhone(phone)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5019\u9009\u4eba\u3002", (String)"LoginMobilePlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            assert (onbrdBill != null);
            String verifyCode = pageInfo.getString(VERIFYCODE);
            Long onbrdBillId = onbrdBill.getLong("id");
            IMobCommonAppService.getInstance().showHomePage(this.getView(), onbrdBillId);
        } else if (HRStringUtils.equals((String)OPKEY_PRIVACYSHOW, (String)operateKey)) {
            IMobCommonAppService.getInstance().showPageWithOnbrdId(this.getView(), null, "hom_privacyshow");
        } else if (HRStringUtils.equals((String)OPKEY_GETCODE, (String)operateKey)) {
            this.sendVerifyCode();
        }
    }

    private void sendVerifyCode() {
        String phone = this.validatePhone();
        if (HRStringUtils.isEmpty((String)phone)) {
            return;
        }
        String verifyCode = IOnbrdCommonAppService.getInstance().getPhoneVerifyCode();
        IHRAppCache cache = HRAppCache.get((String)APPCACHE_KEY_LOGIN);
        JSONObject jsonObject = (JSONObject)cache.get(phone, JSONObject.class);
        Integer sendCount = 1;
        Long firstTime = System.currentTimeMillis();
        if (jsonObject == null || jsonObject.isEmpty()) {
            jsonObject = new JSONObject();
            jsonObject.put("firstTime", (Object)System.currentTimeMillis());
        } else {
            sendCount = jsonObject.getInteger("sendCount") + 1;
            firstTime = jsonObject.getLong("firstTime");
        }
        if (System.currentTimeMillis() - firstTime < 300000L && sendCount > 5) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u53d1\u9001\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"LoginMobilePlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        String messageContext = String.format(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\uff1a%s\uff0c15\u5206\u949f\u5185\u6709\u6548\u3002\u8be5\u9a8c\u8bc1\u7801\u7528\u4e8e\u767b\u5f55\u5165\u804c\u670d\u52a1\u5e73\u53f0\uff0c\u8bf7\u52ff\u6cc4\u9732\u8be5\u9a8c\u8bc1\u7801\u3002", (String)"LoginMobilePlugin_8", (String)"hr-hom-formplugin", (Object[])new Object[0]), verifyCode);
        boolean sendResult = new SendMessageServiceImpl().sendMessage(phone, messageContext);
        if (sendResult) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536\u77ed\u4fe1\u3002", (String)"LoginMobilePlugin_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            jsonObject.put(APPCACHE_KEY_LOGIN_VERIFYCODE, (Object)verifyCode);
            jsonObject.put("sendCount", (Object)sendCount);
            jsonObject.put("lastTime", (Object)System.currentTimeMillis());
            cache.put(phone, (Object)jsonObject);
        }
    }

    private String validatePhone() {
        DynamicObject pageInfo = this.getModel().getDataEntity();
        String phone = pageInfo.getString("phone");
        if (HRStringUtils.isEmpty((String)phone)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u624b\u673a\u53f7\u7801\u3002", (String)"LoginMobilePlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return null;
        }
        phone = phone.replace("+86", "+86-");
        Optional validateResult = IOnbrdCommonAppService.getInstance().validatePhone(phone);
        if (validateResult.isPresent()) {
            this.getView().showTipNotification((String)validateResult.get());
            return null;
        }
        return phone;
    }

    private DynamicObject getOnbrdInfoByPhone(String phone) {
        QFilter qFilter = new QFilter("phone", "=", (Object)phone);
        Object[] onbrdBillInfos = IOnbrdBillDomainService.getInstance().findOnbrdBills("enrollstatus", new QFilter[]{qFilter});
        if (HRArrayUtils.isEmpty((Object[])onbrdBillInfos)) {
            LOGGER.info("cannot find onbrdBill");
            return null;
        }
        List onbrdInfosSorted = Stream.of(onbrdBillInfos).sorted(Comparator.comparing(onbrdBillInfo -> onbrdBillInfo.getString("enrollstatus"), Comparator.naturalOrder())).collect(Collectors.toList());
        return (DynamicObject)onbrdInfosSorted.get(0);
    }
}

