/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.mobile.onbrd;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.hr.web.util.HrGuestUrlUtil;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.mobile.IMobCommonAppService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;

public class PersonalCenterMobilePlugin
extends AbstractMobFormPlugin {
    private static final String PROPERTIES_SHOWPAGE = "id,name,candidate,employeeno,picturefield,aadminorg,aposition,stdposition,apositiontype,baselocation,validuntil";
    private static final String OPKEY_PRIVACYSHOW = "privacyshow";
    private static final String OPKEY_LOGOUT = "logout";

    public void afterCreateNewData(EventObject eventObject) {
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdBillId);
        DynamicObject onbrdBillInfo = IOnbrdBillDomainService.getInstance().findOnbrdBill(PROPERTIES_SHOWPAGE, new QFilter[]{qFilter});
        if (HRObjectUtils.isEmpty((Object)onbrdBillInfo)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReservationMobilePlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        String headphoto = onbrdBillInfo.getString("picturefield");
        if (HRStringUtils.isNotEmpty((String)headphoto)) {
            this.getModel().setValue("headphoto", (Object)headphoto);
        }
        this.setLabelText("name", onbrdBillInfo.getLocaleString("name").getLocaleValue());
        this.setLabelText("aadminorg", onbrdBillInfo.getString("aadminorg.name"));
        String apositionType = onbrdBillInfo.getString("apositiontype");
        if (HRStringUtils.equals((String)"1", (String)apositionType)) {
            this.setLabelText("aposition", onbrdBillInfo.getString("aposition.name"));
        } else {
            this.setLabelText("positiontype", ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d\uff1a", (String)"PersonalCenterMobilePlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.setLabelText("aposition", onbrdBillInfo.getString("stdposition.name"));
        }
        this.setLabelText("baselocation", onbrdBillInfo.getString("baselocation.name"));
        Date validUntilDate = onbrdBillInfo.getDate("validuntil");
        this.setLabelText("validuntil", validUntilDate == null ? "-" : HRDateTimeUtils.format((Date)validUntilDate, (String)"yyyy-MM-dd"));
    }

    private void setLabelText(String key, String value) {
        Label label = (Label)this.getView().getControl(key);
        if (HRStringUtils.isEmpty((String)value)) {
            label.setText("-");
        } else {
            label.setText(value);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)OPKEY_PRIVACYSHOW, (String)operateKey)) {
            Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
            IMobCommonAppService.getInstance().showPageWithOnbrdId(this.getView(), onbrdBillId, "hom_privacyshow");
        } else if (HRStringUtils.equals((String)OPKEY_LOGOUT, (String)operateKey)) {
            HrGuestUrlUtil.hrLogout((IFormView)this.getView());
        }
    }
}

