/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.mobile.onbrd.homepage;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.mobile.IMobCommonAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.repository.config.CollectConfigRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.collect.IAcceptManageService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.AcceptManageEnum;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.common.enums.CollectApproveStatusEnum;
import kd.hr.hom.common.enums.CollectManageStatusEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;
import kd.hr.hom.formplugin.common.ApBuildUtils;

public class HomePageMobilePlugin
extends AbstractMobFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(HomePageMobilePlugin.class);
    private static final String CLICK_INFO = "click_info";
    private static final String CLICK_DATAACCEPT = "click_dataaccept";
    private static final String CLICK_APPOINT = "click_appoint";
    private static final String CLICK_CHECKIN = "click_checkin";
    private static final String CLICK_INFO_FLEX = "click_info_flex";
    private static final String CLICK_DATAACCEPT_FLEX = "click_dataaccept_flex";
    private static final String CLICK_APPOINT_FLEX = "click_appoint_flex";
    private static final String CLICK_CHECKIN_FLEX = "click_checkin_flex";
    private static final String SELECT_PROPERTIES = "id,activityscheme,entryentity.activity,entryentity.seq,entryentity.activityins,entryentity.createtime,entryentity.latestdeadline";
    private static final String ONBRD = "onbrd";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ACTIVITYINS = "activityins";
    private static final String ACTIVITY = "activity";
    private static final String TASKSTATUS = "taskstatus";
    private static final String NUMBER = "number";
    private static final String APPOINTLABEL = "appointlabel";
    private static final String INFOLABEL = "infolabel";
    private static final String DATAACCEPTLABEL = "dataacceptlabel";
    private static final String CHECKINLABEL = "checkinlabel";
    private static final String APPOINTALLOT = "appointallot";
    private static final String INFOALLOT = "infoallot";
    private static final String DATAACCEPTALLOT = "dataacceptallot";
    private static final String CHECKINALLOT = "checkinallot";
    private static final String APPOINTREMARK = "appointremark";
    private static final String INFOREMARK = "inforemark";
    private static final String DATAACCEPTREMARK = "dataacceptremark";
    private static final String CHECKINREMARK = "checkinremark";
    private static final String BORDERSTYLE_BLUE = "1px_solid_#55A0F5";
    private static final String BORDERSTYLE_GREEN = "1px_solid_#26B175";
    private static final String BORDERSTYLE_RED = "1px_solid_#FD6C6A";
    private static final String BORDERSTYLE_GRAY = "1px_solid_#B2B2B2";
    private static final String BLUE = "#55A0F5";
    private static final String GREEN = "#26B175";
    private static final String RED = "#FD6C6A";
    private static final String GRAY = "#B2B2B2";
    private static final String BACKBLUE = "#F2F9FF";
    private static final String BACKGREEN = "#F2FFF5";
    private static final String BACKRED = "#FFF2F4";
    private static final String BACKGRAY = "##F5F5F5";
    private static final String HOMECHECKINFLEX = "homecheckinflex";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        LOGGER.info("====HomePageMobilePlugin.afterCreateNewData.begin====");
        this.setActivityVisible();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        LOGGER.info("===HomePageMobilePlugin onbrdId:{}===", (Object)onbrdId);
        this.showHomePageCheckIn(onbrdId);
        QFilter filter = new QFilter(ONBRD, "=", (Object)onbrdId);
        DynamicObject activityInfodyo = IActivityDomainService.getInstance().findActivityInfo(SELECT_PROPERTIES, filter);
        if (Objects.isNull(activityInfodyo)) {
            LOGGER.info("====HomePageMobilePlugin activity is not start ===");
            this.checkActivityIsExist("0", INFOLABEL, INFOALLOT);
            this.checkActivityIsExist("0", APPOINTLABEL, APPOINTALLOT);
            this.checkActivityIsExist("0", DATAACCEPTLABEL, DATAACCEPTALLOT);
            this.checkActivityIsExist("0", CHECKINLABEL, CHECKINALLOT);
            return;
        }
        DynamicObjectCollection coll = activityInfodyo.getDynamicObjectCollection(ENTRYENTITY);
        LinkedHashMap<Long, String> activityMap = new LinkedHashMap<Long, String>(coll.size());
        for (DynamicObject dyo : coll) {
            LOGGER.info("====HomePageMobilePlugin coll {} ===", (Object)dyo.toString());
            DynamicObject activityIns = dyo.getDynamicObject(ACTIVITYINS);
            DynamicObject activity = dyo.getDynamicObject(ACTIVITY);
            if (Objects.isNull(activityIns) && Objects.isNull(activity)) {
                LOGGER.info("====HomePageMobilePlugin activityIns && activity is null");
                continue;
            }
            if (Objects.isNull(activityIns)) {
                LOGGER.info("====HomePageMobilePlugin activityIns is null");
                activityMap.put(activity.getLong("id"), "0");
                continue;
            }
            if (Objects.isNull(activity)) continue;
            if (ActivityStatusEnum.PROCESSING.getValue().equals(activityIns.getString(TASKSTATUS)) || ActivityStatusEnum.COMPLETED.getValue().equals(activityIns.getString(TASKSTATUS))) {
                LOGGER.info("====HomePageMobilePlugin activityIns PROCESSING or COMPLETED {} ===", (Object)activity.getLong("id"));
                activityMap.put(activity.getLong("id"), "1");
                continue;
            }
            activityMap.put(activity.getLong("id"), "0");
        }
        this.showHomePageView(activityMap);
        LOGGER.info("====HomePageMobilePlugin.afterCreateNewData.begin====");
    }

    public void afterCreateNewData(EventObject e) {
        LOGGER.info("===hompage afterCreateNewData==");
    }

    private void setActivityVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{CLICK_APPOINT_FLEX});
        this.getView().setVisible(Boolean.FALSE, new String[]{CLICK_INFO_FLEX});
        this.getView().setVisible(Boolean.FALSE, new String[]{CLICK_DATAACCEPT_FLEX});
        this.getView().setVisible(Boolean.FALSE, new String[]{CLICK_CHECKIN_FLEX});
    }

    private void showHomePageCheckIn(Long onbrdId) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"guideflexpanelap"});
        QFilter conFilter = new QFilter(ONBRD, "=", (Object)onbrdId);
        DynamicObject configDyo = HomCommonRepository.queryDynamicObject((String)"hom_onbrdinvite", (String)"", (QFilter[])new QFilter[]{conFilter});
        if (Objects.isNull(configDyo)) {
            LOGGER.info("====HomePageMobilePlugin configDyo is null ===");
            return;
        }
        Long id = configDyo.getLong("guidetpl.id");
        DynamicObject guidDyo = HomCommonRepository.queryDynamicObjectByPk((String)"hom_guidscheme", (String)"", (Object)id);
        if (Objects.isNull(guidDyo)) {
            LOGGER.info("====HomePageMobilePlugin guidDyo is null ===");
            return;
        }
        DynamicObjectCollection guidColl = guidDyo.getDynamicObjectCollection(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)guidColl)) {
            LOGGER.info("====HomePageMobilePlugin guidColl is null ===");
            return;
        }
        IMobCommonAppService.getInstance().showViewByDyos(HOMECHECKINFLEX, this.getView(), onbrdId, guidColl);
        this.getView().setVisible(Boolean.TRUE, new String[]{"guideflexpanelap"});
    }

    private void showHomePageView(Map<Long, String> activityMap) {
        LOGGER.info("====HomePageMobilePlugin showHomePageView begin===");
        for (Map.Entry<Long, String> entry : activityMap.entrySet()) {
            Long activityId = entry.getKey();
            String value = entry.getValue();
            LOGGER.info("===HomePageMobilePlugin activityId:{} value:{}===", (Object)activityId, (Object)value);
            if (activityId.equals(ActivityNumberEnum.APPOINTMENT.getId())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{CLICK_APPOINT_FLEX});
                this.setRollStatusLabel(value);
                continue;
            }
            if (activityId.equals(ActivityNumberEnum.CHECKININFO.getId())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{CLICK_CHECKIN_FLEX});
                this.setCheckInStatus(value);
                continue;
            }
            if (activityId.equals(ActivityNumberEnum.DATAACCEPTANCE.getId())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{CLICK_DATAACCEPT_FLEX});
                this.setDataAcceptStatus(value);
                continue;
            }
            if (activityId.equals(ActivityNumberEnum.INFOAUDIT.getId())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{CLICK_INFO_FLEX});
                this.setAproveStatus(value);
                continue;
            }
            if (activityId.equals(ActivityNumberEnum.INFOCOLLECTION.getId())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{CLICK_INFO_FLEX});
                this.setCollectStatus(value);
                continue;
            }
            LOGGER.info("===HomePageMobilePlugin without matching===", (Object)activityId, (Object)value);
        }
    }

    private void setCollectStatus(String value) {
        LOGGER.info("====HomePageMobilePlugin setCollectStatus begin ===");
        if (this.checkActivityIsExist(value, INFOLABEL, INFOALLOT)) {
            return;
        }
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        DynamicObject dyo = HomCommonRepository.queryDynamicObject((String)"hom_collect", (String)"", (QFilter[])new QFilter[]{new QFilter("onboard", "=", (Object)onbrdId)});
        if (HRObjectUtils.isEmpty((Object)dyo)) {
            return;
        }
        String collectstatus = dyo.getString("collectstatus");
        if (collectstatus.equals(CollectManageStatusEnum.SUBMIT.getStatus())) {
            ApBuildUtils.setLabelStyle(CollectManageStatusEnum.SUBMIT.getDesc(), BORDERSTYLE_BLUE, BLUE, INFOLABEL, this.getView(), BACKBLUE);
            ApBuildUtils.setLabelData(this.getView(), INFOREMARK, ResManager.loadKDString((String)"\u5c3d\u5feb\u5f55\u5165\u91c7\u96c6\u4fe1\u606f\u3002", (String)"HomePageMobilePlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        if (collectstatus.equals(CollectManageStatusEnum.FINISH.getStatus())) {
            String name = ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"ACCEPTMOBILE_15", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            ApBuildUtils.setLabelStyle(name, BORDERSTYLE_GREEN, GREEN, INFOLABEL, this.getView(), BACKGREEN);
            ApBuildUtils.setLabelData(this.getView(), INFOREMARK, ResManager.loadKDString((String)"\u4fe1\u606f\u91c7\u96c6\u5df2\u5b8c\u6210\u3002", (String)"HomePageMobilePlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
    }

    private void setAproveStatus(String value) {
        String name;
        LOGGER.info("====HomePageMobilePlugin setAproveStatus begin ===");
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        DynamicObject dyo = HomCommonRepository.queryDynamicObject((String)"hom_collect", (String)"", (QFilter[])new QFilter[]{new QFilter("onboard", "=", (Object)onbrdId)});
        if (HRObjectUtils.isEmpty((Object)dyo)) {
            return;
        }
        String approvestatus = dyo.getString("approvestatus");
        if (approvestatus.equals(CollectApproveStatusEnum.APPROVING.getStatus())) {
            ApBuildUtils.setLabelStyle(CollectApproveStatusEnum.APPROVING.getDesc(), BORDERSTYLE_BLUE, BLUE, INFOLABEL, this.getView(), BACKBLUE);
            ApBuildUtils.setLabelData(this.getView(), INFOREMARK, ResManager.loadKDString((String)"\u4fe1\u606f\u5ba1\u6838\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"HomePageMobilePlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        if (approvestatus.equals(CollectApproveStatusEnum.REJECT.getStatus())) {
            name = ResManager.loadKDString((String)"\u5df2\u9a73\u56de", (String)"ACCEPTMOBILE_5", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            ApBuildUtils.setLabelStyle(name, BORDERSTYLE_RED, RED, INFOLABEL, this.getView(), BACKRED);
            ApBuildUtils.setLabelData(this.getView(), INFOREMARK, ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u9a73\u56de\u4fe1\u606f\u540e\uff0c\u518d\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"HomePageMobilePlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        if (approvestatus.equals(CollectApproveStatusEnum.PASS.getStatus()) || approvestatus.equals(CollectApproveStatusEnum.REMIT.getStatus())) {
            name = ResManager.loadKDString((String)"\u5df2\u901a\u8fc7", (String)"ACCEPTMOBILE_6", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            ApBuildUtils.setLabelStyle(name, BORDERSTYLE_GREEN, GREEN, INFOLABEL, this.getView(), BACKGREEN);
            ApBuildUtils.setLabelData(this.getView(), INFOREMARK, ResManager.loadKDString((String)"\u606d\u559c\u60a8\uff01\u5b8c\u6210\u4fe1\u606f\u91c7\u96c6\u3002", (String)"HomePageMobilePlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        if (approvestatus.equals(CollectApproveStatusEnum.FAIL.getStatus())) {
            name = ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"ACCEPTMOBILE_7", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            ApBuildUtils.setLabelStyle(name, BORDERSTYLE_RED, RED, INFOLABEL, this.getView(), BACKRED);
            ApBuildUtils.setLabelData(this.getView(), INFOREMARK, ResManager.loadKDString((String)"\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfbHR\u3002", (String)"HomePageMobilePlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
    }

    private void setDataAcceptStatus(String value) {
        String name;
        LOGGER.info("====HomePageMobilePlugin setDataAcceptStatus begin ===");
        if (this.checkActivityIsExist(value, DATAACCEPTLABEL, DATAACCEPTALLOT)) {
            return;
        }
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        DynamicObject dyo = HomCommonRepository.queryDynamicObject((String)"hom_collect", (String)"", (QFilter[])new QFilter[]{new QFilter("onboard", "=", (Object)onbrdId)});
        if (HRObjectUtils.isEmpty((Object)dyo)) {
            return;
        }
        String acceptStatus = dyo.getString("acceptstatus");
        if (HRStringUtils.isEmpty((String)acceptStatus)) {
            name = ResManager.loadKDString((String)"\u5df2\u901a\u8fc7", (String)"ACCEPTMOBILE_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            ApBuildUtils.setLabelStyle(name, BORDERSTYLE_GREEN, GREEN, DATAACCEPTLABEL, this.getView(), BACKGREEN);
            ApBuildUtils.setLabelData(this.getView(), DATAACCEPTREMARK, ResManager.loadKDString((String)"\u606d\u559c\u60a8\uff01\u6750\u6599\u90fd\u9a8c\u6536\u901a\u8fc7\u3002", (String)"HomePageMobilePlugin_8", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        if (acceptStatus.equals(AcceptManageEnum.ACCEPTMANAGEING.getStatus())) {
            ApBuildUtils.setLabelStyle(AcceptManageEnum.ACCEPTMANAGEING.getDesc(), BORDERSTYLE_BLUE, BLUE, DATAACCEPTLABEL, this.getView(), BACKBLUE);
            ApBuildUtils.setLabelData(this.getView(), DATAACCEPTREMARK, ResManager.loadKDString((String)"\u53ef\u4ee5\u5e26\u7740\u6750\u6599\u53bb\u62a5\u5230\u3002", (String)"HomePageMobilePlugin_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        if (acceptStatus.equals(AcceptManageEnum.ACCEPTMANAGEPASS.getStatus())) {
            name = ResManager.loadKDString((String)"\u5df2\u901a\u8fc7", (String)"ACCEPTMOBILE_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            ApBuildUtils.setLabelStyle(name, BORDERSTYLE_GREEN, GREEN, DATAACCEPTLABEL, this.getView(), BACKGREEN);
            ApBuildUtils.setLabelData(this.getView(), DATAACCEPTREMARK, ResManager.loadKDString((String)"\u606d\u559c\u60a8\uff01\u6750\u6599\u90fd\u9a8c\u6536\u901a\u8fc7\u3002", (String)"HomePageMobilePlugin_8", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        if (acceptStatus.equals(AcceptManageEnum.ACCEPTMANAGEUNPASS.getStatus())) {
            name = ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"ACCEPTMOBILE_3", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            ApBuildUtils.setLabelStyle(name, BORDERSTYLE_RED, RED, DATAACCEPTLABEL, this.getView(), BACKRED);
            ApBuildUtils.setLabelData(this.getView(), DATAACCEPTREMARK, ResManager.loadKDString((String)"\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfbHR\u3002", (String)"HomePageMobilePlugin_9", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
    }

    private void setCheckInStatus(String value) {
        LOGGER.info("====HomePageMobilePlugin setCheckInStatus begin ===");
        if (this.checkActivityIsExist(value, CHECKINLABEL, CHECKINALLOT)) {
            return;
        }
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdId);
        String properties = "checkinstatus";
        DynamicObject onbrdDyo = IOnbrdBillDomainService.getInstance().findOnbrdBill(properties, new QFilter[]{qFilter});
        if (onbrdDyo == null) {
            return;
        }
        String checkinStatus = onbrdDyo.getString("checkinstatus");
        if (checkinStatus.equals(CheckinStatusEnum.WAIT_CHECKIN.toString())) {
            ApBuildUtils.setLabelStyle(CheckinStatusEnum.WAIT_CHECKIN.getDesc(), BORDERSTYLE_BLUE, BLUE, CHECKINLABEL, this.getView(), BACKBLUE);
            ApBuildUtils.setLabelData(this.getView(), CHECKINREMARK, ResManager.loadKDString((String)"\u8bf7\u6309\u65f6\u81ea\u52a9\u6253\u5361\u62a5\u5230\u3002", (String)"HomePageMobilePlugin_11", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        if (checkinStatus.equals(CheckinStatusEnum.HAS_CHECKIN.toString())) {
            ApBuildUtils.setLabelStyle(CheckinStatusEnum.HAS_CHECKIN.getDesc(), BORDERSTYLE_GREEN, GREEN, CHECKINLABEL, this.getView(), BACKGREEN);
            ApBuildUtils.setLabelData(this.getView(), CHECKINREMARK, ResManager.loadKDString((String)"\u60a8\u5df2\u5b8c\u6210\u62a5\u5230\uff0c\u795d\u60a8\u5de5\u4f5c\u987a\u5229\u3002", (String)"HomePageMobilePlugin_13", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        if (checkinStatus.equals(CheckinStatusEnum.CHECKIN_EXCEPTION.toString()) || checkinStatus.equals(CheckinStatusEnum.CHECKIN_WAIT_CONFIRM.toString())) {
            String name = ResManager.loadKDString((String)"\u5f85\u786e\u8ba4", (String)"ACCEPTMOBILE_4", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            ApBuildUtils.setLabelStyle(name, BORDERSTYLE_RED, RED, CHECKINLABEL, this.getView(), BACKRED);
            ApBuildUtils.setLabelData(this.getView(), CHECKINREMARK, ResManager.loadKDString((String)"\u62a5\u5230\u4fe1\u606f\u786e\u8ba4\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"HomePageMobilePlugin_12", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkActivityIsExist(String value, String labelKey, String allotKey) {
        LOGGER.info("====HomePageMobilePlugin checkActivityIsExist begin ===");
        if ("0".equals(value)) {
            this.getView().getModel().setValue(allotKey, (Object)value);
            String name = ResManager.loadKDString((String)"\u5c1a\u672a\u5f00\u59cb", (String)"ACCEPTMOBILE_8", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            ApBuildUtils.setLabelStyle(name, BORDERSTYLE_GRAY, GRAY, labelKey, this.getView(), BACKGRAY);
            return true;
        }
        return false;
    }

    private void setRollStatusLabel(String value) {
        String name;
        LOGGER.info("====HomePageMobilePlugin setRollStatusLabel begin ===");
        if (this.checkActivityIsExist(value, APPOINTLABEL, APPOINTALLOT)) {
            return;
        }
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdId);
        String properties = "preenrollstatus" + "," + "preeneffectdate" + "," + "preenonbrdtcity" + "." + "name";
        DynamicObject onbrdDyo = IOnbrdBillDomainService.getInstance().findOnbrdBill(properties, new QFilter[]{qFilter});
        if (Objects.isNull(onbrdDyo)) {
            return;
        }
        String preenrollstatus = onbrdDyo.getString("preenrollstatus");
        if (preenrollstatus.equals(PreEnrollStatusEnum.WAIT_RESERVATION.getValue())) {
            name = ResManager.loadKDString((String)"\u5f85\u9884\u7ea6", (String)"ReservationMobilePlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            ApBuildUtils.setLabelStyle(name, BORDERSTYLE_BLUE, BLUE, APPOINTLABEL, this.getView(), BACKBLUE);
            ApBuildUtils.setLabelData(this.getView(), APPOINTREMARK, ResManager.loadKDString((String)"\u60a8\u8fd8\u6ca1\u6709\u9884\u7ea6\uff0c\u5c3d\u5feb\u9884\u7ea6\u54e6\uff01", (String)"HomePageMobilePlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        if (preenrollstatus.equals(PreEnrollStatusEnum.HAS_RESERVATION.getValue()) || preenrollstatus.equals(PreEnrollStatusEnum.WAIT_CONFIRM_RESERVATION.getValue())) {
            name = PreEnrollStatusEnum.getEnumByValue((String)preenrollstatus).getDesc();
            ApBuildUtils.setLabelStyle(name, BORDERSTYLE_GREEN, GREEN, APPOINTLABEL, this.getView(), BACKGREEN);
            String effectDate = "";
            if (onbrdDyo.getDate("preeneffectdate") != null) {
                effectDate = HRDateTimeUtils.format((Date)onbrdDyo.getDate("preeneffectdate"), (String)"yyyy-MM-dd");
            }
            String effectName = ResManager.loadKDString((String)"\u9884\u7ea6\u65f6\u95f4\uff1a", (String)"ReservationMobilePlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            ApBuildUtils.setLabelData(this.getView(), APPOINTREMARK, effectName + effectDate);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "click_info": {
                this.clickInfo();
                break;
            }
            case "click_dataaccept": {
                this.clickDataAccept();
                break;
            }
            case "click_appoint": {
                this.clickAppoint();
                break;
            }
            case "click_checkin": {
                this.clickCheckIn();
                break;
            }
        }
    }

    private void clickCheckIn() {
        String checkinAllot = (String)this.getView().getModel().getValue(CHECKINALLOT);
        if ("0".equals(checkinAllot)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a9\u62a5\u5230\u4e8b\u9879\u6682\u672a\u5f00\u59cb\uff0c\u8bf7\u5148\u5b8c\u6210\u524d\u5e8f\u4e8b\u9879\u3002", (String)"ACCEPTMOBILE_12", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        IMobCommonAppService.getInstance().showCheckinPage(this.getView(), onbrdId);
    }

    private void clickInfo() {
        String infoAllot = (String)this.getView().getModel().getValue(INFOALLOT);
        if ("0".equals(infoAllot)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fe1\u606f\u91c7\u96c6\u4e8b\u9879\u6682\u672a\u5f00\u59cb\uff0c\u8bf7\u5148\u5b8c\u6210\u524d\u5e8f\u4e8b\u9879\u3002", (String)"ACCEPTMOBILE_9", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        DynamicObject dyo = HomCommonRepository.queryDynamicObject((String)"hom_collect", (String)"", (QFilter[])new QFilter[]{new QFilter("onboard", "=", (Object)onbrdId)});
        long collectConfigHisId = dyo.getLong("collectconfighis.id");
        if (0L == collectConfigHisId) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u91c7\u96c6\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u5165\u804c\u670d\u52a1\u4eba\u5458\u5904\u7406\u3002", (String)"ACCEPTMOBILE_23", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        IMobCommonAppService.getInstance().showClickInfo(this.getView(), onbrdId);
    }

    private void clickAppoint() {
        String appointAllot = (String)this.getView().getModel().getValue(APPOINTALLOT);
        if ("0".equals(appointAllot)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5165\u804c\u9884\u7ea6\u4e8b\u9879\u6682\u672a\u5f00\u59cb\uff0c\u8bf7\u5148\u5b8c\u6210\u524d\u5e8f\u4e8b\u9879\u3002", (String)"ACCEPTMOBILE_10", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        IMobCommonAppService.getInstance().showReservationPage(this.getView(), onbrdId);
    }

    private void clickDataAccept() {
        String dataacceptAllot = (String)this.getView().getModel().getValue(DATAACCEPTALLOT);
        if ("0".equals(dataacceptAllot)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u6599\u9a8c\u6536\u4e8b\u9879\u6682\u672a\u5f00\u59cb\uff0c\u8bf7\u5148\u5b8c\u6210\u524d\u5e8f\u4e8b\u9879\u3002", (String)"ACCEPTMOBILE_11", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        DynamicObject dyo = HomCommonRepository.queryDynamicObject((String)"hom_collect", (String)"", (QFilter[])new QFilter[]{new QFilter("onboard", "=", (Object)onbrdId)});
        if (HRObjectUtils.isEmpty((Object)dyo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u9a8c\u6536\u7684\u6750\u6599\uff0c\u8bf7\u7b49\u5f85\u5165\u804c\u670d\u52a1\u4eba\u5458\u5904\u7406\u3002", (String)"ACCEPTMOBILE_14", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        long canidateId = dyo.getLong("onboard.candidate.id");
        long collectConfigHisId = dyo.getLong("collectconfighis.id");
        if (0L == collectConfigHisId) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u9a8c\u6536\u6e05\u5355\uff0c\u8bf7\u8054\u7cfb\u5165\u804c\u670d\u52a1\u4eba\u5458\u5904\u7406\u3002", (String)"ACCEPTMOBILE_22", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        String acceptStatus = dyo.getString("acceptstatus");
        DynamicObject dataEntity = CollectConfigRepository.queryCollectConfigHisById((String)"", (Long)collectConfigHisId);
        InfoGroupConfigEntity infoConfig = ((ICollectService)ServiceFactory.getService(ICollectService.class)).transferDynToEntity(dataEntity);
        List imgAndAttachList = IAcceptManageService.getInstance().getImgAndAttachList(infoConfig, onbrdId.longValue(), canidateId, collectConfigHisId, "");
        if (CollectionUtils.isEmpty((Collection)imgAndAttachList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u9a8c\u6536\u7684\u6750\u6599\uff0c\u8bf7\u7b49\u5f85\u5165\u804c\u670d\u52a1\u4eba\u5458\u5904\u7406\u3002", (String)"ACCEPTMOBILE_14", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        IMobCommonAppService.getInstance().shwowAcceptView(this.getView(), imgAndAttachList, acceptStatus, onbrdId);
    }
}

