/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.common.CommonService;
import kd.hr.hom.business.domain.service.activity.IActivityCommonInfoService;
import kd.hr.hom.business.domain.service.collect.ICooperationManageService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.ActivityinsTaskSwitchEnum;

public class ActivityManagePlugin
extends HRDataBaseEdit
implements UploadListener {
    private static final String HOM_ACTIVEINFOTASK = "hom_activeinfotask";
    private static final String TASKPLANE = "taskplane";
    private static final String ACTIVITYINS_TASKSTATUS = "activityins.taskstatus";
    private static final String BAR_SAVEANDNEW = "bar_saveandnew";

    private void initTaskPlane() {
        Long entryId = IActivityCommonInfoService.getInstance().getActivityId(this.getView());
        this.getView().setStatus(OperationStatus.VIEW);
        DynamicObject onbrdDyObj = ICooperationManageService.getInstance().queryCooperationById("id,onbrdid,activityins", entryId);
        DynamicObject activityIns = onbrdDyObj.getDynamicObject("activityins");
        boolean activityIsCompleted = ActivityStatusEnum.COMPLETED.getValue().equals(onbrdDyObj.getString(ACTIVITYINS_TASKSTATUS));
        boolean activityIsSscTask = activityIns.containsProperty("taskswitch") && ActivityinsTaskSwitchEnum.STR_THREE.getValue().equals(activityIns.getString("taskswitch"));
        this.getView().setVisible(Boolean.valueOf(!activityIsCompleted && !activityIsSscTask), new String[]{BAR_SAVEANDNEW});
        this.getView().getPageCache().put("taskstatus", onbrdDyObj.getString(ACTIVITYINS_TASKSTATUS));
        this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(TASKPLANE);
        formShowParameter.setFormId(HOM_ACTIVEINFOTASK);
        formShowParameter.setSendToClient(true);
        formShowParameter.setPkId((Object)entryId);
        this.getView().showForm((FormShowParameter)formShowParameter);
        this.getView().setEnable(Boolean.FALSE, new String[]{"taskpanelap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String str = eventArgs.getOperateKey();
        if ("donothing_tran".equals(str)) {
            this.doTransfer(eventArgs);
        }
    }

    private void doTransfer(AfterDoOperationEventArgs event) {
        if (!HRObjectUtils.isEmpty((Object)event.getOperationResult()) && !event.getOperationResult().isSuccess()) {
            return;
        }
        IActivityCommonInfoService.getInstance().showTransfer(this.getView(), (IFormPlugin)this, "transfer_callback", "hom_activitytransfer");
    }

    private void release(String dataId, String entityName, String operKey) {
        IHomDataMutexService.getInstance().release(dataId, entityName, operKey);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Long entryId = IActivityCommonInfoService.getInstance().getActivityId(this.getView());
        this.release(String.valueOf(entryId), "hom_collaborationdetail", "donothing_tran");
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"transfer_callback") && closedCallBackEvent.getReturnData() != null) {
            Map resultMap = (Map)closedCallBackEvent.getReturnData();
            HRPageCache parentCache = new HRPageCache(this.getView());
            List userIds = resultMap.get("cachepersonid") != null ? (List)resultMap.get("cachepersonid") : new ArrayList();
            parentCache.put("personid", userIds);
            resultMap = (Map)closedCallBackEvent.getReturnData();
            if (Objects.isNull(resultMap.get("operation")) || !"determine".equals((String)resultMap.get("operation"))) {
                return;
            }
            DynamicObject dynamicObject = IActivityCommonInfoService.getInstance().getActivityDetail(entryId);
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)new Date());
            IActivityCommonInfoService.getInstance().updateDataOne(dynamicObject);
            IActivityCommonInfoService.getInstance().handleTransfer(this.getView(), resultMap);
            CommonService.releaseLockWithOnbrdBill((Long)entryId, (String)"KEY_DATAMUTEX_ACTIVITY", (String)"hom_activebase", (String)"donothing_tran", (IFormView)this.getView());
            IFormView iFormView = this.getView();
            iFormView.invokeOperation("refresh");
            iFormView.sendFormAction(iFormView);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initTaskPlane();
    }
}

