/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.repository.config.CollectConfigRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityCommonInfoService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.collect.ISyncCollectToHcf;
import kd.hr.hom.business.domain.service.common.IPreOpenFormCheckService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.CollectApproveStatusEnum;
import kd.hr.hom.common.enums.CollectDynFormTypeEnum;
import kd.hr.hom.common.enums.CollectManageStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.formplugin.common.CustomStyleUtils;
import kd.sdk.hr.hom.common.InfoGroupEntity;
import kd.sdk.hr.ssc.common.util.SSCCommonUtil;

public class CollectActivityPlugin
extends HRCoreBaseBillEdit {
    private static final Log LOGGER = LogFactory.getLog(CollectActivityPlugin.class);
    private static final String VECTOR_EXPAND = "vectorap_expand";
    private static final String APPROVELOG_FLEX = "collectapprovelog";
    private static final String APPROVELOG_EXPAND_FLEX = "collectapprovelogexpand";
    private static final Set<String> COLLECT_PAGE_PREFIX = new HashSet<String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Image expand = (Image)this.getControl(VECTOR_EXPAND);
        if (expand != null) {
            expand.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (VECTOR_EXPAND.equals(control.getKey())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{APPROVELOG_FLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{APPROVELOG_EXPAND_FLEX});
        }
    }

    private boolean isCollectPage(String formId) {
        for (String pagePrefix : COLLECT_PAGE_PREFIX) {
            if (!formId.startsWith(pagePrefix)) continue;
            return true;
        }
        return false;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        formShowParameter.setCustomParam("ue_param", (Object)"true");
        if (!"wf_msg_center".equals(formShowParameter.getParentFormId())) {
            return;
        }
        String formId = (String)formShowParameter.getCustomParam("formId");
        String bindBizBillId = (String)formShowParameter.getCustomParam("pkId");
        if (formId.startsWith("hom_collectapprove") || formId.contains("hom_collectmanage")) {
            this.checkTemplate(e, bindBizBillId);
        }
        if (formId.startsWith("hom_acceptmanage")) {
            this.checkIsTermination(e, bindBizBillId);
        }
        if ("hom_activehandle".equals(formId)) {
            this.checkIsExistData(formShowParameter, e, bindBizBillId);
        }
        IPreOpenFormCheckService.getInstance().isHandlerCheck(e);
        if (!e.isCancel()) {
            this.setCaption(formShowParameter, formId);
        }
    }

    private void setCaption(FormShowParameter formShowParameter, String formId) {
        if (!this.isCollectPage(formId)) {
            return;
        }
        Long pkId = HRJSONUtils.getLongValOfCustomParam((Object)((BillShowParameter)formShowParameter).getPkId());
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk((String)"hom_collect", (String)"acceptstatus,onboard.name", (Object)pkId);
        String personName = dynamicObject.getString("onboard.name");
        if (formId.startsWith("hom_collectapprove")) {
            formShowParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4fe1\u606f\u5ba1\u6838-%s", (String)"CollectActivityPlugin_12", (String)"hr-hom-formplugin", (Object[])new Object[0]), personName));
        } else if (formId.startsWith("hom_collectmanage")) {
            formShowParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4fe1\u606f\u91c7\u96c6-%s", (String)"CollectActivityPlugin_10", (String)"hr-hom-formplugin", (Object[])new Object[0]), personName));
        } else if (formId.startsWith("hom_acceptmanage")) {
            formShowParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8d44\u6599\u9a8c\u6536-%s", (String)"CollectActivityPlugin_11", (String)"hr-hom-formplugin", (Object[])new Object[0]), personName));
        }
    }

    private void checkTemplate(PreOpenFormEventArgs e, String bindBizBillId) {
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk((String)"hom_collect", (String)"", (Object)Long.parseLong(bindBizBillId));
        if ("0".equals(dynamicObject.getString("templateresult"))) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u5f85\u5165\u804c\u4eba\u5458\u5165\u804c\u6d41\u7a0b\u5df2\u7ed3\u675f\uff0c\u8bf7\u6838\u5bf9\u5165\u804c\u72b6\u6001\u3002", (String)"CollectActivityPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void checkIsTermination(PreOpenFormEventArgs e, String bindBizBillId) {
        DynamicObject dyo = HomCommonRepository.queryDynamicObjectByPk((String)"hom_collect", (String)"acceptstatus,onboard.id,onboard.enrollstatus,templateresult", (Object)Long.parseLong(bindBizBillId));
        String acceptStatus = dyo.getString("acceptstatus");
        if (OnbrdStatusEnum.BREAK_UP.toString().equals(dyo.getString("onboard.enrollstatus")) || acceptStatus.equals("40")) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u5f85\u5165\u804c\u4eba\u5458\u5165\u804c\u6d41\u7a0b\u5df2\u7ed3\u675f\uff0c\u8bf7\u6838\u5bf9\u5165\u804c\u72b6\u6001\u3002", (String)"CollectActivityPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void checkIsExistData(FormShowParameter formShowParameter, PreOpenFormEventArgs e, String bindBizBillId) {
        String number = (String)formShowParameter.getCustomParam("activity.number");
        QFilter typeFilter = new QFilter("activity.number", "=", (Object)number);
        QFilter onbFilter = new QFilter("onbrdid", "=", (Object)bindBizBillId);
        DynamicObject[] dynamicObjects = IActivityCommonInfoService.getInstance().getActivityInfo(new QFilter[]{typeFilter, onbFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u6d3b\u52a8\u7684\u5b9e\u4f8b\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ActivityOverViewPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String formId = this.getView().getEntityId();
        if (formId.contains("hom_acceptmanage")) {
            return;
        }
        this.showPersonHeadView();
        this.showInfoGroupView();
        this.showButtonView();
        this.showCollectApproveLog();
        Object setDefaultTemplate = this.getView().getFormShowParameter().getCustomParam("setDefaultTemplate");
        if (Boolean.TRUE.equals(setDefaultTemplate)) {
            String tipMsg = ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u4e1a\u52a1\u89c4\u5219\uff0c\u5f53\u524d\u9875\u9762\u5c06\u4e3a\u60a8\u663e\u793a\u9ed8\u8ba4\u4fe1\u606f\u91c7\u96c6\u65b9\u6848\u3002\u82e5\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574\u4e1a\u52a1\u89c4\u5219\u3002", (String)"CollectActivityPlugin_13", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tipMsg);
        }
    }

    private void showCollectApproveLog() {
        String entityId = this.getView().getEntityId();
        if (entityId.startsWith("hom_collectapprove")) {
            long collectactivityId = this.getModel().getDataEntity().getLong("id");
            CollectApproveStatusEnum approvestatus = CollectApproveStatusEnum.valueByStatus((String)this.getModel().getDataEntity().getString("approvestatus"));
            Object[] activityLogs = HomCommonRepository.queryDynamicObjects((String)"hom_collectlog", (String)"id", (QFilter[])new QFilter[]{new QFilter("collectactivity", "=", (Object)collectactivityId)});
            if (CollectApproveStatusEnum.APPROVING != approvestatus || !HRArrayUtils.isEmpty((Object[])activityLogs)) {
                this.setCollectLogView(collectactivityId);
                if (SSCCommonUtil.showParameterAppIdIsHstc((IFormView)this.getView())) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{APPROVELOG_EXPAND_FLEX});
                    this.getView().setVisible(Boolean.FALSE, new String[]{APPROVELOG_FLEX});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{APPROVELOG_FLEX});
                this.getView().setVisible(Boolean.FALSE, new String[]{APPROVELOG_EXPAND_FLEX});
            }
        }
    }

    private void setCollectLogView(long collectActivityId) {
        this.getView().setVisible(Boolean.FALSE, new String[]{APPROVELOG_EXPAND_FLEX});
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(APPROVELOG_FLEX);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setFormId("hom_collectlogview");
        formShowParameter.setCustomParam("activityId", (Object)collectActivityId);
        this.getView().showForm(formShowParameter);
    }

    private void showButtonView() {
        String entityId = this.getView().getEntityId();
        if (entityId.startsWith("hom_collectapprove")) {
            CollectApproveStatusEnum approveStatus = CollectApproveStatusEnum.valueByStatus((String)this.getModel().getDataEntity().getString("approvestatus"));
            if (CollectApproveStatusEnum.REJECT == approveStatus) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_edit", "approvepass", "approvereject", "approvefail"});
            } else if (CollectApproveStatusEnum.FAIL == approveStatus) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"submit", "bar_save", "bar_edit", "notice", "approvepass", "approvereject", "approvefail"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"submit", "bar_save", "bar_edit"});
            }
        } else {
            CollectManageStatusEnum collectstatus = CollectManageStatusEnum.valueByStatus((String)this.getModel().getDataEntity().getString("collectstatus"));
            if (collectstatus == CollectManageStatusEnum.FINISH) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"submit", "bar_save", "bar_edit"});
            }
        }
        boolean isEnroll = IOnbrdBillDomainService.getInstance().isCanOperate(Long.valueOf(this.getModel().getDataEntity().getLong("onboard.id")));
        if (isEnroll || OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"submit", "bar_save", "bar_edit", "notice", "approvepass", "approvereject", "approvefail"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_close"});
        }
        if (SSCCommonUtil.showParameterAppIdIsHstc((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"titlepanel"});
        }
    }

    private void showPersonHeadView() {
        ActivityNumberEnum activityNumberEnum;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("personhead");
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setFormId("hom_onbrdactivityhead");
        String entityId = this.getView().getEntityId();
        if (entityId.startsWith("hom_collectapprove")) {
            activityNumberEnum = ActivityNumberEnum.INFOAUDIT;
            CollectApproveStatusEnum approvestatus = CollectApproveStatusEnum.valueByStatus((String)this.getModel().getDataEntity().getString("approvestatus"));
            formShowParameter.setCustomParam("activitystatusdesc", (Object)approvestatus.getDesc());
            formShowParameter.setCustomParam("statusNumber", (Object)approvestatus.getStatusNumber());
            formShowParameter.setCustomParam("hom_collectapprove", (Object)"hom_collectapprove");
        } else {
            CollectManageStatusEnum collectstatus = CollectManageStatusEnum.valueByStatus((String)this.getModel().getDataEntity().getString("collectstatus"));
            formShowParameter.setCustomParam("activitystatusdesc", (Object)collectstatus.getDesc());
            formShowParameter.setCustomParam("statusNumber", (Object)collectstatus.getStatusNumber());
            activityNumberEnum = ActivityNumberEnum.INFOCOLLECTION;
        }
        formShowParameter.setCustomParam("id", (Object)this.getModel().getDataEntity().getLong("onboard.id"));
        formShowParameter.setCustomParam("activity.id", (Object)activityNumberEnum.getId());
        this.getView().showForm(formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean collectActivityChange;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        boolean isEnroll = IOnbrdBillDomainService.getInstance().isCanOperate(Long.valueOf(this.getModel().getDataEntity().getLong("onboard.id")));
        if (isEnroll) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5f85\u5165\u804c\u4eba\u5458\u5165\u804c\u6d41\u7a0b\u5df2\u7ed3\u675f\uff0c\u8bf7\u6838\u5bf9\u5165\u804c\u72b6\u6001\u3002", (String)"CollectActivityPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (collectActivityChange = ((ICollectService)ServiceFactory.getService(ICollectService.class)).isCollectActivityChange(this.getModel().getDataEntity())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u63d0\u4ea4\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\u3002", (String)"CollectActivityPlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (HRStringUtils.equals((String)"donothing_submit", (String)op.getOperateKey())) {
            this.doBeforeSubmit(args);
        }
    }

    private void doBeforeSubmit(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        long collectConfigHisId = dataEntity.getLong("collectconfighis.id");
        DynamicObject collectConfigHis = CollectConfigRepository.queryCollectConfigHisById((String)"", (Long)collectConfigHisId);
        InfoGroupConfigEntity onfigEntity = ((ICollectService)ServiceFactory.getService(ICollectService.class)).transferDynToEntity(collectConfigHis);
        List infoGroupEntityList = onfigEntity.getInfoGroupEntityList();
        String fieldErrorInfo = CustomStyleUtils.checkFieldList(infoGroupEntityList, this.getChildView(), dataEntity.getDynamicObject("onboard"));
        if (HRStringUtils.isNotEmpty((String)fieldErrorInfo)) {
            this.getView().showConfirm(fieldErrorInfo, MessageBoxOptions.Toast);
            args.setCancel(true);
            return;
        }
        List<String> fieldDescList = CustomStyleUtils.checkFieldDescList(infoGroupEntityList, this.getChildView());
        if (!CollectionUtils.isEmpty(fieldDescList)) {
            this.getView().showTipNotification(fieldDescList.stream().collect(Collectors.joining(";", "", "\u3002")));
            args.setCancel(true);
            return;
        }
        ((ISyncCollectToHcf)ServiceFactory.getService(ISyncCollectToHcf.class)).saveCollectToHcf(onfigEntity, this.getChildView(), dataEntity);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        HashMap<String, Runnable> map = new HashMap<String, Runnable>();
        map.put("donothing_notice", this::oneClickNotice);
        map.put("donothing_submit", this::submitCollectData);
        map.getOrDefault(args.getOperateKey(), () -> {}).run();
    }

    private void oneClickNotice() {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u9192\u6210\u529f", (String)"CollectActivityPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("showapprove".equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            IFormView childView = this.getChildView();
            if (((Boolean)newValue).booleanValue()) {
                childView.invokeOperation("hiddenapprove");
            } else {
                childView.invokeOperation("showapprove");
            }
            this.getView().sendFormAction(childView);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String formId = this.getView().getEntityId();
        if (formId.contains("hom_acceptmanage")) {
            return;
        }
        String itemKey = evt.getItemKey();
        if ("bar_close".equals(itemKey)) {
            this.getModel().setDataChanged(false);
            IFormView childView = this.getChildView();
            List changeFieldList = new ArrayList();
            String changeFieldListStr = childView.getPageCache().get("changeFieldList");
            if (HRStringUtils.isNotEmpty((String)changeFieldListStr)) {
                changeFieldList = SerializationUtils.fromJsonStringToList((String)changeFieldListStr, Long.class);
            }
            long collectConfigHisId = this.getModel().getDataEntity().getLong("collectconfighis.id");
            DynamicObject collectConfigHis = CollectConfigRepository.queryCollectConfigHisById((String)"", (Long)collectConfigHisId);
            InfoGroupConfigEntity infoGroupConfigEntity = ((ICollectService)ServiceFactory.getService(ICollectService.class)).transferDynToEntity(collectConfigHis);
            List finalChangeFieldList = changeFieldList;
            ArrayList collect = new ArrayList();
            infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroupEntity -> collect.addAll(infoGroupEntity.getInfoGroupFieldList().stream().filter(field -> finalChangeFieldList.contains(field.getFieldId())).collect(Collectors.toList())));
            if (!collect.isEmpty()) {
                evt.setCancel(true);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractCollectDynViewPlugin_9", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AbstractCollectDynViewPlugin_10", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                String msg = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f%s\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AbstractCollectDynViewPlugin_11", (String)"hr-hom-formplugin", (Object[])new Object[0]), System.lineSeparator());
                String changeDesc = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934\u53d8\u52a8\u5b57\u6bb5\uff1a%s", (String)"AbstractCollectDynViewPlugin_12", (String)"hr-hom-formplugin", (Object[])new Object[0]), collect.stream().map(InfoGroupEntity.InfoGroupField::getFieldName).collect(Collectors.joining("\uff0c")));
                this.getView().showConfirm(msg, changeDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener("changeconfirm", (IFormPlugin)this), btnNameMaps);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("changeconfirm".equals(messageBoxClosedEvent.getCallBackId()) && "yes".equalsIgnoreCase(messageBoxClosedEvent.getResultValue())) {
            this.getChildView().getPageCache().put("changeFieldList", "");
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        LOGGER.info("###CollectActivityPlugin.beforeClosed");
        String formId = this.getView().getEntityId();
        if (formId.contains("hom_acceptmanage")) {
            return;
        }
        LOGGER.info("###CollectActivityPlugin.beforeClosed, setCheckDataChange");
        this.getModel().setDataChanged(false);
        e.setCheckDataChange(false);
        IFormView childView = this.getChildView();
        List changeFieldList = new ArrayList();
        String changeFieldListStr = childView.getPageCache().get("changeFieldList");
        if (HRStringUtils.isNotEmpty((String)changeFieldListStr)) {
            changeFieldList = SerializationUtils.fromJsonStringToList((String)changeFieldListStr, Long.class);
        }
        long collectConfigHisId = this.getModel().getDataEntity().getLong("collectconfighis.id");
        DynamicObject collectConfigHis = CollectConfigRepository.queryCollectConfigHisById((String)"", (Long)collectConfigHisId);
        InfoGroupConfigEntity infoGroupConfigEntity = ((ICollectService)ServiceFactory.getService(ICollectService.class)).transferDynToEntity(collectConfigHis);
        List finalChangeFieldList = changeFieldList;
        ArrayList collect = new ArrayList();
        infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroupEntity -> collect.addAll(infoGroupEntity.getInfoGroupFieldList().stream().filter(field -> finalChangeFieldList.contains(field.getFieldId())).collect(Collectors.toList())));
        if (!collect.isEmpty()) {
            e.setCancel(true);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractCollectDynViewPlugin_9", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AbstractCollectDynViewPlugin_10", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f%s\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AbstractCollectDynViewPlugin_11", (String)"hr-hom-formplugin", (Object[])new Object[0]), System.lineSeparator());
            String changeDesc = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934\u53d8\u52a8\u5b57\u6bb5\uff1a%s", (String)"AbstractCollectDynViewPlugin_12", (String)"hr-hom-formplugin", (Object[])new Object[0]), collect.stream().map(InfoGroupEntity.InfoGroupField::getFieldName).collect(Collectors.joining("\uff0c")));
            this.getView().showConfirm(msg, changeDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener("changeconfirm", (IFormPlugin)this), btnNameMaps);
        }
    }

    private void submitCollectData() {
        IFormView childView = this.getChildView();
        if (SSCCommonUtil.showParameterAppIdIsHstc((IFormView)this.getView())) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("opkey", "donothing_submit");
            result.put("success", "true");
            this.getView().returnDataToParent(result);
            this.getView().close();
            return;
        }
        childView.getPageCache().put("changeFieldList", "");
        this.getView().invokeOperation("close");
        if (this.getView().getParentView() != null) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"AbstractCollectDynViewPlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.getView().getParentView().updateView();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void showInfoGroupView() {
        String entityId = this.getView().getEntityId();
        String status = this.getModel().getDataEntity().getString("collectstatus");
        if (entityId.startsWith("hom_collectapprove")) {
            status = this.getModel().getDataEntity().getString("approvestatus");
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCaption("");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("infogroup");
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        long collectConfigHisId = dynamicObject.getLong("collectconfighis.id");
        DynamicObject dataEntity = CollectConfigRepository.queryCollectConfigHisById((String)"", (Long)collectConfigHisId);
        InfoGroupConfigEntity infoGroupConfigEntity = ((ICollectService)ServiceFactory.getService(ICollectService.class)).transferDynToEntity(dataEntity, Long.valueOf(RequestContext.getOrCreate().getOrgId()));
        formShowParameter.setCustomParam("onboardid", (Object)this.getModel().getDataEntity().getLong("onboard.candidate.id"));
        formShowParameter.setCustomParam("onbrdid", (Object)this.getModel().getDataEntity().getLong("onboard.id"));
        formShowParameter.setCustomParam("config", (Object)infoGroupConfigEntity);
        formShowParameter.setCustomParam("status", (Object)status);
        formShowParameter.setCustomParam("formtype", (Object)CollectDynFormTypeEnum.MANAGE.getFormType());
        Object approve = this.getView().getFormShowParameter().getCustomParam("approve");
        Object object = approve = HRObjectUtils.isEmpty((Object)approve) && this.getView().getEntityId().contains("hom_collectapprove") ? "enable" : approve;
        if (!HRObjectUtils.isEmpty((Object)approve)) {
            formShowParameter.setCustomParam("approve", approve);
            formShowParameter.setFormId("hom_infogroupdynviewapp");
        } else {
            formShowParameter.setFormId("hom_infogroupdynview");
        }
        formShowParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(formShowParameter);
        this.getView().getPageCache().put("childPageId", formShowParameter.getPageId());
    }

    private IFormView getChildView() {
        String childPageId = this.getView().getPageCache().get("childPageId");
        return this.getView().getView(childPageId);
    }

    static {
        COLLECT_PAGE_PREFIX.add("hom_collectapprove");
        COLLECT_PAGE_PREFIX.add("hom_acceptmanage");
        COLLECT_PAGE_PREFIX.add("hom_collectmanage");
    }
}

