/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.collect.ICollectApproveLogService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.business.domain.service.ssc.IBuildShowFormStrategyService;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.CollectApproveStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.sdk.hr.ssc.common.util.SSCCommonUtil;

public class CollectApprovingPlugin
extends HRCoreBaseBillEdit {
    private static final String OP_DONOTHING_APPROVEPASS = "donothing_approvepass";
    private static final String OP_DONOTHING_APPROVEREJECT = "donothing_approvereject";
    private static final String OP_DONOTHING_APPROVEFAIL = "donothing_approvefail";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"approvepass", "approvereject", "approvefail", "bar_close"});
        this.addItemClickListeners(new String[]{"approvepass", "approvereject", "approvefail", "bar_close"});
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().getFormShowParameter().setCustomParam("approve", (Object)"1");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_close".equals(itemKey)) {
            this.getModel().setDataChanged(false);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("approvepass".equals(messageBoxClosedEvent.getCallBackId()) && "yes".equalsIgnoreCase(messageBoxClosedEvent.getResultValue())) {
            this.getView().getPageCache().put("approvepass_yes", "true");
            this.getView().invokeOperation(OP_DONOTHING_APPROVEPASS);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String approveStr;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        boolean isEnroll = IOnbrdBillDomainService.getInstance().isCanOperate(Long.valueOf(this.getModel().getDataEntity().getLong("onboard.id")));
        if (isEnroll) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5f85\u5165\u804c\u4eba\u5458\u5165\u804c\u6d41\u7a0b\u5df2\u7ed3\u675f\uff0c\u8bf7\u6838\u5bf9\u5165\u804c\u72b6\u6001\u3002", (String)"CollectActivityPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (OP_DONOTHING_APPROVEPASS.equals(opKey) && !Boolean.TRUE.toString().equals(this.getView().getPageCache().get("approvepass_yes")) && HRStringUtils.isNotEmpty((String)(approveStr = this.getView().getPageCache().get("approveList")))) {
            String desc = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u6807\u8bb0\u9700\u8981\u9a73\u56de\u7684\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u5ba1\u6838\u901a\u8fc7\uff1f", (String)"CollectApprovingPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(desc, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("approvepass"));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.getModel().setDataChanged(false);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put(OP_DONOTHING_APPROVEPASS, this::approvePass);
        map.put(OP_DONOTHING_APPROVEREJECT, this::approveReject);
        map.put(OP_DONOTHING_APPROVEFAIL, this::approveFail);
        map.getOrDefault(args.getOperateKey(), () -> {}).run();
    }

    private void approvePass() {
        String desc = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"CollectApprovingPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(desc);
        if (SSCCommonUtil.showParameterAppIdIsHstc((IFormView)this.getView())) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("opkey", OP_DONOTHING_APPROVEPASS);
            result.put("success", "true");
            this.getView().returnDataToParent(result);
            this.getView().close();
            return;
        }
        this.getView().invokeOperation("close");
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if ("approvefail".equals(closedCallBackEvent.getActionId())) {
            DynamicObject returnData = (DynamicObject)closedCallBackEvent.getReturnData();
            String remark = returnData.getString("remark");
            ((ICollectApproveLogService)ServiceFactory.getService(ICollectApproveLogService.class)).approveFailCollectLog(Long.valueOf(this.getModel().getDataEntity().getLong("id")), remark);
            DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk((String)"hom_collect", (String)"", (Object)this.getModel().getDataEntity().getLong("id"));
            dynamicObject.set("approvestatus", (Object)CollectApproveStatusEnum.FAIL.getStatus());
            dynamicObject.set("approvemodifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("approvemodifytime", (Object)new Date());
            HomCommonRepository.updateDynamicObject((String)"hom_collect", (DynamicObject)dynamicObject);
            ((ISendMessageService)ServiceFactory.getService(ISendMessageService.class)).sendMessageNew(dynamicObject, RuleEngineSceneNumberEnum.COLLECT_APPROVE_FAIL);
            IActivityDomainService.getInstance().batchConsentTask(Collections.singletonList(dynamicObject.getLong("onboard.id")), ActivityNumberEnum.INFOAUDIT);
            this.getModel().setDataChanged(false);
            if (SSCCommonUtil.showParameterAppIdIsHstc((IFormView)this.getView())) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("opkey", OP_DONOTHING_APPROVEFAIL);
                result.put("success", "true");
                this.getView().returnDataToParent(result);
                this.getView().close();
                return;
            }
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
            }
            this.getView().invokeOperation("close");
        }
    }

    private void approveReject() {
        IBuildShowFormStrategyService service = (IBuildShowFormStrategyService)ServiceFactory.getService((String)"BuildApproveRejectFormStrategy");
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("pageId", this.getView().getPageId());
        FormShowParameter formShowParameter = service.buildFormShowParameter(Long.valueOf(this.getModel().getDataEntity().getLong("id")), params);
        this.getView().showForm(formShowParameter);
    }

    private void approveFail() {
        IBuildShowFormStrategyService service = (IBuildShowFormStrategyService)ServiceFactory.getService((String)"BuildApproveFailFormStrategy");
        FormShowParameter formShowParameter = service.buildFormShowParameter(Long.valueOf(this.getModel().getDataEntity().getLong("id")), null);
        this.getView().showForm(formShowParameter);
    }
}

