/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.LabelStyleEnum;
import kd.hr.hom.common.util.ComboPropValueUtils;
import kd.hr.hom.common.util.CreateLabelApUtils;
import kd.hr.hom.common.util.DateUtils;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.formplugin.web.activity.AbstractOnbrdHeadPlugin;
import kd.sdk.hr.ssc.business.mservice.helper.SSCSLAServiceHelper;
import kd.sdk.hr.ssc.common.dto.SLATimeInfoDTO;

public class OnbrdActivityHeadPlugin
extends AbstractOnbrdHeadPlugin {
    private static final Log LOGGER = LogFactory.getLog(OnbrdActivityHeadPlugin.class);
    private static final String LATESTDEADLINEAP = "latestdeadlineap";
    private static final String REMAININGTIMEAP = "remainingtimeap";
    private static final String HANDLETIMEAP = "handletimeap";
    private static final String ACTIVITYTIMEAP = "activitytimeap";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        DynamicObject onbrdObj = IOnbrdBillDomainService.getInstance().findOnbrdBillById("name,billno,barcode,org.name,creator.name,createtime,picturefield,resumeno,gender,phone,peremail,validuntil,starttime,effectdate,enrollstatus,laborrelstatus,aposition.name,acompany.name,aadminorg.name,checkinstatus,candidate.number,onbrdtype.name,picturefield,processstatus,handler.picturefield,handler.name,apositiontype,stdposition.name,ajob.name,viewtype", (Object)onbrdId);
        QFilter onbrdFilter = new QFilter("onbrd", "=", (Object)onbrdId);
        DynamicObject activityOverviewDy = IActivityDomainService.getInstance().findActivityInfo("id,activityscheme,entryentity.activity,entryentity.activityins,entryentity.createtime,entryentity.latestdeadline,entryentity.bindbizbillid,taskstatus", onbrdFilter);
        this.setHeadInfoValue(this.getView(), onbrdObj, activityOverviewDy);
    }

    private void setHeadInfoValue(IFormView view, DynamicObject onbrdObj, DynamicObject activityOverviewDy) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long activityId = (Long)customParams.get("activity.id");
        this.fillBillInfo(view, onbrdObj, customParams, activityId);
        if (activityOverviewDy == null) {
            LOGGER.info("activityOverviewDy is null");
            return;
        }
        this.fillFlowInfo(view, activityOverviewDy, activityId);
    }

    private void fillFlowInfo(IFormView view, DynamicObject activityOverviewDy, Long activityId) {
        Map slaInfoMap;
        SLATimeInfoDTO slaTimeInfo;
        DynamicObjectCollection entryEntityDys = activityOverviewDy.getDynamicObjectCollection("entryentity");
        List activityNameList = entryEntityDys.stream().filter(dy -> activityId.equals(dy.getLong("activity.id"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(activityNameList)) {
            LOGGER.info("activityNameList is null");
            return;
        }
        DynamicObject activityDetailDy = (DynamicObject)activityNameList.get(0);
        DynamicObject activityins = activityDetailDy.getDynamicObject("activityins");
        if (ObjectUtils.isEmpty((Object)activityins)) {
            LOGGER.info("activityins is null");
            return;
        }
        Label handlerLabel = (Label)view.getControl("handlers");
        StringBuilder str = new StringBuilder();
        DynamicObjectCollection handlersDys = activityins.getDynamicObjectCollection("handlers");
        if (!CollectionUtils.isEmpty((Collection)handlersDys)) {
            for (DynamicObject handlersDy : handlersDys) {
                if (handlersDy.getDynamicObject("fbasedataid") == null) continue;
                str.append(handlersDy.getDynamicObject("fbasedataid").getString("name")).append(';');
            }
        }
        if (StringUtils.isNotBlank((CharSequence)str)) {
            str.deleteCharAt(str.length() - 1);
            handlerLabel.setText(str.toString());
        }
        Date createTime = activityins.getDate("createtime");
        Date handleTime = activityins.getDate("handletime");
        Date latestDeadline = activityDetailDy.getDate("latestdeadline");
        SLATimeInfoDTO slaTimeInfoDto = new SLATimeInfoDTO();
        slaTimeInfoDto.setCreateTime(createTime);
        slaTimeInfoDto.setRealFinishTime(handleTime);
        slaTimeInfoDto.setLatestdFinishTime(latestDeadline);
        slaTimeInfoDto.setConsumingDays(DateUtils.getDayAndHour((Date)createTime, (Date)handleTime));
        slaTimeInfoDto.setRemainingDays(DateUtils.getDayAndHour((Date)new Date(), (Date)latestDeadline));
        long sscTaskId = activityDetailDy.getLong("activityins.ssctaskid");
        if (!HOMObjectUtils.isEmptyWithDynamicObjectField((Object)sscTaskId) && !HRObjectUtils.isEmpty((Object)(slaTimeInfo = (SLATimeInfoDTO)(slaInfoMap = SSCSLAServiceHelper.getSLAInfoByIds(Collections.singletonList(sscTaskId))).get(sscTaskId)))) {
            slaTimeInfoDto = slaTimeInfo;
            slaTimeInfoDto.setRealFinishTime(handleTime);
            slaTimeInfoDto.setConsumingDays(DateUtils.getDayAndHour((Date)slaTimeInfo.getCreateTime(), (Date)handleTime));
        }
        Label startDateLabel = (Label)view.getControl("createtime");
        startDateLabel.setText(createTime == null ? "" : HRInteDateTimeUtil.formatDate((String)activityins.getDataEntityType().getName(), (String)"createtime", (Date)createTime));
        String taskStatus = activityins.getString("taskstatus");
        if (ActivityStatusEnum.COMPLETED.getValue().equals(taskStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{HANDLETIMEAP, ACTIVITYTIMEAP});
            Label handleTimeLabel = (Label)view.getControl("handletime");
            handleTimeLabel.setText(handleTime == null ? "" : HRInteDateTimeUtil.formatDate((String)activityins.getDataEntityType().getName(), (String)"handletime", (Date)handleTime));
            Label activityTimeLabel = (Label)view.getControl("activitytime");
            activityTimeLabel.setText(slaTimeInfoDto.getConsumingDays());
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{HANDLETIMEAP, ACTIVITYTIMEAP});
            Label latestDeadlineLabel = (Label)view.getControl("latestdeadline");
            latestDeadlineLabel.setText(latestDeadline == null ? "" : HRInteDateTimeUtil.formatDate((String)activityOverviewDy.getDataEntityType().getName(), (String)"latestdeadline", (Date)latestDeadline));
            Label remainingTimeLabel = (Label)view.getControl("dayremaining");
            String dateStr = slaTimeInfoDto.getRemainingDays();
            remainingTimeLabel.setText(dateStr);
        }
        this.getView().setVisible(Boolean.valueOf(!Arrays.asList(ActivityStatusEnum.COMPLETED.getValue(), ActivityStatusEnum.TERMINATED.getValue()).contains(taskStatus)), new String[]{LATESTDEADLINEAP, REMAININGTIMEAP});
    }

    private void fillBillInfo(IFormView view, DynamicObject onbrdObj, Map<String, Object> customParams, Long activityId) {
        DynamicObject handler;
        try {
            String pictureField = onbrdObj.getString("picturefield");
            if (StringUtils.isNotBlank((CharSequence)pictureField)) {
                Image pictureFieldImage = (Image)view.getControl("picturefield");
                pictureFieldImage.setUrl(HRImageUrlUtil.getImageFullUrl((String)onbrdObj.getString("picturefield")));
            }
        }
        catch (Exception exception) {
            LOGGER.error("fillBillInfo_pictureFieldImage_error:", (Throwable)exception);
        }
        Label activityNameLabel = (Label)view.getControl("activityname");
        activityNameLabel.setText(this.getActivityName(activityId));
        this.setActivityStatus(customParams);
        this.setTextValue(view, onbrdObj, "name1", "name");
        this.setTextValue(view, onbrdObj, "candidatenumber", "candidate.number");
        if (StringUtils.isBlank((CharSequence)onbrdObj.getString("candidate.number"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap14"});
        }
        if (StringUtils.isBlank((CharSequence)onbrdObj.getString("gender.name"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"gender"});
        }
        this.setTextValue(view, onbrdObj, "gender", "gender.name");
        this.setNameByPositionType(onbrdObj, "apositionname");
        this.setValueByPositionType(onbrdObj, "aposition");
        if (StringUtils.isBlank((CharSequence)onbrdObj.getString("onbrdtype.name"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"onbrdtypename"});
        }
        this.setTextValue(view, onbrdObj, "onbrdtypename", "onbrdtype.name");
        if (StringUtils.isBlank((CharSequence)onbrdObj.getString("phone"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"phonepanelap"});
        }
        this.getModel().setValue("phone", (Object)onbrdObj.getString("phone"));
        if (StringUtils.isBlank((CharSequence)onbrdObj.getString("peremail"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"peremailpanelap"});
        }
        this.getModel().setValue("peremail", (Object)onbrdObj.getString("peremail"));
        Label enrollStatus = (Label)view.getControl("enrollstatus");
        Map enrollStatusComboPropValueMap = ComboPropValueUtils.comboPropValue((String)"hom_onbrdbilltpl", (String)"enrollstatus");
        enrollStatus.setText((String)enrollStatusComboPropValueMap.get(onbrdObj.getString("enrollstatus")));
        if (HRStringUtils.isEmpty((String)((String)enrollStatusComboPropValueMap.get(onbrdObj.getString("enrollstatus"))))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"enrollstatus"});
        }
        this.setTextValue(view, onbrdObj, "effectdate", "effectdate");
        if (StringUtils.isBlank((CharSequence)onbrdObj.getString("effectdate"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap22"});
        }
        Label effectDateLabel = (Label)view.getControl("effectdate");
        Date effectDate = onbrdObj.getDate("effectdate");
        effectDateLabel.setText(effectDate == null ? "" : HRInteDateTimeUtil.formatDate((String)"hom_onbrdbillbase", (String)"effectdate", (Date)effectDate));
        this.setTextValue(view, onbrdObj, "acompany", "acompany.name");
        if (StringUtils.isBlank((CharSequence)onbrdObj.getString("acompany.name"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap23"});
        }
        this.setTextValue(view, onbrdObj, "aadminorg", "aadminorg.name");
        if (StringUtils.isBlank((CharSequence)onbrdObj.getString("aadminorg.name"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap231"});
        }
        if ((handler = onbrdObj.getDynamicObject("handler")) == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        } else {
            Image handlerPictureField = (Image)view.getControl("handlerpicturefield");
            handlerPictureField.setUrl(HRImageUrlUtil.getImageFullUrl((String)handler.getString("picturefield")));
            Label handlername = (Label)view.getControl("handlername");
            String name = handler.getString("name");
            String number = handler.getString("number");
            handlername.setText(name + "," + number);
        }
        String viewType = onbrdObj.getString("viewtype");
        String dropdownListNameByCode = ComboPropValueUtils.getDropdownListNameByCode((String)"hom_onbrdbilltpl", (String)"viewtype", (String)viewType);
        Label viewTypeLabel = (Label)view.getControl("viewtype");
        viewTypeLabel.setText(dropdownListNameByCode);
        if (HRStringUtils.isEmpty((String)dropdownListNameByCode)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"viewtype"});
        }
    }

    private void setTextValue(IFormView view, DynamicObject onbrdObj, String keyIdentify, String keyField) {
        Label billNo = (Label)view.getControl(keyIdentify);
        billNo.setText(onbrdObj.getString(keyField));
    }

    private void setActivityStatus(Map<String, Object> customParams) {
        String text = (String)customParams.get("activitystatusdesc");
        if (StringUtils.isBlank((CharSequence)text)) {
            return;
        }
        LabelStyleEnum statusNumber = LabelStyleEnum.getEnumByStatusNumber((String)((String)customParams.get("statusNumber")));
        CreateLabelApUtils.createLabelAp((IFormView)this.getView(), (String)"activitystatus", (LabelStyleEnum)statusNumber, (String)text);
    }

    private String getActivityName(Long activityId) {
        if (!HRObjectUtils.isEmpty((Object)ActivityNumberEnum.getEnumById((Long)activityId))) {
            return ActivityNumberEnum.getEnumById((Long)activityId).getDesc();
        }
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk((String)"hrcs_activity", (String)"id", (Object)activityId);
        return dynamicObject.getString("name");
    }
}

