/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity.acceptmanage;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hom.business.application.impl.page.PanelApAdatper;
import kd.hr.hom.business.application.page.StyleAdapter;
import kd.hr.hom.business.domain.repository.AcceptManageRepository;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.repository.config.CollectConfigRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.collect.IAcceptManageService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.common.IPreOpenFormCheckService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.AcceptManageEntity;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.AcceptManageEnum;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;

public class AcceptManageActivityPlugin
extends HRCoreBaseBillEdit {
    private static final Log LOGGER = LogFactory.getLog(AcceptManageActivityPlugin.class);
    private static final String SELECT_PROPERTIES = "collectconfighis,onboard,pagekey,fieldkey,ispass,educertid,onboard,fieldtype,recheckstand,fieldname,index,entitykey";
    private static final String INFOGROUP = "infogroup";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"AcceptManageActivityPlugin_0001", (int)30);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        IPreOpenFormCheckService.getInstance().isHandlerCheck(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        Long onbrdId = dynamicObject.getLong("onboard.id");
        boolean flag = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
        if ("VIEW".equals(this.getView().getFormShowParameter().getStatus().name()) || flag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_pass"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_unpass"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save"});
        }
        if (this.setVisibleByStatus(dynamicObject)) {
            return;
        }
        this.showAcceptHeadView();
        this.addPanel();
    }

    private boolean setVisibleByStatus(DynamicObject dyo) {
        String acceptStatus = dyo.getString("acceptstatus");
        if ("0".equals(dyo.getString("templateresult"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5f85\u5165\u804c\u4eba\u5458\u672a\u5339\u914d\u5230\u4fe1\u606f\u91c7\u96c6\u65b9\u6848\uff0c\u8bf7\u8fdb\u5165\u4fe1\u606f\u91c7\u96c6\u5217\u8868\u91cd\u65b0\u5339\u914d\u3002", (String)"CollectActivityListPlugin_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_pass"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_unpass"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save"});
            return true;
        }
        if (OnbrdStatusEnum.BREAK_UP.toString().equals(dyo.getString("onboard.enrollstatus")) || acceptStatus.equals("40")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62\u7684\u5355\u636e\u65e0\u6cd5\u67e5\u770b\u8be6\u60c5\u3002", (String)"CollectActivityListPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_pass"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_unpass"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save"});
            return true;
        }
        if ("20".equals(acceptStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_pass"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save"});
        }
        if ("30".equals(acceptStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_unpass"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save"});
        }
        return false;
    }

    private void showAcceptHeadView() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("personhead");
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setFormId("hom_onbrdactivityhead");
        String entityId = this.getView().getEntityId();
        ActivityNumberEnum activityNumberEnum = ActivityNumberEnum.DATAACCEPTANCE;
        AcceptManageEnum acceptStatus = AcceptManageEnum.valueByStatus((String)this.getModel().getDataEntity().getString("acceptstatus"));
        formShowParameter.setCustomParam("activitystatusdesc", (Object)acceptStatus.getDesc());
        formShowParameter.setCustomParam("statusNumber", (Object)acceptStatus.getStatusNumber());
        formShowParameter.setCustomParam("hom_acceptmanage", (Object)"hom_collectapprove");
        if (entityId.startsWith("hom_acceptmanageing")) {
            formShowParameter.setCustomParam("hom_acceptmanageing", (Object)"hom_acceptmanageing");
        } else if (entityId.startsWith("hom_acceptmanagepass")) {
            formShowParameter.setCustomParam("hom_acceptmanagepass", (Object)"hom_acceptmanageing");
        }
        formShowParameter.setCustomParam("id", (Object)this.getModel().getDataEntity().getLong("onboard.id"));
        formShowParameter.setCustomParam("activity.id", (Object)activityNumberEnum.getId());
        this.getView().showForm(formShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        boolean success = args.getOperationResult().isSuccess();
        DynamicObject colectDyo = this.getCollectDyo();
        if (colectDyo == null) {
            return;
        }
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        Long onbrdId = dynamicObject.getLong("onboard.id");
        ArrayList<Long> ids = new ArrayList<Long>(2);
        ids.add(onbrdId);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        if (success && "btn_pass".equals(args.getOperateKey())) {
            if (!this.checkFieldIsPass("1")) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u6807\u8bb0\u4e0d\u5408\u683c\u7684\u8d44\u6599\uff0c\u8bf7\u786e\u8ba4\u9a8c\u6536\u901a\u8fc7\uff1f", (String)"ACCEPTMOBILE_20", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("pass", (IFormPlugin)this));
            } else {
                this.acceptPass(collection, colectDyo);
                this.saveData("btn_pass", colectDyo, collection, ids);
            }
        }
        if (success && "btn_unpass".equals(args.getOperateKey())) {
            if (!this.checkFieldIsPass("0")) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u6807\u8bb0\u5408\u683c\u7684\u8d44\u6599\uff0c\u8bf7\u786e\u8ba4\u9a8c\u6536\u4e0d\u901a\u8fc7\uff1f", (String)"ACCEPTMOBILE_21", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("unpass", (IFormPlugin)this));
            } else {
                this.acceptUnpass(collection, colectDyo);
                this.saveData("btn_unpass", colectDyo, collection, ids);
            }
        }
        if (success && "btn_save".equals(args.getOperateKey())) {
            this.btnSave(collection, colectDyo);
            this.saveData("btn_save", colectDyo, collection, ids);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operation = (FormOperate)args.getSource();
        String opKey = operation.getOperateKey();
        if ("btn_pass".equals(opKey) || "btn_unpass".equals(opKey) || "btn_save".equals(opKey)) {
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            Long onbrdId = dynamicObject.getLong("onboard.id");
            boolean flag = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
            if (flag) {
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        DynamicObject colectDyo = this.getCollectDyo();
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        long onbrdId = dynamicObject.getLong("onboard.id");
        boolean flag = IOnbrdBillDomainService.getInstance().isEnrolled(Long.valueOf(onbrdId));
        if (flag) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bf9\u5165\u804c\u72b6\u6001\u4e3a\u201c\u5df2\u5165\u804c\u201d\u201c\u5165\u804c\u7ec8\u6b62\u201d\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ACCEPTMANAGE_12", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(2);
        ids.add(onbrdId);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        if (HRStringUtils.equals((String)actionId, (String)"unpass") && MessageBoxResult.Yes == resultValue) {
            if (colectDyo == null) {
                return;
            }
            this.acceptUnpass(collection, colectDyo);
            this.saveData("btn_unpass", colectDyo, collection, ids);
        } else if (HRStringUtils.equals((String)actionId, (String)"pass") && MessageBoxResult.Yes == resultValue) {
            if (colectDyo == null) {
                return;
            }
            this.acceptPass(collection, colectDyo);
            this.saveData("btn_pass", colectDyo, collection, ids);
        }
    }

    private boolean checkFieldIsPass(String isPass) {
        DynamicObject collectDyo = this.getCollectDyo();
        String acceptStatus = collectDyo.getString("acceptstatus");
        if (HRStringUtils.equals((String)"20", (String)acceptStatus) || HRStringUtils.equals((String)"30", (String)acceptStatus)) {
            return true;
        }
        Map allMap = this.getView().getPageCache().getAll();
        for (Map.Entry entry : allMap.entrySet()) {
            AcceptManageEntity entity;
            if (!((String)entry.getKey()).contains("acceptentity") || HRStringUtils.isEmpty((String)(entity = (AcceptManageEntity)TypeUtils.castToJavaBean((Object)JSONObject.parseObject((String)((String)entry.getValue())), AcceptManageEntity.class)).getIspass()) || HRStringUtils.equals((String)entity.getIspass(), (String)isPass)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData(String key, DynamicObject colectDyo, DynamicObjectCollection collection, List<Long> ids) {
        try (TXHandle txHandle = TX.required();){
            if (!CollectionUtils.isEmpty((Collection)collection)) {
                IAcceptManageService.getInstance().save(collection);
            }
            HomCommonRepository.updateDynamicObject((String)"hom_collect", (DynamicObject)colectDyo);
            String errMsg = this.getSuccessMsg(key);
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().showSuccessNotification(errMsg);
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
            }
            this.getView().close();
        }
        threadPool.execute(() -> {
            if (key.equals("btn_pass") || key.equals("btn_unpass")) {
                LOGGER.info("===AcceptManageActivityPlugin batchConsentTask ids start workflow {}===", (Object)ids.toString());
                IActivityDomainService.getInstance().batchConsentTask(ids, ActivityNumberEnum.DATAACCEPTANCE);
                LOGGER.info("===end workflow ===");
                if (key.equals("btn_pass")) {
                    LOGGER.info("===start BTN_PASS sendMessage===");
                    ((ISendMessageService)ServiceFactory.getService(ISendMessageService.class)).sendMessageNew(colectDyo, RuleEngineSceneNumberEnum.HOMSCE_CHECK_PASS_MESSAGE);
                    LOGGER.info("===end BTN_PASS sendMessage===");
                } else {
                    LOGGER.info("===start BTN_UNPASS sendMessage===", (Object)ids.toString());
                    ((ISendMessageService)ServiceFactory.getService(ISendMessageService.class)).sendMessageNew(colectDyo, RuleEngineSceneNumberEnum.HOMSCE_CHECK_FAIL_MESSAGE);
                    LOGGER.info("===end BTN_UNPASS sendMessage===");
                }
            }
        });
    }

    private String getSuccessMsg(String key) {
        String msg = "";
        if ("btn_pass".equals(key)) {
            msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f!", (String)"OnbrdBreakupEdit_10", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        }
        if ("btn_unpass".equals(key)) {
            msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f!", (String)"OnbrdBreakupEdit_10", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        }
        if ("btn_save".equals(key)) {
            msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f!", (String)"ACCEPTMANAGE_8", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    private void btnSave(DynamicObjectCollection collection, DynamicObject colectDyo) {
        Map allMap = this.getView().getPageCache().getAll();
        if (!CollectionUtils.isEmpty((Map)allMap)) {
            LOGGER.info("===btnSave");
            for (Map.Entry entry : allMap.entrySet()) {
                if (!((String)entry.getKey()).contains("acceptentity")) continue;
                AcceptManageEntity entity = (AcceptManageEntity)TypeUtils.castToJavaBean((Object)JSONObject.parseObject((String)((String)entry.getValue())), AcceptManageEntity.class);
                DynamicObject dyo = this.geAcceptDyo(entity, "");
                dyo.set("ispass", (Object)entity.getIspass());
                collection.add((Object)dyo);
            }
        }
        colectDyo.set("acceptmodifier", (Object)RequestContext.get().getCurrUserId());
        colectDyo.set("acceptmodifytime", (Object)new Date());
    }

    private void acceptUnpass(DynamicObjectCollection collection, DynamicObject colectDyo) {
        Map allMap = this.getView().getPageCache().getAll();
        if (!CollectionUtils.isEmpty((Map)allMap)) {
            LOGGER.info("===acceptUnpass");
            for (Map.Entry entry : allMap.entrySet()) {
                if (!((String)entry.getKey()).contains("acceptentity")) continue;
                AcceptManageEntity entity = (AcceptManageEntity)TypeUtils.castToJavaBean((Object)JSONObject.parseObject((String)((String)entry.getValue())), AcceptManageEntity.class);
                DynamicObject dyo = this.geAcceptDyo(entity, "0");
                dyo.set("ispass", (Object)"0");
                collection.add((Object)dyo);
            }
        }
        colectDyo.set("acceptmodifier", (Object)RequestContext.get().getCurrUserId());
        colectDyo.set("acceptmodifytime", (Object)new Date());
        colectDyo.set("acceptstatus", (Object)"30");
    }

    private void acceptPass(DynamicObjectCollection collection, DynamicObject colectDyo) {
        Map allMap = this.getView().getPageCache().getAll();
        if (!CollectionUtils.isEmpty((Map)allMap)) {
            LOGGER.info("===acceptPass");
            for (Map.Entry entry : allMap.entrySet()) {
                if (!((String)entry.getKey()).contains("acceptentity")) continue;
                AcceptManageEntity entity = (AcceptManageEntity)TypeUtils.castToJavaBean((Object)JSONObject.parseObject((String)((String)entry.getValue())), AcceptManageEntity.class);
                DynamicObject dyo = this.geAcceptDyo(entity, "1");
                dyo.set("ispass", (Object)"1");
                collection.add((Object)dyo);
            }
        }
        colectDyo.set("acceptmodifier", (Object)RequestContext.get().getCurrUserId());
        colectDyo.set("acceptmodifytime", (Object)new Date());
        colectDyo.set("acceptstatus", (Object)"20");
    }

    private DynamicObject getCollectDyo() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long onbrdId = dataEntity.getLong("onboard.id");
        return HomCommonRepository.queryDynamicObject((String)"hom_collect", (String)"", (QFilter[])new QFilter[]{new QFilter("onboard", "=", (Object)onbrdId)});
    }

    private DynamicObject geAcceptDyo(AcceptManageEntity entity, String isPass) {
        DynamicObject dyo = null;
        dyo = entity.getId() != null ? AcceptManageRepository.generateDynamicObject((Object)entity.getId(), (String)SELECT_PROPERTIES) : new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hom_acceptmanagedetail"));
        dyo.set("collectconfighis", (Object)entity.getCollectId());
        dyo.set("onboard", (Object)entity.getOnbrdId());
        dyo.set("pagekey", (Object)entity.getPageKey());
        dyo.set("fieldKey", (Object)entity.getFieldKey());
        dyo.set("ispass", (Object)isPass);
        dyo.set("educertid", (Object)entity.getEduId());
        dyo.set("recheckstand", (Object)entity.getFieldRecheckStand());
        dyo.set("fieldtype", (Object)entity.getFieldType());
        dyo.set("fieldname", (Object)entity.getFieldName());
        dyo.set("index", (Object)entity.getIndex());
        dyo.set("entitykey", (Object)entity.getEntityKey());
        return dyo;
    }

    private void addPanel() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        long collectConfigHisId = dynamicObject.getLong("collectconfighis.id");
        long onbrdId = dynamicObject.getLong("onboard.id");
        DynamicObject dataEntity = CollectConfigRepository.queryCollectConfigHisById((String)"", (Long)collectConfigHisId);
        InfoGroupConfigEntity infoConfig = ((ICollectService)ServiceFactory.getService(ICollectService.class)).transferDynToEntity(dataEntity, "acceptmanage");
        List<AcceptManageEntity> acceptlist = this.getAcceptList(collectConfigHisId, onbrdId, infoConfig);
        if (CollectionUtils.isEmpty(acceptlist)) {
            String msg = ResManager.loadKDString((String)"\u8be5\u5f85\u5165\u804c\u4eba\u5458\u6ca1\u6709\u9700\u8981\u9a8c\u6536\u7684\u8d44\u6599\u3002", (String)"ACCEPTMANAGE_9", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey(INFOGROUP);
            formShowParameter.setFormId("hom_acceptnullpage");
            formShowParameter.setSendToClient(true);
            this.getView().showForm(formShowParameter);
            return;
        }
        FlexPanelAp allEduPanel = this.generateEduPanel(INFOGROUP);
        StyleAdapter head = this.generateHeadPanel();
        allEduPanel.getItems().add(head.getPanelAp());
        this.generateImgPanel(collectConfigHisId, acceptlist, allEduPanel, infoConfig);
        this.getView().updateControlMetadata(allEduPanel.getKey(), allEduPanel.createControl());
    }

    private void generateImgPanel(long collectConfigHisId, List<AcceptManageEntity> acceptlist, FlexPanelAp allEduPanel, InfoGroupConfigEntity infoConfig) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String acceptStatus = dynamicObject.getString("acceptstatus");
        Long onbrdId = dynamicObject.getLong("onboard.id");
        boolean flag = IOnbrdBillDomainService.getInstance().isEnrolled(onbrdId);
        for (int i = 0; i < acceptlist.size(); ++i) {
            PanelApAdatper imgPanelStyleAdapter = new PanelApAdatper("imgPanel" + i){

                public void setStyle() {
                    this.panelAp.setGrow(0);
                    this.panelAp.setShrink(0);
                    this.panelAp.setDirection("row");
                    this.panelAp.setWrap(true);
                }
            };
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hom_acceptmanagedetail");
            formShowParameter.setCaption("");
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("imgPanel" + i);
            formShowParameter.setCustomParam("candidateid", (Object)this.getModel().getDataEntity().getLong("onboard.candidate.id"));
            formShowParameter.setCustomParam("onboardid", (Object)this.getModel().getDataEntity().getLong("onboard.id"));
            formShowParameter.setCustomParam("config", (Object)infoConfig);
            formShowParameter.setCustomParam("collectconfighisid", (Object)collectConfigHisId);
            formShowParameter.setCustomParam("acceptentity", (Object)acceptlist.get(i));
            formShowParameter.setCustomParam("index", (Object)(i + ""));
            formShowParameter.setCustomParam("acceptstatus", (Object)acceptStatus);
            formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            formShowParameter.setCustomParam("formid", (Object)(i + ""));
            if (flag) {
                formShowParameter.setStatus(OperationStatus.VIEW);
            }
            formShowParameter.setSendToClient(true);
            this.getView().showForm(formShowParameter);
            allEduPanel.getItems().add(imgPanelStyleAdapter.getPanelAp());
        }
    }

    private StyleAdapter generateHeadPanel() {
        PanelApAdatper head = new PanelApAdatper("flexpanelap1222"){

            public void setStyle() {
                this.panelAp.setGrow(0);
                this.panelAp.setShrink(0);
                this.panelAp.setWidth(new LocaleString("100%"));
                this.panelAp.setDirection("row");
            }
        };
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hom_acceptmanagehead");
        formShowParameter.setCaption("");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("flexpanelap1222");
        this.getView().showForm(formShowParameter);
        return head;
    }

    private List<AcceptManageEntity> getAcceptList(long collectConfigHisId, long onbrdId, InfoGroupConfigEntity infoConfig) {
        List acceptlist = this.transDyoToList(collectConfigHisId, onbrdId);
        if (CollectionUtils.isEmpty(acceptlist)) {
            acceptlist = this.getImgAndAttachList(infoConfig);
        }
        return acceptlist;
    }

    private List getImgAndAttachList(InfoGroupConfigEntity infoConfig) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long onbrdId = dataEntity.getLong("onboard.id");
        long canidateId = dataEntity.getLong("onboard.candidate.id");
        long collectConfigHisId = dataEntity.getLong("collectconfighis.id");
        String acceptStatus = dataEntity.getString("acceptstatus");
        String isPass = "";
        if (acceptStatus.equals("20")) {
            isPass = "1";
        } else if (acceptStatus.equals("30")) {
            isPass = "0";
        }
        return IAcceptManageService.getInstance().getImgAndAttachList(infoConfig, onbrdId, canidateId, collectConfigHisId, isPass);
    }

    private List<AcceptManageEntity> transDyoToList(long collectConfigHisId, long onbrdId) {
        ArrayList<AcceptManageEntity> acceptlist = new ArrayList<AcceptManageEntity>(50);
        DynamicObject[] dyos = IAcceptManageService.getInstance().queryByCollectByOnbrd(SELECT_PROPERTIES, (Object)onbrdId, "index asc");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long canidateId = dataEntity.getLong("onboard.candidate.id");
        for (DynamicObject dyo : dyos) {
            String fieldName = dyo.getString("fieldname");
            String fieldKey = dyo.getString("fieldkey");
            String pageKey = dyo.getString("pagekey");
            int fieldType = Integer.parseInt(dyo.getString("fieldtype"));
            String fieldRecheckStand = dyo.getString("recheckstand");
            String isPass = dyo.getString("ispass");
            String entityKey = dyo.getString("entitykey");
            long eduId = dyo.getLong("educertid");
            int index = dyo.getInt("index");
            long id = dyo.getLong("id");
            ArrayList acceptlistRes = new ArrayList(50);
            IAcceptManageService.getInstance().queryImgAndAttach(onbrdId, canidateId, collectConfigHisId, isPass, acceptlistRes, fieldName, fieldKey, 0, fieldType, fieldRecheckStand, Long.valueOf(eduId), entityKey, pageKey);
            if (acceptlistRes.size() <= 0) continue;
            AcceptManageEntity acceptEntity = (AcceptManageEntity)acceptlistRes.get(0);
            acceptEntity.setId(Long.valueOf(id));
            acceptEntity.setIndex(index);
            acceptlist.add(acceptEntity);
        }
        return acceptlist;
    }

    private FlexPanelAp generateEduPanel(String panelKey) {
        PanelApAdatper mainPanelApt = new PanelApAdatper(panelKey){

            public void setStyle() {
                this.panelAp.setGrow(0);
                this.panelAp.setShrink(0);
                this.panelAp.setDirection("row");
                this.panelAp.setWrap(true);
                this.margin.setBottom("10px");
                this.panelAp.setJustifyContent("default");
                this.panelAp.setAlignItems("default");
                this.panelAp.setAlignContent("default");
            }
        };
        return mainPanelApt.getPanelAp();
    }
}

