/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity.acceptmanage;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;

public class AcceptManageListLinkPlugin
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(AcceptManageListLinkPlugin.class);
    private static final String BTN_PASS_LIST = "btn_pass_list";
    private static final String BTN_UNPASS_LIST = "btn_unpass_list";
    private static final String SELECT_PROPERTIE = "onboard.id, acceptstatus, acceptmodifier, acceptmodifytime";
    private static final String ACCEPTSTATUS = "acceptstatus";
    private static final String ACCEPTMODIFIER = "acceptmodifier";
    private static final String ACCEPTMODIFYTIME = "acceptmodifytime";
    private static final String HOM_ACCEPTMANAGEALL = "hom_acceptmanageall";
    private static final String HOM_ACCEPTMANAGEPASS = "hom_acceptmanagepass";
    private static final String HOM_ACCEPTMANAGEUNPASS = "hom_acceptmanageunpass";
    private static final String HOM_ACCEPTMANAGEING = "hom_acceptmanageing";
    private static final String TBLCLOSE = "tblclose";
    private static final String ERRCODE_01 = "01";
    private static final String ERRCODE_02 = "02";
    private static final String ERRCODE_03 = "03";
    private static final String COLLECT_TEMPLATE_NONE = "0";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"AcceptManageListLinkPlugin_0001", (int)30);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean success;
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        boolean bl = success = args.getOperationResult() == null || args.getOperationResult().isSuccess();
        if (success) {
            ArrayList<Long> ids;
            String errCode;
            DynamicObject[] dyos;
            Object[] pks;
            ListSelectedRowCollection seldRows;
            if (key.equals(BTN_PASS_LIST)) {
                seldRows = this.checkListSelectedRows();
                if (seldRows == null) {
                    return;
                }
                pks = seldRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
                dyos = HomCommonRepository.queryDynamicObjectByPks((String)"hom_collect", (String)SELECT_PROPERTIE, (Object[])pks);
                errCode = this.updateCollectEntity("20", dyos);
                if (!ERRCODE_01.equals(errCode)) {
                    if (ERRCODE_02.equals(errCode)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff01", (String)"ACCEPTMANAGE_11", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bf9\u5165\u804c\u72b6\u6001\u4e3a\u201c\u5df2\u5165\u804c\u201d\u201c\u5165\u804c\u7ec8\u6b62\u201d\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ACCEPTMANAGE_12", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f!", (String)"OnbrdBreakupEdit_10", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                ids = new ArrayList<Long>(dyos.length);
                for (DynamicObject dyo : dyos) {
                    ids.add(dyo.getLong("onboard.id"));
                }
                this.sendMsgAndWorkFlow(key, ids, dyos);
            }
            if (key.equals(BTN_UNPASS_LIST)) {
                seldRows = this.checkListSelectedRows();
                if (seldRows == null) {
                    return;
                }
                pks = seldRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
                dyos = HomCommonRepository.queryDynamicObjectByPks((String)"hom_collect", (String)SELECT_PROPERTIE, (Object[])pks);
                errCode = this.updateCollectEntity("30", dyos);
                if (!ERRCODE_01.equals(errCode)) {
                    if (ERRCODE_02.equals(errCode)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25!", (String)"ACCEPTMANAGE_11", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bf9\u5165\u804c\u72b6\u6001\u4e3a\u201c\u5df2\u5165\u804c\u201d\u201c\u5165\u804c\u7ec8\u6b62\u201d\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ACCEPTMANAGE_12", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f!", (String)"ACCEPTMANAGE_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                ids = new ArrayList(dyos.length);
                for (DynamicObject dyo : dyos) {
                    ids.add(dyo.getLong("onboard.id"));
                }
                this.sendMsgAndWorkFlow(key, ids, dyos);
            }
        }
    }

    private void sendMsgAndWorkFlow(String key, List<Long> ids, DynamicObject[] colectDyos) {
        threadPool.execute(() -> {
            block2: {
                block3: {
                    if (!key.equals(BTN_PASS_LIST) && !key.equals(BTN_UNPASS_LIST)) break block2;
                    LOGGER.info("===AcceptManageActivityPlugin batchConsentTask ids start workflow {}===", (Object)ids.toString());
                    IActivityDomainService.getInstance().batchConsentTask(ids, ActivityNumberEnum.DATAACCEPTANCE);
                    LOGGER.info("===end workflow ===");
                    if (!key.equals(BTN_PASS_LIST)) break block3;
                    for (DynamicObject colectDyo : colectDyos) {
                        LOGGER.info("===start BTN_PASS_LIST sendMessage===");
                        ((ISendMessageService)ServiceFactory.getService(ISendMessageService.class)).sendMessageNew(colectDyo, RuleEngineSceneNumberEnum.HOMSCE_CHECK_PASS_MESSAGE);
                        LOGGER.info("===end BTN_PASS_LIST sendMessage===");
                    }
                    break block2;
                }
                if (!key.equals(BTN_UNPASS_LIST)) break block2;
                for (DynamicObject colectDyo : colectDyos) {
                    LOGGER.info("===start BTN_UNPASS_LIST sendMessage===");
                    ((ISendMessageService)ServiceFactory.getService(ISendMessageService.class)).sendMessageNew(colectDyo, RuleEngineSceneNumberEnum.HOMSCE_CHECK_FAIL_MESSAGE);
                    LOGGER.info("===end BTN_UNPASS_LIST sendMessage===");
                }
            }
        });
    }

    private ListSelectedRowCollection checkListSelectedRows() {
        ListSelectedRowCollection seldRows = this.getSelectedRows();
        if (seldRows == null || seldRows.isEmpty()) {
            return null;
        }
        ListSelectedRow listSelectedRow = seldRows.get(0);
        DynamicObject dyo = HomCommonRepository.queryDynamicObjectByPk((String)"hom_collect", (String)ACCEPTSTATUS, (Object)listSelectedRow.getPrimaryKeyValue());
        if (Objects.isNull(dyo)) {
            return null;
        }
        return seldRows;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (TBLCLOSE.equals(evt.getItemKey())) {
            this.getView().getParentView().invokeOperation("close");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String updateCollectEntity(String accept, DynamicObject[] dyos) {
        ArrayList<String> acceptList = new ArrayList<String>(dyos.length);
        ArrayList<Long> ids = new ArrayList<Long>(dyos.length);
        for (DynamicObject dyo : dyos) {
            acceptList.add(dyo.getString(ACCEPTSTATUS));
            ids.add(dyo.getLong("onboard.id"));
            dyo.set(ACCEPTSTATUS, (Object)accept);
            dyo.set(ACCEPTMODIFIER, (Object)RequestContext.get().getCurrUserId());
            dyo.set(ACCEPTMODIFYTIME, (Object)new Date());
        }
        if (acceptList.contains("40")) {
            return ERRCODE_03;
        }
        if (IOnbrdBillDomainService.getInstance().isEnrolled(ids.toArray(new Object[0]))) {
            return ERRCODE_03;
        }
        String errcode = ERRCODE_01;
        try (TXHandle txHandle = TX.required();){
            HomCommonRepository.updateDynamicObjects((String)"hom_collect", (DynamicObject[])dyos);
        }
        return errcode;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object pk = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        DynamicObject dyo = HomCommonRepository.queryDynamicObjectByPk((String)"hom_collect", (String)"acceptstatus,onboard.id,onboard.enrollstatus,templateresult", (Object)pk);
        if (Objects.isNull(dyo)) {
            return;
        }
        String acceptStatus = dyo.getString(ACCEPTSTATUS);
        if (OnbrdStatusEnum.BREAK_UP.toString().equals(dyo.getString("onboard.enrollstatus")) || acceptStatus.equals("40")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62\u7684\u5355\u636e\u65e0\u6cd5\u67e5\u770b\u8be6\u60c5\u3002", (String)"CollectActivityListPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        if (HRStringUtils.equals((String)COLLECT_TEMPLATE_NONE, (String)dyo.getString("templateresult"))) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hom_collectmatchtemplate");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\u63d0\u793a", (String)"CollectActivityListPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("onboardId", (Object)dyo.getLong("onboard.id"));
            formShowParameter.setCustomParam("id", (Object)dyo.getLong("id"));
            this.getView().showForm(formShowParameter);
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        IFormView formView = this.getView();
        if (formView instanceof IListView) {
            IListView listView = (IListView)formView;
            String biilFormId = listView.getBillFormId();
            if (HOM_ACCEPTMANAGEALL.equals(listView.getBillFormId())) {
                biilFormId = this.getBillFormId(acceptStatus, biilFormId);
            }
            billShowParameter.setPkId(pk);
            String candidateName = dyo.getString("onboard.name");
            billShowParameter.setCaption(MessageFormat.format(ResManager.loadKDString((String)"\u8d44\u6599\u9a8c\u6536-{0}", (String)"ACCEPTMANAGE_5", (String)"hr-hom-formplugin", (Object[])new Object[0]), candidateName));
            billShowParameter.setFormId(biilFormId);
            if (this.getView().getParentView() != null) {
                billShowParameter.setPageId(this.getView().getParentView().getPageId() + biilFormId + "_" + pk);
            }
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private String getBillFormId(String acceptStatus, String biilFormId) {
        if ("10".equals(acceptStatus)) {
            biilFormId = HOM_ACCEPTMANAGEING;
        }
        if ("20".equals(acceptStatus)) {
            biilFormId = HOM_ACCEPTMANAGEPASS;
        }
        if ("30".equals(acceptStatus)) {
            biilFormId = HOM_ACCEPTMANAGEUNPASS;
        }
        return biilFormId;
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        String acceptStatus = (String)this.getView().getFormShowParameter().getCustomParam(ACCEPTSTATUS);
        if (HRStringUtils.isEmpty((String)acceptStatus)) {
            setFilterEvent.setOrderBy("acceptStatus asc,acceptmodifytime desc");
            return;
        }
        String orderStr = "acceptmodifytime desc";
        if (HRStringUtils.isNotEmpty((String)orderStr)) {
            setFilterEvent.setOrderBy(orderStr);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        commonFilterColumns.forEach(filterColumn -> {
            String fieldName = filterColumn.getFieldName();
            if (HRStringUtils.equals((String)"onboard.enrollstatus", (String)fieldName)) {
                filterColumn.setDefaultValue(OnbrdStatusEnum.WAIT_ONBRD.toString());
            }
        });
    }
}

