/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity.acceptmanage;

import java.util.EventObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class AcceptManageListPlugin
extends HRDataBaseList
implements TabSelectListener {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        switch (tabKey = tabSelectEvent.getTabKey()) {
            case "all": {
                this.loadAllList();
                break;
            }
            case "ingaccept": {
                this.loadIngList();
                break;
            }
            case "passaccept": {
                this.loadPassList();
                break;
            }
            case "unpassaccept": {
                this.loadUnpassList();
                break;
            }
            case "breakupaccept": {
                this.loadBreakupList();
                break;
            }
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab(((Control)tab.getItems().get(1)).getKey());
    }

    private void loadAllList() {
        this.loadAcceptManageList("hom_acceptmanageall", "all", " ");
    }

    private void loadIngList() {
        this.loadAcceptManageList("hom_acceptmanageing", "ingaccept", "10");
    }

    private void loadPassList() {
        this.loadAcceptManageList("hom_acceptmanagepass", "passaccept", "20");
    }

    private void loadUnpassList() {
        this.loadAcceptManageList("hom_acceptmanageunpass", "unpassaccept", "30");
    }

    private void loadBreakupList() {
        this.loadAcceptManageList("hom_acceptmanagebreakup", "breakupaccept", "40");
    }

    private void loadAcceptManageList(String sourceFormId, String tabLabelName, String acceptStatus) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(sourceFormId);
        listShowParameter.getOpenStyle().setTargetKey(tabLabelName);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.setCustomParam("acceptstatus", (Object)acceptStatus);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter acceptStatusFilter = null;
        acceptStatusFilter = HRStringUtils.isNotEmpty((String)acceptStatus) ? new QFilter("acceptstatus", "=", (Object)acceptStatus) : new QFilter("acceptstatus", "!=", (Object)acceptStatus);
        listFilterParameter.getQFilters().add(acceptStatusFilter);
        listShowParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)listShowParameter);
        IFormView listView = this.getView().getView(listShowParameter.getPageId());
        if (null != listView) {
            this.getView().sendFormAction(listView);
        }
    }
}

