/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity.handle;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.ActivityinsTaskSwitchEnum;

public class ActivityListPlugin
extends HRDataBaseList
implements TabSelectListener {
    static final String ACTIVE_ALL = "activeall";
    static final String PROCESSING = "processing";
    static final String REJECTED = "rejected";
    static final String COMPLETED = "completed";
    static final String TERMINATED = "terminated";
    static final String FLEXPANELAP_ALL = "flexpanelapall";
    static final String FLEXPANELAP_PROCESSING = "flexpanelapprocessing";
    static final String FLEXPANELAP_REJECTED = "flexpanelaprejected";
    static final String FLEXPANELAP_COMPLETED = "flexpanelapcompleted";
    static final String FLEXPANELAP_TERMINATED = "flexpanelapterminated";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        switch (tabKey = tabSelectEvent.getTabKey()) {
            case "activeall": {
                this.loadList("hom_activehandlealllist", "all", FLEXPANELAP_ALL, this.getQFilter(null, true));
                break;
            }
            case "processing": {
                this.loadList("hom_activeinhandleinglist", ActivityStatusEnum.PROCESSING.getValue(), FLEXPANELAP_PROCESSING, this.getQFilter(ActivityStatusEnum.PROCESSING.getValue(), false));
                break;
            }
            case "rejected": {
                this.loadList("hom_activeinrejectlist", ActivityStatusEnum.REJECTED.getValue(), FLEXPANELAP_REJECTED, this.getQFilter(ActivityStatusEnum.REJECTED.getValue(), false));
                break;
            }
            case "completed": {
                this.loadList("hom_activehashandle", ActivityStatusEnum.COMPLETED.getValue(), FLEXPANELAP_COMPLETED, this.getQFilter(ActivityStatusEnum.COMPLETED.getValue(), false));
                break;
            }
            case "terminated": {
                this.loadList("hom_activehasstop", ActivityStatusEnum.TERMINATED.getValue(), FLEXPANELAP_TERMINATED, this.getQFilter(ActivityStatusEnum.TERMINATED.getValue(), false));
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object status = this.getView().getFormShowParameter().getCustomParams().get("taskstatus");
        if (status == null) {
            this.loadList("hom_activehandlealllist", "all", FLEXPANELAP_ALL, this.getQFilter(null, true));
        } else if (status != null && ActivityStatusEnum.PROCESSING.getValue().equals(status.toString())) {
            Tab tab = (Tab)this.getView().getControl("tabap");
            tab.activeTab(PROCESSING);
        }
    }

    private QFilter getQFilter(String status, boolean isall) {
        ActivityStatusEnum.COMPLETED.getValue();
        Long userId = RequestContext.get().getCurrUserId();
        QFilter handler = new QFilter("activityins.handlers.fbasedataid", "=", (Object)userId);
        if (!isall) {
            handler = handler.and(new QFilter("activityins.taskstatus", "=", (Object)status));
        }
        return handler;
    }

    private void loadList(String sourceFormId, String status, String tabLabelName, QFilter qFilter) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(sourceFormId);
        listShowParameter.getOpenStyle().setTargetKey(tabLabelName);
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.getQFilters().add(qFilter);
        DynamicProperty taskSwitchProp = EntityMetadataCache.getDataEntityType((String)"hrcs_activityins").getProperty("taskswitch");
        if (!HRObjectUtils.isEmpty((Object)taskSwitchProp)) {
            listFilterParameter.getQFilters().add(new QFilter("activityins.taskswitch", "!=", (Object)ActivityinsTaskSwitchEnum.STR_THREE.getValue()));
        }
        listShowParameter.setCustomParam("status", (Object)status);
        listShowParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)listShowParameter);
        IFormView listView = this.getView().getView(listShowParameter.getPageId());
        if (null != listView) {
            this.getView().sendFormAction(listView);
        }
    }
}

