/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.activity.handle;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.application.common.CommonService;
import kd.hr.hom.business.domain.service.activity.IActivityCommonInfoService;
import kd.hr.hom.business.domain.service.collect.ICooperationManageService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.ActivityinsTaskSwitchEnum;
import kd.sdk.hr.ssc.common.util.SSCCommonUtil;

public class HandleDetailPlugin
extends HRDynamicFormBasePlugin
implements UploadListener {
    private static final Log LOGGER = LogFactory.getLog(HandleDetailPlugin.class);
    private static final String TASKPANELAP = "taskpanelap";
    private static final String TASK_STATUS = "taskstatus";
    private static final String FIELDGROUPPANELAP1 = "fieldgrouppanelap1";
    private static final String REMARKS = "remarks";
    private static final String REMARKS_T = "remarks_t";
    private static final String REMARKS_STRING = "_";
    private static final String PROCESSING = "processing";
    private static final String COMPLETED = "completed";
    private static final String BAR_SAVEANDNEW = "bar_saveandnew";
    private static final String BAR_COMMIT = "bar_commit";
    private static final String TITLE_APANEL = "titleapanel";
    static final String EDUCATIONATTACH = "attachmentpanelap";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Long pkId = HRJSONUtils.getLongValOfCustomParam((Object)((BillShowParameter)formShowParameter).getPkId());
        DynamicObject onbrdDyObj = ICooperationManageService.getInstance().queryCooperationById("id,onbrdid,activity.name", pkId);
        if (onbrdDyObj != null) {
            formShowParameter.setCaption(MessageFormat.format(ResManager.loadKDString((String)"{0}-{1}", (String)"ActivityCommonInfoServiceImpl_7", (String)"hr-hom-business", (Object[])new Object[0]), onbrdDyObj.getString("activity.name"), onbrdDyObj.getString("onbrdid.name")));
        }
    }

    public void registerListener(EventObject e) {
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(EDUCATIONATTACH);
        panel.addUploadListener((UploadListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long entryId = IActivityCommonInfoService.getInstance().getActivityId(this.getView());
        DynamicObject activityDetail = IActivityCommonInfoService.getInstance().getActivityDetail(entryId);
        if (!this.init(activityDetail)) {
            return;
        }
        boolean flag = CommonService.tryRequireLockWithOnbrdBill((Long)entryId, (String)"donothing_tran", (String)"KEY_DATAMUTEX_ACTIVITY", (IFormView)this.getView(), (String)"hom_activebase");
        LOGGER.info("HandleDetailPlugin_afterBindData_flag:{}", (Object)flag);
        if (!flag) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVEANDNEW, BAR_COMMIT});
            this.getView().setEnable(Boolean.FALSE, new String[]{EDUCATIONATTACH, EDUCATIONATTACH, "basepanelap", TASKPANELAP});
        }
    }

    private boolean init(DynamicObject activityDetail) {
        if (SSCCommonUtil.showParameterAppIdIsHstc((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TITLE_APANEL, "flexpanelap2"});
        }
        if (Objects.isNull(activityDetail)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u8bb0\u5f55\u3002", (String)"HandleDetailPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject activityIns = activityDetail.getDynamicObject("activityins");
        if (Objects.isNull(activityIns)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d3b\u52a8\u5b9e\u4f8b\u8bb0\u5f55\u3002", (String)"HandleDetailPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (activityIns.containsProperty("taskswitch") && ActivityinsTaskSwitchEnum.STR_THREE.getValue().equals(activityIns.getString("taskswitch"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVEANDNEW});
        }
        long userId = UserServiceHelper.getCurrentUserId();
        DynamicObjectCollection handlers = activityIns.getDynamicObjectCollection("handlers");
        Optional<DynamicObject> isHandler = handlers.stream().filter(e -> userId == e.getLong("fbasedataId.id")).findAny();
        if (!isHandler.isPresent()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u5f53\u524d\u4efb\u52a1\u7684\u5904\u7406\u4eba\u3002", (String)"HandleDetailPlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("close");
            return false;
        }
        String taskStatus = activityIns.getString(TASK_STATUS);
        this.getView().getPageCache().put(TASK_STATUS, taskStatus);
        this.getView().setVisible(Boolean.FALSE, new String[]{TASK_STATUS});
        if (!Arrays.asList(ActivityStatusEnum.PROCESSING.getValue(), ActivityStatusEnum.REJECTED.getValue()).contains(taskStatus)) {
            String remark = activityDetail.getString(REMARKS);
            if (HRStringUtils.isEmpty((String)remark)) {
                remark = REMARKS_STRING;
            }
            this.getView().getModel().setValue(REMARKS_T, (Object)remark);
            this.getView().getModel().setValue(TASK_STATUS, (Object)taskStatus);
            this.getView().setEnable(Boolean.FALSE, new String[]{TASKPANELAP});
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_COMMIT, BAR_SAVEANDNEW});
        }
        if (ActivityStatusEnum.COMPLETED.getValue().equals(taskStatus)) {
            this.getView().getModel().setValue(COMPLETED, (Object)Boolean.TRUE);
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Boolean key;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("donothing_commit".equals(operateKey) && Boolean.FALSE.equals(key = (Boolean)this.getView().getModel().getValue(COMPLETED))) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u5148\u5c06\u4efb\u52a1\u5904\u7406\u72b6\u6001\u5207\u6362\u4e3a\u201c\u5df2\u5b8c\u6210\u201d\u540e\u518d\u8fdb\u884c\u63d0\u4ea4\u3002", (String)"HandleDetailPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(tips);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String str;
        super.afterDoOperation(args);
        switch (str = args.getOperateKey()) {
            case "donothing_tran": {
                this.doTransfer(args);
                break;
            }
            case "donothing_commit": {
                this.doCommit(args);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (this.getView().getPageCache().get("change") != null) {
            this.getView().getPageCache().remove("change");
            return;
        }
        if (HRStringUtils.equals((String)name, (String)COMPLETED)) {
            this.getView().getModel().setValue(COMPLETED, (Object)Boolean.TRUE);
            this.change(PROCESSING);
        }
        if (HRStringUtils.equals((String)name, (String)PROCESSING)) {
            this.getView().getModel().setValue(PROCESSING, (Object)Boolean.TRUE);
            this.change(COMPLETED);
        }
    }

    private void change(String change) {
        Boolean processing = (Boolean)this.getView().getModel().getValue(change);
        if (Boolean.TRUE.equals(processing)) {
            this.getView().getPageCache().put("change", change);
            this.getView().getModel().setValue(change, (Object)Boolean.FALSE);
        }
    }

    private void doTransfer(AfterDoOperationEventArgs eventArgs) {
        if (HRObjectUtils.isEmpty((Object)eventArgs.getOperationResult()) || eventArgs.getOperationResult().isSuccess()) {
            IActivityCommonInfoService.getInstance().showTransfer(this.getView(), (IFormPlugin)this, "transfer_callback", "hom_handletransfer");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Long entryId = IActivityCommonInfoService.getInstance().getActivityId(this.getView());
        IHomDataMutexService.getInstance().release(String.valueOf(entryId), "hom_collaborationdetail", "donothing_tran");
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"transfer_callback") && closedCallBackEvent.getReturnData() != null) {
            Boolean isCancel;
            Map resultMap = (Map)closedCallBackEvent.getReturnData();
            Boolean bl = isCancel = resultMap.get("TRANSFER_CLOSE") != null ? (Boolean)resultMap.get("TRANSFER_CLOSE") : Boolean.FALSE;
            if (Boolean.TRUE.equals(isCancel)) {
                HRPageCache parentCache = new HRPageCache(this.getView());
                List userIds = resultMap.get("cachepersonid") != null ? (List)resultMap.get("cachepersonid") : new ArrayList();
                parentCache.put("personid", userIds);
                return;
            }
            if (Objects.isNull(resultMap.get("operation")) || !"determine".equals((String)resultMap.get("operation"))) {
                return;
            }
            IActivityCommonInfoService.getInstance().handleTransfer(this.getView(), resultMap);
            this.upDate();
        }
        LOGGER.info("HandleDetailPlugin_closedCallBack_end");
    }

    private void doCommit(AfterDoOperationEventArgs args) {
        OperationResult opResult = args.getOperationResult();
        if (!HRObjectUtils.isEmpty((Object)opResult) && opResult.isSuccess()) {
            if (SSCCommonUtil.showParameterAppIdIsHstc((IFormView)this.getView())) {
                this.getView().invokeOperation("save");
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("opkey", "donothing_commit");
                result.put("success", "true");
                this.getView().returnDataToParent(result);
                this.getView().close();
                return;
            }
            this.refreshView();
            this.getView().close();
        }
    }

    private void upDate() {
        this.getView().invokeOperation("save");
        this.refreshView();
        this.getView().close();
    }

    private void refreshView() {
        if (this.getView().getParentView() != null) {
            String tips = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f!", (String)"HandleDetailPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().getParentView().showSuccessNotification(tips);
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }
}

