/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfirmPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ConfirmPlugin.class);
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String EXPORT_EXCEL = "exportexcel";
    private static final String LABEL_FINAL = "label_final";
    private static final String FLEXPANEL_CANDONEXT = "flexpanel_candonext";
    private static final String FLEXPANEL_NEEDCLOSE = "flexpanel_needclose";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String allPerson = (String)formShowParameter.getCustomParam("allperson");
        String fitPerson = (String)formShowParameter.getCustomParam("fitperson");
        String noFitPerson = (String)formShowParameter.getCustomParam("nofitperson");
        String unit = (String)formShowParameter.getCustomParam("unit");
        String operation = (String)formShowParameter.getCustomParam("operation");
        String fitOperation = (String)formShowParameter.getCustomParam("fitoperation");
        String fitCondition = (String)formShowParameter.getCustomParam("fitCondition");
        String noFitCondition = (String)formShowParameter.getCustomParam("noFitCondition");
        this.setLabelData(allPerson, "allperson");
        this.setLabelData(fitPerson, "fitperson");
        this.setLabelData(noFitPerson, "nofitperson");
        this.setLabelData(unit, "unit");
        this.setLabelData(operation, "operation");
        this.setLabelData(fitOperation, "fitoperation");
        this.setLabelData(fitCondition, "fitCondition");
        this.setLabelData(noFitCondition, "noFitCondition");
        if (Integer.valueOf(fitPerson).equals(0)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_FINAL, FLEXPANEL_CANDONEXT});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANEL_NEEDCLOSE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANEL_NEEDCLOSE});
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_CONFIRM, EXPORT_EXCEL});
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            Control control = (Control)evt.getSource();
            switch (control.getKey()) {
                case "btn_confirm": {
                    IFormView formView = this.getView();
                    Object parameters = formView.getFormShowParameter().getCustomParam("parameters");
                    formView.returnDataToParent(parameters);
                    formView.close();
                    break;
                }
                case "exportexcel": {
                    this.exportExcel();
                    break;
                }
            }
        }
    }

    private void exportExcel() {
        String excelName = (String)this.getView().getFormShowParameter().getCustomParam("excelname");
        List exportDataList = (List)this.getView().getFormShowParameter().getCustomParam("exportdatalist");
        List headDataLst = new ArrayList();
        try {
            headDataLst = (List)HRJSONUtils.cast((String)this.getView().getFormShowParameter().getCustomParam("headdatalist").toString(), List.class, (Class[])new Class[]{HRExportHeadObject.class});
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
            this.getView().showErrMessage(iOException.getMessage(), " Fail to cast json ! Reason: ");
        }
        String exportUrl = null;
        try {
            exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, (List)exportDataList, headDataLst);
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
            this.getView().showErrMessage(iOException.getMessage(), " Fail to get export Excel url ! Reason: ");
        }
        if (!HRStringUtils.isEmpty((String)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }

    private void setLabelData(String data, String labelName) {
        Label label;
        if (HRStringUtils.isNotEmpty((String)labelName) && HRStringUtils.isNotEmpty((String)data) && (label = (Label)this.getView().getControl(labelName)) != null) {
            label.setText(data);
        }
    }
}

