/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.base;

import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.common.enums.HomPageToHcfPageEnum;
import kd.hr.hom.common.util.HOMObjectUtils;

public class HomOnbrdDataBaseEdit
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(HomOnbrdDataBaseEdit.class);

    protected void showEmbedBillPage(String pageNumber, String targetKey, Tuple<String, String> pkIdTuple, OperationStatus operationStatus, String billNo) {
        long onbrdId;
        BillShowParameter formShowParameter = new BillShowParameter();
        if ("hom_onbrdinfo".equals(pageNumber)) {
            formShowParameter.setEnableUserReentrant(true);
        }
        if ((onbrdId = Long.parseLong((String)pkIdTuple.item1)) != 0L) {
            formShowParameter.setPkId(pkIdTuple.item1);
        }
        formShowParameter.setCustomParam("billno", (Object)billNo);
        formShowParameter.setCustomParam("viewtype", this.getView().getFormShowParameter().getCustomParam("viewtype"));
        formShowParameter.setCustomParam("routine_skip", this.getView().getFormShowParameter().getCustomParam("routine_skip"));
        formShowParameter.setCustomParam("personindexid", this.getView().getFormShowParameter().getCustomParam("personindexid"));
        formShowParameter.setCustomParam("piddata", this.getView().getFormShowParameter().getCustomParam("piddata"));
        this.showEmbedPage((FormShowParameter)formShowParameter, pageNumber, targetKey, pkIdTuple, operationStatus);
    }

    protected void showEmbedPage(String pageNumber, HomPageToHcfPageEnum cardInfoEnum, Tuple<String, String> pkIdTuple, OperationStatus operationStatus, boolean ifCheckPermission) {
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        String pageNumberPermission = pageNumber;
        if (HRStringUtils.equals((String)"hom_emergencycontact_view", (String)pageNumber)) {
            pageNumberPermission = "hom_emergencycontact_show";
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        if (ifCheckPermission && !onbrdCommonAppService.checkPermission(pageNumberPermission, "47150e89000000ac", appId)) {
            logger.info("No PermItem! pageNumber:{}, cardPanelKey:{}", (Object)pageNumberPermission, (Object)cardInfoEnum.getCardPanelKey());
            this.getView().setVisible(Boolean.FALSE, new String[]{cardInfoEnum.getCardPanelKey()});
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        this.showEmbedPage(formShowParameter, pageNumber, cardInfoEnum.getTargetKey(), pkIdTuple, operationStatus);
    }

    protected void showEmbedPage(String pageNumber, String targetKey, Tuple<String, String> pkIdTuple, OperationStatus operationStatus) {
        FormShowParameter formShowParameter = new FormShowParameter();
        this.showEmbedPage(formShowParameter, pageNumber, targetKey, pkIdTuple, operationStatus);
    }

    private void showEmbedPage(FormShowParameter formShowParameter, String pageNumber, String targetKey, Tuple<String, String> dataIds, OperationStatus status) {
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        formShowParameter.setCustomParam("selectedRowIds", dataIds.item1);
        formShowParameter.setCustomParam("id", dataIds.item1);
        formShowParameter.setCustomParam("candidateid", dataIds.item2);
        formShowParameter.setCustomParam("operationStatus", (Object)status.name());
        formShowParameter.setCustomParam("targetPanel", (Object)targetKey);
        formShowParameter.setFormId(pageNumber);
        formShowParameter.setStatus(status);
        formShowParameter.setSendToClient(true);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(pageNumber, formShowParameter.getPageId());
        logger.info("this.getView().getPageId():" + this.getView().getPageId() + ", formShowParameter.getPageId():" + formShowParameter.getPageId() + ", pageNumber:" + pageNumber);
        this.getView().showForm(formShowParameter);
    }

    protected boolean invokeChildOperation(String pageNumber, String operation) {
        return (Boolean)this.invokeChildOperationResult((String)pageNumber, (String)operation).item1;
    }

    protected Tuple<Boolean, String> invokeChildOperationResult(String pageNumber, String operation) {
        IFormView view = this.getView();
        try {
            OperationResult result = this.getInvokeChildOperationResult(pageNumber, operation);
            if (result == null) {
                return Tuple.create((Object)Boolean.FALSE, (Object)"");
            }
            if (!result.isSuccess()) {
                this.showOperationResult(view, result);
                return Tuple.create((Object)Boolean.FALSE, (Object)"");
            }
            return Tuple.create((Object)Boolean.TRUE, (Object)result.getMessage());
        }
        catch (Exception exp) {
            logger.error("===invokeChildOperation===", (Throwable)exp);
            view.showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"HomOnbrdDataBaseEdit_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return Tuple.create((Object)Boolean.FALSE, null);
        }
    }

    protected boolean showOperationResult(IFormView view, OperationResult result) {
        if (result == null) {
            return false;
        }
        if (result.isSuccess()) {
            return true;
        }
        logger.info(HOMObjectUtils.toJSONString((Object)result));
        if (result.getAllErrorOrValidateInfo().size() > 0) {
            logger.info("showOperationResult getAllErrorOrValidateInfo");
            view.showOperationResult(result);
        } else if (HRStringUtils.isNotEmpty((String)result.getMessage())) {
            String msg = result.getMessage();
            if (msg.startsWith("validateStaffUseResult:")) {
                view.showErrorNotification(msg.replaceFirst("validateStaffUseResult:", ""));
            } else if (!HRStringUtils.equals((String)"inblacklist", (String)msg)) {
                view.showTipNotification(msg);
            }
        } else if (HRStringUtils.isNotEmpty((String)result.getClearText())) {
            logger.info("showOperationResult getClearText");
            view.showTipNotification(result.getClearText());
        } else if (result.getInteractionContext() != null && HRStringUtils.isNotEmpty((String)result.getInteractionContext().getSimpleMessage())) {
            logger.info("showOperationResult getInteractionContext");
            view.showTipNotification(result.getInteractionContext().getSimpleMessage());
        } else {
            String defaultTip = ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u6570\u636e\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HomOnbrdDataBaseEdit_3", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            logger.info(defaultTip);
            view.showTipNotification(defaultTip);
        }
        return false;
    }

    protected OperationResult getInvokeChildOperationResult(String pageNumber, String operation) {
        IFormView childView = this.getEmbedPageView(pageNumber);
        if (childView == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"HomOnbrdDataBaseEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return null;
        }
        return childView.invokeOperation(operation);
    }

    protected void updatePageStatusToView(String pageNumber, String targetKey, Tuple<String, String> dataIds, String btnModify, String btnSave, String btnClose, boolean isAttached) {
        if (isAttached) {
            this.showEmbedPage(pageNumber, targetKey, dataIds, OperationStatus.VIEW);
        } else {
            this.showEmbedBillPage(pageNumber, targetKey, dataIds, OperationStatus.VIEW, "");
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{btnModify});
        this.getView().setVisible(Boolean.FALSE, new String[]{btnSave, btnClose});
    }

    protected void updatePageStatusToEdit(String pageNumber, String targetKey, Tuple<String, String> dataIds, String btnModify, String btnSave, String btnClose, boolean isAttached) {
        if (isAttached) {
            this.showEmbedPage(pageNumber, targetKey, dataIds, OperationStatus.EDIT);
        } else {
            this.showEmbedBillPage(pageNumber, targetKey, dataIds, OperationStatus.EDIT, "");
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{btnModify});
        this.getView().setVisible(Boolean.TRUE, new String[]{btnSave, btnClose});
    }

    protected boolean checkCloseChange(String pageNumber, String panelap, Tuple<String, String> dataIds, String btnmodify, String btnclose, String btnsave, boolean isAttached, String entityName) {
        IFormView view = this.getView();
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        IFormView childView = this.getEmbedPageView(pageNumber);
        if (childView != null && childView.getModel() != null && childView.getModel().getDataChanged()) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractFormDrawEdit_6", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AbstractFormDrawEdit_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f%s\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AbstractFormDrawEdit_9", (String)"hr-hom-formplugin", (Object[])new Object[0]), System.lineSeparator());
            String changeDesc = childView.getModel().getChangeDesc();
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("closeBack", (IFormPlugin)this);
            this.getView().showConfirm(msg, changeDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            pageCache.put("closeFormId", pageNumber);
            pageCache.put("closePanelap", panelap);
            pageCache.put("closeOnbrdId", (String)dataIds.item1);
            pageCache.put("closeCandidateId", (String)dataIds.item2);
            pageCache.put("closeBtnmodify", btnmodify);
            pageCache.put("closeBtnclose", btnclose);
            pageCache.put("closeBtnsave", btnsave);
            pageCache.put("closeIsAttached", String.valueOf(isAttached));
            pageCache.put("closeIsEntity", String.valueOf(entityName));
            return false;
        }
        this.updatePageStatusToView(pageNumber, panelap, dataIds, btnmodify, btnclose, btnsave, isAttached);
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)"closeBack") && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            String formId = pageCache.get("closeFormId");
            String panelap = pageCache.get("closePanelap");
            String dataIds1 = pageCache.get("closeOnbrdId");
            String dataIds2 = pageCache.get("closeCandidateId");
            String btnmodify = pageCache.get("closeBtnmodify");
            String btnclose = pageCache.get("closeBtnclose");
            String btnsave = pageCache.get("closeBtnsave");
            String isAttached = pageCache.get("closeIsAttached");
            String entity = pageCache.get("closeIsEntity");
            this.updatePageStatusToView(formId, panelap, (Tuple<String, String>)Tuple.create((Object)dataIds1, (Object)dataIds2), btnmodify, btnsave, btnclose, Boolean.parseBoolean(isAttached));
            this.release(Long.valueOf(dataIds2), entity, btnmodify, formId, dataIds1);
        }
    }

    private void release(Long candidateId, String entity, String operKey, String formId, String onbrdId) {
        DynamicObject perInfoDyo = null;
        if (candidateId != null && !HRStringUtils.isEmpty((String)entity) && !"hom_checkinfo".equals(formId)) {
            perInfoDyo = IHomToHcfAppService.getInstance().getSingleRowEntity(candidateId, entity);
        }
        if (perInfoDyo != null) {
            Long id = perInfoDyo.getLong("id");
            IHomDataMutexService.getInstance().release(id.toString(), "hom_persononbrdhandlebody", operKey);
        } else {
            IHomDataMutexService.getInstance().release(onbrdId, "hom_persononbrdhandlebody", operKey);
        }
    }

    protected IFormView getEmbedPageView(String pageNumber) {
        IFormView parentView = this.getView();
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String cardPageId = pageCache.get(pageNumber);
        if (cardPageId == null) {
            logger.info("parentView.getPageId():" + parentView.getPageId() + ", cardPageId==null, pageNumber:" + pageNumber);
        }
        IFormView childView = parentView.getView(cardPageId);
        for (int i = 0; i < 6 && childView == null; ++i) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException exception) {
                logger.warn("childView", (Throwable)exception);
            }
            childView = parentView.getView(cardPageId);
        }
        if (childView == null) {
            return null;
        }
        IDataModel model = childView.getModel();
        boolean flag = true;
        int nums = 6;
        while (flag && nums > 0) {
            try {
                --nums;
                model.getDataEntity();
                flag = false;
            }
            catch (Exception exception) {
                logger.warn("model", (Throwable)exception);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException exp) {
                    logger.warn("model wait", (Throwable)exp);
                }
            }
        }
        if (flag) {
            return null;
        }
        return childView;
    }

    protected IFormView getEmbedPageViewOfClose(String pageNumber) {
        IFormView view = null;
        try {
            IFormView parentView = this.getView();
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            String cardPageId = pageCache.get(pageNumber);
            if (cardPageId == null) {
                logger.info("parentView.getPageId():" + parentView.getPageId() + ", cardPageId==null, pageNumber:" + pageNumber);
            }
            view = parentView.getView(cardPageId);
        }
        catch (Exception exception) {
            logger.warn((Throwable)exception);
        }
        return view;
    }

    protected OperationStatus getChildViewStatus(String pageNumber) {
        IFormView childView = this.getEmbedPageView(pageNumber);
        if (childView == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"HomOnbrdDataBaseEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return OperationStatus.VIEW;
        }
        return childView.getFormShowParameter().getStatus();
    }

    protected void setChildViewStatus(String pageNumber) {
        IFormView childView = this.getEmbedPageView(pageNumber);
        if (!HRObjectUtils.isEmpty((Object)childView)) {
            childView.getFormShowParameter().setStatus(OperationStatus.EDIT);
            childView.updateView();
        }
    }
}

