/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.NumberGenerater;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.domain.repository.activity.ActivityRepository;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.common.enums.AuditStatusEnum;
import kd.hr.hom.common.enums.BillStatusEnum;
import kd.hr.hom.common.enums.CollectApproveStatusEnum;
import kd.hr.hom.common.enums.CollectManageStatusEnum;
import kd.hr.hom.common.enums.LoginStatusEnum;
import kd.hr.hom.common.enums.SendModeEnum;
import kd.hr.hom.common.enums.SendStatusEnum;

public class ManuPerformancePlugin
extends HRDynamicFormBasePlugin {
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"ManuPerformancePlugin", (int)5, (int)1000);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonap", "buttonactivity"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        switch (button.getKey()) {
            case "buttonap": {
                this.setHeadInfo();
                break;
            }
            case "buttonactivity": {
                this.setActivity();
                break;
            }
        }
    }

    private void initCollectActivity(List<DynamicObject> collectActivityList, HRBaseServiceHelper collectActivityHelper, DynamicObject onbrdbillDyn) {
        DynamicObject collectActivity = collectActivityHelper.generateEmptyDynamicObject();
        collectActivity.set("onboard", onbrdbillDyn.get("id"));
        collectActivity.set("collectstatus", (Object)CollectManageStatusEnum.SUBMIT.getStatus());
        collectActivity.set("billstatus", (Object)BillStatusEnum.SAVE.getCode());
        collectActivity.set("auditstatus", (Object)AuditStatusEnum.SAVE.getCode());
        collectActivity.set("org", onbrdbillDyn.get("org"));
        collectActivity.set("creator", (Object)RequestContext.get().getCurrUserId());
        collectActivity.set("modifier", (Object)RequestContext.get().getCurrUserId());
        collectActivity.set("sendtext", (Object)"0");
        collectActivity.set("collectstatus", (Object)CollectManageStatusEnum.FINISH.getStatus());
        collectActivity.set("createtime", (Object)new Date());
        collectActivity.set("modifytime", (Object)new Date());
        collectActivity.set("templateresult", (Object)"0");
        collectActivity.set("approvecreator", (Object)RequestContext.get().getCurrUserId());
        collectActivity.set("approvemodifier", (Object)RequestContext.get().getCurrUserId());
        collectActivity.set("approvecreatetime", (Object)new Date());
        collectActivity.set("approvemodifytime", (Object)new Date());
        collectActivity.set("approvestatus", (Object)CollectApproveStatusEnum.REMIT.getStatus());
        collectActivity.set("acceptstatus", (Object)"10");
        collectActivityList.add(collectActivity);
    }

    private void initOnbrdInvite(List<DynamicObject> onbrdInviteList, HRBaseServiceHelper onbrdInviteObjHelper, DynamicObject onbrdbillDyn) {
        DynamicObject onbrdInviteObj = onbrdInviteObjHelper.generateEmptyDynamicObject();
        onbrdInviteObj.set("org", onbrdbillDyn.get("org"));
        onbrdInviteObj.set("onbrd", onbrdbillDyn.get("id"));
        onbrdInviteObj.set("auditstatus", (Object)AuditStatusEnum.SAVE.getCode());
        onbrdInviteObj.set("billstatus", (Object)BillStatusEnum.SAVE.getCode());
        onbrdInviteObj.set("sendmode", (Object)SendModeEnum.MANUAL_SEND.getValue());
        onbrdInviteObj.set("loginstatus", (Object)LoginStatusEnum.NO_LOGIN.getValue());
        onbrdInviteObj.set("sendstatus", (Object)SendStatusEnum.HAS_SEND.getValue());
        onbrdInviteObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        onbrdInviteObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        Date date = new Date();
        onbrdInviteObj.set("createtime", (Object)date);
        onbrdInviteObj.set("modifytime", (Object)date);
        onbrdInviteList.add(onbrdInviteObj);
    }

    private void setHeadInfo() {
        int num = (Integer)this.getModel().getValue("num");
        HRBaseServiceHelper candidateHelper = new HRBaseServiceHelper("hcf_candidate");
        ArrayList<DynamicObject> candidateNewList = new ArrayList<DynamicObject>(num);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hom_onbrdbilltpl");
        ArrayList<DynamicObject> onbrdList = new ArrayList<DynamicObject>(num);
        ArrayList<DynamicObject> onbrdInviteList = new ArrayList<DynamicObject>(num);
        ArrayList<DynamicObject> collectActivityList = new ArrayList<DynamicObject>(num);
        HRBaseServiceHelper onbrdInviteObjHelper = new HRBaseServiceHelper("hom_invitesendbill");
        HRBaseServiceHelper collectActivityHelper = new HRBaseServiceHelper("hom_collect");
        long[] candidateIds = ORM.create().genLongIds("hcf_candidate", num);
        long[] ids = ORM.create().genLongIds("hom_onbrdbilltpl", num);
        Date date = new Date();
        RequestContext requestContext = RequestContext.get();
        for (int i = 0; i < num; ++i) {
            String no = this.setNo(date);
            DynamicObject candidateObject = candidateHelper.generateEmptyDynamicObject();
            candidateObject.set("id", (Object)candidateIds[i]);
            candidateObject.set("creator", (Object)requestContext.getCurrUserId());
            candidateObject.set("createtime", (Object)date);
            candidateObject.set("name", (Object)no);
            candidateObject.set("number", (Object)no);
            candidateNewList.add(candidateObject);
            DynamicObject dynamicObject = hrBaseServiceHelper.generateEmptyDynamicObject();
            dynamicObject.set("id", (Object)ids[i]);
            dynamicObject.set("datasource", (Object)"2");
            dynamicObject.set("preenrollstatus", (Object)"1");
            dynamicObject.set("preeneffectdate", (Object)date);
            dynamicObject.set("preenonbrdtcity", (Object)1351516537395096576L);
            dynamicObject.set("checkinstatus", (Object)"3");
            dynamicObject.set("beforelaborreltype", (Object)0L);
            dynamicObject.set("effectdate", (Object)date);
            dynamicObject.set("onbrdtcity", (Object)1351516537395096576L);
            dynamicObject.set("beforelaborrelstatus", (Object)0L);
            dynamicObject.set("checkintype", (Object)"1");
            dynamicObject.set("nocheckintimes", (Object)0);
            dynamicObject.set("beforepostype", (Object)0L);
            dynamicObject.set("ischeckinexception", (Object)Boolean.FALSE);
            dynamicObject.set("exceptioncause", null);
            dynamicObject.set("checkcity", (Object)407);
            dynamicObject.set("checkhospital", (Object)"asdahd");
            dynamicObject.set("checkdate", (Object)date);
            dynamicObject.set("candidate", (Object)candidateIds[i]);
            dynamicObject.set("enrollstatus", (Object)"3");
            dynamicObject.set("starttime", (Object)date);
            dynamicObject.set("processstatus", (Object)"1");
            dynamicObject.set("creator", (Object)requestContext.getCurrUserId());
            dynamicObject.set("createtime", (Object)date);
            dynamicObject.set("org", requestContext.getOrgId() != 0L ? Long.valueOf(requestContext.getOrgId()) : "100000");
            dynamicObject.set("onbrdtype", (Object)1010L);
            dynamicObject.set("name", (Object)no);
            dynamicObject.set("gender", (Object)1010L);
            dynamicObject.set("phone", (Object)"+86-13420653924");
            dynamicObject.set("peremail", (Object)"chen13420653924@163.com");
            dynamicObject.set("certificatetype", (Object)1020L);
            dynamicObject.set("certificatenumber", (Object)no);
            dynamicObject.set("employeeno", (Object)no);
            dynamicObject.set("aposition", (Object)1338235207777528832L);
            dynamicObject.set("aadminorg", (Object)100000L);
            dynamicObject.set("acompany", (Object)100000L);
            dynamicObject.set("managementscope", (Object)1356392551195619328L);
            dynamicObject.set("enterprise", (Object)1356392551195619328L);
            dynamicObject.set("ajobscmorg", (Object)1356392295536013312L);
            dynamicObject.set("ajobscm", (Object)1335376164776062976L);
            dynamicObject.set("ajob", (Object)1336237587416755200L);
            dynamicObject.set("ajoblevel", (Object)1336796506920856576L);
            dynamicObject.set("ajobgrade", (Object)1336799074992532480L);
            dynamicObject.set("baselocation", (Object)1351516441907571712L);
            dynamicObject.set("probationtime", (Object)6);
            dynamicObject.set("laborreltype", (Object)1010L);
            dynamicObject.set("laborrelstatus", (Object)1010L);
            dynamicObject.set("postype", (Object)1010L);
            dynamicObject.set("posstatus", (Object)1010L);
            dynamicObject.set("hrbu", (Object)0L);
            dynamicObject.set("affiliateadminorg", (Object)100000L);
            dynamicObject.set("empgroup", (Object)1020L);
            dynamicObject.set("dependency", (Object)1000001L);
            dynamicObject.set("dependencytype", (Object)1010L);
            dynamicObject.set("recruittype", (Object)1010L);
            dynamicObject.set("resumeno", (Object)no);
            dynamicObject.set("offernumber", (Object)no);
            onbrdList.add(dynamicObject);
            this.initOnbrdInvite(onbrdInviteList, onbrdInviteObjHelper, dynamicObject);
            this.initCollectActivity(collectActivityList, collectActivityHelper, dynamicObject);
        }
        List billNos = CodeRuleServiceHelper.getNumbers((String)"hom_onbrdbillbase", onbrdList);
        for (int i = 0; i < billNos.size(); ++i) {
            ((DynamicObject)onbrdList.get(i)).set("billno", billNos.get(i));
        }
        threadPool.execute(() -> {
            Iterator candidateIterator = candidateNewList.iterator();
            ArrayList<DynamicObject> candidateParamList = new ArrayList<DynamicObject>(1000);
            while (candidateIterator.hasNext()) {
                DynamicObject next = (DynamicObject)candidateIterator.next();
                candidateParamList.add(next);
                if (candidateParamList.size() < 1000) continue;
                IHcfDataDomainService.getInstance().saveCandidate(candidateParamList.toArray(new DynamicObject[candidateParamList.size()]));
                candidateParamList.clear();
            }
            if (candidateParamList.size() > 0) {
                IHcfDataDomainService.getInstance().saveCandidate(candidateParamList.toArray(new DynamicObject[candidateParamList.size()]));
                candidateParamList.clear();
            }
        }, RequestContext.get());
        threadPool.execute(() -> {
            Iterator onbrdIterator = onbrdList.iterator();
            ArrayList<DynamicObject> onbrdParamList = new ArrayList<DynamicObject>(1000);
            while (onbrdIterator.hasNext()) {
                DynamicObject next = (DynamicObject)onbrdIterator.next();
                onbrdParamList.add(next);
                if (onbrdParamList.size() < 1000) continue;
                hrBaseServiceHelper.save(onbrdParamList.toArray(new DynamicObject[onbrdParamList.size()]));
                onbrdParamList.clear();
            }
            if (onbrdParamList.size() > 0) {
                hrBaseServiceHelper.save(onbrdParamList.toArray(new DynamicObject[onbrdParamList.size()]));
                onbrdParamList.clear();
            }
        }, RequestContext.get());
        threadPool.execute(() -> {
            Iterator onbrdInviteIterator = onbrdInviteList.iterator();
            ArrayList<DynamicObject> onbrdInviteParamList = new ArrayList<DynamicObject>(1000);
            while (onbrdInviteIterator.hasNext()) {
                DynamicObject next = (DynamicObject)onbrdInviteIterator.next();
                onbrdInviteParamList.add(next);
                if (onbrdInviteParamList.size() < 1000) continue;
                onbrdInviteObjHelper.save(onbrdInviteParamList.toArray(new DynamicObject[onbrdInviteParamList.size()]));
                onbrdInviteParamList.clear();
            }
            if (onbrdInviteParamList.size() > 0) {
                onbrdInviteObjHelper.save(onbrdInviteParamList.toArray(new DynamicObject[onbrdInviteParamList.size()]));
                onbrdInviteParamList.clear();
            }
        }, RequestContext.get());
        threadPool.execute(() -> {
            Iterator collectActivityIterator = collectActivityList.iterator();
            ArrayList<DynamicObject> collectActivityParamList = new ArrayList<DynamicObject>(1000);
            while (collectActivityIterator.hasNext()) {
                DynamicObject next = (DynamicObject)collectActivityIterator.next();
                collectActivityParamList.add(next);
                if (collectActivityParamList.size() < 1000) continue;
                collectActivityHelper.save(collectActivityParamList.toArray(new DynamicObject[collectActivityParamList.size()]));
                collectActivityParamList.clear();
            }
            if (collectActivityParamList.size() > 0) {
                collectActivityHelper.save(collectActivityParamList.toArray(new DynamicObject[collectActivityParamList.size()]));
                collectActivityParamList.clear();
            }
        }, RequestContext.get());
    }

    private String setNo(Date date) {
        return NumberGenerater.getInstance().generaterNextNumber(date, "cgx");
    }

    private void setActivity() {
        int num = (Integer)this.getModel().getValue("onbrdnum");
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hom_onbrdbillbase");
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query("id", new QFilter[0], "id desc", num);
        List onbrdBillIds = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        Label billNo = (Label)this.getView().getControl("labelap");
        billNo.setText("start...");
        this.splitListByCount(onbrdBillIds, 10).forEach(x -> this.makeActivity((List<Long>)x));
    }

    private <T> List<List<T>> splitListByCount(List<T> list, int count) {
        ArrayList<List<T>> listAll = new ArrayList<List<T>>();
        int size = list.size();
        if (size > count) {
            int absInt = Math.abs(size / count);
            if (size - absInt * count > 0) {
                listAll.add(list.subList(absInt * count, size));
            }
            for (int index = 1; index < absInt + 1; ++index) {
                listAll.add(list.subList((index - 1) * count, index * count));
            }
        } else {
            listAll.add(list);
        }
        return listAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeActivity(List<Long> onbrdBillIds) {
        try (TXHandle txHandle = TX.required();){
            Label billNo = (Label)this.getView().getControl("labelap");
            billNo.setText("start...");
            try {
                DynamicObject[] onbrdBills = HomCommonRepository.queryDynamicObjectByPks((String)"hom_onbrdinfo", (String)"", (Object[])onbrdBillIds.toArray(new Object[0]));
                List fitIds = Arrays.stream(onbrdBills).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                HashMap<Long, DynamicObjectCollection> actSchemeEntryDysMap = new HashMap<Long, DynamicObjectCollection>(onbrdBills.length);
                HashMap<Long, Long> activitySchemeMap = new HashMap<Long, Long>(onbrdBills.length);
                for (DynamicObject onbrdBill : onbrdBills) {
                    Map activitySchemeFromWorkflow = IHomToHrcsAppService.getInstance().getActivitySchemeFromWorkflow(onbrdBill, "actschemeentry.activity,actschemeentry.paramname,actschemeentry.paramnumber,actschemeentry.paramvalue");
                    boolean success = (Boolean)activitySchemeFromWorkflow.get("success");
                    if (!success) continue;
                    Object data = activitySchemeFromWorkflow.get("data");
                    DynamicObject activitySchemeObj = (DynamicObject)data;
                    DynamicObjectCollection actSchemeEntryDys = activitySchemeObj.getDynamicObjectCollection("actschemeentry");
                    actSchemeEntryDysMap.put(onbrdBill.getLong("id"), actSchemeEntryDys);
                    long activityScheme = activitySchemeObj.getLong("id");
                    activitySchemeMap.put(onbrdBill.getLong("id"), activityScheme);
                    fitIds.add(onbrdBill.getLong("id"));
                }
                this.initActivityInfo(onbrdBillIds, activitySchemeMap, actSchemeEntryDysMap);
            }
            catch (Exception exp) {
                txHandle.markRollback();
            }
            finally {
                billNo.setText("end...");
            }
        }
    }

    public void initActivityInfo(List<Long> onbrdBillIds, Map<Long, Long> activitySchemeMap, Map<Long, DynamicObjectCollection> actSchemeEntryDysMap) {
        HRBaseServiceHelper activityOverviewHelper = new HRBaseServiceHelper("hom_activityoverview");
        RequestContext requestContext = RequestContext.get();
        DynamicObjectCollection activityOverviewObjs = new DynamicObjectCollection();
        for (int i = 0; i < onbrdBillIds.size(); ++i) {
            DynamicObject activityOverviewObj = activityOverviewHelper.generateEmptyDynamicObject();
            activityOverviewObj.set("onbrd", (Object)onbrdBillIds.get(i));
            activityOverviewObj.set("activityscheme", (Object)activitySchemeMap.get(onbrdBillIds.get(i)));
            activityOverviewObj.set("schemestartdate", (Object)new Date());
            activityOverviewObj.set("schemefinishdate", null);
            activityOverviewObj.set("totalactivitnum", (Object)actSchemeEntryDysMap.get(onbrdBillIds.get(i)).size());
            activityOverviewObj.set("waitactivitnum", (Object)0);
            activityOverviewObj.set("finishactivitnum", (Object)0);
            activityOverviewObj.set("earlywarnactivitnum", (Object)0);
            activityOverviewObj.set("createtime", (Object)requestContext.getCurrUserId());
            activityOverviewObj.set("createtime", (Object)new Date());
            activityOverviewObj.set("modifier", (Object)requestContext.getCurrUserId());
            activityOverviewObj.set("modifytime", (Object)new Date());
            DynamicObjectCollection activityEntryDys = activityOverviewHelper.generateEmptyEntryCollection(activityOverviewObj, "entryentity");
            int seq = 0;
            for (DynamicObject actSchemeEntryDy : actSchemeEntryDysMap.get(onbrdBillIds.get(i))) {
                DynamicObjectCollection paramConfigDys = actSchemeEntryDy.getDynamicObjectCollection("paramconfig");
                DynamicObject activityEntryDy = activityEntryDys.addNew();
                activityEntryDy.set("onbrdid", (Object)onbrdBillIds.get(i));
                activityEntryDy.set("seq", (Object)seq);
                activityEntryDy.set("activity", actSchemeEntryDy.get("activity"));
                for (DynamicObject paramConfigDy : paramConfigDys) {
                    if (!"onbrdlink".equals(paramConfigDy.getString("paramnumber"))) continue;
                    activityEntryDy.set("onbrdlink", (Object)paramConfigDy.getString("paramvalue"));
                }
                ++seq;
            }
            activityOverviewObj.set("entryentity", (Object)activityEntryDys);
            activityOverviewObjs.add(i, activityOverviewObj);
        }
        ActivityRepository.update((DynamicObject[])((DynamicObject[])activityOverviewObjs.toArray((Object[])new DynamicObject[activityOverviewObjs.size()])));
    }
}

