/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.checkin;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.impl.onbrd.OnbrdConfirmAppServiceImpl;
import kd.hr.hom.business.application.impl.rule.OnbrdConfirmValidatorService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.page.IShowEmbedPageService;
import kd.hr.hom.business.domain.service.checkin.IOnbrdCheckinDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.CheckinPanelBtnParamsEnum;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.formplugin.common.CheckHelper;
import kd.sdk.hr.hom.business.onbrd.IConfirmOnbrdService;

public class CheckinBodyInfoPlugin
extends HRDataBaseEdit {
    private static final String BARCONFIRMCHECKIN = "barconfirmcheckin";
    private static final String BARCONFIRMEXCEPTION = "barconfirmexception";
    private static final String BARCHECKINOVERDUE = "barcheckinoverdue";
    private static final String BREAKUPAP = "breakupap";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.reloadStatus();
    }

    private void reloadStatus() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        DynamicObject onbrdDyObj = IOnbrdBillDomainService.getInstance().findOnbrdBillById("checkinstatus,enrollstatus,org.number,preenrollstatus,org", (Object)onbrdId);
        String checkinStatus = onbrdDyObj.getString("checkinstatus");
        String enrollStatus = onbrdDyObj.getString("enrollstatus");
        this.getView().setVisible(Boolean.FALSE, new String[]{BARCONFIRMCHECKIN, BARCONFIRMEXCEPTION, BARCHECKINOVERDUE, BREAKUPAP});
        this.getView().setVisible(Boolean.TRUE, new String[]{"btn_checkinmodity"});
        if (OnbrdStatusEnum.BREAK_UP.toString().equals(enrollStatus) || OnbrdStatusEnum.HAS_ONBRD.toString().equals(enrollStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_checkinmodity"});
        } else if (CheckinStatusEnum.HAS_CHECKIN.getValue().equals(checkinStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_checkinmodity"});
        } else if (CheckinStatusEnum.CHECKIN_EXCEPTION.getValue().equals(checkinStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BARCONFIRMEXCEPTION, BARCHECKINOVERDUE});
        } else if (CheckinStatusEnum.CHECKIN_WAIT_CONFIRM.getValue().equals(checkinStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BREAKUPAP, BARCONFIRMCHECKIN});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BARCONFIRMCHECKIN});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_checkinclose", "btn_checkinsave"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        CheckHelper.showPersonHeadView(onbrdId, this.getView());
        this.showCheckinBodyInfo(onbrdId, OperationStatus.VIEW);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object childViewDataObject = closedCallBackEvent.getReturnData();
        if (HRStringUtils.equals((String)actionId, (String)"hom_onbrdconfirmsingle") && childViewDataObject instanceof Map) {
            Map resultMap = (Map)childViewDataObject;
            Boolean isSuccess = (Boolean)resultMap.get("isSuccess");
            if (!isSuccess.booleanValue()) {
                String failReason = resultMap.get("failReason").toString();
                this.getView().showTipNotification(failReason);
            } else {
                this.getView().close();
                if (this.getView().getParentView() != null) {
                    IFormView parentView = this.getView().getParentView();
                    String msg = ResManager.loadKDString((String)"\u786e\u8ba4\u5165\u804c\u6210\u529f\u3002", (String)"OnbrdConfirmPlugin_30", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                    parentView.showSuccessNotification(msg);
                    parentView.invokeOperation("refresh");
                    this.getView().sendFormAction(parentView);
                }
            }
        }
    }

    private boolean checkDate(Long onbrdId, BeforeDoOperationEventArgs args, IFormView childView) {
        DynamicObject onbrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBill("validuntil", new QFilter[]{new QFilter("id", "=", (Object)onbrdId)});
        Date effectDate = childView.getModel().getDataEntity().getDate("effectdate");
        Date validuntil = onbrdBill.getDate("validuntil");
        if (effectDate != null && validuntil != null && HRDateTimeUtils.dayAfter((Date)effectDate, (Date)validuntil)) {
            args.setCancel(true);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u9700\u5728\u5165\u804c\u6709\u6548\u671f\uff08%s\uff09\u5185\u3002", (String)"ReservationOnbrdPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)validuntil, (String)"yyyy-MM-dd")));
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String lblKey = operate.getOperateKey();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        if (!HRStringUtils.equals((String)"donothing_close", (String)lblKey) && !IOnbrdCommonAppService.getInstance().tryRequireLockWithOnbrdCheck(onbrdId, this.getView(), "hom_onbrdcheckinbody")) {
            return;
        }
        this.getPageCache().put("is_lock", "true");
        this.clickOnCheckinInfo(lblKey, onbrdId, args);
        switch (lblKey) {
            case "btn_confirmcheckin": {
                this.beforConfirmCheckin(lblKey, onbrdId);
                break;
            }
            case "btn_confirmhascheckin": {
                this.confirmCheckin(lblKey, onbrdId);
                break;
            }
            case "btn_checkinoverdue": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u540e\uff0c\u5c06\u6e05\u7a7a\u6240\u9009\u5f85\u5165\u804c\u4eba\u5458\u7684\u9884\u7ea6\u4fe1\u606f\uff0c\u5e76\u91cd\u7f6e\u9884\u7ea6\u72b6\u6001\u4e3a\u201c\u5f85\u9884\u7ea6\u201d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CheckinListOperationPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(lblKey, (IFormPlugin)this));
                break;
            }
            case "donothing_close": {
                this.closePage(lblKey);
                break;
            }
        }
    }

    private void beforConfirmCheckin(String lblKey, Long onbrdId) {
        boolean result = true;
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof IListView) {
            ListView listView = (ListView)this.getView().getParentView();
            String entityNum = listView.getBillFormId();
            String appId = listView.getFormShowParameter().getAppId();
            result = IOnbrdCommonAppService.getInstance().checkPermission(entityNum, "24IKGJCCX69+", appId);
        }
        if (result) {
            this.confirmCheckin(lblKey, onbrdId);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5165\u804c\u62a5\u5230\u8be6\u60c5\u9875\u9762\u7684\u201c\u786e\u8ba4\u5165\u804c\u201d\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CheckinBodyInfoPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
    }

    private void confirmCheckin(String lblKey, Long onbrdId) {
        if (new OnbrdConfirmValidatorService().checkCertCountForOnbrdConfirm(this.getView(), 1, lblKey)) {
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IConfirmOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IConfirmOnbrdService", null);
            hrPluginProxy.callReplace(hrPlugin -> {
                hrPlugin.beforeConfirmOnbrds(new Object[]{onbrdId});
                return null;
            });
            this.showOnBrdConfirmPage(onbrdId, "btn_confirmcheckin");
        }
    }

    private void closePage(String lblKey) {
        if (!this.checkDataChange()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u51fa\uff1f", (String)"OnbrdBodyInfoPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(lblKey, (IFormPlugin)this));
        } else {
            this.getView().close();
        }
    }

    protected IFormView getEmbedPageView(String pageNumber) {
        IFormView parentView = this.getView();
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String cardPageId = pageCache.get(pageNumber);
        return parentView.getView(cardPageId);
    }

    private boolean checkDataChange() {
        IFormView childView = this.getEmbedPageView(CheckinPanelBtnParamsEnum.RESERVATION_INFO.getPageIdName());
        IFormView childView1 = this.getEmbedPageView(CheckinPanelBtnParamsEnum.CHECKIN_INFO.getPageIdName());
        return this.childViewChange(childView) && this.childViewChange(childView1);
    }

    private boolean childViewChange(IFormView childView) {
        return childView == null || childView.getModel() == null || !childView.getModel().getDataChanged();
    }

    private void showOnBrdConfirmPage(Long onbrdId, String operateKey) {
        DynamicObject[] onbrdBillInfos = new OnbrdConfirmAppServiceImpl().getOnbrdBillsForShowPage(new Long[]{onbrdId});
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "hom_onbrdconfirmsingle");
        new OnbrdConfirmAppServiceImpl().showOnBrdConfirmPageWithOneData(this.getView(), onbrdBillInfos[0], closeCallBack, operateKey);
    }

    private void clickOnCheckinInfo(String lblKey, Long onbrdId, BeforeDoOperationEventArgs args) {
        switch (lblKey) {
            case "btn_checkinmodity": {
                this.updatePageStatusToEdit(CheckinPanelBtnParamsEnum.CHECKIN_INFO, onbrdId, OperationStatus.EDIT);
                break;
            }
            case "btn_checkinclose": {
                this.checkCloseChange(CheckinPanelBtnParamsEnum.CHECKIN_INFO, onbrdId);
                break;
            }
            case "btn_checkinsave": {
                if (!this.invokeChildOperation(CheckinPanelBtnParamsEnum.CHECKIN_INFO, "save", onbrdId, args)) break;
                this.updatePageStatusToView(CheckinPanelBtnParamsEnum.CHECKIN_INFO, onbrdId, OperationStatus.VIEW);
                this.reloadView();
                break;
            }
        }
    }

    private void updatePageStatusToEdit(CheckinPanelBtnParamsEnum checkinPanelBtnParamsEnum, Long onbrdId, OperationStatus status) {
        this.showEmbedPage(checkinPanelBtnParamsEnum.getPageNumber(), checkinPanelBtnParamsEnum.getTargetKey(), checkinPanelBtnParamsEnum.getPageIdName(), onbrdId, status);
        this.getView().setVisible(Boolean.FALSE, new String[]{checkinPanelBtnParamsEnum.getBtnModify()});
        this.getView().setVisible(Boolean.TRUE, new String[]{checkinPanelBtnParamsEnum.getBtnClose(), checkinPanelBtnParamsEnum.getBtnSave()});
    }

    private boolean invokeChildOperation(CheckinPanelBtnParamsEnum checkinPanelBtnParamsEnum, String operation, Long onbrdId, BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        String pageIdName = checkinPanelBtnParamsEnum.getPageIdName();
        String pageIdNameCache = this.getPageCache().get(pageIdName);
        IFormView childView = view.getView(pageIdNameCache);
        if (HRStringUtils.equals((String)operation, (String)"save") && !this.checkDate(onbrdId, args, childView)) {
            return false;
        }
        OperationResult result = childView.invokeOperation(operation);
        if (result.isSuccess()) {
            return true;
        }
        if (result.getAllErrorOrValidateInfo().size() > 0) {
            view.showOperationResult(result);
        } else if (HRStringUtils.isNotEmpty((String)result.getMessage())) {
            view.showErrorNotification(result.getMessage());
        }
        return false;
    }

    private void checkCloseChange(CheckinPanelBtnParamsEnum checkinPanelBtnParamsEnum, Long onbrdId) {
        String pageId = this.getPageCache().get(checkinPanelBtnParamsEnum.getPageIdName());
        IFormView childView = this.getView().getView(pageId);
        this.getPageCache().put("pageNumber", checkinPanelBtnParamsEnum.getPageNumber());
        this.getPageCache().put("onbrdid", onbrdId.toString());
        if (childView != null && childView.getModel() != null && childView.getModel().getDataChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(checkinPanelBtnParamsEnum.getPageNumber(), (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f%s\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"CheckinBodyInfoPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), System.lineSeparator()), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            return;
        }
        this.updatePageStatusToView(checkinPanelBtnParamsEnum, onbrdId, OperationStatus.VIEW);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("onbrdid"));
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            switch (actionId) {
                case "btn_checkinoverdue": {
                    QFilter idLongsFilter = new QFilter("id", "in", (Object)onbrdId);
                    IOnbrdCheckinDomainService.getInstance().overdueCheckin(idLongsFilter);
                    this.getView().close();
                    if (this.getView().getParentView() == null) break;
                    IFormView parentView = this.getView().getParentView();
                    parentView.showSuccessNotification(ResManager.loadKDString((String)"\u201c\u786e\u8ba4\u672a\u62a5\u5230\u201d\u64cd\u4f5c\u6210\u529f\uff0c\u9884\u7ea6\u72b6\u6001\u5df2\u91cd\u7f6e\u4e3a\u201c\u5f85\u9884\u7ea6\u201d\u3002", (String)"CheckinListOperationPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    this.getView().sendFormAction(parentView);
                    break;
                }
                case "donothing_close": {
                    this.getView().close();
                    this.reloadView();
                    break;
                }
            }
            String pageNumber = this.getPageCache().get("pageNumber");
            if (StringUtils.isBlank((CharSequence)pageNumber)) {
                return;
            }
            if (HRStringUtils.equals((String)actionId, (String)pageNumber)) {
                CheckinPanelBtnParamsEnum checkinPanelBtnParamsEnum = CheckinPanelBtnParamsEnum.getEnumByName((String)pageNumber);
                this.updatePageStatusToView(checkinPanelBtnParamsEnum, onbrdId, OperationStatus.VIEW);
            }
        }
    }

    private void reloadView() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
        this.getView().updateView();
        this.reloadStatus();
    }

    private void updatePageStatusToView(CheckinPanelBtnParamsEnum checkinPanelBtnParamsEnum, Long onbrdId, OperationStatus status) {
        this.showEmbedPage(checkinPanelBtnParamsEnum.getPageNumber(), checkinPanelBtnParamsEnum.getTargetKey(), null, onbrdId, status);
        this.getView().setVisible(Boolean.TRUE, new String[]{checkinPanelBtnParamsEnum.getBtnModify()});
        this.getView().setVisible(Boolean.FALSE, new String[]{checkinPanelBtnParamsEnum.getBtnClose(), checkinPanelBtnParamsEnum.getBtnSave()});
    }

    private void showCheckinBodyInfo(Long onbrdId, OperationStatus status) {
        this.showEmbedPage("hom_reservationinfo", "reservationinfopanel", null, onbrdId, status);
        this.showEmbedPage("hom_checkininfo", "checkininfopanel", null, onbrdId, status);
    }

    private void showEmbedPage(String pageNumber, String targetKey, String pageIdName, Long onbrdId, OperationStatus status) {
        IShowEmbedPageService.getInstance().showEmbedPage(pageNumber, targetKey, pageIdName, onbrdId, status, this.getView());
    }

    public void pageRelease(EventObject event) {
        String isLock = this.getPageCache().get("is_lock");
        if (HRStringUtils.equals((String)"true", (String)isLock)) {
            Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
            IOnbrdCommonAppService.getInstance().releaseLockWithOnbrdCheck(onbrdId, "hom_onbrdcheckinbody");
        }
    }
}

