/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.checkin;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.common.IPreOpenFormCheckService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;

public class ReservationInfoPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(ReservationInfoPlugin.class);
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"ReservationInfoPlugin", (int)5, (int)1000);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        IPreOpenFormCheckService.getInstance().isHandlerCheck(e);
    }

    public void afterCreateNewData(EventObject eventObject) {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        DynamicObject reservationObj = IOnbrdBillDomainService.getInstance().findOnbrdBillById("preenrollstatus,preeneffectdate,preenonbrdtcity,effectdate,onbrdtcity,checkintype,nocheckintimes,ischeckinexception,exceptioncause,checkinstatus,preenonbrdtcity.id,enrollstatus", (Object)onbrdId);
        this.getModel().setValue("preeneffectdate", reservationObj.get("preeneffectdate"));
        this.getModel().setValue("preenonbrdtcity", reservationObj.get("preenonbrdtcity"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            this.checkDate(onbrdId, args);
        }
        String properties = "id,effectdate,aadminorg,aposition,stdposition,apositiontype,ajob,viewtype,personfield,personindexid";
        DynamicObject onbrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBill(properties, new QFilter[]{new QFilter("id", "=", (Object)onbrdId)});
        Date preenEffectDateNew = HRDateTimeUtils.truncateDate((Date)this.getModel().getDataEntity().getDate("preeneffectdate"));
        onbrdBill.set("effectdate", (Object)preenEffectDateNew);
        String validateResult = IOnbrdCommonAppService.getInstance().validateEffectDateWithOrgField(onbrdBill);
        if (HRStringUtils.isNotEmpty((String)validateResult)) {
            args.setCancel(true);
            args.setCancelMessage(validateResult);
            return;
        }
        Map validEntryDateOfQuitDateMap = IValidEntryDateService.getInstance().validEntryDateOfQuitDate(new DynamicObject[]{onbrdBill}, false);
        Optional message = validEntryDateOfQuitDateMap.getOrDefault(onbrdBill.getLong("personfield.id"), Optional.empty());
        if (message.isPresent()) {
            args.setCancel(true);
            args.setCancelMessage((String)message.get());
        }
    }

    private boolean checkDate(Long onbrdId, BeforeDoOperationEventArgs args) {
        DynamicObject onbrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBill("validuntil", new QFilter[]{new QFilter("id", "=", (Object)onbrdId)});
        Date effectDate = this.getModel().getDataEntity().getDate("preeneffectdate");
        Date validuntil = onbrdBill.getDate("validuntil");
        if (effectDate != null && validuntil != null && HRDateTimeUtils.dayAfter((Date)effectDate, (Date)validuntil)) {
            args.setCancel(true);
            args.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u9700\u5728\u5165\u804c\u6709\u6548\u671f\uff08%s\uff09\u5185\u3002", (String)"ReservationOnbrdPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)validuntil, (String)"yyyy-MM-dd")));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        block23: {
            Throwable throwable;
            TXHandle txHandle;
            Date effectDateOld;
            Date preenEffectDateOld;
            Date preenEffectDateNew;
            String preStatus;
            DynamicObject reservationObj;
            IOnbrdBillDomainService onbrdBillDomainService;
            Long onbrdId;
            AtomicBoolean atomicBoolean;
            block20: {
                block21: {
                    block22: {
                        long preenOnbrdtCityId;
                        super.afterDoOperation(afterDoOperationEventArgs);
                        if (!afterDoOperationEventArgs.getOperationResult().isSuccess() || !"save".equals(afterDoOperationEventArgs.getOperateKey())) break block23;
                        atomicBoolean = new AtomicBoolean(false);
                        onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
                        onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
                        reservationObj = onbrdBillDomainService.findOnbrdBillById("preenrollstatus,preeneffectdate,preenonbrdtcity,effectdate,onbrdtcity,checkintype,nocheckintimes,ischeckinexception,exceptioncause,checkinstatus,preenonbrdtcity.id,enrollstatus", (Object)onbrdId);
                        preStatus = reservationObj.getString("preenrollstatus");
                        preenEffectDateNew = HRDateTimeUtils.truncateDate((Date)((Date)this.getModel().getValue("preeneffectdate")));
                        preenEffectDateOld = reservationObj.getDate("preeneffectdate");
                        effectDateOld = reservationObj.getDate("effectdate");
                        txHandle = TX.required();
                        throwable = null;
                        DynamicObject preenOnbrdtCityObj = (DynamicObject)this.getModel().getValue("preenonbrdtcity");
                        long l = preenOnbrdtCityId = preenOnbrdtCityObj == null ? 0L : preenOnbrdtCityObj.getLong("id");
                        if (preenEffectDateNew != reservationObj.getDate("preeneffectdate")) {
                            reservationObj.set("effectdate", (Object)preenEffectDateNew);
                        }
                        if (preenOnbrdtCityId != reservationObj.getLong("preenonbrdtcity.id")) {
                            reservationObj.set("onbrdtcity", (Object)preenOnbrdtCityObj);
                        }
                        reservationObj.set("preeneffectdate", (Object)preenEffectDateNew);
                        reservationObj.set("preenonbrdtcity", (Object)preenOnbrdtCityObj);
                        if (!PreEnrollStatusEnum.WAIT_CONFIRM_RESERVATION.getValue().equals(reservationObj.getString("preenrollstatus"))) break block20;
                        onbrdBillDomainService.saveOnbrdBillInfo(reservationObj);
                        if (txHandle == null) break block21;
                        if (throwable == null) break block22;
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block21;
                    }
                    txHandle.close();
                }
                return;
            }
            try {
                try {
                    reservationObj.set("preenrollstatus", (Object)PreEnrollStatusEnum.HAS_RESERVATION.getValue());
                    onbrdBillDomainService.setWaitCheckin(new DynamicObject[]{reservationObj});
                    onbrdBillDomainService.saveOnbrdBillInfo(reservationObj);
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5165\u804c\u9884\u7ea6\u6210\u529f", (String)"ReservationOnbrdPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    atomicBoolean.set(true);
                }
                catch (Exception exception) {
                    this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7ea6\u5165\u804c\u5931\u8d25", (String)"ReservationOnbrdPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    txHandle.markRollback();
                    LOGGER.error((Throwable)exception);
                }
                if (atomicBoolean.get()) {
                    threadPool.execute(() -> {
                        if (PreEnrollStatusEnum.WAIT_RESERVATION.getValue().equals(preStatus)) {
                            IActivityDomainService.getInstance().batchConsentTask((List)ImmutableList.of((Object)reservationObj.getLong("id")), ActivityNumberEnum.APPOINTMENT);
                        }
                    }, RequestContext.get());
                    threadPool.execute(() -> ((ICollectService)ServiceFactory.getService(ICollectService.class)).sendNoticeCandidate(onbrdId, preenEffectDateNew, effectDateOld), RequestContext.get());
                    threadPool.execute(() -> {
                        LOGGER.info("HOMSCE_APPOINTMEN_NOTICE_MESSAGE start onbrdId is [{}]", (Object)onbrdId);
                        if (preenEffectDateNew != null && (preenEffectDateOld == null || preenEffectDateNew.compareTo(preenEffectDateOld) != 0)) {
                            LOGGER.info("HOMSCE_APPOINTMEN_NOTICE_MESSAGE start send onbrdId is [{}]", (Object)onbrdId);
                            ((ISendMessageService)ServiceFactory.getService(ISendMessageService.class)).sendMessage((Collection)ImmutableList.of((Object)reservationObj.getLong("id")), RuleEngineSceneNumberEnum.NOTICE_APPOINTMENT);
                            LOGGER.info("HOMSCE_APPOINTMEN_NOTICE_MESSAGE end send onbrdId is [{}]", (Object)onbrdId);
                        }
                    }, RequestContext.get());
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (txHandle != null) {
                    if (throwable != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        txHandle.close();
                    }
                }
            }
        }
    }
}

