/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.checkin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.common.util.ComboPropValueUtils;

public class ReservationOnbrdPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(ReservationOnbrdPlugin.class);
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"ReservationOnbrdPlugin", (int)5, (int)1000);
    private static final String ORDER_ONBRD_CLOSECALLBACK = "orderonbrdclosecallback";
    private static final String FEEDBACK = "feedback";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("id");
        if (IOnbrdBillDomainService.getInstance().isEnrolled(ids.toArray(new Object[0]))) {
            args.setCancel(true);
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ec8\u6b62\u5165\u804c\u6216\u5df2\u5165\u804c\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ReservationOnbrdPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult().isSuccess() && "save".equals(afterDoOperationEventArgs.getOperateKey())) {
            IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
            if (!onbrdCommonAppService.checkPermissionAndShowTips("hom_waitresercheckin", "24IKFK+/OFV/", this.getView())) {
                return;
            }
            String properties = "id,effectdate,aadminorg,aposition,stdposition,ajob,validuntil,preeneffectdate,name,candidatenumber,employeeno,enrollstatus,sendstatus,apositiontype,loginstatus,viewtype,personfield,personindexid";
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            DynamicObject[] onboardBills = IOnbrdBillDomainService.getInstance().findOnbrdBills(properties, new QFilter[]{new QFilter("id", "in", formShowParameter.getCustomParam("onboardBillsid"))});
            if (onboardBills.length > 1) {
                this.openSecondConfirm(onboardBills);
            } else {
                Date effectDate = onboardBills[0].getDate("validuntil");
                Date orderOnboardDate = this.getModel().getDataEntity().getDate("preeneffectdate");
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                if (HRDateTimeUtils.dayBefore((Date)effectDate, (Date)orderOnboardDate)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u9700\u5728\u5165\u804c\u6709\u6548\u671f\uff08%s\uff09\u5185\u3002", (String)"ReservationOnbrdPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), format.format(effectDate)));
                    return;
                }
                onboardBills[0].set("effectdate", (Object)orderOnboardDate);
                String validateResult = IOnbrdCommonAppService.getInstance().validateEffectDateWithOrgField(onboardBills[0]);
                if (HRStringUtils.isNotEmpty((String)validateResult)) {
                    this.getView().showTipNotification(validateResult);
                    return;
                }
                Map validEntryDateOfQuitDateMap = IValidEntryDateService.getInstance().validEntryDateOfQuitDate(new DynamicObject[]{onboardBills[0]}, false);
                Optional message = validEntryDateOfQuitDateMap.getOrDefault(onboardBills[0].getLong("personfield.id"), Optional.empty());
                if (message.isPresent()) {
                    this.getView().showTipNotification((String)message.get());
                    return;
                }
                this.saveDate(null);
            }
        }
    }

    private void saveDate(DynamicObject[] reservationObjs) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("id");
        QFilter idLongsFilter = new QFilter("id", "in", (Object)ids);
        IOnbrdBillDomainService onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
        if (reservationObjs == null) {
            reservationObjs = onbrdBillDomainService.findOnbrdBills("preenrollstatus,preeneffectdate,preenonbrdtcity,effectdate,onbrdtcity,checkintype,nocheckintimes,ischeckinexception,exceptioncause,checkinstatus,preenonbrdtcity.id,enrollstatus", new QFilter[]{idLongsFilter});
        }
        DynamicObject[] reservationDys = reservationObjs;
        HashMap<Long, Date> effectDateOldMap = new HashMap<Long, Date>(16);
        try (TXHandle txHandle = TX.required();){
            try {
                for (DynamicObject reservationObj : reservationDys) {
                    effectDateOldMap.put(reservationObj.getLong("id"), reservationObj.getDate("effectdate"));
                    Date preenEffectDate = HRDateTimeUtils.truncateDate((Date)((Date)this.getModel().getValue("preeneffectdate")));
                    reservationObj.set("preeneffectdate", (Object)preenEffectDate);
                    reservationObj.set("preenonbrdtcity", this.getModel().getValue("preenonbrdtcity"));
                    reservationObj.set("effectdate", (Object)preenEffectDate);
                    reservationObj.set("onbrdtcity", this.getModel().getValue("preenonbrdtcity"));
                    reservationObj.set("preenrollstatus", (Object)PreEnrollStatusEnum.HAS_RESERVATION.getValue());
                }
                onbrdBillDomainService.setWaitCheckin(reservationObjs);
                onbrdBillDomainService.saveOnbrdBillInfos(reservationObjs);
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5165\u804c\u9884\u7ea6\u6210\u529f", (String)"ReservationOnbrdPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                this.getModel().setDataChanged(false);
                this.getView().close();
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
                atomicBoolean.set(true);
            }
            catch (Exception exception) {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7ea6\u5165\u804c\u5931\u8d25", (String)"ReservationOnbrdPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                txHandle.markRollback();
                atomicBoolean.set(false);
                LOGGER.error((Throwable)exception);
            }
        }
        if (atomicBoolean.get()) {
            threadPool.execute(() -> IActivityDomainService.getInstance().batchConsentTask(ids, ActivityNumberEnum.APPOINTMENT), RequestContext.get());
            threadPool.execute(() -> {
                for (DynamicObject reservationObj : reservationDys) {
                    long onbrdId = reservationObj.getLong("id");
                    Date effectDateOld = (Date)effectDateOldMap.get(onbrdId);
                    Date effectDateNew = reservationObj.getDate("effectdate");
                    ((ICollectService)ServiceFactory.getService(ICollectService.class)).sendNoticeCandidate(Long.valueOf(onbrdId), effectDateNew, effectDateOld);
                }
            }, RequestContext.get());
            threadPool.execute(() -> ((ISendMessageService)ServiceFactory.getService(ISendMessageService.class)).sendMessage((Collection)ids, RuleEngineSceneNumberEnum.NOTICE_APPOINTMENT), RequestContext.get());
        }
    }

    private List<HRExportHeadObject> getHeadDataListWithConfirmCount() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>(8);
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"OnbrdInviteOperateListPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("candidatenumber", ResManager.loadKDString((String)"\u5019\u9009\u4eba\u7f16\u53f7", (String)"OnbrdInviteOperateListPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("employeeno", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"OnbrdInviteOperateListPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("effectdate", ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f", (String)"OnbrdInviteOperateListPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("enrollstatus", ResManager.loadKDString((String)"\u5165\u804c\u72b6\u6001", (String)"OnbrdInviteOperateListPlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("validuntil", ResManager.loadKDString((String)"\u5165\u804c\u6709\u6548\u671f\u81f3", (String)"ReservationOnbrdPlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject(FEEDBACK, ResManager.loadKDString((String)"\u65e0\u6cd5\u9884\u7ea6\u539f\u56e0", (String)"ReservationOnbrdPlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        return headDataList;
    }

    private void openSecondConfirm(DynamicObject[] onboardBills) {
        Date preOnboardDate = this.getModel().getDataEntity().getDate("preeneffectdate");
        for (DynamicObject onbrdBill : onboardBills) {
            onbrdBill.set("effectdate", (Object)preOnboardDate);
        }
        Map validateResultMap = IOnbrdCommonAppService.getInstance().validateEffectDateWithOrgField(onboardBills);
        List<DynamicObject> fitBills = Arrays.stream(onboardBills).filter(bill -> bill.getDate("validuntil") != null && HRDateTimeUtils.dayBefore((Date)preOnboardDate, (Date)bill.getDate("validuntil")) && HRStringUtils.isEmpty((String)((String)validateResultMap.get(bill.getLong("id")))) || HRDateTimeUtils.dayEquals((Date)preOnboardDate, (Date)bill.getDate("validuntil"))).collect(Collectors.toList());
        Map validEntryDateOfQuitDateMap = IValidEntryDateService.getInstance().validEntryDateOfQuitDate(fitBills.toArray(new DynamicObject[0]), false);
        fitBills = fitBills.stream().filter(data -> {
            Optional message = validEntryDateOfQuitDateMap.getOrDefault(data.getLong("personfield.id"), Optional.empty());
            return !message.isPresent();
        }).collect(Collectors.toList());
        FormShowParameter confirmShowParameter = new FormShowParameter();
        confirmShowParameter.setFormId("hom_orderonbrdmodal");
        confirmShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        confirmShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ORDER_ONBRD_CLOSECALLBACK));
        confirmShowParameter.setCustomParam("allperson", (Object)onboardBills.length);
        confirmShowParameter.setCustomParam("fitperson", (Object)fitBills.size());
        confirmShowParameter.setCustomParam("nofitperson", (Object)(onboardBills.length - fitBills.size()));
        List<HRExportHeadObject> headDataList = this.getHeadDataListWithConfirmCount();
        confirmShowParameter.setCustomParam("headdatalist", headDataList);
        List<Map<String, Object>> exportDataList = this.getExportDataListWithConfirmCount(onboardBills);
        confirmShowParameter.setCustomParam("exportdatalist", exportDataList);
        confirmShowParameter.setCustomParam("excelname", (Object)ResManager.loadKDString((String)"\u9884\u7ea6\u5165\u804c\u786e\u8ba4", (String)"ReservationOnbrdPlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        this.getView().showForm(confirmShowParameter);
    }

    private List<Map<String, Object>> getExportDataListWithConfirmCount(DynamicObject[] dynamicObjects) {
        ArrayList<Map<String, Object>> exportdatalist = new ArrayList<Map<String, Object>>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            StringBuilder feedback = new StringBuilder();
            this.getExportDataListWithConfirmCountInfo(exportdatalist, dynamicObject, feedback);
        }
        return exportdatalist;
    }

    private void getExportDataListWithConfirmCountInfo(List<Map<String, Object>> exportdatalist, DynamicObject onbrdObj, StringBuilder feedback) {
        Date orderOnboardDate;
        Date effectDate;
        String enrollStatus = onbrdObj.getString("enrollstatus");
        if (HRStringUtils.equals((String)OnbrdStatusEnum.HAS_ONBRD.toString(), (String)enrollStatus) || HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.toString(), (String)enrollStatus)) {
            feedback.append(ResManager.loadKDString((String)"\u5165\u804c\u6d41\u7a0b\u5df2\u5b8c\u6210\u3002", (String)"OnbrdInviteOperateListPlugin_9", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        if (HRDateTimeUtils.dayBefore((Date)(effectDate = onbrdObj.getDate("validuntil")), (Date)(orderOnboardDate = this.getModel().getDataEntity().getDate("preeneffectdate")))) {
            feedback.append(String.format(ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f\u9700\u5728\u5165\u804c\u6709\u6548\u671f\uff08%s\uff09\u5185\u3002", (String)"ReservationOnbrdPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)effectDate, (String)"yyyy-MM-dd")));
        }
        Map<String, Object> personInfoMap = this.getExportDataListData(onbrdObj, feedback.toString());
        exportdatalist.add(personInfoMap);
    }

    private Map<String, Object> getExportDataListData(DynamicObject onbrdInfoObj, String feedback) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("name", onbrdInfoObj.getString("name"));
        resultMap.put("candidatenumber", onbrdInfoObj.getString("candidatenumber"));
        resultMap.put("employeeno", onbrdInfoObj.getString("employeeno"));
        Date effectDate = onbrdInfoObj.getDate("effectdate");
        if (Objects.nonNull(effectDate)) {
            resultMap.put("effectdate", HRDateTimeUtils.format((Date)effectDate, (String)"yyyy/MM/dd"));
        }
        Map enrollStatusComboPropValueMap = ComboPropValueUtils.comboPropValue((String)"hom_onbrdbilltpl", (String)"enrollstatus");
        resultMap.put("enrollstatus", enrollStatusComboPropValueMap.get(onbrdInfoObj.getString("enrollstatus")));
        resultMap.put("validuntil", HRDateTimeUtils.format((Date)onbrdInfoObj.getDate("validuntil"), (String)"yyyy/MM/dd"));
        resultMap.put(FEEDBACK, feedback);
        return resultMap;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)ORDER_ONBRD_CLOSECALLBACK)) {
            HashMap map = (HashMap)closedCallBackEvent.getReturnData();
            if (map == null) {
                return;
            }
            String result = (String)map.get("result");
            if (HRStringUtils.equals((String)result, (String)"ok")) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                DynamicObject[] onboardBills = IOnbrdBillDomainService.getInstance().findOnbrdBills("validuntil,effectdate,preenrollstatus,onbrdtcity,preenonbrdtcity,preeneffectdate,viewtype,personfield,personindexid", new QFilter[]{new QFilter("id", "in", formShowParameter.getCustomParam("onboardBillsid"))});
                Date preOnboardDate = this.getModel().getDataEntity().getDate("preeneffectdate");
                List<DynamicObject> fitBills = Arrays.stream(onboardBills).filter(bill -> bill.getDate("validuntil") != null && HRDateTimeUtils.dayBefore((Date)preOnboardDate, (Date)bill.getDate("validuntil")) || HRDateTimeUtils.dayEquals((Date)preOnboardDate, (Date)bill.getDate("validuntil"))).collect(Collectors.toList());
                Map validEntryDateOfQuitDateMap = IValidEntryDateService.getInstance().validEntryDateOfQuitDate(fitBills.toArray(new DynamicObject[0]), false);
                fitBills = fitBills.stream().filter(data -> {
                    Optional message = validEntryDateOfQuitDateMap.getOrDefault(data.getLong("personfield.id"), Optional.empty());
                    return !message.isPresent();
                }).collect(Collectors.toList());
                this.saveDate((DynamicObject[])fitBills.stream().toArray(DynamicObject[]::new));
            }
        }
    }
}

