/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.collectconfig;

import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.repository.common.HomConfigRepository;
import kd.hr.hom.business.domain.repository.config.CollectConfigRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.common.constant.InfoGroupFieldConstants;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.CollectDynFormTypeEnum;
import kd.hr.hom.common.enums.InfoGroupCertTypeEnum;
import kd.hr.hom.common.enums.InfoGroupEnum;
import kd.hr.hom.common.enums.InfoGroupFieldTypeEnum;

public class InfoCollectConfigPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener,
CellClickListener,
IConfirmCallBack {
    private static final String LABELAP = "labelap";
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("hom_infocollectconfig");
    private static final HRBaseServiceHelper ORGHELPER = new HRBaseServiceHelper("bos_org");
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String CREATEORG = "createorg";
    ImmutableMap<String, String> PAGE_ENTITY_MAP = ImmutableMap.builder().put((Object)"tabpagetext", (Object)"textentity").put((Object)"tabpageimg", (Object)"imgentity").put((Object)"tabpageattach", (Object)"attachentity").build();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"cardentryrowap", "infogroupop", "infogroupfieldop", "tbmain", "infoconfigop", "infogroupadd", "infogroupedit"});
        this.addClickListeners(new String[]{"cardentryrowap", "infogroupop", "infogroupfieldop", "tbmain", "infoconfigop", "infogroupadd", "infogroupedit", "infogroupup", "infogroupdown"});
        BasedataEdit infoGroup = (BasedataEdit)this.getView().getControl("infogroupbd");
        BasedataEdit infoGroupField = (BasedataEdit)this.getView().getControl("infogroupfield");
        infoGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        infoGroup.addAfterF7SelectListener((AfterF7SelectListener)this);
        infoGroupField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        infoGroupField.addAfterF7SelectListener((AfterF7SelectListener)this);
        CardEntry card = (CardEntry)this.getView().getControl("infogroupentity");
        card.addCellClickListener((CellClickListener)this);
        CardEntry certentity = (CardEntry)this.getView().getControl("certentity");
        certentity.addCellClickListener((CellClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (OperationStatus.ADDNEW.equals((Object)e.getFormShowParameter().getStatus())) {
            e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u91c7\u96c6\u4fe1\u606f\u6a21\u677f", (String)"InfoCollectConfig_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection) || dynamicObjectCollection.size() == 1 && HRObjectUtils.isEmpty((Object)((DynamicObject)dynamicObjectCollection.get(0)).get("infogroup"))) {
                this.getModel().deleteEntryRow("infogroupentity", 0);
                this.replayDefault();
            }
            this.getModel().setValue("enable", (Object)"10");
        }
        this.initCertMulBd();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.createCertEntity();
        this.syncEntityFieldToTab();
        this.initCertificateInfo();
        this.getModel().setDataChanged(false);
    }

    private void initCertMulBd() {
        this.getModel().clearNoDataRow();
        DynamicObjectCollection certentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("certentity");
        MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)this.getModel().getDataEntity(true).get("certmulbd");
        certentity.stream().filter(dynamicObject -> dynamicObject.getBoolean("ischeck")).forEach(dynamicObject -> {
            DynamicObject dy = mulBasedataDynamicObjectCollection.addNew();
            dy.set("fbasedataid", dynamicObject.get("certtype"));
            dy.set("fbasedataid_id", (Object)dynamicObject.getLong("certtype_id"));
        });
        this.getModel().getDataEntity(true).set("certmulbd", (Object)mulBasedataDynamicObjectCollection);
    }

    private void syncMulBdToEntity() {
        this.getModel().deleteEntryData("certentity");
        DynamicObjectCollection certentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("certentity");
        MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)this.getModel().getDataEntity(true).get("certmulbd");
        mulBasedataDynamicObjectCollection.forEach(dynamicObject -> {
            DynamicObject dy = certentity.addNew();
            dy.set("certtype", dynamicObject.get("fbasedataid"));
            dy.set("ischeck", (Object)Boolean.TRUE);
        });
    }

    private void initCertificateInfo() {
        DynamicObjectCollection infogroupbd = this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity");
        String infoGroupNumber = "";
        if (!CollectionUtils.isEmpty((Collection)infogroupbd)) {
            infoGroupNumber = ((DynamicObject)infogroupbd.get(0)).getString("infogroup.number");
        }
        this.clickCertificateInfo(infoGroupNumber);
    }

    private void createCertEntity() {
        DynamicObjectCollection certEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("certentity");
        if (!CollectionUtils.isEmpty((Collection)certEntity) && HRObjectUtils.isEmpty((Object)((DynamicObject)certEntity.get(0)).getDynamicObject("certtype"))) {
            this.getModel().deleteEntryRow("certentity", 0);
        }
        List certTypeOrigIds = certEntity.stream().filter(dynamicObject -> !HRObjectUtils.isEmpty((Object)dynamicObject.getDynamicObject("certtype"))).map(dynamicObject -> dynamicObject.getLong("certtype.id")).collect(Collectors.toList());
        List certTypeIdList = Arrays.stream(InfoGroupCertTypeEnum.values()).map(InfoGroupCertTypeEnum::getId).collect(Collectors.toList());
        Object[] ids = CollectConfigRepository.queryCredentialsType((String)"id,name", (QFilter[])new QFilter[]{new QFilter("isidentity", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)"1"), new QFilter("id", "in", certTypeIdList), new QFilter("id", "not in", certTypeOrigIds)});
        if (HRArrayUtils.isEmpty((Object[])ids)) {
            return;
        }
        int[] certentities = this.getModel().batchCreateNewEntryRow("certentity", ids.length);
        IntStream.range(0, certentities.length).forEach(arg_0 -> this.lambda$createCertEntity$5((DynamicObject[])ids, certentities, arg_0));
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        if (cellClickEvent.getSource() instanceof CardEntry) {
            EntryGrid entryGrid;
            int[] selectRows;
            CardEntry cardEntry = (CardEntry)cellClickEvent.getSource();
            String key = cardEntry.getKey();
            if ("certentity".equals(key)) {
                int row = cellClickEvent.getRow();
                boolean ischeck = (Boolean)this.getModel().getValue("ischeck", row);
                this.getModel().setValue("ischeck", (Object)(!ischeck ? 1 : 0), row);
            } else if ("infogroupentity".equals(key) && (selectRows = (entryGrid = (EntryGrid)this.getControl("infogroupentity")).getSelectRows()).length > 0) {
                this.getPageCache().put("infogroupindex", String.valueOf(selectRows[0]));
                this.reCountNum();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean result;
        Donothing donothing;
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing && "donothing_save".equals(operateKey = (donothing = (Donothing)source).getOperateKey()) && !(result = this.checkBankInfoGroup())) {
            String msg = ResManager.loadKDString((String)"\u94f6\u884c\u5361\u4fe1\u606f\u7ec4\u4e2d\uff0c\u8d26\u6237\u540d\u3001\u94f6\u884c\u8d26\u53f7\u3001\u5f00\u6237\u94f6\u884c\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e\u3002", (String)"InfoCollectConfigPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            args.setCancel(true);
        }
    }

    private boolean checkBankInfoGroup() {
        DynamicObjectCollection infogroup = this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity");
        Optional<DynamicObject> first = infogroup.stream().filter(dynamicObject -> InfoGroupEnum.BANK_INFO.getNumber().equals(dynamicObject.get("infogroup.number"))).findFirst();
        if (!first.isPresent()) {
            return true;
        }
        DynamicObject dynamicObject2 = first.get();
        List fieldList = dynamicObject2.getDynamicObjectCollection("infofieldentity").stream().map(field -> field.getLong("field.id")).collect(Collectors.toList());
        if (!fieldList.containsAll(InfoGroupFieldConstants.BANK_MUST_FIELD)) {
            return false;
        }
        return dynamicObject2.getDynamicObjectCollection("infofieldentity").stream().filter(field -> InfoGroupFieldConstants.BANK_MUST_FIELD.contains(field.getLong("field.id"))).allMatch(field -> field.getBoolean("fieldmustinput"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (!HRObjectUtils.isEmpty((Object)operationResult) && !operationResult.isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        HashMap<String, Runnable> map = new HashMap<String, Runnable>();
        map.put("donothing_infogroupadd", this::infoGroupAddOp);
        map.put("donothing_infogroupedit", this::infoGroupEditOp);
        map.put("donothing_fieldadd", this::infoGroupFieldAdd);
        map.put("donothing_fieldremove", this::infoGroupFieldRemove);
        map.put("donothing_fieldtop", this::infoGroupFieldTop);
        map.put("donothing_fieldfoot", this::infoGroupFieldFoot);
        map.put("donothing_fieldup", this::infoGroupFieldUp);
        map.put("donothing_fielddown", this::infoGroupFieldDown);
        map.put("donothing_replaydefault", this::replayDefaultClick);
        map.put("donothing_preview", this::preView);
        map.put("donothing_deleteentry", this::deleteEntry);
        map.put("donothing_save", this::barSave);
        map.getOrDefault(operateKey, () -> {}).run();
    }

    private void barSave() {
        this.saveBar();
        this.getRuleCode();
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    private void deleteEntry() {
        String infogroupindex;
        int index;
        EntryGrid entryGrid = (EntryGrid)this.getControl("infogroupentity");
        EntryData entryData = entryGrid.getEntryData(1, index = Integer.parseInt(infogroupindex = this.getPageCache().get("infogroupindex")), index + 1, 0, 0, 0, Boolean.FALSE);
        if (HRArrayUtils.isEmpty((Object[])entryData.getDataEntitys()) && index > 0) {
            entryGrid.selectRows(index - 1);
        } else {
            entryGrid.selectRows(Integer.parseInt(infogroupindex));
        }
        if (entryGrid.getEntryData().getDataEntitys().length == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap7", "flexpanelap3", "tabap", "flexpanelap81"});
        }
    }

    private void replayDefaultClick() {
        String remark = ResManager.loadKDString((String)"\u6062\u590d\u9ed8\u8ba4\u914d\u7f6e\u4f1a\u91cd\u7f6e\u60a8\u5f53\u524d\u5df2\u7ecf\u64cd\u4f5c\u7684\u4fe1\u606f\u7ec4\u548c\u5b57\u6bb5\uff0c\u662f\u5426\u786e\u8ba4\u6062\u590d\u9ed8\u8ba4\u914d\u7f6e\uff1f", (String)"InfoCollectConfig_12", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(remark, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("replaydefault"));
    }

    private void getRuleCode() {
        String entityId = this.getModel().getDataEntityType().getName();
        DynamicObject dataInfo = this.getModel().getDataEntity();
        String orgId = null;
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)entityId, (DynamicObject)dataInfo, orgId);
        CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dataInfo);
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        CardEntry cardEntry;
        String key;
        if (cellClickEvent.getSource() instanceof CardEntry && "certentity".equals(key = (cardEntry = (CardEntry)cellClickEvent.getSource()).getKey())) {
            int row = cellClickEvent.getRow();
            boolean ischeck = (Boolean)this.getModel().getValue("ischeck", row);
            this.getModel().setValue("ischeck", (Object)(!ischeck ? 1 : 0), row);
        }
    }

    private void reCountNum() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("infogroupentity");
        int rowIndex = 0;
        if (entryGrid.getSelectRows().length != 0) {
            rowIndex = entryGrid.getSelectRows()[0];
        }
        LinkedList queue = new LinkedList();
        DynamicObjectCollection infogroupbd = this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity");
        int amount = 0;
        for (Map.Entry entry : this.PAGE_ENTITY_MAP.entrySet()) {
            DynamicObjectCollection infogroupfield = ((DynamicObject)infogroupbd.get(rowIndex)).getDynamicObjectCollection((String)entry.getValue());
            amount += infogroupfield.size();
            TabPage tabPage = (TabPage)this.getControl((String)entry.getKey());
            boolean isExit = infogroupfield.size() != 0;
            this.getView().setVisible(Boolean.valueOf(isExit), new String[]{(String)entry.getKey()});
            if (isExit) {
                queue.offer(entry.getKey());
            }
            if ("tabpagetext".equals(entry.getKey())) {
                tabPage.setText(new LocaleString(String.format(ResManager.loadKDString((String)"\u6587\u672c\u7c7b\u4fe1\u606f(%s)", (String)"InfoCollectConfig_1", (String)"hr-hom-formplugin", (Object[])new Object[0]), infogroupfield.size())));
                continue;
            }
            if ("tabpageimg".equals(tabPage.getKey())) {
                tabPage.setText(new LocaleString(String.format(ResManager.loadKDString((String)"\u56fe\u7247\u7c7b\u4fe1\u606f(%s)", (String)"InfoCollectConfig_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), infogroupfield.size())));
                continue;
            }
            if (!"tabpageattach".equals(tabPage.getKey())) continue;
            tabPage.setText(new LocaleString(String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u7c7b\u4fe1\u606f(%s)", (String)"InfoCollectConfig_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), infogroupfield.size())));
        }
        String infoGroupNumber = ((DynamicObject)infogroupbd.get(rowIndex)).getString("infogroup.number");
        this.clickCertificateInfo(infoGroupNumber);
        Label labelap = (Label)this.getControl(LABELAP);
        labelap.setText(((DynamicObject)infogroupbd.get(rowIndex)).getLocaleString("infogroupname").getLocaleValue() + "(" + amount + ")");
        boolean dataChanged = this.getModel().getDataChanged();
        this.getModel().setValue("infogroupnameshow", (Object)(((DynamicObject)infogroupbd.get(rowIndex)).getString("infogroupname") + "(" + amount + ")"), rowIndex);
        this.getModel().setValue("infofieldinput", (Object)((DynamicObject)infogroupbd.get(rowIndex)).getBoolean("infomustinput"));
        this.getModel().setValue("infofieldapprove", (Object)((DynamicObject)infogroupbd.get(rowIndex)).getBoolean("infoapprove"));
        this.getModel().setValue("groupmustinput", (Object)((DynamicObject)infogroupbd.get(rowIndex)).getBoolean("infogroupmustinput"));
        ((DynamicObject)infogroupbd.get(rowIndex)).getDataEntityState().setBizChanged(5, false);
        ((DynamicObject)infogroupbd.get(rowIndex)).getDataEntityState().setBizChanged(2, false);
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(37, false);
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(39, false);
        if (!dataChanged) {
            this.getView().getModel().setDataChanged(false);
        }
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab((String)queue.poll());
    }

    private void clickCertificateInfo(String infoGroupNumber) {
        if (InfoGroupEnum.CERTIFICATE_INFO.getNumber().equals(infoGroupNumber)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldadd", "fieldremove"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap7"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fieldadd", "fieldremove"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap7"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        String name = property.getName();
        if ("infogroupbd".equals(name)) {
            DynamicObjectCollection infogroupbd = this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity");
            List idList = infogroupbd.stream().filter(item -> !HRObjectUtils.isEmpty((Object)item.getDynamicObject("infogroup"))).map(item -> item.getDynamicObject("infogroup").getLong("id")).collect(Collectors.toList());
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "not in", idList));
            String captionStr = ResManager.loadKDString((String)"\u4fe1\u606f\u91c7\u96c6\u914d\u7f6e", (String)"InfoCollectConfig_13", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            beforeF7SelectEvent.getFormShowParameter().setCaption(captionStr);
        } else if ("infogroupfield".equals(name)) {
            this.syncEntityTabToField();
            EntryGrid entryGrid = (EntryGrid)this.getControl("infogroupentity");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity").get(selectRows[0]);
            long infoGroupId = dynamicObject.getLong("infogroup.id");
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("infofieldentity");
            List infoGroupFieldId = dynamicObjectCollection.stream().map(dy -> dy.getLong("field.id")).collect(Collectors.toList());
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "not in", infoGroupFieldId).and(new QFilter("infogroup", "=", (Object)infoGroupId)));
            String captionStr = MessageFormat.format(ResManager.loadKDString((String)"\u6dfb\u52a0{0}\u5b57\u6bb5", (String)"InfoCollectConfig_8", (String)"hr-hom-formplugin", (Object[])new Object[0]), dynamicObject.getString("infogroupname"));
            beforeF7SelectEvent.getFormShowParameter().setCaption(captionStr);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        MulBasedataEdit field;
        Object source = afterF7SelectEvent.getSource();
        if (source instanceof MulBasedataEdit && "infogroupfield".equals((field = (MulBasedataEdit)source).getKey())) {
            List ids = afterF7SelectEvent.getListSelectedRowCollection().stream().map(fieldId -> (Long)fieldId.getPrimaryKeyValue()).collect(Collectors.toList());
            int[] fieldIndex = this.getModel().batchCreateNewEntryRow("infofieldentity", ids.size());
            IntStream.range(0, fieldIndex.length).forEach(fi -> {
                this.getModel().setValue("field", ids.get(fi), fieldIndex[fi]);
                Object fieldremark = ((DynamicObject)this.getModel().getValue("field", fieldIndex[fi])).get("fieldremark");
                if (!((OrmLocaleValue)fieldremark).isEmpty()) {
                    this.getModel().setValue("fieldremark", fieldremark, fieldIndex[fi]);
                }
                EntryGrid entryGrid = (EntryGrid)this.getControl("infogroupentity");
                int[] selectRows = entryGrid.getSelectRows();
                int currentRow = 0;
                if (selectRows.length != 0) {
                    currentRow = selectRows[0];
                }
                this.getModel().setValue("fieldmustinput", (Object)this.checkOneRowSel("infomustinput", currentRow), fieldIndex[fi]);
                this.getModel().setValue("fieldapprove", (Object)this.checkOneRowSel("infoapprove", currentRow), fieldIndex[fi]);
            });
            this.syncEntityFieldToTab();
            this.getModel().setValue("infogroupfield", null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        if ("infogroupedit".equals(actionId)) {
            DynamicObject dynamicObject = (DynamicObject)returnData;
            ILocaleString infogroupname = dynamicObject.getLocaleString("infogroupname");
            String infogroupindex = this.getPageCache().get("infogroupindex");
            this.getModel().setValue("infogroupname", (Object)infogroupname, Integer.parseInt(infogroupindex));
            EntryGrid entryGrid = (EntryGrid)this.getControl("infogroupentity");
            entryGrid.selectRows(Integer.parseInt(infogroupindex));
        }
    }

    private boolean checkOneRowSel(String key, int selRow) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("infogroupentity");
        if (collection.size() < selRow) {
            return true;
        }
        return ((DynamicObject)collection.get(selRow)).getBoolean(key);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("fieldremove".equals(messageBoxClosedEvent.getCallBackId()) && "yes".equalsIgnoreCase(messageBoxClosedEvent.getResultValue())) {
            String fieldEntityKey = this.getFieldEntityKey();
            SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl(fieldEntityKey);
            this.getModel().deleteEntryRows(fieldEntityKey, subEntryGrid.getSelectRows());
            this.reCountNum();
        }
        if ("replaydefault".equals(messageBoxClosedEvent.getCallBackId()) && "yes".equalsIgnoreCase(messageBoxClosedEvent.getResultValue())) {
            this.replayDefault();
        }
    }

    private void saveBar() {
        this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId());
        this.getModel().setValue("modifytime", (Object)new Date());
        HomCommonRepository.updateDynamicObject((String)"hom_infocollectconfig", (DynamicObject)this.getModel().getDataEntity());
    }

    private void preView() {
        this.syncEntityTabToField();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        InfoGroupConfigEntity infoGroupConfigEntity = ((ICollectService)ServiceFactory.getService(ICollectService.class)).transferDynToEntity(dataEntity);
        if (CollectionUtils.isEmpty((Collection)infoGroupConfigEntity.getInfoGroupEntityList())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u4fe1\u606f\u7ec4\u3002", (String)"InfoCollectConfig_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hom_infogroupdynpreview");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u89c8\u6a21\u677f", (String)"InfoCollectConfig_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.getOpenStyle().setTargetKey("hom_infogroupdynpreview");
        formShowParameter.setCustomParam("config", (Object)infoGroupConfigEntity);
        formShowParameter.setCustomParam("formtype", (Object)CollectDynFormTypeEnum.PRE_VIEW.getFormType());
        this.getView().showForm(formShowParameter);
    }

    private void replayDefault() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap7", "flexpanelap3", "tabap", "flexpanelap81"});
        this.getModel().deleteEntryData("infogroupentity");
        this.getModel().deleteEntryData("certentity");
        this.getModel().clearNoDataRow();
        this.createCertEntity();
        Label labelAp = (Label)this.getControl(LABELAP);
        DynamicObjectCollection infoGroupConfigDefaultList = HomConfigRepository.queryConfigEntityByBusinessKey((String)"info_group_config_default");
        EntryGrid entryGrid = (EntryGrid)this.getControl("infogroupentity");
        this.getPageCache().put("infogroupindex", "0");
        int count = infoGroupConfigDefaultList.size();
        int[] rowIndex = this.getModel().batchCreateNewEntryRow("infogroupentity", count);
        IntStream.range(0, count).forEach(index -> {
            DynamicObject infoGroupConfigDefault = (DynamicObject)infoGroupConfigDefaultList.get(index);
            this.getModel().setValue("infogroup", (Object)infoGroupConfigDefault.getString("entitykey"), rowIndex[index]);
            DynamicObject infoGroup = (DynamicObject)this.getModel().getValue("infogroup", rowIndex[index]);
            this.getModel().setValue("infogroupname", (Object)infoGroup.getLocaleString(NAME), rowIndex[index]);
            this.getModel().setValue("infogroupmustinput", infoGroup.get("infogroupmustinput"), rowIndex[index]);
            String entityValue = infoGroupConfigDefault.getString("entityvalue");
            String[] infoGroupFieldArr = entityValue.split(",");
            String infoGroupNameShow = infoGroup.getString(NAME) + "(" + infoGroupFieldArr.length + ")";
            this.getModel().setValue("infogroupnameshow", (Object)infoGroupNameShow, rowIndex[index]);
            entryGrid.selectRows(rowIndex[index]);
            this.getModel().deleteEntryRow("infofieldentity", 0);
            int[] fieldIndex = this.getModel().batchCreateNewEntryRow("infofieldentity", infoGroupFieldArr.length);
            IntStream.range(0, fieldIndex.length).forEach(fi -> {
                this.getModel().setValue("field", (Object)infoGroupFieldArr[fi], fieldIndex[fi]);
                if (!HRObjectUtils.isEmpty((Object)this.getModel().getValue("field", fieldIndex[fi]))) {
                    this.getModel().setValue("fieldremark", ((DynamicObject)this.getModel().getValue("field", fieldIndex[fi])).get("fieldremark"), fieldIndex[fi]);
                }
            });
            labelAp.setText(infoGroup.getLocaleString(NAME).getLocaleValue() + "(" + infoGroupFieldArr.length + ")");
        });
        entryGrid.selectRows(0);
        this.getModel().setValue("mustinput", (Object)Boolean.TRUE);
        this.getModel().setValue("approve", (Object)Boolean.TRUE);
        this.getModel().setValue("infogroupinput", (Object)Boolean.TRUE);
        this.getModel().setValue("infogroupapprove", (Object)Boolean.TRUE);
        this.getModel().setValue("infofieldinput", (Object)Boolean.TRUE);
        this.getModel().setValue("infofieldapprove", (Object)Boolean.TRUE);
        this.getModel().clearNoDataRow();
        this.syncEntityFieldToTab();
    }

    private void infoGroupInput() {
        boolean infogroupinput = this.getModel().getDataEntity().getBoolean("infogroupinput");
        this.getModel().setValue("mustinput", (Object)infogroupinput);
        this.getModel().setValue("infofieldinput", (Object)infogroupinput);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity");
        AtomicReference<Integer> fatherIndex = new AtomicReference<Integer>(0);
        dynamicObjectCollection.forEach(dynamicObject -> {
            DynamicObjectCollection dynamicObjectCollectionText = dynamicObject.getDynamicObjectCollection("textentity");
            IntStream.range(0, dynamicObjectCollectionText.size()).forEach(index -> this.getModel().setValue("textinput", (Object)infogroupinput, index, ((Integer)fatherIndex.get()).intValue()));
            DynamicObjectCollection dynamicObjectCollectionImg = dynamicObject.getDynamicObjectCollection("imgentity");
            IntStream.range(0, dynamicObjectCollectionImg.size()).forEach(index -> this.getModel().setValue("imginput", (Object)infogroupinput, index, ((Integer)fatherIndex.get()).intValue()));
            DynamicObjectCollection dynamicObjectCollectionAttach = dynamicObject.getDynamicObjectCollection("attachentity");
            IntStream.range(0, dynamicObjectCollectionAttach.size()).forEach(index -> this.getModel().setValue("attachinput", (Object)infogroupinput, index, ((Integer)fatherIndex.get()).intValue()));
            this.getModel().setValue("infomustinput", (Object)infogroupinput, ((Integer)fatherIndex.get()).intValue());
            fatherIndex.getAndSet((Integer)fatherIndex.get() + 1);
        });
    }

    private void infoFieldInput(int[] selectRows) {
        boolean infoFieldInput = this.getModel().getDataEntity().getBoolean("infofieldinput");
        if (!infoFieldInput) {
            this.getModel().setValue("infogroupinput", (Object)infoFieldInput);
            this.getModel().setValue("mustinput", (Object)infoFieldInput);
        }
        this.getModel().setValue("infomustinput", (Object)infoFieldInput, selectRows[0]);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity");
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(selectRows[0]);
        DynamicObjectCollection dynamicObjectCollectionText = dynamicObject.getDynamicObjectCollection("textentity");
        IntStream.range(0, dynamicObjectCollectionText.size()).forEach(index -> this.getModel().setValue("textinput", (Object)infoFieldInput, index));
        DynamicObjectCollection dynamicObjectCollectionImg = dynamicObject.getDynamicObjectCollection("imgentity");
        IntStream.range(0, dynamicObjectCollectionImg.size()).forEach(index -> this.getModel().setValue("imginput", (Object)infoFieldInput, index));
        DynamicObjectCollection dynamicObjectCollectionAttach = dynamicObject.getDynamicObjectCollection("attachentity");
        IntStream.range(0, dynamicObjectCollectionAttach.size()).forEach(index -> this.getModel().setValue("attachinput", (Object)infoFieldInput, index));
        if (this.checkAllInfosGroupSel(dynamicObjectCollection, "infomustinput")) {
            this.getModel().setValue("infogroupinput", (Object)Boolean.TRUE);
            this.getModel().setValue("mustinput", (Object)Boolean.TRUE);
        }
    }

    private void infoGroupApprove() {
        boolean infogroupapprove = this.getModel().getDataEntity().getBoolean("infogroupapprove");
        this.getModel().setValue("infofieldapprove", (Object)infogroupapprove);
        this.getModel().setValue("approve", (Object)infogroupapprove);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity");
        AtomicReference<Integer> fatherIndex = new AtomicReference<Integer>(0);
        dynamicObjectCollection.forEach(dynamicObject -> {
            DynamicObjectCollection dynamicObjectCollectionText = dynamicObject.getDynamicObjectCollection("textentity");
            IntStream.range(0, dynamicObjectCollectionText.size()).forEach(index -> this.getModel().setValue("textapprove", (Object)infogroupapprove, index, ((Integer)fatherIndex.get()).intValue()));
            DynamicObjectCollection dynamicObjectCollectionImg = dynamicObject.getDynamicObjectCollection("imgentity");
            IntStream.range(0, dynamicObjectCollectionImg.size()).forEach(index -> this.getModel().setValue("imgapprove", (Object)infogroupapprove, index, ((Integer)fatherIndex.get()).intValue()));
            DynamicObjectCollection dynamicObjectCollectionAttach = dynamicObject.getDynamicObjectCollection("attachentity");
            IntStream.range(0, dynamicObjectCollectionAttach.size()).forEach(index -> this.getModel().setValue("attachapprove", (Object)infogroupapprove, index, ((Integer)fatherIndex.get()).intValue()));
            this.getModel().setValue("infoapprove", (Object)infogroupapprove, ((Integer)fatherIndex.get()).intValue());
            fatherIndex.getAndSet((Integer)fatherIndex.get() + 1);
        });
    }

    private void infoFieldApprove(int[] selectRows) {
        boolean infoFieldApprove = this.getModel().getDataEntity().getBoolean("infofieldapprove");
        if (!infoFieldApprove) {
            this.getModel().setValue("infogroupapprove", (Object)infoFieldApprove);
            this.getModel().setValue("approve", (Object)infoFieldApprove);
        }
        this.getModel().setValue("infoapprove", (Object)infoFieldApprove, selectRows[0]);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity");
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(selectRows[0]);
        DynamicObjectCollection dynamicObjectCollectionText = dynamicObject.getDynamicObjectCollection("textentity");
        IntStream.range(0, dynamicObjectCollectionText.size()).forEach(index -> this.getModel().setValue("textapprove", (Object)infoFieldApprove, index));
        DynamicObjectCollection dynamicObjectCollectionImg = dynamicObject.getDynamicObjectCollection("imgentity");
        IntStream.range(0, dynamicObjectCollectionImg.size()).forEach(index -> this.getModel().setValue("imgapprove", (Object)infoFieldApprove, index));
        DynamicObjectCollection dynamicObjectCollectionAttach = dynamicObject.getDynamicObjectCollection("attachentity");
        IntStream.range(0, dynamicObjectCollectionAttach.size()).forEach(index -> this.getModel().setValue("attachapprove", (Object)infoFieldApprove, index));
        if (this.checkAllInfosGroupSel(dynamicObjectCollection, "infoapprove")) {
            this.getModel().setValue("infogroupapprove", (Object)Boolean.TRUE);
            this.getModel().setValue("approve", (Object)Boolean.TRUE);
        }
    }

    private boolean checkAllInfosGroupSel(DynamicObjectCollection collection, String key) {
        for (int i = 0; i < collection.size(); ++i) {
            if (((DynamicObject)collection.get(i)).getBoolean(key)) continue;
            return false;
        }
        return true;
    }

    private void syncEntityFieldToTab() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("infogroupentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("infogroupentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        Label labelap = (Label)this.getControl(LABELAP);
        IntStream.range(0, dynamicObjectCollection.size()).forEach(index -> {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(index);
            entryGrid.selectRows(index);
            this.getModel().deleteEntryData("textentity");
            this.getModel().deleteEntryData("imgentity");
            this.getModel().deleteEntryData("attachentity");
            DynamicObjectCollection infogroupfield = dynamicObject.getDynamicObjectCollection("infofieldentity");
            infogroupfield.forEach(dy -> {
                if (InfoGroupFieldTypeEnum.TEXT.getFieldType().equals(dy.getString("field.fieldtype"))) {
                    int[] fieldIndex = this.getModel().batchCreateNewEntryRow("textentity", 1);
                    this.getModel().setValue("textfield", (Object)dy.getLong("field.id"), fieldIndex[0]);
                    this.getModel().setValue("textinput", (Object)dy.getBoolean("fieldmustinput"), fieldIndex[0]);
                    this.getModel().setValue("textapprove", (Object)dy.getBoolean("fieldapprove"), fieldIndex[0]);
                    this.getModel().setValue("textremark", (Object)dy.getLocaleString("fieldremark"), fieldIndex[0]);
                    this.getModel().setValue("textnameshow", (Object)dy.getLocaleString("fieldnameshow"), fieldIndex[0]);
                } else if (InfoGroupFieldTypeEnum.IMAGE.getFieldType().equals(dy.getString("field.fieldtype"))) {
                    int[] fieldIndex = this.getModel().batchCreateNewEntryRow("imgentity", 1);
                    this.getModel().setValue("imgfield", (Object)dy.getLong("field.id"), fieldIndex[0]);
                    this.getModel().setValue("imginput", (Object)dy.getBoolean("fieldmustinput"), fieldIndex[0]);
                    this.getModel().setValue("imgapprove", (Object)dy.getBoolean("fieldapprove"), fieldIndex[0]);
                    this.getModel().setValue("imgremark", (Object)dy.getLocaleString("fieldremark"), fieldIndex[0]);
                    this.getModel().setValue("imgrecheck", (Object)dy.getString("fieldrecheck"), fieldIndex[0]);
                    this.getModel().setValue("imgnameshow", (Object)dy.getLocaleString("fieldnameshow"), fieldIndex[0]);
                    this.getModel().setValue("imgrecheckstand", (Object)dy.getLocaleString("fieldrecheckstand"), fieldIndex[0]);
                } else if (InfoGroupFieldTypeEnum.ATTACH.getFieldType().equals(dy.getString("field.fieldtype"))) {
                    int[] fieldIndex = this.getModel().batchCreateNewEntryRow("attachentity", 1);
                    this.getModel().setValue("attachfield", (Object)dy.getLong("field.id"), fieldIndex[0]);
                    this.getModel().setValue("attachinput", (Object)dy.getBoolean("fieldmustinput"), fieldIndex[0]);
                    this.getModel().setValue("attachapprove", (Object)dy.getBoolean("fieldapprove"), fieldIndex[0]);
                    this.getModel().setValue("attachremark", (Object)dy.getLocaleString("fieldremark"), fieldIndex[0]);
                    this.getModel().setValue("attachcount", (Object)dy.getInt("fieldcount"), fieldIndex[0]);
                    this.getModel().setValue("attachnameshow", (Object)dy.getLocaleString("fieldnameshow"), fieldIndex[0]);
                    this.getModel().setValue("attachrecheck", (Object)dy.getString("fieldrecheck"), fieldIndex[0]);
                    this.getModel().setValue("attachrecheckstand", (Object)dy.getLocaleString("fieldrecheckstand"), fieldIndex[0]);
                }
            });
            labelap.setText(dynamicObject.getString("infogroupname") + "(" + infogroupfield.size() + ")");
            this.getModel().setValue("infogroupnameshow", (Object)(dynamicObject.getString("infogroupname") + "(" + infogroupfield.size() + ")"), index);
            this.getModel().setValue("infofieldinput", (Object)dynamicObject.getBoolean("infomustinput"));
            this.getModel().setValue("infofieldapprove", (Object)dynamicObject.getBoolean("infoapprove"));
        });
        String infogroupindex = this.getPageCache().get("infogroupindex");
        if (HRStringUtils.isEmpty((String)infogroupindex)) {
            infogroupindex = "0";
            this.getPageCache().put("infogroupindex", "0");
        }
        entryGrid.selectRows(Integer.parseInt(infogroupindex));
        boolean mustinput = (Boolean)this.getModel().getValue("mustinput");
        this.getModel().setValue("infogroupinput", (Object)mustinput);
        boolean approve = (Boolean)this.getModel().getValue("approve");
        this.getModel().setValue("infogroupapprove", (Object)approve);
    }

    private void syncEntityTabToField() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("infogroupentity");
        if (dynamicObjectCollection.size() == 0) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("infogroupentity");
        int[] selectRows = entryGrid.getSelectRows();
        IntStream.range(0, dynamicObjectCollection.size()).forEach(index -> {
            entryGrid.selectRows(index);
            this.getModel().deleteEntryData("infofieldentity");
            this.getModel().clearNoDataRow();
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(index);
            DynamicObjectCollection textEntity = dynamicObject.getDynamicObjectCollection("textentity");
            DynamicObjectCollection imgEntity = dynamicObject.getDynamicObjectCollection("imgentity");
            DynamicObjectCollection attachEntity = dynamicObject.getDynamicObjectCollection("attachentity");
            if (!CollectionUtils.isEmpty((Collection)textEntity)) {
                int[] textFieldIndex = this.getModel().batchCreateNewEntryRow("infofieldentity", textEntity.size());
                IntStream.range(0, textFieldIndex.length).forEach(fi -> {
                    DynamicObject dy = (DynamicObject)textEntity.get(fi);
                    this.getModel().setValue("field", (Object)dy.getLong("textfield.id"), textFieldIndex[fi]);
                    this.getModel().setValue("fieldmustinput", (Object)dy.getBoolean("textinput"), textFieldIndex[fi]);
                    this.getModel().setValue("fieldapprove", (Object)dy.getBoolean("textapprove"), textFieldIndex[fi]);
                    this.getModel().setValue("fieldremark", (Object)dy.getLocaleString("textremark"), textFieldIndex[fi]);
                    this.getModel().setValue("fieldnameshow", (Object)dy.getLocaleString("textnameshow"), textFieldIndex[fi]);
                });
            }
            if (!CollectionUtils.isEmpty((Collection)imgEntity)) {
                int[] imgFieldIndex = this.getModel().batchCreateNewEntryRow("infofieldentity", imgEntity.size());
                IntStream.range(0, imgFieldIndex.length).forEach(fi -> {
                    DynamicObject dy = (DynamicObject)imgEntity.get(fi);
                    this.getModel().setValue("field", (Object)dy.getLong("imgfield.id"), imgFieldIndex[fi]);
                    this.getModel().setValue("fieldmustinput", (Object)dy.getBoolean("imginput"), imgFieldIndex[fi]);
                    this.getModel().setValue("fieldapprove", (Object)dy.getBoolean("imgapprove"), imgFieldIndex[fi]);
                    this.getModel().setValue("fieldremark", (Object)dy.getLocaleString("imgremark"), imgFieldIndex[fi]);
                    this.getModel().setValue("fieldrecheck", (Object)dy.getString("imgrecheck"), imgFieldIndex[fi]);
                    this.getModel().setValue("fieldnameshow", (Object)dy.getLocaleString("imgnameshow"), imgFieldIndex[fi]);
                    this.getModel().setValue("fieldrecheckstand", (Object)dy.getLocaleString("imgrecheckstand"), imgFieldIndex[fi]);
                });
            }
            if (!CollectionUtils.isEmpty((Collection)attachEntity)) {
                int[] attachFieldIndex = this.getModel().batchCreateNewEntryRow("infofieldentity", attachEntity.size());
                IntStream.range(0, attachFieldIndex.length).forEach(fi -> {
                    DynamicObject dy = (DynamicObject)attachEntity.get(fi);
                    this.getModel().setValue("field", (Object)dy.getLong("attachfield.id"), attachFieldIndex[fi]);
                    this.getModel().setValue("fieldmustinput", (Object)dy.getBoolean("attachinput"), attachFieldIndex[fi]);
                    this.getModel().setValue("fieldapprove", (Object)dy.getBoolean("attachapprove"), attachFieldIndex[fi]);
                    this.getModel().setValue("fieldremark", (Object)dy.getLocaleString("attachremark"), attachFieldIndex[fi]);
                    this.getModel().setValue("fieldcount", (Object)dy.getInt("attachcount"), attachFieldIndex[fi]);
                    this.getModel().setValue("fieldnameshow", (Object)dy.getLocaleString("attachnameshow"), attachFieldIndex[fi]);
                    this.getModel().setValue("fieldrecheck", (Object)dy.getString("attachrecheck"), attachFieldIndex[fi]);
                    ILocaleString attachrecheckstand = dy.getLocaleString("attachrecheckstand");
                    this.getModel().setValue("fieldrecheckstand", (Object)attachrecheckstand, attachFieldIndex[fi]);
                });
            }
        });
        entryGrid.selectRows(selectRows[0]);
        this.syncMulBdToEntity();
    }

    private String getFieldEntityKey() {
        Tab tabAp = (Tab)this.getControl("tabap");
        String currentTab = tabAp.getCurrentTab();
        return (String)this.PAGE_ENTITY_MAP.get((Object)currentTab);
    }

    private void infoGroupFieldRemove() {
        String fieldEntityKey = this.getFieldEntityKey();
        SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl(fieldEntityKey);
        if (subEntryGrid.getSelectRows().length == 0) {
            String remark = ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u9700\u8981\u5220\u9664\u7684\u5b57\u6bb5\u3002", (String)"InfoCollectConfig_6", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(remark);
        } else {
            String remark = ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u8be5\u5b57\u6bb5\uff1f", (String)"InfoCollectConfig_7", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(remark, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("fieldremove"));
        }
    }

    private void infoGroupFieldTop() {
        String fieldEntityKey = this.getFieldEntityKey();
        SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl(fieldEntityKey);
        if (subEntryGrid.getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u5b57\u6bb5\u3002", (String)"InfoCollectConfig_15", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setEntryRowTop(fieldEntityKey, subEntryGrid.getSelectRows());
        }
    }

    private void infoGroupFieldFoot() {
        String fieldEntityKey = this.getFieldEntityKey();
        SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl(fieldEntityKey);
        if (subEntryGrid.getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u5b57\u6bb5\u3002", (String)"InfoCollectConfig_15", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setEntryRowBottom(fieldEntityKey, subEntryGrid.getSelectRows());
        }
    }

    private void infoGroupFieldUp() {
        String fieldEntityKey = this.getFieldEntityKey();
        SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl(fieldEntityKey);
        if (subEntryGrid.getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u5b57\u6bb5\u3002", (String)"InfoCollectConfig_15", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().moveEntryRowsUp(fieldEntityKey, subEntryGrid.getSelectRows());
        }
    }

    private void infoGroupFieldDown() {
        String fieldEntityKey = this.getFieldEntityKey();
        SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl(fieldEntityKey);
        if (subEntryGrid.getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u5b57\u6bb5\u3002", (String)"InfoCollectConfig_15", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().moveEntryRowsDown(fieldEntityKey, subEntryGrid.getSelectRows());
        }
    }

    private void infoGroupFieldAdd() {
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("infogroupfield");
        edit.click();
    }

    private void infoGroupEditOp() {
        EntryGrid infogroupentity = (EntryGrid)this.getControl("infogroupentity");
        int[] selectRows = infogroupentity.getSelectRows();
        this.getPageCache().put("infogroupindex", String.valueOf(selectRows[0]));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "infogroupedit"));
        String captionStr = ResManager.loadKDString((String)"\u7f16\u8f91", (String)"InfoCollectConfig_9", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        formShowParameter.setCaption(captionStr);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getOpenStyle().setTargetKey("hom_infogroupedit");
        formShowParameter.setFormId("hom_infogroupedit");
        HashMap<String, String> reqParams = new HashMap<String, String>();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity");
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(selectRows[0]);
        reqParams.put("origininfogroupname", dynamicObject.getString("infogroupname"));
        formShowParameter.setCustomParams(reqParams);
        this.getView().showForm(formShowParameter);
    }

    private void infoGroupAddOp() {
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("infogroupbd");
        edit.click();
    }

    private void refreshEntity(DynamicObjectCollection infogroupfield) {
        this.getModel().deleteEntryData("textentity");
        this.getModel().deleteEntryData("imgentity");
        this.getModel().deleteEntryData("attachentity");
        infogroupfield.forEach(dynamicObject -> {
            if (InfoGroupFieldTypeEnum.TEXT.getFieldType().equals(dynamicObject.getString("fieldtype"))) {
                int[] fieldIndex = this.getModel().batchCreateNewEntryRow("textentity", 1);
                this.getModel().setValue("textfield", (Object)dynamicObject.getLong("id"), fieldIndex[0]);
            } else if (InfoGroupFieldTypeEnum.IMAGE.getFieldType().equals(dynamicObject.getString("fieldtype"))) {
                int[] fieldIndex = this.getModel().batchCreateNewEntryRow("imgentity", 1);
                this.getModel().setValue("imgfield", (Object)dynamicObject.getLong("id"), fieldIndex[0]);
            } else if (InfoGroupFieldTypeEnum.ATTACH.getFieldType().equals(dynamicObject.getString("fieldtype"))) {
                int[] fieldIndex = this.getModel().batchCreateNewEntryRow("attachentity", 1);
                this.getModel().setValue("attachfield", (Object)dynamicObject.getLong("id"), fieldIndex[0]);
            }
        });
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if ("bar_save".equals(evt.getItemKey())) {
            DynamicObject dyo = this.getModel().getDataEntity();
            if (this.checkCodeAndNameValid(dyo)) {
                String errMsg = ResManager.loadKDString((String)"\u7f16\u53f7\u6216\u8005\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"InfoCollectConfig_10", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errMsg);
                evt.setCancel(true);
            } else if (this.checkOrgId(dyo)) {
                String errMsg = ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u5df2\u5931\u6548\u3002", (String)"InfoCollectConfig_11", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errMsg);
                evt.setCancel(true);
            } else {
                this.syncEntityTabToField();
            }
        }
    }

    private boolean checkCodeAndNameValid(DynamicObject dyo) {
        QFilter filter = new QFilter(NUMBER, "=", (Object)dyo.getString(NUMBER)).or(NAME, "=", (Object)dyo.getString(NAME)).and("id", "!=", (Object)dyo.getLong("id"));
        DynamicObject[] query = HELPER.query(new QFilter[]{filter});
        return query != null && query.length > 0;
    }

    private boolean checkOrgId(DynamicObject dyo) {
        if (HRObjectUtils.isEmpty((Object)dyo.getDynamicObject(CREATEORG))) {
            return true;
        }
        String number = dyo.getDynamicObject(CREATEORG).getString(NUMBER);
        QFilter filter = new QFilter(NUMBER, "=", (Object)number).and("enable", "=", (Object)"1").and("status", "=", (Object)"C").and("fishr", "=", (Object)"1");
        DynamicObject[] query = ORGHELPER.query(new QFilter[]{filter});
        return query == null || query.length <= 0;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeStatus = this.getPageCache().get("changeStatus");
        if (RequestContext.get().getTraceId().equals(changeStatus)) {
            return;
        }
        this.getPageCache().put("changeStatus", RequestContext.get().getTraceId());
        EntryGrid control = (EntryGrid)this.getControl("infogroupentity");
        int[] selectRows = control.getSelectRows();
        IDataEntityProperty property = e.getProperty();
        HashMap<String, Runnable> map = new HashMap<String, Runnable>();
        map.put("infogroupinput", this::infoGroupInput);
        map.put("infogroupapprove", this::infoGroupApprove);
        map.put("infofieldinput", () -> this.infoFieldInput(selectRows));
        map.put("infofieldapprove", () -> this.infoFieldApprove(selectRows));
        map.put("infogroupbd", () -> this.addInfoGroupDb(e));
        map.put("textinput", () -> this.mustInputChange(e, selectRows));
        map.put("imginput", () -> this.mustInputChange(e, selectRows));
        map.put("attachinput", () -> this.mustInputChange(e, selectRows));
        map.put("textapprove", () -> this.approveChange(e, selectRows));
        map.put("imgapprove", () -> this.approveChange(e, selectRows));
        map.put("attachapprove", () -> this.approveChange(e, selectRows));
        map.put("allgroupmustinput", () -> this.allMustInputGroupChange(e, selectRows));
        map.put("groupmustinput", () -> this.mustInputGroupChange(e, selectRows));
        map.getOrDefault(property.getName(), () -> {}).run();
    }

    private void mustInputGroupChange(PropertyChangedArgs e, int[] selectRows) {
        ChangeData[] changeSet = e.getChangeSet();
        Boolean newValue = (Boolean)changeSet[0].getNewValue();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity");
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(selectRows[0]);
        dynamicObject.set("infogroupmustinput", (Object)newValue);
        if (newValue.booleanValue()) {
            boolean existNotInput = dynamicObjectCollection.stream().anyMatch(dy -> !dy.getBoolean("infogroupmustinput"));
            if (!existNotInput) {
                this.getModel().setValue("allgroupmustinput", (Object)Boolean.TRUE);
                this.getModel().setValue("cfgallgroupmustinput", (Object)Boolean.TRUE);
            }
        } else {
            this.getModel().setValue("allgroupmustinput", (Object)Boolean.FALSE);
            this.getModel().setValue("cfgallgroupmustinput", (Object)Boolean.FALSE);
        }
    }

    private void allMustInputGroupChange(PropertyChangedArgs e, int[] selectRows) {
        ChangeData[] changeSet = e.getChangeSet();
        Boolean newValue = (Boolean)changeSet[0].getNewValue();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity");
        dynamicObjectCollection.forEach(dy -> dy.set("infogroupmustinput", (Object)newValue));
        this.getModel().setValue("groupmustinput", (Object)newValue);
    }

    private void mustInputChange(PropertyChangedArgs e, int[] selectRows) {
        DynamicObject dyo = this.getOneRowFieldCollection(selectRows[0]);
        if (dyo != null) {
            DynamicObjectCollection textColl = dyo.getDynamicObjectCollection("textentity");
            DynamicObjectCollection imgColl = dyo.getDynamicObjectCollection("imgentity");
            DynamicObjectCollection attachColl = dyo.getDynamicObjectCollection("attachentity");
            Boolean input = this.checkOneRowFieldSel(textColl, imgColl, attachColl, "textinput", "imginput", "attachinput");
            this.getModel().setValue("infofieldinput", (Object)input);
            this.getModel().setValue("infogroupinput", (Object)input);
            this.getModel().setValue("mustinput", (Object)input);
            this.getModel().setValue("infomustinput", (Object)input, selectRows[0]);
        }
    }

    private DynamicObject getOneRowFieldCollection(int selectRow) {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("infogroupentity");
        return (DynamicObject)dynamicObjectCollection.get(selectRow);
    }

    private Boolean checkOneRowFieldSel(DynamicObjectCollection textColl, DynamicObjectCollection imgColl, DynamicObjectCollection attachColl, String textType, String imgType, String attachType) {
        for (DynamicObject dyo : textColl) {
            if (dyo.getBoolean(textType)) continue;
            return Boolean.FALSE;
        }
        for (DynamicObject dyo : imgColl) {
            if (dyo.getBoolean(imgType)) continue;
            return Boolean.FALSE;
        }
        for (DynamicObject dyo : attachColl) {
            if (dyo.getBoolean(attachType)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void approveChange(PropertyChangedArgs e, int[] selectRows) {
        DynamicObject dyo = this.getOneRowFieldCollection(selectRows[0]);
        if (dyo != null) {
            DynamicObjectCollection textColl = dyo.getDynamicObjectCollection("textentity");
            DynamicObjectCollection imgColl = dyo.getDynamicObjectCollection("imgentity");
            DynamicObjectCollection attachColl = dyo.getDynamicObjectCollection("attachentity");
            Boolean approve = this.checkOneRowFieldSel(textColl, imgColl, attachColl, "textapprove", "imgapprove", "attachapprove");
            this.getModel().setValue("infofieldapprove", (Object)approve);
            this.getModel().setValue("infogroupapprove", (Object)approve);
            this.getModel().setValue("approve", (Object)approve);
            this.getModel().setValue("infoapprove", (Object)approve, selectRows[0]);
        }
    }

    private void addInfoGroupDb(PropertyChangedArgs e) {
        Label labelap = (Label)this.getControl(LABELAP);
        DynamicObjectCollection infogroupbd = this.getModel().getDataEntity().getDynamicObjectCollection("infogroupbd");
        DynamicObjectCollection newValue = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
        int count = newValue.size();
        EntryGrid entryGrid = (EntryGrid)this.getControl("infogroupentity");
        int[] selectRows = entryGrid.getSelectRows();
        int[] rowIndex = this.getModel().batchCreateNewEntryRow("infogroupentity", count);
        IntStream.range(0, count).forEach(index -> {
            DynamicObject dynamicObject = ((DynamicObject)newValue.get(index)).getDynamicObject(1);
            this.getModel().setValue("infogroup", (Object)dynamicObject.getLong("id"), rowIndex[index]);
            this.getModel().setValue("infogroupname", (Object)dynamicObject.getLocaleString(NAME), rowIndex[index]);
            this.getModel().setValue("infogroupmustinput", dynamicObject.get("infogroupmustinput"), rowIndex[index]);
            DynamicObjectCollection infogroupfield = dynamicObject.getDynamicObjectCollection("infogroupfield");
            String infoGroupNameShow = dynamicObject.getString(NAME) + "(" + infogroupfield.size() + ")";
            this.getModel().setValue("infogroupnameshow", (Object)infoGroupNameShow, rowIndex[index]);
            entryGrid.selectRows(rowIndex[index]);
            this.getModel().deleteEntryRow("infofieldentity", 0);
            int[] fieldIndex = this.getModel().batchCreateNewEntryRow("infofieldentity", infogroupfield.size());
            IntStream.range(0, fieldIndex.length).forEach(fi -> this.getModel().setValue("field", (Object)((DynamicObject)infogroupfield.get(fi)).getLong("id"), fieldIndex[fi]));
            this.refreshEntity(infogroupfield);
            labelap.setText(dynamicObject.getLocaleString(NAME).getLocaleValue() + "(" + infogroupfield.size() + ")");
        });
        if (selectRows.length > 0) {
            entryGrid.selectRows(selectRows[0]);
        }
        infogroupbd.clear();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap7", "flexpanelap3", "tabap", "flexpanelap81"});
    }

    private /* synthetic */ void lambda$createCertEntity$5(DynamicObject[] ids, int[] certentities, int index) {
        this.getModel().setValue("certtype", (Object)ids[index], certentities[index]);
    }
}

