/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.collectconfig;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.DecimalEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.collect.DynamicFiledViewServiceFactory;
import kd.hr.hom.business.domain.service.collect.ICollectGroupStatusService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.collect.ISyncCollectToHcf;
import kd.hr.hom.business.domain.service.common.IHomConfigService;
import kd.hr.hom.business.domain.service.common.IPreOpenFormCheckService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.InfoGroupFieldConstants;
import kd.hr.hom.common.entity.DynViewParamEntity;
import kd.hr.hom.common.entity.ImageCacheEntity;
import kd.hr.hom.common.entity.InfoGroupAttachEntity;
import kd.hr.hom.common.entity.InfoGroupCertEntity;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.CollectDynFormTypeEnum;
import kd.hr.hom.common.enums.InfoGroupCertTypeEnum;
import kd.hr.hom.common.enums.InfoGroupEnum;
import kd.hr.hom.common.enums.InfoGroupFieldTypeEnum;
import kd.hr.hom.common.util.FlexBuildUtils;
import kd.hr.hom.formplugin.common.CustomStyleUtils;
import kd.hr.hom.formplugin.web.activity.AbstractCollectDynViewPlugin;
import kd.sdk.hr.hom.common.InfoGroupEntity;

public class InfoGroupDynViewPlugin
extends AbstractCollectDynViewPlugin {
    private static final Log logger = LogFactory.getLog(InfoGroupDynViewPlugin.class);
    private final Map<String, Consumer<InfoGroupConfigEntity>> PAGE_MAP = ImmutableMap.builder().put((Object)"hom_collectapprovefail", this::collectApproveFailView).put((Object)"hom_collectmanagesub", this::collectManageSubView).put((Object)"hom_collectmanagefin", this::collectManageFinView).put((Object)"hom_collectapproveing", this::collectApprovingView).put((Object)"hom_collectapprovepass", this::collectApprovePassView).put((Object)"hom_collectapprovereject", this::collectApproveRejectView).put((Object)"hom_collectapproveremit", this::collectApproveRemitView).build();
    private final List<String> nonApproveFieldList = new ArrayList<String>();
    private final List<String> hideFieldList = new ArrayList<String>();
    private final List<String> showFieldList = new ArrayList<String>();
    private final List<String> disableFieldList = new ArrayList<String>();
    private final List<String> enableFieldList = new ArrayList<String>();

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        IPreOpenFormCheckService.getInstance().isHandlerCheck(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (HRObjectUtils.isEmpty((Object)this.getView().getFormShowParameter().getCustomParam("config"))) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        dataEntity.getDataEntityType().getProperties().forEach(property -> {
            if (!(property instanceof BasedataProp)) {
                return;
            }
            if (HRObjectUtils.isEmpty((Object)property.getValue((Object)dataEntity))) {
                this.getModel().setValue(property.getName(), ((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)(property.getName() + "_id"))).getValue((Object)dataEntity));
            }
        });
        this.cacheCertConfig();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONObject config = (JSONObject)formShowParameter.getCustomParam("config");
        boolean isDataView = CollectDynFormTypeEnum.MANAGE.getFormType().equals(formShowParameter.getCustomParam("formtype"));
        InfoGroupConfigEntity infoGroupConfigEntity = (InfoGroupConfigEntity)TypeUtils.castToJavaBean((Object)config, InfoGroupConfigEntity.class);
        DynViewParamEntity dynViewParamEntity = new DynViewParamEntity.Builder().setDataView(isDataView).setApprove(this.isApprove()).setStatus((String)formShowParameter.getCustomParam("status")).build();
        FlexPanelAp flexPanelAp = this.loadMetas(null, infoGroupConfigEntity, dynViewParamEntity);
        Container fldPanel = (Container)this.getView().getControl("infogroupflex");
        fldPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(fldPanel.getItems());
        Label labelap = (Label)this.getControl("labelap");
        labelap.setText(infoGroupConfigEntity.getConfigName());
        List infoGroupEntityList = infoGroupConfigEntity.getInfoGroupEntityList();
        IPageCache pageCache = this.getPageCache();
        pageCache.put("infoGroupConfig", JSONObject.toJSONString((Object)infoGroupConfigEntity));
        this.getModel().setValue("fieldcerttype", (Object)InfoGroupCertTypeEnum.IDCARD.getId());
        this.syncCandidateInfo(formShowParameter, infoGroupEntityList);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        InfoGroupConfigEntity infoGroupConfigData = this.getInfoGroupConfigData();
        AtomicBoolean flag = new AtomicBoolean(false);
        infoGroupConfigData.getInfoGroupEntityList().forEach(infoGroupEntity -> {
            if (infoGroupEntity.isMultipleEntity()) {
                return;
            }
            infoGroupEntity.getInfoGroupFieldList().forEach(infoGroupField -> {
                if (!infoGroupField.isFieldApprove()) {
                    this.nonApproveFieldList.add("fieldboard" + infoGroupField.getFieldId());
                }
            });
        });
        String multiPageIdList = this.getPageCache().get("multiPageIdList");
        Object[] multiPageIdArr = new String[]{};
        if (HRStringUtils.isNotEmpty((String)multiPageIdList)) {
            multiPageIdArr = HRStringUtils.split((String)multiPageIdList, (String)",");
        }
        if (!"submitcollect".equalsIgnoreCase(afterDoOperationEventArgs.getOperateKey())) {
            if ("showapprove".equalsIgnoreCase(afterDoOperationEventArgs.getOperateKey())) {
                this.getView().setVisible(Boolean.TRUE, this.nonApproveFieldList.toArray(new String[0]));
                if (!HRArrayUtils.isEmpty((Object[])multiPageIdArr)) {
                    for (Object multiPageId : multiPageIdArr) {
                        IFormView view = this.getView().getView((String)multiPageId);
                        view.getModel().createNewData();
                        view.invokeOperation("showapprove");
                        this.getView().sendFormAction(view);
                    }
                }
                this.hiddenEmptyPage(infoGroupConfigData);
            } else if ("hiddenapprove".equalsIgnoreCase(afterDoOperationEventArgs.getOperateKey())) {
                this.getView().setVisible(Boolean.FALSE, this.nonApproveFieldList.toArray(new String[0]));
                if (!HRArrayUtils.isEmpty((Object[])multiPageIdArr)) {
                    for (Object multiPageId : multiPageIdArr) {
                        IFormView view = this.getView().getView((String)multiPageId);
                        view.getModel().createNewData();
                        view.invokeOperation("hiddenapprove");
                        this.getView().sendFormAction(view);
                    }
                }
                this.showEmptyPage(infoGroupConfigData);
            }
        }
    }

    private void showEmptyPage(InfoGroupConfigEntity infoGroupConfigData) {
        infoGroupConfigData.getInfoGroupEntityList().forEach(infoGroupEntity -> {
            boolean flag = infoGroupEntity.getInfoGroupFieldList().stream().anyMatch(InfoGroupEntity.InfoGroupField::isFieldApprove);
            if (!flag) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"infogroupdataflex1" + infoGroupEntity.getInfoGroupNumber().toLowerCase()});
                this.getView().setVisible(Boolean.FALSE, new String[]{"infogroupdataflex" + infoGroupEntity.getInfoGroupNumber().toLowerCase()});
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.getOpenStyle().setTargetKey("infogroupdataflex1" + infoGroupEntity.getInfoGroupNumber().toLowerCase());
                formShowParameter.setFormId("hom_approveemptypage");
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                this.getView().showForm(formShowParameter);
            }
        });
    }

    private void hiddenEmptyPage(InfoGroupConfigEntity infoGroupConfigData) {
        infoGroupConfigData.getInfoGroupEntityList().forEach(infoGroupEntity -> {
            boolean flag = infoGroupEntity.getInfoGroupFieldList().stream().anyMatch(InfoGroupEntity.InfoGroupField::isFieldApprove);
            if (!flag) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"infogroupdataflex" + infoGroupEntity.getInfoGroupNumber().toLowerCase()});
                this.getView().setVisible(Boolean.FALSE, new String[]{"infogroupdataflex1" + infoGroupEntity.getInfoGroupNumber().toLowerCase()});
            }
        });
    }

    private void syncCandidateInfo(FormShowParameter formShowParameter, List<InfoGroupEntity> infoGroupEntityList) {
        DynamicObject dynamicObject2;
        IDataEntityProperty iDataEntityProperty;
        List value;
        DynamicObject singleRowEntity;
        String pageKey;
        if (HRObjectUtils.isEmpty((Object)formShowParameter.getCustomParam("onboardid")) || !HRObjectUtils.isEmpty((Object)this.getModel().getValue("textfield"))) {
            return;
        }
        if ("1".equals(this.getPageCache().get("syncCandidate"))) {
            return;
        }
        long onboardId = this.getView().getParentView().getModel().getDataEntity().getLong("onboard.id");
        this.getPageCache().put("syncCandidate", "1");
        HashMap hcfSingleMap = Maps.newHashMapWithExpectedSize((int)3);
        HashMap homEntityMap = Maps.newHashMapWithExpectedSize((int)3);
        Long candidateId = Long.parseLong(formShowParameter.getCustomParam("onboardid").toString());
        ArrayList attachEntityList = new ArrayList();
        HashMap map = new HashMap();
        infoGroupEntityList.forEach(infoGroupEntity -> {
            if (infoGroupEntity.isMultipleEntity()) {
                HashMap keyIndexMap = Maps.newHashMapWithExpectedSize((int)3);
                HashMap hcfMultiMap = Maps.newHashMapWithExpectedSize((int)3);
                infoGroupEntity.getInfoGroupFieldList().forEach(field -> {
                    String pageKey = field.getPageKey();
                    if (pageKey.contains("hcf_")) {
                        ((ISyncCollectToHcf)ServiceFactory.getService(ISyncCollectToHcf.class)).fillEntityMap(hcfMultiMap, field, pageKey);
                    } else {
                        ((ISyncCollectToHcf)ServiceFactory.getService(ISyncCollectToHcf.class)).fillEntityMap(homEntityMap, field, pageKey);
                    }
                });
                for (Map.Entry stringListEntry : hcfMultiMap.entrySet()) {
                    String pageKey = (String)stringListEntry.getKey();
                    DynamicObjectCollection multiRowEntity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, pageKey);
                    if (CollectionUtils.isEmpty((Collection)multiRowEntity) || "hcf_educertificate".equals(pageKey)) continue;
                    if ("hcf_caneduexp".equals(pageKey)) {
                        List collect = multiRowEntity.stream().filter(dy -> !HRObjectUtils.isEmpty((Object)dy.getDate("gradutiondate"))).sorted(Comparator.comparing(dy -> dy.getDate("gradutiondate"), Comparator.reverseOrder())).collect(Collectors.toList());
                        multiRowEntity.removeAll(collect);
                        multiRowEntity.addAll(collect);
                        collect = (collect.isEmpty() ? multiRowEntity : collect).stream().filter(dy -> !HRObjectUtils.isEmpty((Object)dy.getDate("admissiondate"))).sorted(Comparator.comparing(dy -> dy.getDate("admissiondate"), Comparator.reverseOrder())).collect(Collectors.toList());
                        multiRowEntity.removeAll(collect);
                        multiRowEntity.addAll(collect);
                    }
                    this.syncMutilInfoGroupData(multiRowEntity, (InfoGroupEntity)infoGroupEntity, (List)stringListEntry.getValue(), keyIndexMap, attachEntityList);
                }
                if (hcfMultiMap.containsKey("hcf_educertificate")) {
                    this.syncCandidateEduCertifiate(candidateId, attachEntityList, (InfoGroupEntity)infoGroupEntity, keyIndexMap, hcfMultiMap);
                }
            } else {
                infoGroupEntity.getInfoGroupFieldList().forEach(field -> {
                    String pageKey = field.getPageKey();
                    map.put(pageKey, infoGroupEntity);
                    if (pageKey.contains("hcf_")) {
                        ((ISyncCollectToHcf)ServiceFactory.getService(ISyncCollectToHcf.class)).fillEntityMap(hcfSingleMap, field, pageKey);
                    } else {
                        ((ISyncCollectToHcf)ServiceFactory.getService(ISyncCollectToHcf.class)).fillEntityMap(homEntityMap, field, pageKey);
                    }
                });
            }
        });
        for (Map.Entry stringListEntry : hcfSingleMap.entrySet()) {
            pageKey = (String)stringListEntry.getKey();
            if ("hcf_canaddress".equals(pageKey)) {
                DynamicObjectCollection canAddressDynamicObject = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, pageKey);
                canAddressDynamicObject.forEach(dynamicObject -> {
                    String addressType = dynamicObject.getString("addresstype.id");
                    String confVal = ((IHomConfigService)ServiceFactory.getService(IHomConfigService.class)).getConfVal("ADDRESS_ID_MAP", "");
                    if (HRStringUtils.isNotEmpty((String)confVal)) {
                        Map tempMap = (Map)JSONObject.parseObject((String)confVal, Map.class);
                        InfoGroupFieldConstants.ADDRESS_ID_MAP.putAll(tempMap);
                    }
                    for (Map.Entry stringLongEntry : InfoGroupFieldConstants.ADDRESS_ID_MAP.entrySet()) {
                        Object obj;
                        String key = (String)stringLongEntry.getKey();
                        if (!key.startsWith(addressType + "_")) continue;
                        String fieldKey = key.substring((addressType + "_").length());
                        Long fieldId = (Long)stringLongEntry.getValue();
                        try {
                            obj = dynamicObject.get(fieldKey);
                        }
                        catch (Exception e) {
                            logger.warn("###canAddressDynamicObject exception:", (Throwable)e);
                            continue;
                        }
                        this.setValue(fieldId, obj);
                    }
                });
                continue;
            }
            singleRowEntity = IHomToHcfAppService.getInstance().getSingleRowEntity(candidateId, pageKey);
            if (singleRowEntity == null) continue;
            value = (List)stringListEntry.getValue();
            for (InfoGroupEntity.InfoGroupField infoGroupField : value) {
                this.getModel().setValue("field" + infoGroupField.getFieldId(), singleRowEntity.get(infoGroupField.getFieldKey()));
                iDataEntityProperty = (IDataEntityProperty)singleRowEntity.getDataEntityType().getProperties().get((Object)infoGroupField.getFieldKey());
                if (!(iDataEntityProperty instanceof BasedataProp) || HRObjectUtils.isEmpty((Object)(dynamicObject2 = singleRowEntity.getDynamicObject(infoGroupField.getFieldKey())))) continue;
                this.getModel().getDataEntity().set("field" + infoGroupField.getFieldId() + "_id", (Object)dynamicObject2.getLong("id"));
            }
            this.getModel().getDataEntity().set("field" + ((InfoGroupEntity)map.get(pageKey)).getInfoGroupId(), (Object)singleRowEntity.getLong("id"));
        }
        for (Map.Entry stringListEntry : homEntityMap.entrySet()) {
            pageKey = (String)stringListEntry.getKey();
            if ("hom_standardfield".equalsIgnoreCase(pageKey) || (singleRowEntity = HomCommonRepository.queryDynamicObjectByPk((String)pageKey, (String)"", (Object)onboardId)) == null) continue;
            value = (List)stringListEntry.getValue();
            for (InfoGroupEntity.InfoGroupField infoGroupField : value) {
                if (infoGroupField.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
                    AttachmentPanel attachmentEdit = (AttachmentPanel)this.getView().getControl("field" + infoGroupField.getFieldId());
                    List attachments = AttachmentServiceHelper.getAttachments((String)infoGroupField.getPageKey(), (Object)onboardId, (String)infoGroupField.getFieldKey());
                    IClientViewProxy proxy = (IClientViewProxy)attachmentEdit.getView().getService(IClientViewProxy.class);
                    proxy.setFieldProperty(attachmentEdit.getKey(), "v", (Object)attachments);
                    this.getView().getPageCache().put(attachmentEdit.getKey(), SerializationUtils.toJsonString((Object)attachments));
                    ((ICollectService)ServiceFactory.getService(ICollectService.class)).dynEntityBindAttach(attachments, attachmentEdit.getKey(), this.getView());
                    continue;
                }
                iDataEntityProperty = (IDataEntityProperty)singleRowEntity.getDataEntityType().getProperties().get((Object)infoGroupField.getFieldKey());
                this.getModel().setValue("field" + infoGroupField.getFieldId(), singleRowEntity.get(infoGroupField.getFieldKey()));
                if (!(iDataEntityProperty instanceof BasedataProp) || HRObjectUtils.isEmpty((Object)(dynamicObject2 = singleRowEntity.getDynamicObject(infoGroupField.getFieldKey())))) continue;
                this.getModel().getDataEntity().set("field" + infoGroupField.getFieldId() + "_id", (Object)dynamicObject2.getLong("id"));
            }
            if (!(singleRowEntity.getDataEntityType().getProperties().get((Object)((InfoGroupEntity.InfoGroupField)value.get(0)).getFieldKey()) instanceof BasedataProp)) continue;
            this.getModel().getDataEntity().set("field" + ((InfoGroupEntity.InfoGroupField)value.get(0)).getFieldId() + "_id", (Object)singleRowEntity.getLong(((InfoGroupEntity.InfoGroupField)value.get(0)).getFieldKey() + ".id"));
        }
        this.getPageCache().put("cacheAttach", JSON.toJSONString(attachEntityList));
    }

    private void syncCandidateEduCertifiate(Long candidateId, List<InfoGroupAttachEntity> attachEntityList, InfoGroupEntity infoGroupEntity, Map<Long, Integer> keyIndexMap, Map<String, List<InfoGroupEntity.InfoGroupField>> hcfMultiMap) {
        String pageKey = "hcf_educertificate";
        DynamicObjectCollection multiRowEntity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, pageKey);
        if (CollectionUtils.isEmpty((Collection)multiRowEntity)) {
            return;
        }
        Map<Long, List<DynamicObject>> originDataMap = multiRowEntity.stream().filter(dynamicObject -> !HRObjectUtils.isEmpty((Object)dynamicObject.get("edu"))).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("edu.id")));
        Map<String, List<InfoGroupEntity.InfoGroupField>> fieldGroupMap = hcfMultiMap.get(pageKey).stream().collect(Collectors.groupingBy(field -> (String)InfoGroupFieldConstants.EDU_CERTIFICATE_MAP.get(field.getFieldId())));
        for (Map.Entry<Long, List<DynamicObject>> longListEntry : originDataMap.entrySet()) {
            long eduId = longListEntry.getKey();
            Integer index = keyIndexMap.get(eduId);
            if (HRObjectUtils.isEmpty((Object)index)) continue;
            List<DynamicObject> value = longListEntry.getValue();
            value.forEach(dynamicObject -> {
                String certtype = dynamicObject.getString("certtype.id");
                List fieldList = (List)fieldGroupMap.get(certtype);
                if (CollectionUtils.isEmpty((Collection)fieldList)) {
                    return;
                }
                for (InfoGroupEntity.InfoGroupField infoGroupField : fieldList) {
                    if (Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType()) == infoGroupField.getFieldType()) {
                        List attachments = AttachmentServiceHelper.getAttachments((String)infoGroupField.getPageKey(), (Object)dynamicObject.getLong("id"), (String)infoGroupField.getFieldKey());
                        attachEntityList.add(new InfoGroupAttachEntity("field" + infoGroupField.getFieldId() + "_" + eduId, attachments));
                        continue;
                    }
                    this.getModel().setValue("entryfield" + infoGroupField.getFieldId(), dynamicObject.get(infoGroupField.getFieldKey()), index.intValue());
                    if (!(dynamicObject.getDataEntityType().getProperties().get((Object)infoGroupField.getFieldKey()) instanceof BasedataProp)) continue;
                    ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase()).get(index.intValue())).set("entryfield" + infoGroupField.getFieldId() + "_id", dynamicObject.get(infoGroupField.getFieldKey() + ".id"));
                }
            });
        }
    }

    private void syncMutilInfoGroupData(DynamicObjectCollection multiRowEntity, InfoGroupEntity infoGroupEntity, List<InfoGroupEntity.InfoGroupField> value, Map<Long, Integer> keyIndexMap, List<InfoGroupAttachEntity> attachEntityList) {
        int[] ints = this.getModel().batchCreateNewEntryRow("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase(), multiRowEntity.size());
        IntStream.range(0, multiRowEntity.size()).forEach(index -> {
            keyIndexMap.put(((DynamicObject)multiRowEntity.get(index)).getLong("id"), ints[index]);
            for (InfoGroupEntity.InfoGroupField infoGroupField : value) {
                if (Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType()) == infoGroupField.getFieldType()) {
                    List attachments = AttachmentServiceHelper.getAttachments((String)infoGroupField.getPageKey(), (Object)((DynamicObject)multiRowEntity.get(index)).getLong("id"), (String)infoGroupField.getFieldKey());
                    attachEntityList.add(new InfoGroupAttachEntity("field" + infoGroupField.getFieldId() + "_" + ((DynamicObject)multiRowEntity.get(index)).getLong("id"), attachments));
                    continue;
                }
                if (InfoGroupEnum.CERTIFICATE_INFO.getNumber().equals(infoGroupEntity.getInfoGroupNumber()) && infoGroupField.getFieldId().equals(InfoGroupFieldConstants.CERT_TYPE)) {
                    ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase()).get(ints[index])).set("entryfieldcert", (Object)((DynamicObject)multiRowEntity.get(index)).getString(infoGroupField.getFieldKey() + ".id"));
                }
                if (infoGroupField.getFieldId().equals(InfoGroupFieldConstants.RSM_PTDATA)) {
                    ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase()).get(ints[index])).set("entryfield" + infoGroupField.getFieldId() + "_ptstartdate", ((DynamicObject)multiRowEntity.get(index)).get("ptstartdate"));
                    ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase()).get(ints[index])).set("entryfield" + infoGroupField.getFieldId() + "_ptendingdate", ((DynamicObject)multiRowEntity.get(index)).get("ptendingdate"));
                } else if (((DynamicObject)multiRowEntity.get(index)).getDataEntityType().getProperties().get((Object)infoGroupField.getFieldKey()) instanceof MulBasedataProp) {
                    MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)((DynamicObject)multiRowEntity.get(index)).get(infoGroupField.getFieldKey());
                    MulBasedataDynamicObjectCollection newMul = new MulBasedataDynamicObjectCollection();
                    MulBasedataProp iDataEntityProperty = (MulBasedataProp)((DynamicObject)multiRowEntity.get(index)).getDataEntityType().getProperties().get((Object)infoGroupField.getFieldKey());
                    mulBasedataDynamicObjectCollection.forEach(dynamicObject -> {
                        long id = dynamicObject.getLong("fbasedataid_id");
                        newMul.add(BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)iDataEntityProperty.getBaseEntityId()));
                    });
                    if (!CollectionUtils.isEmpty((Collection)newMul)) {
                        this.getModel().setValue("entryfield" + infoGroupField.getFieldId(), (Object)newMul, ints[index]);
                    }
                } else {
                    this.getModel().setValue("entryfield" + infoGroupField.getFieldId(), ((DynamicObject)multiRowEntity.get(index)).get(infoGroupField.getFieldKey()), ints[index]);
                }
                if (((DynamicObject)multiRowEntity.get(index)).getDataEntityType().getProperties().get((Object)infoGroupField.getFieldKey()) instanceof BasedataProp) {
                    ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase()).get(ints[index])).set("entryfield" + infoGroupField.getFieldId() + "_id", ((DynamicObject)multiRowEntity.get(index)).get(infoGroupField.getFieldKey() + ".id"));
                }
                if (!HRObjectUtils.isEmpty((Object)((DynamicObject)multiRowEntity.get(index)).getDynamicObjectType().getProperties().get((Object)"boid"))) {
                    ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase()).get(ints[index])).set("entryid", ((DynamicObject)multiRowEntity.get(index)).get("boid"));
                    continue;
                }
                if (HRObjectUtils.isEmpty((Object)((DynamicObject)multiRowEntity.get(index)).getDynamicObjectType().getProperties().get((Object)"id"))) continue;
                ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase()).get(ints[index])).set("entryid", ((DynamicObject)multiRowEntity.get(index)).get("id"));
            }
            this.getModel().setValue("entryfield" + ((InfoGroupEntity.InfoGroupField)value.get(0)).getFieldId(), ((DynamicObject)multiRowEntity.get(index)).get(((InfoGroupEntity.InfoGroupField)value.get(0)).getFieldKey()), ints[index]);
            if (((DynamicObject)multiRowEntity.get(index)).getDataEntityType().getProperties().get((Object)((InfoGroupEntity.InfoGroupField)value.get(0)).getFieldKey()) instanceof BasedataProp) {
                ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase()).get(ints[index])).set("entryfield" + ((InfoGroupEntity.InfoGroupField)value.get(0)).getFieldId() + "_id", ((DynamicObject)multiRowEntity.get(index)).get(((InfoGroupEntity.InfoGroupField)value.get(0)).getFieldKey() + ".id"));
            }
        });
    }

    private void setValue(Long fieldId, Object object) {
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)this.getModel().getDataEntityType().getProperties().get((Object)("field" + fieldId));
        if (HRObjectUtils.isEmpty((Object)iDataEntityProperty) || object == null || HRStringUtils.isEmpty((String)object.toString()) || HRObjectUtils.isEmpty((Object)object)) {
            return;
        }
        if (iDataEntityProperty instanceof BasedataProp) {
            this.getModel().getDataEntity().set("field" + fieldId + "_id", ((DynamicObject)object).get("id"));
        }
        this.getModel().setValue("field" + fieldId, object);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("AbstractCollTemplateViewPlugin", exp.getMessage()), new Object[0]);
        }
        InfoGroupConfigEntity infoGroupConfigData = this.getInfoGroupConfigData();
        boolean formtype = CollectDynFormTypeEnum.MANAGE.getFormType().equals(this.getView().getFormShowParameter().getCustomParam("formtype"));
        List infoGroupEntityList = infoGroupConfigData.getInfoGroupEntityList();
        MainEntityType finalNewMainType = newMainType;
        infoGroupEntityList.forEach(infoGroupEntity -> {
            List infoGroupFieldList = infoGroupEntity.getInfoGroupFieldList();
            infoGroupFieldList.forEach(infoGroupField -> {
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)infoGroupField.getPageKey()));
                ((ICollectService)ServiceFactory.getService(ICollectService.class)).registerDynamicProps("field", (DynamicObjectType)finalNewMainType, infoGroupField, dynamicObject, "");
            });
            if (formtype && infoGroupEntity.isMultipleEntity()) {
                DynamicObjectType newtype = new DynamicObjectType("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase());
                EntryProp entryProp = new EntryProp("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase(), newtype);
                entryProp.setName("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase());
                entryProp.setDisplayName(ResManager.getLocaleString((String)"\u540d\u79f0", (String)"InfoGroupDynViewPlugin_0", (String)"hr-hom-formplugin"));
                entryProp.setDbIgnore(false);
                entryProp.setDefaultRows(0);
                DynamicSimpleProperty entryfield = new DynamicSimpleProperty("entryfieldtext", Long.class, null);
                DynamicSimpleProperty idPro = new DynamicSimpleProperty("entryid", Long.class, null);
                DynamicSimpleProperty boIdPro = new DynamicSimpleProperty("boid", Long.class, null);
                DynamicSimpleProperty seqPro = new DynamicSimpleProperty("seq", Integer.class, null);
                newtype.registerSimpleProperty(entryfield);
                newtype.registerSimpleProperty(idPro);
                newtype.registerSimpleProperty(boIdPro);
                newtype.registerSimpleProperty(seqPro);
                infoGroupFieldList.forEach(infoGroupField -> {
                    DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)infoGroupField.getPageKey()));
                    ((ICollectService)ServiceFactory.getService(ICollectService.class)).registerDynamicProps("entryfield", newtype, infoGroupField, dynamicObject, "");
                });
                ComboProp fieldProp = new ComboProp();
                fieldProp.setName("entryfieldcert");
                fieldProp.setDisplayName(ResManager.getLocaleString((String)"\u8bc1\u4ef6\u7c7b\u578b", (String)"CollectActivityAddPlugin_0", (String)"hr-hom-formplugin"));
                fieldProp.setDbIgnore(true);
                fieldProp.setDefValue((Object)"");
                Arrays.stream(InfoGroupCertTypeEnum.values()).forEach(infoGroupCertTypeEnum -> {
                    ValueMapItem valueMapItem = new ValueMapItem();
                    valueMapItem.setValue(infoGroupCertTypeEnum.getId().toString());
                    valueMapItem.setName(new LocaleString(infoGroupCertTypeEnum.getName()));
                    fieldProp.getComboItems().add(valueMapItem);
                });
                newtype.registerSimpleProperty((DynamicSimpleProperty)fieldProp);
                finalNewMainType.registerCollectionProperty((DynamicCollectionProperty)entryProp);
            } else {
                DynamicFiledViewServiceFactory.getDynamicFiledViewService((String)"LongProp").registerDynamicProps((DynamicObjectType)finalNewMainType, "field" + infoGroupEntity.getInfoGroupId(), null, "id", new InfoGroupEntity.InfoGroupField());
            }
        });
        ComboProp comboProp = new ComboProp();
        comboProp.setName("fieldcerttype");
        comboProp.setDisplayName(ResManager.getLocaleString((String)"\u8bc1\u4ef6\u7c7b\u578b", (String)"CollectActivityAddPlugin_0", (String)"hr-hom-formplugin"));
        comboProp.setDbIgnore(true);
        Arrays.stream(InfoGroupCertTypeEnum.values()).forEach(infoGroupCertTypeEnum -> {
            ValueMapItem valueMapItem = new ValueMapItem();
            valueMapItem.setValue(infoGroupCertTypeEnum.getId().toString());
            valueMapItem.setName(new LocaleString(infoGroupCertTypeEnum.getName()));
            comboProp.getComboItems().add(valueMapItem);
        });
        finalNewMainType.registerSimpleProperty((DynamicSimpleProperty)comboProp);
        e.setNewEntityType(finalNewMainType);
    }

    private void transferEntityToFlex() {
        boolean formtype = CollectDynFormTypeEnum.MANAGE.getFormType().equals(this.getView().getFormShowParameter().getCustomParam("formtype"));
        if (!formtype) {
            return;
        }
        this.showInfoGroupFormShowParameter();
    }

    @Override
    public void tabSelected(TabSelectEvent tabSelectEvent) {
        super.tabSelected(tabSelectEvent);
        this.showInfoGroupFormShowParameter();
    }

    @Override
    protected IFormView getDynView() {
        return this.getView();
    }

    private void showInfoGroupFormShowParameter() {
        InfoGroupConfigEntity infoGroupConfigData = this.getInfoGroupConfigData();
        InfoGroupEntity infoGroupEntity = this.getCurrentInfoGroup();
        if (!infoGroupEntity.isMultipleEntity()) {
            return;
        }
        String entityKey = "entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entityKey);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setTargetKey("entryDataflex" + infoGroupEntity.getInfoGroupNumber().toLowerCase());
            formShowParameter.setFormId("hom_emptypage");
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            this.getView().showForm(formShowParameter);
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setTargetKey("entryDataflex" + infoGroupEntity.getInfoGroupNumber().toLowerCase());
        formShowParameter.setCustomParam("param", (Object)infoGroupEntity);
        formShowParameter.setCustomParam("config", (Object)infoGroupConfigData);
        dynamicObjectCollection.forEach(this::dealBaseData);
        formShowParameter.setCustomParam("data", (Object)dynamicObjectCollection);
        formShowParameter.setCustomParam("image", this.getApImageMap());
        formShowParameter.setCustomParam("status", this.getView().getFormShowParameter().getCustomParam("status"));
        Object approve = this.getView().getFormShowParameter().getCustomParam("approve");
        if (!HRObjectUtils.isEmpty((Object)approve)) {
            formShowParameter.setCustomParam("approve", approve);
            formShowParameter.setFormId("hom_multipleinfogroupapp");
        } else {
            formShowParameter.setFormId("hom_multipleinfogroup");
        }
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        this.getView().showForm(formShowParameter);
        this.getPageCache().put("multiPageIdList", formShowParameter.getPageId());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.startsWith("addentity")) {
            DynamicObjectCollection dynamicObjectCollection;
            InfoGroupConfigEntity infoGroupConfigData = this.getInfoGroupConfigData();
            ArrayList fieldIdList = new ArrayList();
            infoGroupConfigData.getInfoGroupEntityList().forEach(infoGroupEntity -> fieldIdList.addAll(infoGroupEntity.getInfoGroupFieldList().stream().map(field -> String.valueOf(field.getFieldId())).collect(Collectors.toList())));
            Object returnData = closedCallBackEvent.getReturnData();
            if (Objects.isNull(returnData)) {
                return;
            }
            Map data = (Map)returnData;
            DynamicObject dynamicObject = (DynamicObject)data.get("dyn");
            String infoGroupNumber = actionId.substring(9).toLowerCase();
            if (infoGroupNumber.equalsIgnoreCase(InfoGroupEnum.EDUCATIONAL_EXPERIENCE.getNumber()) && dynamicObject.getDataEntityType().getProperties().containsKey((Object)("field" + InfoGroupFieldConstants.EDU_IS_HIGHEST_DEGREE)) && dynamicObject.getBoolean("field" + InfoGroupFieldConstants.EDU_IS_HIGHEST_DEGREE)) {
                dynamicObjectCollection = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupNumber);
                dynamicObjectCollection.forEach(dy -> dy.set("entryfield" + InfoGroupFieldConstants.EDU_IS_HIGHEST_DEGREE, (Object)Boolean.FALSE));
            }
            if (infoGroupNumber.equalsIgnoreCase(InfoGroupEnum.CERTIFICATE_INFO.getNumber()) && dynamicObject.getDataEntityType().getProperties().containsKey((Object)("field" + InfoGroupFieldConstants.ISMAJOR_CERT)) && dynamicObject.getBoolean("field" + InfoGroupFieldConstants.ISMAJOR_CERT)) {
                dynamicObjectCollection = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupNumber);
                dynamicObjectCollection.forEach(dy -> dy.set("entryfield" + InfoGroupFieldConstants.ISMAJOR_CERT, (Object)Boolean.FALSE));
            }
            Map attachMap = (Map)data.get("attach");
            logger.info("InfoGroupDynViewPlugin attach json : {}", (Object)SerializationUtils.toJsonString(data.get("attach")));
            int[] ints = this.getModel().batchCreateNewEntryRow("entryap" + infoGroupNumber, 1);
            DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
            properties.forEach(propertie -> {
                if ("fieldcerttype".equals(propertie.getName())) {
                    ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupNumber).get(ints[0])).set("entryfieldcert", dynamicObject.get(propertie.getName()));
                    ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupNumber).get(ints[0])).set("entryfield" + InfoGroupFieldConstants.CERT_TYPE + "_id", dynamicObject.get(propertie.getName()));
                    return;
                }
                if (propertie.getName().length() < 24) {
                    return;
                }
                String idStr = propertie.getName().substring(5, 24);
                if (idStr.equals(InfoGroupFieldConstants.CERT_TYPE.toString())) {
                    return;
                }
                if (propertie instanceof BasedataProp) {
                    if (!fieldIdList.contains(idStr)) {
                        return;
                    }
                    if (Objects.isNull(dynamicObject.get(propertie.getName())) && Objects.isNull(dynamicObject.get(propertie.getName() + "_id"))) {
                        ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupNumber).get(ints[0])).set("entryfield" + idStr, null);
                        ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupNumber).get(ints[0])).set("entryfield" + idStr + "_id", (Object)0L);
                        return;
                    }
                    ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupNumber).get(ints[0])).set("entryfield" + idStr, dynamicObject.get(propertie.getName() + "_id"));
                    ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupNumber).get(ints[0])).set("entryfield" + idStr + "_id", dynamicObject.get(propertie.getName() + "_id"));
                } else {
                    if (!fieldIdList.contains(idStr)) {
                        return;
                    }
                    if (Objects.isNull(dynamicObject.get(propertie.getName()))) {
                        ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupNumber).get(ints[0])).set("entry" + propertie.getName(), null);
                        return;
                    }
                    ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupNumber).get(ints[0])).set("entry" + propertie.getName(), dynamicObject.get(propertie.getName()));
                }
            });
            InfoGroupEntity infoGroupEntity2 = infoGroupConfigData.getInfoGroupEntityList().stream().filter(infoGroup -> infoGroup.getInfoGroupNumber().equalsIgnoreCase(infoGroupNumber)).findFirst().get();
            Long candidateId = this.getView().getParentView().getModel().getDataEntity().getLong("onboard.candidate.id");
            ArrayList visibleFiledList = new ArrayList();
            if (infoGroupNumber.equalsIgnoreCase(InfoGroupEnum.CERTIFICATE_INFO.getNumber())) {
                DynamicObjectCollection dynamicObjectCollection2 = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupNumber);
                Map infoGroupConfigFieldCertMap = (Map)JSON.parseObject((String)this.getPageCache().get("certConfigMap"), Map.class);
                IntStream.range(0, dynamicObjectCollection2.size()).forEach(index -> {
                    DynamicObject dy = (DynamicObject)dynamicObjectCollection2.get(index);
                    String certType = dy.getString("entryfield" + InfoGroupFieldConstants.CERT_TYPE + "_id");
                    if (CollectionUtils.isEmpty((Collection)((Collection)infoGroupConfigFieldCertMap.getOrDefault(certType, infoGroupConfigFieldCertMap.get("9999"))))) {
                        return;
                    }
                    List showFieldList = (List)infoGroupConfigFieldCertMap.getOrDefault(certType, infoGroupConfigFieldCertMap.get("9999"));
                    List hiddenField = dy.getDynamicObjectType().getProperties().stream().filter(propertie -> propertie.getName().startsWith("entryfield")).filter(propertie -> !showFieldList.contains(propertie.getName().replace("entry", ""))).map(propertie -> propertie.getName() + index).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(hiddenField)) {
                        return;
                    }
                    visibleFiledList.addAll(hiddenField);
                });
            }
            this.cacheAttach(this.getView(), attachMap, -1L, infoGroupEntity2);
            long entryid = ((ISyncCollectToHcf)ServiceFactory.getService(ISyncCollectToHcf.class)).saveMultiEntityByInfoGroup(infoGroupEntity2, this.getView(), candidateId, visibleFiledList);
            ((DynamicObject)this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupNumber).get(ints[0])).set("entryid", (Object)entryid);
            if (infoGroupNumber.equalsIgnoreCase(InfoGroupEnum.EDUCATIONAL_EXPERIENCE.getNumber())) {
                DynamicObjectCollection dynamicObjectCollection3 = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupNumber);
                List collect = null;
                if (!HRObjectUtils.isEmpty((Object)this.getModel().getProperty("entryfield" + InfoGroupFieldConstants.EDU_STARTTIME))) {
                    collect = dynamicObjectCollection3.stream().filter(dy -> !HRObjectUtils.isEmpty((Object)dy.getDate("entryfield" + InfoGroupFieldConstants.EDU_STARTTIME))).sorted(Comparator.comparing(dy -> dy.getDate("entryfield" + InfoGroupFieldConstants.EDU_STARTTIME), Comparator.reverseOrder())).collect(Collectors.toList());
                    dynamicObjectCollection3.removeAll(collect);
                    dynamicObjectCollection3.addAll(collect);
                }
                if (!HRObjectUtils.isEmpty((Object)this.getModel().getProperty("entryfield" + InfoGroupFieldConstants.EDU_ENDTIME))) {
                    collect = (collect == null || collect.isEmpty() ? dynamicObjectCollection3 : collect).stream().filter(dy -> !HRObjectUtils.isEmpty((Object)dy.getDate("entryfield" + InfoGroupFieldConstants.EDU_ENDTIME))).sorted(Comparator.comparing(dy -> dy.getDate("entryfield" + InfoGroupFieldConstants.EDU_ENDTIME), Comparator.reverseOrder())).collect(Collectors.toList());
                    dynamicObjectCollection3.removeAll(collect);
                    dynamicObjectCollection3.addAll(collect);
                }
            }
            this.cacheAttach(this.getView(), attachMap, entryid, infoGroupEntity2);
            this.removeCacheAttach(this.getView(), attachMap, -1L, infoGroupEntity2);
            if (infoGroupNumber.equalsIgnoreCase(InfoGroupEnum.CERTIFICATE_INFO.getNumber()) && dynamicObject.getDataEntityType().getProperties().containsKey((Object)("field" + InfoGroupFieldConstants.ISMAJOR_CERT)) && dynamicObject.getBoolean("field" + InfoGroupFieldConstants.ISMAJOR_CERT)) {
                Long onboardId = this.getView().getParentView().getModel().getDataEntity().getLong("onboard.id");
                ((ICollectService)ServiceFactory.getService(ICollectService.class)).syncMajorCertInfo(candidateId, onboardId);
            }
            ((ICollectService)ServiceFactory.getService(ICollectService.class)).syncSubmitPro(Long.valueOf(this.getView().getParentView().getModel().getDataEntity().getLong("onboard.id")));
            ((ICollectGroupStatusService)ServiceFactory.getService(ICollectGroupStatusService.class)).completeCollectGroup(Collections.singletonList(infoGroupEntity2.getInfoGroupId()), Long.valueOf(this.getView().getParentView().getModel().getDataEntity().getLong("id")));
            this.transferEntityToFlex();
        }
    }

    private Map<String, List<ImageCacheEntity>> getApImageMap() {
        IPageCache pageCache = this.getPageCache();
        String apImageStr = pageCache.get("apImage");
        Map<String, List<Object>> apImageMap = new HashMap<String, List<ImageCacheEntity>>();
        if (HRStringUtils.isNotEmpty((String)apImageStr)) {
            apImageMap = (Map)JSON.parse((String)apImageStr);
        }
        return apImageMap;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        InfoGroupConfigEntity infoGroupConfigEntity = this.getInfoGroupConfigData();
        Object formType = this.getView().getFormShowParameter().getCustomParam("formtype");
        boolean isDataView = CollectDynFormTypeEnum.MANAGE.getFormType().equals(formType);
        DynViewParamEntity dynViewParamEntity = new DynViewParamEntity.Builder().setDataView(isDataView).setApprove(this.isApprove()).setStatus((String)this.getView().getFormShowParameter().getCustomParam("status")).build();
        FlexPanelAp flexPanelAp = this.loadMetas(null, infoGroupConfigEntity, dynViewParamEntity);
        Container flexPanel = (Container)this.getView().getControl("infogroupflex");
        flexPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(flexPanel.getItems());
        this.getModel().updateCache();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnableFiled();
        this.transferEntityToFlex();
        this.beginInitFieldShow();
        this.pageFieldShow();
        this.endInitFieldShow();
    }

    private void beginInitFieldShow() {
        this.hideFieldList.clear();
        this.showFieldList.clear();
        this.nonApproveFieldList.clear();
        this.disableFieldList.clear();
        this.enableFieldList.clear();
    }

    private void endInitFieldShow() {
        this.getView().setVisible(Boolean.FALSE, this.hideFieldList.toArray(new String[0]));
        this.getView().setVisible(Boolean.TRUE, this.showFieldList.toArray(new String[0]));
        this.getView().setEnable(Boolean.FALSE, this.disableFieldList.toArray(new String[0]));
        this.getView().setEnable(Boolean.TRUE, this.enableFieldList.toArray(new String[0]));
        this.getModel().setDataChanged(false);
    }

    private void pageFieldShow() {
        boolean isEnroll;
        InfoGroupConfigEntity infoGroupConfigData = this.getInfoGroupConfigData();
        String pageId = this.getView().getParentView().getEntityId();
        if (!"hom_infocollectconfig".equals(pageId) && ((isEnroll = IOnbrdBillDomainService.getInstance().isCanOperate(Long.valueOf(this.getView().getParentView().getModel().getDataEntity().getLong("onboard.id")))) || OperationStatus.VIEW.equals((Object)this.getView().getParentView().getFormShowParameter().getStatus()))) {
            if ("hom_collectmanagesub".equals(pageId)) {
                pageId = "hom_collectmanagefin";
            } else if ("hom_collectapprovereject".equals(pageId)) {
                pageId = "hom_collectapprovepass";
            }
        }
        this.PAGE_MAP.getOrDefault(pageId, this::defaultShowView).accept(infoGroupConfigData);
        String cacheSingleButton = this.getPageCache().get("cacheSingleButton");
        if (HRStringUtils.isEmpty((String)cacheSingleButton)) {
            return;
        }
        List<String> cacheSingleButtonList = Arrays.asList(cacheSingleButton.split(","));
        for (String singleButton : cacheSingleButtonList) {
            String saveButton = "savesingle" + singleButton;
            String cancelButton = "cancelsingle" + singleButton;
            this.showFieldList.add(saveButton);
            this.showFieldList.add(cancelButton);
            this.enableFieldList.add("infogroupfield" + singleButton);
        }
    }

    private void collectApproveFailView(InfoGroupConfigEntity infoGroupConfigEntity) {
        this.hideFieldList.add("flexpanelap");
        infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroup -> {
            String suffix = infoGroup.getInfoGroupNumber().toLowerCase();
            if (infoGroup.isMultipleEntity()) {
                this.hideFieldList.add("entryap" + suffix);
            }
            infoGroup.getInfoGroupFieldList().forEach(infoGroupField -> {
                this.disableFieldList.add("field" + infoGroupField.getFieldId());
                this.hideFieldList.add("approveoff" + infoGroupField.getFieldId());
                if (!infoGroupField.isFieldApprove()) {
                    this.hideFieldList.add("approveon" + infoGroupField.getFieldId());
                }
            });
        });
        this.hiddenButton(infoGroupConfigEntity);
    }

    private void collectManageSubView(InfoGroupConfigEntity infoGroupConfigEntity) {
        this.hideFieldList.add("flexpanelap");
        infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroup -> {
            String infoGroupNumber = infoGroup.getInfoGroupNumber().toLowerCase();
            if (infoGroup.isMultipleEntity()) {
                this.hideFieldList.add("entryap" + infoGroupNumber);
            } else {
                this.hideFieldList.add("cancelsingle" + infoGroupNumber);
                this.hideFieldList.add("savesingle" + infoGroupNumber);
                this.disableFieldList.add("infogroupfield" + infoGroup.getInfoGroupNumber().toLowerCase());
            }
            infoGroup.getInfoGroupFieldList().forEach(infoGroupField -> {
                this.hideFieldList.add("approveoff" + infoGroupField.getFieldId());
                this.hideFieldList.add("approveon" + infoGroupField.getFieldId());
            });
        });
    }

    private void collectManageFinView(InfoGroupConfigEntity infoGroupConfigEntity) {
        this.hideFieldList.add("flexpanelap");
        infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroup -> {
            String suffix = infoGroup.getInfoGroupNumber().toLowerCase();
            if (infoGroup.isMultipleEntity()) {
                this.hideFieldList.add("entryap" + suffix);
            }
            infoGroup.getInfoGroupFieldList().forEach(infoGroupField -> {
                this.disableFieldList.add("field" + infoGroupField.getFieldId());
                this.hideFieldList.add("approveoff" + infoGroupField.getFieldId());
                this.hideFieldList.add("approveon" + infoGroupField.getFieldId());
            });
        });
        this.hiddenButton(infoGroupConfigEntity);
    }

    private void collectApprovingView(InfoGroupConfigEntity infoGroupConfigEntity) {
        this.hideFieldList.add("flexpanelap");
        infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroup -> {
            String suffix = infoGroup.getInfoGroupNumber().toLowerCase();
            if (infoGroup.isMultipleEntity()) {
                this.hideFieldList.add("entryap" + suffix);
            }
            infoGroup.getInfoGroupFieldList().forEach(infoGroupField -> {
                this.disableFieldList.add("field" + infoGroupField.getFieldId());
                this.hideFieldList.add("approveoff" + infoGroupField.getFieldId());
                if (!infoGroupField.isFieldApprove()) {
                    this.hideFieldList.add("approveon" + infoGroupField.getFieldId());
                }
            });
        });
        this.hiddenButton(infoGroupConfigEntity);
    }

    private void collectApprovePassView(InfoGroupConfigEntity infoGroupConfigEntity) {
        this.hideFieldList.add("flexpanelap");
        infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroup -> {
            String suffix = infoGroup.getInfoGroupNumber().toLowerCase();
            if (infoGroup.isMultipleEntity()) {
                this.hideFieldList.add("entryap" + suffix);
            }
            infoGroup.getInfoGroupFieldList().forEach(infoGroupField -> {
                this.disableFieldList.add("field" + infoGroupField.getFieldId());
                this.hideFieldList.add("approveoff" + infoGroupField.getFieldId());
                if (!infoGroupField.isFieldApprove()) {
                    this.hideFieldList.add("approveon" + infoGroupField.getFieldId());
                }
            });
        });
        this.hiddenButton(infoGroupConfigEntity);
    }

    private void collectApproveRejectView(InfoGroupConfigEntity infoGroupConfigEntity) {
        this.hideFieldList.add("flexpanelap");
        infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroup -> {
            String infoGroupNumber = infoGroup.getInfoGroupNumber().toLowerCase();
            if (infoGroup.isMultipleEntity()) {
                this.hideFieldList.add("entryap" + infoGroupNumber);
            } else {
                this.hideFieldList.add("cancelsingle" + infoGroupNumber);
                this.hideFieldList.add("savesingle" + infoGroupNumber);
                this.disableFieldList.add("infogroupfield" + infoGroup.getInfoGroupNumber().toLowerCase());
            }
            infoGroup.getInfoGroupFieldList().forEach(infoGroupField -> {
                this.hideFieldList.add("approveoff" + infoGroupField.getFieldId());
                this.hideFieldList.add("approveon" + infoGroupField.getFieldId());
            });
        });
    }

    private void collectApproveRemitView(InfoGroupConfigEntity infoGroupConfigEntity) {
        this.hideFieldList.add("flexpanelap");
        infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroup -> {
            String suffix = infoGroup.getInfoGroupNumber().toLowerCase();
            if (infoGroup.isMultipleEntity()) {
                this.hideFieldList.add("entryap" + suffix);
            }
            infoGroup.getInfoGroupFieldList().forEach(infoGroupField -> {
                this.disableFieldList.add("field" + infoGroupField.getFieldId());
                this.hideFieldList.add("approveoff" + infoGroupField.getFieldId());
                this.hideFieldList.add("approveon" + infoGroupField.getFieldId());
            });
        });
        this.hiddenButton(infoGroupConfigEntity);
    }

    private void defaultShowView(InfoGroupConfigEntity infoGroupConfigEntity) {
        Control certTypeControl;
        boolean approve = this.isApprove();
        infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroup -> {
            String suffix = infoGroup.getInfoGroupNumber().toLowerCase();
            if (infoGroup.isMultipleEntity()) {
                if (approve) {
                    this.hideFieldList.add("addentity" + suffix);
                }
                this.hideFieldList.add("entryap" + suffix);
            } else {
                this.hideFieldList.add("savesingle" + suffix);
                this.hideFieldList.add("cancelsingle" + suffix);
                if (approve) {
                    this.hideFieldList.add("editsingle" + suffix);
                }
            }
            infoGroup.getInfoGroupFieldList().forEach(infoGroupField -> {
                this.hideFieldList.add("approveoff" + infoGroupField.getFieldId());
                this.hideFieldList.add("approveon" + infoGroupField.getFieldId());
                if (InfoGroupEnum.CERTIFICATE_INFO.getNumber().equalsIgnoreCase(suffix)) {
                    this.disableFieldList.add("field" + infoGroupField.getFieldId());
                }
            });
            this.disableFieldList.add("infogroupfield" + infoGroup.getInfoGroupNumber().toLowerCase());
        });
        Object formType = this.getView().getFormShowParameter().getCustomParam("formtype");
        if (!HRObjectUtils.isEmpty((Object)formType) && CollectDynFormTypeEnum.MANAGE.getFormType().equals(formType.toString())) {
            this.hideFieldList.add("flexpanelap");
        }
        if (!HRObjectUtils.isEmpty((Object)(certTypeControl = this.getControl("infogroup" + InfoGroupEnum.CERTIFICATE_INFO.getNumber().toLowerCase())))) {
            this.enableFieldList.add("infogroupfield" + InfoGroupEnum.CERTIFICATE_INFO.getNumber().toLowerCase());
            this.getView().setStatus(OperationStatus.EDIT);
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (HRObjectUtils.isEmpty((Object)this.getPageCache())) {
            return;
        }
        String infoGroupConfig = this.getPageCache().get("infoGroupConfig");
        if (StringUtils.isEmpty((Object)infoGroupConfig)) {
            return;
        }
        InfoGroupConfigEntity infoGroupConfigEntity = (InfoGroupConfigEntity)JSON.parseObject((String)infoGroupConfig, InfoGroupConfigEntity.class);
        ArrayList fieldList = new ArrayList();
        infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroupEntity -> {
            fieldList.addAll(infoGroupEntity.getInfoGroupFieldList());
            if (("infogroup" + infoGroupEntity.getInfoGroupNumber()).equalsIgnoreCase(key)) {
                TabPage tabPage = new TabPage();
                tabPage.setKey(key);
                tabPage.setView(this.getView());
                e.setControl((Control)tabPage);
            } else if (("addentity" + infoGroupEntity.getInfoGroupNumber()).equalsIgnoreCase(key) || ("savesingle" + infoGroupEntity.getInfoGroupNumber()).equalsIgnoreCase(key) || ("editsingle" + infoGroupEntity.getInfoGroupNumber()).equalsIgnoreCase(key) || ("cancelsingle" + infoGroupEntity.getInfoGroupNumber()).equalsIgnoreCase(key)) {
                Button button = new Button();
                button.setKey(key);
                button.setView(this.getView());
                button.addClickListener((ClickListener)this);
                this.setOperate(key, button);
                e.setControl((Control)button);
            } else if (("entryap" + infoGroupEntity.getInfoGroupNumber()).equalsIgnoreCase(key)) {
                EntryGrid entryGrid = new EntryGrid();
                entryGrid.setKey(key);
                entryGrid.setEntryKey(key);
                entryGrid.setView(this.getView());
                e.setControl((Control)entryGrid);
            }
        });
        if (key.endsWith("_id") && key.startsWith("entryfield")) {
            DecimalEdit decimalEdit = new DecimalEdit();
            decimalEdit.setKey(key);
            e.setControl((Control)decimalEdit);
            return;
        }
        Map<String, InfoGroupEntity.InfoGroupField> fieldIdList = fieldList.stream().collect(Collectors.toMap(field -> "field" + field.getFieldId(), obj -> obj, (key1, key2) -> key1));
        Map<String, InfoGroupEntity.InfoGroupField> entryFieldIdList = fieldList.stream().collect(Collectors.toMap(field -> "entryfield" + field.getFieldId(), obj -> obj, (key1, key2) -> key1));
        fieldIdList.putAll(entryFieldIdList);
        if (!fieldIdList.containsKey(key)) {
            return;
        }
        InfoGroupEntity.InfoGroupField infoGroupField = fieldIdList.get(key);
        this.setBaseControl(e, infoGroupField);
    }

    private void setOperate(String key, Button button) {
        if (key.startsWith("addentity")) {
            button.setOperationKey("addcollectdata");
        } else if (key.startsWith("savesingle")) {
            button.setOperationKey("savesingle");
        } else if (key.startsWith("editsingle")) {
            button.setOperationKey("editsingle");
        } else if (key.startsWith("cancelsingle")) {
            // empty if block
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        if (HRObjectUtils.isEmpty((Object)formShowParameter.getCustomParam("config"))) {
            return;
        }
        boolean isDataView = CollectDynFormTypeEnum.MANAGE.getFormType().equals(formShowParameter.getCustomParam("formtype"));
        InfoGroupConfigEntity infoGroupConfigEntity = (InfoGroupConfigEntity)formShowParameter.getCustomParam("config");
        DynViewParamEntity dynViewParamEntity = new DynViewParamEntity.Builder().setDataView(isDataView).setApprove(this.isApprove(formShowParameter)).setStatus((String)formShowParameter.getCustomParam("status")).build();
        FlexPanelAp infoGroupFlex = this.loadMetas(null, infoGroupConfigEntity, dynViewParamEntity);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("id", "infogroupflex");
        paramsMap.put("items", (String)infoGroupFlex.createControl().get("items"));
        e.getItems().add(paramsMap);
    }

    private EntryAp createDynamicEntryAp(InfoGroupEntity infoGroupEntity, InfoGroupConfigEntity infoGroupConfigEntity) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryap" + infoGroupEntity.getInfoGroupNumber());
        entryAp.setId("entryap" + infoGroupEntity.getInfoGroupNumber());
        List infoGroupFieldList = infoGroupEntity.getInfoGroupFieldList();
        infoGroupFieldList.forEach(infoGroupField -> {
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            entryFieldAp.setId("entryfield" + infoGroupField.getFieldId());
            entryFieldAp.setKey("entryfield" + infoGroupField.getFieldId());
            entryFieldAp.setName(new LocaleString(infoGroupField.getFieldName()));
            entryFieldAp.setFireUpdEvt(true);
            if (infoGroupField.getFieldType() != Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
                Field field = ((ICollectService)ServiceFactory.getService(ICollectService.class)).buildField(infoGroupField, "");
                field.setId("entryfield" + infoGroupField.getFieldId());
                field.setKey("entryfield" + infoGroupField.getFieldId());
                if (field instanceof DateRangeField) {
                    ((DateRangeField)field).setStartDateFieldKey("entry" + ((DateRangeField)field).getStartDateFieldKey());
                    ((DateRangeField)field).setStartDateFieldName("entry" + ((DateRangeField)field).getStartDateFieldName());
                    ((DateRangeField)field).setEndDateFieldName("entry" + ((DateRangeField)field).getEndDateFieldName());
                    ((DateRangeField)field).setEndDateFieldKey("entry" + ((DateRangeField)field).getEndDateFieldKey());
                }
                entryFieldAp.setField(field);
                entryFieldAp.setOpenSelector(true);
                entryFieldAp.setQuickAddNew(false);
                entryAp.getItems().add(entryFieldAp);
            }
        });
        if (InfoGroupEnum.CERTIFICATE_INFO.getNumber().equalsIgnoreCase(infoGroupEntity.getInfoGroupNumber())) {
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            entryFieldAp.setId("entryfieldcert");
            entryFieldAp.setKey("entryfieldcert");
            entryFieldAp.setName(ResManager.getLocaleString((String)"\u8bc1\u4ef6\u7c7b\u578b", (String)"CollectActivityAddPlugin_0", (String)"hr-hom-formplugin"));
            entryFieldAp.setFireUpdEvt(true);
            ComboField comboField = new ComboField();
            List infoGroupCertEntityList = infoGroupConfigEntity.getInfoGroupCertEntityList();
            ArrayList items = Lists.newArrayListWithCapacity((int)infoGroupCertEntityList.size());
            for (InfoGroupCertEntity infoGroupCertEntity : infoGroupCertEntityList) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(infoGroupCertEntity.getCertTypeName()));
                item.setValue(String.valueOf(infoGroupCertEntity.getCertTypeNumber()));
                items.add(item);
            }
            comboField.setItems((List)items);
            comboField.setId("entryfieldcert");
            comboField.setKey("entryfieldcert");
            entryFieldAp.setField((Field)comboField);
            entryAp.getItems().add(entryFieldAp);
        }
        return entryAp;
    }

    @Override
    protected FlexPanelAp loadMetas(InfoGroupEntity infoGroupEntity, InfoGroupConfigEntity infoGroupConfigEntity, DynViewParamEntity dynViewParamEntity) {
        FlexPanelAp infoGroupFlex = new HRFlexPanelAp.Builder("infogroupflex").setAlignItems("center").setWrap(true).build();
        TabAp tabAp = FlexBuildUtils.buildTabAp((String)"infogroup");
        infoGroupFlex.getItems().add(tabAp);
        List infoGroupEntityList = infoGroupConfigEntity.getInfoGroupEntityList();
        int index = 0;
        StringBuilder customerStyle = new StringBuilder();
        for (InfoGroupEntity infoGroup : infoGroupEntityList) {
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setIndex(index);
            this.buildTabPage(tabAp, infoGroup, tabPageAp);
            if (infoGroup.getMustInput().booleanValue()) {
                customerStyle.append("$ > div>div>div>div>div:nth-child(").append(index + 1).append(")>span:first-child:after { color:red;  content: '*'}\n");
            }
            FlexPanelAp fieldDataFlexAp = FlexBuildUtils.buildFlexPanelAp((String)("infogroupdataflex" + infoGroup.getInfoGroupNumber()));
            fieldDataFlexAp.setDirection("column");
            FlexPanelAp fieldDataFlexAp1 = FlexBuildUtils.buildFlexPanelAp((String)("infogroupdataflex1" + infoGroup.getInfoGroupNumber()));
            tabPageAp.getItems().add(fieldDataFlexAp);
            tabPageAp.getItems().add(fieldDataFlexAp1);
            fieldDataFlexAp1.setShrink(0);
            fieldDataFlexAp1.setWidth(new LocaleString("100%"));
            fieldDataFlexAp1.setAlignItems("stretch");
            fieldDataFlexAp1.setDirection("column");
            fieldDataFlexAp1.setGrow(1);
            fieldDataFlexAp.setAlignItems("stretch");
            fieldDataFlexAp.setDirection("column");
            fieldDataFlexAp.setGrow(1);
            fieldDataFlexAp.setWrap(false);
            if (dynViewParamEntity.isDataView()) {
                FlexPanelAp infoGroupField = FlexBuildUtils.buildFlexPanelAp((String)("infogroupop" + infoGroup.getInfoGroupNumber()));
                infoGroupField.setDirection("column");
                infoGroupField.setAlignItems("stretch");
                infoGroupField.setWrap(false);
                infoGroupField.setGrow(0);
                fieldDataFlexAp.getItems().add(infoGroupField);
                FlexPanelAp fieldFlexAp = FlexBuildUtils.buildFlexPanelAp((String)("addentityflex" + infoGroup.getInfoGroupNumber()));
                infoGroupField.getItems().add(fieldFlexAp);
                fieldFlexAp.setDirection("row");
                fieldFlexAp.setAlignItems("flex-start");
                fieldFlexAp.getStyle().getPadding().setLeft("12px");
                if (infoGroup.isMultipleEntity()) {
                    String add = ResManager.loadKDString((String)"\u65b0\u589e", (String)"InfoGroupDynViewPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                    ButtonAp button = this.buildButton("addentity" + infoGroup.getInfoGroupNumber(), add);
                    fieldFlexAp.getItems().add(button);
                    button.setOperationKey("addcollectdata");
                    button.setParentId("addentityflex" + infoGroup.getInfoGroupNumber());
                    EntryAp entryAp = this.createDynamicEntryAp(infoGroup, infoGroupConfigEntity);
                    EntryEntity entryEntity = new EntryEntity();
                    entryEntity.setId("entryap" + infoGroup.getInfoGroupNumber().toLowerCase());
                    entryEntity.setKey("entryap" + infoGroup.getInfoGroupNumber().toLowerCase());
                    entryEntity.setKeyEntry(false);
                    entryEntity.setDefaultRows(0);
                    entryEntity.setEntityMetadata(new EntityMetadata());
                    entryAp.setEntry(entryEntity);
                    fieldDataFlexAp.getItems().add(entryAp);
                    FlexPanelAp entryDataFlexAp = FlexBuildUtils.buildFlexPanelAp((String)("entryDataflex" + infoGroup.getInfoGroupNumber().toLowerCase()));
                    entryDataFlexAp.setWidth(new LocaleString("100%"));
                    fieldDataFlexAp.getItems().add(entryDataFlexAp);
                } else {
                    String save = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"InfoGroupDynViewPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                    ButtonAp saveButton = this.buildButton("savesingle" + infoGroup.getInfoGroupNumber(), save);
                    fieldFlexAp.getItems().add(saveButton);
                    saveButton.setParentId("addentityflex" + infoGroup.getInfoGroupNumber());
                    saveButton.setOperationKey("infogroupsave");
                    saveButton.setForeColor("#ffffff");
                    saveButton.setBackColor("themeColor");
                    saveButton.getStyle().getMargin().setBottom("16px");
                    saveButton.getStyle().getMargin().setRight("12px");
                    String cancel = ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InfoGroupDynViewPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                    ButtonAp cancelButton = this.buildButton("cancelsingle" + infoGroup.getInfoGroupNumber(), cancel);
                    fieldFlexAp.getItems().add(cancelButton);
                    cancelButton.setParentId("addentityflex" + infoGroup.getInfoGroupNumber());
                    cancelButton.getStyle().getMargin().setBottom("16px");
                    String edit = ResManager.loadKDString((String)"\u4fee\u6539", (String)"InfoGroupDynViewPlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                    ButtonAp editButton = this.buildButton("editsingle" + infoGroup.getInfoGroupNumber(), edit);
                    fieldFlexAp.getItems().add(editButton);
                    editButton.setParentId("addentityflex" + infoGroup.getInfoGroupNumber());
                    editButton.setOperationKey("infogroupedit");
                    editButton.getStyle().getMargin().setBottom("16px");
                    ((ICollectService)ServiceFactory.getService(ICollectService.class)).buildInfoGroupEntity(infoGroupConfigEntity, infoGroup, fieldDataFlexAp, dynViewParamEntity);
                }
            } else {
                ((ICollectService)ServiceFactory.getService(ICollectService.class)).buildInfoGroupEntity(infoGroupConfigEntity, infoGroup, fieldDataFlexAp, dynViewParamEntity);
            }
            ++index;
        }
        tabAp.setCustomeStyles(CustomStyleUtils.getStyleToBase64(customerStyle.toString()));
        return infoGroupFlex;
    }

    private void hiddenButton(InfoGroupConfigEntity infoGroupConfigEntity) {
        infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroupEntity -> {
            String infoGroupNumber = infoGroupEntity.getInfoGroupNumber().toLowerCase();
            if (infoGroupEntity.isMultipleEntity()) {
                this.hideFieldList.add("addentity" + infoGroupNumber);
            } else {
                this.hideFieldList.add("editsingle" + infoGroupNumber);
                this.hideFieldList.add("cancelsingle" + infoGroupNumber);
                this.hideFieldList.add("savesingle" + infoGroupNumber);
            }
        });
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("nothingchange".equals(messageBoxClosedEvent.getCallBackId()) && "yes".equalsIgnoreCase(messageBoxClosedEvent.getResultValue())) {
            this.clickCancel(messageBoxClosedEvent.getCustomVaule());
        }
    }
}

