/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.config;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.util.StringUtils;
import kd.bos.utils.KDEncodeUtil;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class WelcomeLetterEdit
extends HRDataBaseEdit
implements UploadListener {
    private static final String BAKIMAGERAD = "bakimagerad";
    private static final String WELCOMECONTENT = "welcomecontent_tag";
    private static final String CUSPICTUREAP = "cuspictureap";
    private static final String CUSPICTURE = "cuspicture";
    private static final String CUSTOMPICTURE = "custompicture";
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String ATTACHMENTPANEL = "attachmentpanel";
    private static final String BG_IMAGE1 = "/images/mobile/banner/hr_defaultbg1_1080_421.png";
    private static final String BG_IMAGE2 = "/images/mobile/banner/hr_defaultbg2_1080_421.png";
    private static final String BG_IMAGE3 = "/images/mobile/banner/hr_defaultbg3_1080_421.png";
    private static final String BG_IMAGE4 = "/images/mobile/banner/hr_defaultbg4_1080_421.png";
    private static final Map<String, String> BG_IMAGE_MAP = new HashMap<String, String>(6);
    private static final String KEY4 = "4";
    private static final String KEY5 = "5";
    private static final String BACKGROUNDAP = "backgroundap";
    private static final String RICHTEXTEDITORAP = "richtexteditorap";
    private static final String HTMLAP = "htmlap";
    private static final String SELECTCUSTOMPICTURE = "selectcustompicture";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CUSPICTURE});
        Label labelAp = (Label)this.getView().getControl(CUSPICTURE);
        labelAp.addUploadListener((UploadListener)this);
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(ATTACHMENTPANELAP);
        panel.addUploadListener((UploadListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String pageId = this.getView().getPageId();
        switch (operateKey) {
            case "viewpage": {
                this.getView().getPageCache().put(this.getSaveCacheKey(pageId), "save");
                OperationResult operationResult = this.getView().invokeOperation("save");
                if (!operationResult.isSuccess()) {
                    return;
                }
                long id = (Long)this.getModel().getValue("id");
                IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                service.removeAction("ShowNotificationMsg");
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u6b22\u8fce\u4fe1\u79fb\u52a8\u7aef\u9884\u89c8", (String)"WelcomeLetterEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                formShowParameter.setFormId("hom_configviewqrcode");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setStatus(OperationStatus.EDIT);
                formShowParameter.setCustomParam("entityid", (Object)"hom_welcomeconfigview");
                formShowParameter.setCustomParam("id", (Object)id);
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().showForm(formShowParameter);
                break;
            }
            case "save": {
                if (args.getSource() instanceof SaveAndNew) {
                    return;
                }
                if (this.getView().getPageCache().get(this.getSaveCacheKey(pageId)) == null) {
                    this.getView().close();
                    if (this.getView().getParentView() != null) {
                        this.getView().getParentView().invokeOperation("refresh");
                    }
                }
                this.getView().getPageCache().remove(this.getSaveCacheKey(pageId));
                break;
            }
        }
    }

    private String getSaveCacheKey(String pageId) {
        return pageId + "-save";
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ((Image)this.getControl("imageap1")).setUrl(BG_IMAGE1);
        ((Image)this.getControl("imageap2")).setUrl(BG_IMAGE2);
        ((Image)this.getControl("imageap3")).setUrl(BG_IMAGE3);
        ((Image)this.getControl("imageap4")).setUrl(BG_IMAGE4);
        this.setWelcomeContent();
        this.setBakImage(true);
        this.loadAttachment();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        HashMap propertyChangedMap = Maps.newHashMapWithExpectedSize((int)3);
        propertyChangedMap.put(CUSTOMPICTURE, this::setCustomPicture);
        propertyChangedMap.put(BAKIMAGERAD, this::setBakImageRad);
        propertyChangedMap.put(WELCOMECONTENT, this::setWelcomeContent);
        propertyChangedMap.getOrDefault(name, () -> {}).run();
    }

    private void setBakImageRad() {
        this.setBakImage(false);
    }

    private void setCustomPicture() {
        this.getModel().setValue(BAKIMAGERAD, (Object)KEY5);
        this.setBakImageRad();
    }

    private void setBakImage(boolean isInit) {
        String customPicture = (String)this.getModel().getValue(CUSTOMPICTURE);
        if (StringUtils.isEmpty((String)customPicture)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CUSTOMPICTURE});
            this.getView().setVisible(Boolean.TRUE, new String[]{CUSPICTUREAP});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{CUSTOMPICTURE});
            this.getView().setVisible(Boolean.FALSE, new String[]{CUSPICTUREAP});
        }
        String bakimagerad = (String)this.getModel().getValue(BAKIMAGERAD);
        Image backgroundap = (Image)this.getControl(BACKGROUNDAP);
        String selectCustomPicture = "";
        if (HRStringUtils.equals((String)KEY5, (String)bakimagerad)) {
            backgroundap.setUrl(HRImageUrlUtil.getImageFullUrl((String)customPicture));
            selectCustomPicture = HRImageUrlUtil.getImageFullUrl((String)customPicture);
        } else {
            backgroundap.setUrl(BG_IMAGE_MAP.get(bakimagerad));
            selectCustomPicture = BG_IMAGE_MAP.get(bakimagerad);
        }
        Object value = this.getModel().getValue(SELECTCUSTOMPICTURE);
        if (!isInit || value == null) {
            this.getModel().setValue(SELECTCUSTOMPICTURE, (Object)selectCustomPicture);
        }
    }

    private void setWelcomeContent() {
        RichTextEditor editor = (RichTextEditor)this.getView().getControl(RICHTEXTEDITORAP);
        String welcomeContent = (String)this.getModel().getValue(WELCOMECONTENT);
        editor.setText(welcomeContent);
        Html htmlAp = (Html)this.getControl(HTMLAP);
        htmlAp.setConent(welcomeContent);
    }

    public void upload(UploadEvent e) {
        Control source = (Control)e.getSource();
        switch (source.getKey()) {
            case "cuspicture": {
                Object[] urls = e.getUrls();
                this.getView().setVisible(Boolean.TRUE, new String[]{CUSTOMPICTURE});
                this.getModel().setValue(CUSTOMPICTURE, urls[0]);
                break;
            }
        }
    }

    public void afterUpload(UploadEvent evt) {
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "attachmentpanelap": {
                this.loadAttachment();
                break;
            }
        }
    }

    private void loadAttachment() {
        AttachmentPanel attachmentpanelap = (AttachmentPanel)this.getView().getControl(ATTACHMENTPANELAP);
        List attachmentData = attachmentpanelap.getAttachmentData();
        FlexPanelAp headPanelAp = new HRFlexPanelAp.Builder(ATTACHMENTPANEL).setAlignItems("center").setGrow(0).setWrap(true).setOverflow("auto").build();
        for (int index = 0; index < attachmentData.size(); ++index) {
            Map stringObjectMap = (Map)attachmentData.get(index);
            HRFlexPanelAp.Builder buildFlexPanelAp = new HRFlexPanelAp.Builder(ATTACHMENTPANEL + index).setAlignItems("center").setGrow(0).setWrap(true);
            headPanelAp.getItems().add(buildFlexPanelAp.build());
            buildFlexPanelAp.setMarginTop("8px");
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hom_attachmentpanelap");
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey(ATTACHMENTPANEL + index);
            formShowParameter.setCustomParam(ATTACHMENTPANELAP, (Object)SerializationUtils.toJsonString((Object)stringObjectMap));
            this.getView().showForm(formShowParameter);
        }
        this.getView().updateControlMetadata(ATTACHMENTPANEL, headPanelAp.createControl());
    }

    public void afterRemove(UploadEvent evt) {
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "attachmentpanelap": {
                this.loadAttachment();
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        if (HRStringUtils.isNotEmpty((String)eventArgs)) {
            this.getModel().setValue(WELCOMECONTENT, (Object)KDEncodeUtil.kdDecoding((String)eventArgs));
        }
    }

    static {
        BG_IMAGE_MAP.put("1", BG_IMAGE1);
        BG_IMAGE_MAP.put("2", BG_IMAGE2);
        BG_IMAGE_MAP.put("3", BG_IMAGE3);
        BG_IMAGE_MAP.put(KEY4, BG_IMAGE4);
    }
}

