/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.cooperation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.application.impl.onbrd.OnbrdWorkTableServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdWorkTableService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.impl.collect.CollectServiceImpl;
import kd.hr.hom.business.domain.service.impl.invite.OnbrdInviteDomainService;
import kd.hr.hom.business.domain.service.invite.IOnbrdInviteDomainService;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.CollectManageStatusEnum;
import kd.hr.hom.common.enums.ExceptionCauseEnum;
import kd.hr.hom.common.enums.LoginStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.SendStatusEnum;

public class WorkingTableFilter
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(WorkingTableFilter.class);
    private static final ICollectService COLLECT_SERVICE = new CollectServiceImpl();
    private static final IOnbrdInviteDomainService INVITE_DOMAIN_SERVICE = new OnbrdInviteDomainService();
    private static final IOnbrdWorkTableService WORK_TABLE_SERVICE = new OnbrdWorkTableServiceImpl();
    private static final Map<String, List<String>> EXCEPTION_MAP = new HashMap<String, List<String>>();

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        String key = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if (key != null && "8".equals(key)) {
            this.collectFilter(setFilterEvent);
        }
        if (key != null && "7".equals(key)) {
            this.inviteFilter(setFilterEvent);
        }
        if (key != null && "5".equals(key)) {
            this.checkinAbnormal(setFilterEvent);
        }
        if (key != null && "6".equals(key)) {
            this.checkinOverdue(setFilterEvent);
        }
    }

    private void collectFilter(SetFilterEvent setFilterEvent) {
        List orgIds = (List)this.getView().getFormShowParameter().getCustomParam("adminorgids");
        List hrbuIds = (List)this.getView().getFormShowParameter().getCustomParam("hrbuids");
        List onbIds = COLLECT_SERVICE.workTableCollectOnbIds(OnbrdStatusEnum.WAIT_ONBRD.getValue(), CollectManageStatusEnum.SUBMIT.getStatus(), orgIds, hrbuIds);
        LOGGER.info("collectFilter_workTableCollectOnbIds_size:{}", (Object)(onbIds == null ? 0 : onbIds.size()));
        this.setFilterEvent(setFilterEvent, onbIds, ActivityNumberEnum.INFOCOLLECTION.getId());
    }

    private void inviteFilter(SetFilterEvent setFilterEvent) {
        List orgIds = (List)this.getView().getFormShowParameter().getCustomParam("adminorgids");
        List hrbuIds = (List)this.getView().getFormShowParameter().getCustomParam("hrbuids");
        List onbIds = INVITE_DOMAIN_SERVICE.workTableInviteOnbIds(OnbrdStatusEnum.WAIT_ONBRD.getValue(), SendStatusEnum.HAS_SEND.getValue(), LoginStatusEnum.NO_LOGIN.getValue(), orgIds, hrbuIds);
        LOGGER.info("inviteFilter_workTableInviteOnbIds_size:{}", (Object)(onbIds == null ? 0 : onbIds.size()));
        this.setFilterEvent(setFilterEvent, onbIds, ActivityNumberEnum.INDUCTIONINVITATION.getId());
    }

    private void checkinAbnormal(SetFilterEvent setFilterEvent) {
        List<Long> onbIds = this.getLongs();
        LOGGER.info("inviteFilter_checkinAbnormal_size:{}", (Object)(onbIds == null ? 0 : onbIds.size()));
        this.setFilterEvent(setFilterEvent, onbIds, ActivityNumberEnum.CHECKININFO.getId());
    }

    private void checkinOverdue(SetFilterEvent setFilterEvent) {
        List<Long> onbIds = this.getLongs();
        LOGGER.info("inviteFilter_checkinOverdue_size:{}", (Object)(onbIds == null ? 0 : onbIds.size()));
        this.setFilterEvent(setFilterEvent, onbIds, ActivityNumberEnum.CHECKININFO.getId());
    }

    private List<Long> getLongs() {
        String key = (String)this.getView().getFormShowParameter().getCustomParam("type");
        List orgIds = (List)this.getView().getFormShowParameter().getCustomParam("adminorgids");
        List hrbuIds = (List)this.getView().getFormShowParameter().getCustomParam("hrbuids");
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("hrbuids", hrbuIds);
        map.put("adminorgids", orgIds);
        List<String> causeList = EXCEPTION_MAP.get(key);
        map.put("ExceptionCause", causeList);
        return WORK_TABLE_SERVICE.getOnbsIdForTable(map, key);
    }

    private void setFilterEvent(SetFilterEvent setFilterEvent, List<Long> onbIds, Long activityId) {
        setFilterEvent.setMainOrgQFilter(null);
        List customQFilters = setFilterEvent.getCustomQFilters();
        QFilter activityTypeFilter = new QFilter("activity.id", "=", (Object)activityId);
        QFilter onbFilter = new QFilter("onbrdid", "in", onbIds);
        customQFilters.add(activityTypeFilter);
        customQFilters.add(onbFilter);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        String key = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if (key == null) {
            return;
        }
        commonFilterColumns.forEach(filterColumn -> {
            String fieldName = filterColumn.getFieldName();
            if (HRStringUtils.equals((String)"org.name", (String)fieldName)) {
                filterColumn.setDefaultValue(null);
            }
        });
    }

    static {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(ExceptionCauseEnum.GPS.getNumber());
        list1.add(ExceptionCauseEnum.NO_REACHED.getNumber());
        list1.add(ExceptionCauseEnum.NO_STARTED.getNumber());
        EXCEPTION_MAP.put("5", list1);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(ExceptionCauseEnum.NO_CHECKIN.getNumber());
        EXCEPTION_MAP.put("6", list2);
    }
}

