/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.integrate;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.IListView;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.application.impl.onbrd.OnbrdConfirmAppServiceImpl;
import kd.hr.hom.business.domain.service.integrate.IIntegrateService;
import kd.hr.hom.common.enums.SynchStatusEnum;

public class SyncPersonPlugin
extends HRDataBaseList {
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean isSuccess;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        boolean bl = isSuccess = afterDoOperationEventArgs.getOperationResult() == null || afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (isSuccess && "btn_syncperson".equals(operateKey)) {
            this.showSyncPersonPage();
        }
    }

    public void showSyncPersonPage() {
        IFormView formView = this.getView();
        if (formView instanceof IListView) {
            IListView listview = (IListView)formView;
            ListSelectedRowCollection selectedRows = listview.getSelectedRows();
            if (selectedRows.size() <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u540c\u6b65\u4fe1\u606f\u7684\u4eba\u5458\u3002", (String)"SyncPersonPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            Long[] onbrdIdArray = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(pkId -> Long.valueOf(pkId.toString())).toArray(Long[]::new);
            IIntegrateService service = IIntegrateService.getInstance();
            Object[] onbrdBillInfos = new OnbrdConfirmAppServiceImpl().getOnbrdBillsForShowPage(onbrdIdArray);
            if (HRArrayUtils.isEmpty((Object[])onbrdBillInfos)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u8bb0\u5f55\u3002", (String)"OnbrdConfirmPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            if (onbrdBillInfos.length == 1) {
                Object dy = onbrdBillInfos[0];
                String syncStatus = dy.getString("synchstatus");
                if (SynchStatusEnum.SYNCH_SUCCESS.getValue().equals(syncStatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u540c\u6b65\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"SyncPersonPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (SynchStatusEnum.SYNCH_DOING.getValue().equals(syncStatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SyncPersonPlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    return;
                }
                service.syncHpfs(onbrdIdArray);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u89e6\u53d1\u540c\u6b65\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u540c\u6b65\u7ed3\u679c", (String)"SyncPersonPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            } else {
                this.batchRetryHpfs((DynamicObject[])onbrdBillInfos);
            }
        }
    }

    private void batchRetryHpfs(DynamicObject[] onbrdInfos) {
        IIntegrateService service = IIntegrateService.getInstance();
        ArrayList<Long> ids = new ArrayList<Long>(onbrdInfos.length);
        ArrayList<Long> ingIds = new ArrayList<Long>(onbrdInfos.length);
        ArrayList<Long> canSyncIds = new ArrayList<Long>(onbrdInfos.length);
        if (onbrdInfos.length > 0) {
            for (DynamicObject dy : onbrdInfos) {
                String syncStatus = dy.getString("synchstatus");
                if (SynchStatusEnum.SYNCH_SUCCESS.getValue().equals(syncStatus)) {
                    ids.add(dy.getLong("id"));
                    continue;
                }
                if (SynchStatusEnum.SYNCH_DOING.getValue().equals(syncStatus)) {
                    ingIds.add(dy.getLong("id"));
                    continue;
                }
                canSyncIds.add(dy.getLong("id"));
            }
        }
        if (canSyncIds.size() == onbrdInfos.length) {
            service.syncHpfs(canSyncIds.toArray(new Long[0]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u89e6\u53d1\u540c\u6b65\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u540c\u6b65\u7ed3\u679c", (String)"SyncPersonPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else if (ids.size() == onbrdInfos.length) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u540c\u6b65\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"SyncPersonPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        } else if (ingIds.size() == onbrdInfos.length) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SyncPersonPlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u81ea\u52a8\u4e3a\u60a8\u6392\u9664\u5df2\u540c\u6b65\u6210\u529f\u6216\u540c\u6b65\u4e2d\u7684\u6570\u636e\uff08\u5171{0}\u6761\uff09\u3002", (String)"SyncPersonPlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]), ids.size() + ingIds.size()));
            service.syncHpfs(canSyncIds.toArray(new Long[0]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u89e6\u53d1\u540c\u6b65\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u540c\u6b65\u7ed3\u679c", (String)"SyncPersonPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }
}

