/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.invite;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.utils.SendMessageUtil;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.invite.IOnbrdInviteDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.LoginStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.common.enums.SendStatusEnum;
import kd.hr.hom.common.util.ComboPropValueUtils;
import kd.hr.hom.formplugin.common.InviteHelper;
import org.apache.commons.lang3.StringUtils;

public class OnbrdInviteOperateListPlugin
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(OnbrdInviteOperateListPlugin.class);
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"OnbrdInviteOperateListPlugin", (int)5, (int)1000);
    private static final String SENDINVITESINGLE = "sendinvitesingle";
    private static final String SENDINVITEMULTI = "sendinvitemulti";
    private static final String REMINDLOGINMULTI = "remindloginmulti";
    private static final String FLOWPERSONID = "flowpersonid";
    private static final String WAITSENDID = "waitsendid";
    private static final String ISEXCLUDEHASSEND = "isexcludehassend";
    private static final String SENDINVITE = "sendinvite";
    private static final String REMINDLOGIN = "remindlogin";
    private static final String FEEDBACK = "feedback";
    private static final String FITPERSONID = "fitpersonid";
    private static final String ONBRD_ID = "onbrd.id";

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        IFormView formView = this.getView();
        if (formView instanceof IListView) {
            String actionId = closedCallBackEvent.getActionId();
            Object returnData = closedCallBackEvent.getReturnData();
            switch (actionId) {
                case "sendinvitemulti": {
                    this.sendInviteMutil(returnData);
                    break;
                }
                case "remindloginmulti": {
                    LOGGER.info("OnbrdInviteOperateListPlugin-closedCallBack-remindloginmulti-satrt");
                    if (returnData instanceof Map) {
                        Map returnDataMap = (Map)returnData;
                        JSONArray flowPersonId = (JSONArray)returnDataMap.get(FITPERSONID);
                        DynamicObject[] inviteSendBillObjs = ((IOnbrdInviteDomainService)ServiceFactory.getService(IOnbrdInviteDomainService.class)).getInviteSendBillObjs(flowPersonId.toArray(new Object[0]));
                        List<Object> ids = Arrays.stream(inviteSendBillObjs).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
                        int successOpCount = ids.size();
                        int failOpCount = 0;
                        String successOperation = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"OnbrdConfirmPlugin_14", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                        String failOperation = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"OnbrdConfirmPlugin_15", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                        this.showOnBrdResultPage(successOpCount, successOperation, failOpCount, failOperation, this.getExportDataListWithConfirmCount(inviteSendBillObjs, "2"));
                        ArrayList<DynamicObject> remindInfoObjs = new ArrayList<DynamicObject>(ids.size());
                        DynamicObject[] inviteSendBillObjSuccessIds = ((IOnbrdInviteDomainService)ServiceFactory.getService(IOnbrdInviteDomainService.class)).getInviteSendBillObjs(ids.toArray(new Object[0]));
                        for (Long l : ids) {
                            DynamicObject remindInfoObj = new HRBaseServiceHelper("hom_remindinfo").generateEmptyDynamicObject();
                            remindInfoObj.set("inductioninvite", (Object)l);
                            remindInfoObj.set("reminddate", (Object)new Date());
                            remindInfoObj.set("operator", (Object)RequestContext.get().getCurrUserId());
                            remindInfoObjs.add(remindInfoObj);
                        }
                        HomCommonRepository.updateDynamicObjects((String)"hom_remindinfo", (DynamicObject[])remindInfoObjs.toArray(new DynamicObject[remindInfoObjs.size()]));
                        for (DynamicObject inviteSendBillObj : inviteSendBillObjSuccessIds) {
                            inviteSendBillObj.set("remindnum", (Object)(inviteSendBillObj.getInt("remindnum") + 1));
                        }
                        HomCommonRepository.updateDynamicObjects((String)"hom_invitesendbill", (DynamicObject[])inviteSendBillObjSuccessIds);
                        threadPool.execute(() -> {
                            LOGGER.info("OnbrdInviteOperateListPlugin-closedCallBack-remindloginmulti-threadPool-satrt");
                            Map<String, List<DynamicObject>> paramMap = Arrays.stream(inviteSendBillObjs).collect(Collectors.groupingBy(onbrdObj -> onbrdObj.getString("org.number")));
                            ((ISendMessageService)ServiceFactory.getService(ISendMessageService.class)).batchSendShortInfo(paramMap, RuleEngineSceneNumberEnum.LOGIN_REMIND_MESSAGE, ids);
                            LOGGER.info("OnbrdInviteOperateListPlugin-closedCallBack-remindloginmulti-threadPool-satrt");
                        }, RequestContext.get());
                        this.getView().invokeOperation("refresh");
                    }
                    LOGGER.info("OnbrdInviteOperateListPlugin-closedCallBack-remindloginmulti-end");
                    break;
                }
            }
        }
    }

    private void sendInviteMutil(Object returnData) {
        LOGGER.info("OnbrdInviteOperateListPlugin-closedCallBack-sendinvitemulti-satrt");
        if (returnData instanceof Map) {
            Map returnDataMap = (Map)returnData;
            JSONArray flowPersonId = (JSONArray)returnDataMap.get(FLOWPERSONID);
            JSONArray waitSendId = (JSONArray)returnDataMap.get(WAITSENDID);
            boolean isExcludeHasSend = (Boolean)returnDataMap.get(ISEXCLUDEHASSEND);
            Object[] ids = isExcludeHasSend ? (Long[])waitSendId.toArray((Object[])new Long[0]) : (Long[])flowPersonId.toArray((Object[])new Long[0]);
            Object[] inviteSendBillObjs = ((IOnbrdInviteDomainService)ServiceFactory.getService(IOnbrdInviteDomainService.class)).getInviteSendBillObjs(ids);
            if (HRArrayUtils.isEmpty((Object[])inviteSendBillObjs)) {
                return;
            }
            DynamicObject[] successIdObjs = ((IOnbrdInviteDomainService)ServiceFactory.getService(IOnbrdInviteDomainService.class)).getInviteSendBillObjs(ids);
            this.sendShort(successIdObjs);
            this.sendMail(successIdObjs);
            this.workflow(successIdObjs);
            int successOpCount = ids.length;
            int failOpCount = 0;
            String successOperation = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"OnbrdConfirmPlugin_14", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            String failOperation = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"OnbrdConfirmPlugin_15", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.showOnBrdResultPage(successOpCount, successOperation, failOpCount, failOperation, this.getExportDataListWithConfirmCount(successIdObjs, "1"));
            this.getView().invokeOperation("refresh");
        }
        LOGGER.info("OnbrdInviteOperateListPlugin-closedCallBack-sendinvitemulti-end");
    }

    private void workflow(DynamicObject[] successIdObjs) {
        threadPool.execute(() -> {
            LOGGER.info("OnbrdInviteOperateListPlugin-closedCallBack-sendinvitemulti-workflow-start");
            ArrayList<Long> workflowIds = new ArrayList<Long>();
            for (DynamicObject inviteSendBillObj : successIdObjs) {
                DynamicObject onbrdObj = inviteSendBillObj.getDynamicObject("onbrd");
                if (!SendStatusEnum.WAIT_SEND.getValue().equals(inviteSendBillObj.getString("sendstatus"))) continue;
                workflowIds.add(onbrdObj.getLong("id"));
            }
            this.sendWorkflow(workflowIds);
            InviteHelper.updateInviteDatas(successIdObjs);
            LOGGER.info("OnbrdInviteOperateListPlugin-closedCallBack-sendinvitemulti-workflow-end");
        }, RequestContext.get());
    }

    private void sendMail(DynamicObject[] successIdObjs) {
        threadPool.execute(() -> {
            LOGGER.info("OnbrdInviteOperateListPlugin-closedCallBack-sendinvitemulti-email-start");
            HashMap<Long, Map> emailInfoMaps = new HashMap<Long, Map>(successIdObjs.length);
            Tuple sysWhiteListConfig = SendMessageUtil.smsWhiteList();
            for (DynamicObject inviteSendBillObj : successIdObjs) {
                DynamicObject onbrdObj = inviteSendBillObj.getDynamicObject("onbrd");
                String perEmail = onbrdObj.getString("peremail");
                if (HRStringUtils.isBlank((CharSequence)perEmail) || !"0".equals(sysWhiteListConfig.item1) && !((String)sysWhiteListConfig.item2).contains(perEmail)) continue;
                Long bizId = inviteSendBillObj.getLong("id");
                IOnbrdInviteDomainService inviteDomainService = (IOnbrdInviteDomainService)ServiceFactory.getService(IOnbrdInviteDomainService.class);
                Map emailInfoMap = inviteDomainService.getEmailInfoMap(inviteSendBillObj, onbrdObj);
                emailInfoMaps.put(bizId, emailInfoMap);
            }
            ((ISendMessageService)ServiceFactory.getService(ISendMessageService.class)).batchSendmail(emailInfoMaps);
            LOGGER.info("OnbrdInviteOperateListPlugin-closedCallBack-sendinvitemulti-email-end");
        }, RequestContext.get());
    }

    private void sendShort(DynamicObject[] successIdObjs) {
        threadPool.execute(() -> {
            LOGGER.info("OnbrdInviteOperateListPlugin-closedCallBack-sendinvitemulti-shortInfo-satrt");
            Map<Long, Long> bizIdAndMessageTplIdMap = Arrays.stream(successIdObjs).collect(Collectors.toMap(inviteSendBillObj -> inviteSendBillObj.getLong("id"), inviteSendBillObj -> inviteSendBillObj.getLong("sendinvitemessagetpl.id")));
            Map<Long, List> bizIdAndPhoneListMap = Arrays.stream(successIdObjs).collect(Collectors.toMap(inviteSendBillObj -> inviteSendBillObj.getLong("id"), inviteSendBillObj -> ImmutableList.of((Object)inviteSendBillObj.getString("onbrd.phone"))));
            Map<Long, Long> bizIdAndOnbrdIdMap = Arrays.stream(successIdObjs).collect(Collectors.toMap(successIdObj -> successIdObj.getLong("id"), successIdObj -> successIdObj.getLong(ONBRD_ID)));
            ((ISendMessageService)ServiceFactory.getService(ISendMessageService.class)).batchSendShortInfo(bizIdAndMessageTplIdMap, bizIdAndPhoneListMap, bizIdAndOnbrdIdMap);
            LOGGER.info("OnbrdInviteOperateListPlugin-closedCallBack-sendinvitemulti-shortInfo-end");
        }, RequestContext.get());
    }

    private void sendWorkflow(List<Long> workflowIds) {
        this.batchConsentTask(workflowIds);
    }

    private void showOnBrdResultPage(Integer successOpCount, String successOperation, Integer failOpCount, String failOperation, List<Map<String, Object>> templateExportDataList) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String excelName = ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"OnbrdConfirmPlugin_16", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        if (failOpCount == 0) {
            formShowParameter.setFormId("hom_result_success");
        } else if (successOpCount == 0) {
            formShowParameter.setFormId("hom_result_fail");
        } else {
            formShowParameter.setFormId("hom_result_all");
            excelName = ResManager.loadKDString((String)"\u64cd\u4f5c\u63d0\u793a", (String)"OnbrdConfirmPlugin_17", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        }
        formShowParameter.setCustomParam("successperson", (Object)String.format(ResManager.loadKDString((String)"%s\u4eba", (String)"OnbrdConfirmPlugin_18", (String)"hr-hom-formplugin", (Object[])new Object[0]), successOpCount.toString()));
        formShowParameter.setCustomParam("successoperation", (Object)successOperation);
        formShowParameter.setCustomParam("failperson", (Object)String.format(ResManager.loadKDString((String)"%s\u4eba", (String)"OnbrdConfirmPlugin_18", (String)"hr-hom-formplugin", (Object[])new Object[0]), failOpCount));
        formShowParameter.setCustomParam("failoperation", (Object)failOperation);
        formShowParameter.setCaption(excelName);
        formShowParameter.setCustomParam("excelname", (Object)excelName);
        List<HRExportHeadObject> headDataList = this.getHeadDataListWithConfirmCount();
        formShowParameter.setCustomParam("headdatalist", headDataList);
        formShowParameter.setCustomParam("exportdatalist", templateExportDataList);
        this.getView().showForm(formShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        IFormView formView = this.getView();
        if (formView instanceof IListView) {
            String actionId = messageBoxClosedEvent.getCallBackId();
            MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes.equals((Object)resultValue) && SENDINVITESINGLE.equals(actionId)) {
                IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                Object[] inviteSendBillObjs = (DynamicObject[])SerializationUtils.deSerializeFromBase64((String)pageCache.get("invitesendbillobjs"));
                if (HRArrayUtils.isEmpty((Object[])inviteSendBillObjs)) {
                    return;
                }
                Object inviteSendBillObj = inviteSendBillObjs[0];
                InviteHelper.updateInviteDatas(new DynamicObject[]{inviteSendBillObj});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u9080\u7ea6\u6210\u529f", (String)"OnbrdInviteOperateListPlugin_17", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                InviteHelper.sendShortAndEmail((DynamicObject)inviteSendBillObj);
            }
        }
    }

    private OperationResult batchConsentTask(List<Long> onbrdIds) {
        if (CollectionUtils.isEmpty(onbrdIds)) {
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(true);
            return operationResult;
        }
        return IActivityDomainService.getInstance().batchConsentTask(onbrdIds, ActivityNumberEnum.INDUCTIONINVITATION);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        if (HRObjectUtils.isEmpty((Object)args.getOperationResult()) || !args.getOperationResult().isSuccess()) {
            return;
        }
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "sendinvite": {
                this.sendInvite();
                break;
            }
            case "remindlogin": {
                this.remindLogin();
                break;
            }
        }
    }

    private void remindLogin() {
        LOGGER.info("OnbrdInviteOperateListPlugin-remindLogin-start");
        IFormView formView = this.getView();
        if (formView instanceof IListView) {
            IListView listView = (IListView)formView;
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            if (selectedRows.size() == 0) {
                return;
            }
            String appId = this.getView().getFormShowParameter().getAppId();
            IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
            if (!onbrdCommonAppService.checkPermission("hom_onbrdinvite", "25S0CDISAJ8D", appId)) {
                return;
            }
            DynamicObject[] inviteSendBillObjs = ((IOnbrdInviteDomainService)ServiceFactory.getService(IOnbrdInviteDomainService.class)).getInviteSendBillObjs(selectedRows.getPrimaryKeyValues());
            Long[] onbrdIds = (Long[])Arrays.stream(inviteSendBillObjs).map(inviteSendBillObj -> inviteSendBillObj.getLong(ONBRD_ID)).toArray(Long[]::new);
            this.getPageCache().put("onbrdid", SerializationUtils.toJsonString(Arrays.asList(onbrdIds)));
            if (inviteSendBillObjs.length == 1) {
                if (this.remindLoginSingle(inviteSendBillObjs[0])) {
                    return;
                }
            } else {
                this.remindLoginMulti(inviteSendBillObjs);
            }
            LOGGER.info("OnbrdInviteOperateListPlugin-remindLogin-end");
        }
    }

    private void remindLoginMulti(DynamicObject[] inviteSendBillObjs) {
        HashSet<Long> notFitPersonIdSet = new HashSet<Long>(inviteSendBillObjs.length);
        for (DynamicObject inviteSendBillObj2 : inviteSendBillObjs) {
            String enrollStatus = inviteSendBillObj2.getString("onbrd.enrollstatus");
            if (HRStringUtils.equals((String)OnbrdStatusEnum.HAS_ONBRD.toString(), (String)enrollStatus) || HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.toString(), (String)enrollStatus)) {
                notFitPersonIdSet.add(inviteSendBillObj2.getLong("id"));
                continue;
            }
            String loginStatus = inviteSendBillObj2.getString("loginstatus");
            String sendStatus = inviteSendBillObj2.getString("sendstatus");
            if (!LoginStatusEnum.HAS_LOGIN.getValue().equals(loginStatus) && !SendStatusEnum.WAIT_SEND.getValue().equals(sendStatus)) continue;
            notFitPersonIdSet.add(inviteSendBillObj2.getLong("id"));
        }
        Set fitPersonIdSet = Arrays.stream(inviteSendBillObjs).filter(inviteSendBillObj -> !notFitPersonIdSet.contains(inviteSendBillObj.getLong("id"))).map(inviteSendBillObj -> inviteSendBillObj.getLong("id")).collect(Collectors.toSet());
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hom_remindloginconfirm");
        formShowParameter.setCustomParam("allperson", (Object)inviteSendBillObjs.length);
        formShowParameter.setCustomParam("fitperson", (Object)(inviteSendBillObjs.length - notFitPersonIdSet.size()));
        formShowParameter.setCustomParam("nofitperson", (Object)notFitPersonIdSet.size());
        formShowParameter.setCustomParam(FITPERSONID, fitPersonIdSet);
        List<HRExportHeadObject> headDataList = this.getHeadDataListWithConfirmCount();
        String excelName = ResManager.loadKDString((String)"\u63d0\u9192\u767b\u5f55\u786e\u8ba4", (String)"OnbrdInviteOperateListPlugin_15", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        formShowParameter.setCustomParam("excelname", (Object)excelName);
        formShowParameter.setCustomParam("headdatalist", headDataList);
        List<Map<String, Object>> templateExportDataList = this.getExportDataListWithConfirmCount(inviteSendBillObjs, "2");
        formShowParameter.setCustomParam("exportdatalist", templateExportDataList);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REMINDLOGINMULTI));
        this.getView().showForm(formShowParameter);
    }

    private boolean remindLoginSingle(DynamicObject inviteSendBillObj1) {
        DynamicObject inviteSendBillObj = inviteSendBillObj1;
        String sendStatus = inviteSendBillObj.getString("sendstatus");
        DynamicObject onbrdObj = inviteSendBillObj.getDynamicObject("onbrd");
        String enrollStatus = onbrdObj.getString("enrollstatus");
        if (HRStringUtils.equals((String)OnbrdStatusEnum.HAS_ONBRD.toString(), (String)enrollStatus) || HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.toString(), (String)enrollStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5f85\u5165\u804c\u4eba\u5458\u5df2\u5165\u804c/\u5df2\u7ec8\u6b62\u5165\u804c\uff0c\u65e0\u6cd5\u53d1\u9001\u63d0\u9192\u767b\u5f55\u6d88\u606f\u3002", (String)"OnbrdInviteOperateListPlugin_13", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (SendStatusEnum.WAIT_SEND.getValue().equals(sendStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u64cd\u4f5c\u201c\u53d1\u9001\u9080\u7ea6\u201d\u3002", (String)"OnbrdInviteOperateListPlugin_23", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return true;
        }
        String loginStatus = inviteSendBillObj.getString("loginstatus");
        if (LoginStatusEnum.HAS_LOGIN.getValue().equals(loginStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5f85\u5165\u804c\u4eba\u5458\u5df2\u5b8c\u6210\u5165\u804c\u670d\u52a1\u5e73\u53f0\u767b\u5f55\uff0c\u65e0\u9700\u53d1\u9001\u767b\u5f55\u63d0\u9192\u6d88\u606f\u3002", (String)"OnbrdInviteOperateListPlugin_14", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return true;
        }
        Map resultMap = IOnbrdInviteDomainService.getInstance().sendShortInfo(onbrdObj, RuleEngineSceneNumberEnum.LOGIN_REMIND_MESSAGE);
        if (Boolean.TRUE.equals(resultMap.get("success"))) {
            IOnbrdInviteDomainService.getInstance().updateRemindInfo(inviteSendBillObj, this.getView());
            this.getView().invokeOperation("refresh");
        } else {
            this.getView().showErrorNotification(String.valueOf(resultMap.get("message")));
        }
        return false;
    }

    private void sendInvite() {
        LOGGER.info("OnbrdInviteOperateListPlugin-sendInvite-start");
        IFormView formView = this.getView();
        if (formView instanceof IListView) {
            String appId;
            IListView listview = (IListView)formView;
            ListSelectedRowCollection selectedRows = listview.getSelectedRows();
            if (selectedRows.size() == 0) {
                return;
            }
            IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
            if (!onbrdCommonAppService.checkPermission("hom_onbrdinvite", "25S0ARLJONHL", appId = this.getView().getFormShowParameter().getAppId())) {
                return;
            }
            DynamicObject[] inviteSendBillObjs = ((IOnbrdInviteDomainService)ServiceFactory.getService(IOnbrdInviteDomainService.class)).getInviteSendBillObjs(selectedRows.getPrimaryKeyValues());
            Object[] onbrdIds = (Long[])Arrays.stream(inviteSendBillObjs).map(inviteSendBillObj -> inviteSendBillObj.getLong(ONBRD_ID)).toArray(Long[]::new);
            this.getPageCache().put("onbrdid", SerializationUtils.toJsonString(Arrays.asList(onbrdIds)));
            this.getPageCache().put("invitesendbillobjs", SerializationUtils.serializeToBase64((Object)inviteSendBillObjs));
            if (inviteSendBillObjs.length == 1) {
                DynamicObject inviteSendBillObj2 = inviteSendBillObjs[0];
                DynamicObject onbrdObj = inviteSendBillObj2.getDynamicObject("onbrd");
                if (!InviteHelper.sendInviteOne(inviteSendBillObj2, this.getView())) {
                    return;
                }
                String sendStatus = inviteSendBillObj2.getString("sendstatus");
                if (SendStatusEnum.WAIT_SEND.getValue().equals(sendStatus)) {
                    InviteHelper.sendInvite(onbrdObj, inviteSendBillObj2, this.getView(), true);
                } else {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5411\u8be5\u5165\u804c\u5458\u5de5\u53d1\u9001\u8fc7\u5165\u804c\u6b22\u8fce\u4fe1\uff0c\u8bf7\u786e\u8ba4\u518d\u6b21\u53d1\u9001\uff1f", (String)"OnbrdInviteOperateListPlugin_20", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SENDINVITESINGLE, (IFormPlugin)this));
                }
            } else {
                DynamicObject[] enrolledInfos = IOnbrdBillDomainService.getInstance().isEnrolledInfos(onbrdIds);
                Set pkId = Arrays.stream(enrolledInfos).map(enrolledInfo -> enrolledInfo.getLong("id")).collect(Collectors.toSet());
                List notEnrolledInfos = Arrays.stream(inviteSendBillObjs).filter(inviteSendBillObj -> !pkId.contains(inviteSendBillObj.getLong(ONBRD_ID))).collect(Collectors.toList());
                HashMap messageMap = Maps.newHashMapWithExpectedSize((int)notEnrolledInfos.size());
                List notFits = IOnbrdInviteDomainService.getInstance().notFitData(notEnrolledInfos, (Map)messageMap);
                notEnrolledInfos.removeAll(notFits);
                Set flowPersonIdSet = notEnrolledInfos.stream().map(notEnrolledInfo -> notEnrolledInfo.getLong("id")).collect(Collectors.toSet());
                Set waitSendIdSet = notEnrolledInfos.stream().filter(notEnrolledInfo -> SendStatusEnum.WAIT_SEND.getValue().equals(notEnrolledInfo.getString("sendstatus"))).map(enrolledInfo -> enrolledInfo.getLong("id")).collect(Collectors.toSet());
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setFormId("hom_onbrdinviteconfirm");
                formShowParameter.setCustomParam("allperson", (Object)inviteSendBillObjs.length);
                formShowParameter.setCustomParam("endperson", (Object)enrolledInfos.length);
                formShowParameter.setCustomParam("nofitperson", (Object)notFits.size());
                formShowParameter.setCustomParam("flowperson", (Object)flowPersonIdSet.size());
                formShowParameter.setCustomParam("sendperson", (Object)(flowPersonIdSet.size() - waitSendIdSet.size()));
                formShowParameter.setCustomParam(FLOWPERSONID, flowPersonIdSet);
                formShowParameter.setCustomParam(WAITSENDID, waitSendIdSet);
                List<HRExportHeadObject> headDataList = this.getHeadDataListWithConfirmCount();
                String excelName = ResManager.loadKDString((String)"\u5165\u804c\u9080\u7ea6\u786e\u8ba4", (String)"OnbrdInviteOperateListPlugin_8", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                formShowParameter.setCustomParam("excelname", (Object)excelName);
                formShowParameter.setCustomParam("headdatalist", headDataList);
                List<Map<String, Object>> templateExportDataList = this.getExportDataListWithConfirmCount(inviteSendBillObjs, "1", messageMap);
                formShowParameter.setCustomParam("exportdatalist", templateExportDataList);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SENDINVITEMULTI));
                this.getView().showForm(formShowParameter);
            }
            LOGGER.info("OnbrdInviteOperateListPlugin-sendInvite-end");
        }
    }

    private List<HRExportHeadObject> getHeadDataListWithConfirmCount() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>(8);
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"OnbrdInviteOperateListPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("candidatenumber", ResManager.loadKDString((String)"\u5019\u9009\u4eba\u7f16\u53f7", (String)"OnbrdInviteOperateListPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("employeeno", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"OnbrdInviteOperateListPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("effectdate", ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f", (String)"OnbrdInviteOperateListPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("enrollstatus", ResManager.loadKDString((String)"\u5165\u804c\u72b6\u6001", (String)"OnbrdInviteOperateListPlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("sendstatus", ResManager.loadKDString((String)"\u53d1\u9001\u72b6\u6001", (String)"OnbrdInviteOperateListPlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("welcomelettersendstatus", ResManager.loadKDString((String)"\u6b22\u8fce\u4fe1\u53d1\u9001\u72b6\u6001", (String)"OnbrdInviteOperateListPlugin_21", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("invitemessagesendstatus", ResManager.loadKDString((String)"\u9080\u7ea6\u6d88\u606f\u53d1\u9001\u72b6\u6001", (String)"OnbrdInviteOperateListPlugin_22", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("loginstatus", ResManager.loadKDString((String)"\u767b\u5f55\u72b6\u6001", (String)"OnbrdInviteOperateListPlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject(FEEDBACK, ResManager.loadKDString((String)"\u6821\u9a8c\u53cd\u9988", (String)"OnbrdInviteOperateListPlugin_7", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        return headDataList;
    }

    private List<Map<String, Object>> getExportDataListWithConfirmCount(DynamicObject[] dynamicObjects, String type) {
        ArrayList<Map<String, Object>> exportdatalist = new ArrayList<Map<String, Object>>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            StringBuilder feedback = new StringBuilder();
            this.getExportDataListWithConfirmCountInfo(type, exportdatalist, dynamicObject, feedback);
        }
        return exportdatalist;
    }

    private List<Map<String, Object>> getExportDataListWithConfirmCount(DynamicObject[] dynamicObjects, String type, Map<Long, String> messageMap) {
        ArrayList<Map<String, Object>> exportdatalist = new ArrayList<Map<String, Object>>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            StringBuilder feedback = new StringBuilder();
            String message = messageMap.get(dynamicObject.getLong("id"));
            if (StringUtils.isNotBlank((CharSequence)message)) {
                feedback.append(message);
            }
            this.getExportDataListWithConfirmCountInfo(type, exportdatalist, dynamicObject, feedback);
        }
        return exportdatalist;
    }

    private void getExportDataListWithConfirmCountInfo(String type, List<Map<String, Object>> exportdatalist, DynamicObject dynamicObject, StringBuilder feedback) {
        DynamicObject onbrdObj = dynamicObject.getDynamicObject("onbrd");
        String enrollStatus = onbrdObj.getString("enrollstatus");
        if (HRStringUtils.equals((String)OnbrdStatusEnum.HAS_ONBRD.toString(), (String)enrollStatus) || HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.toString(), (String)enrollStatus)) {
            feedback.append(ResManager.loadKDString((String)"\u5165\u804c\u6d41\u7a0b\u5df2\u5b8c\u6210\u3002", (String)"OnbrdInviteOperateListPlugin_9", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        if ("2".equals(type)) {
            String loginStatus = dynamicObject.getString("loginstatus");
            if (LoginStatusEnum.HAS_LOGIN.getValue().equals(loginStatus)) {
                feedback.append(ResManager.loadKDString((String)"\u767b\u5f55\u72b6\u6001\u5df2\u767b\u5f55", (String)"OnbrdInviteOperateListPlugin_16", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            }
        }
        String sendStatus = dynamicObject.getString("sendstatus");
        if (SendStatusEnum.WAIT_SEND.getValue().equals(sendStatus)) {
            feedback.append(ResManager.loadKDString((String)"\u8bf7\u5148\u64cd\u4f5c\u201c\u53d1\u9001\u9080\u7ea6\u201d\u3002", (String)"OnbrdInviteOperateListPlugin_23", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        Map<String, Object> personInfoMap = this.getExportDataListData(dynamicObject, feedback.toString());
        exportdatalist.add(personInfoMap);
    }

    private Map<String, Object> getExportDataListData(DynamicObject dynamicObject, String feedback) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        DynamicObject onbrdInfoObj = dynamicObject.getDynamicObject("onbrd");
        resultMap.put("name", onbrdInfoObj.getString("name"));
        resultMap.put("candidatenumber", onbrdInfoObj.getString("candidate.number"));
        resultMap.put("employeeno", onbrdInfoObj.getString("employeeno"));
        Date effectDate = onbrdInfoObj.getDate("effectdate");
        if (Objects.nonNull(effectDate)) {
            resultMap.put("effectdate", HRDateTimeUtils.format((Date)effectDate, (String)"yyyy/MM/dd"));
        }
        Map enrollStatusComboPropValueMap = ComboPropValueUtils.comboPropValue((String)"hom_onbrdbilltpl", (String)"enrollstatus");
        resultMap.put("enrollstatus", enrollStatusComboPropValueMap.get(onbrdInfoObj.getString("enrollstatus")));
        Map sendStatusComboPropValueMap = ComboPropValueUtils.comboPropValue((String)"hom_invitesendbill", (String)"sendstatus");
        resultMap.put("sendstatus", sendStatusComboPropValueMap.get(dynamicObject.getString("sendstatus")));
        Map welcomeLetterSendStatusMap = ComboPropValueUtils.comboPropValue((String)"hom_invitesendbill", (String)"welcomelettersendstatus");
        resultMap.put("welcomelettersendstatus", welcomeLetterSendStatusMap.get(dynamicObject.getString("welcomelettersendstatus")));
        Map inviteMessageSendStatusMap = ComboPropValueUtils.comboPropValue((String)"hom_invitesendbill", (String)"invitemessagesendstatus");
        resultMap.put("invitemessagesendstatus", inviteMessageSendStatusMap.get(dynamicObject.getString("invitemessagesendstatus")));
        Map loginStatusComboPropValueMap = ComboPropValueUtils.comboPropValue((String)"hom_invitesendbill", (String)"loginstatus");
        resultMap.put("loginstatus", loginStatusComboPropValueMap.get(dynamicObject.getString("loginstatus")));
        resultMap.put(FEEDBACK, feedback);
        return resultMap;
    }
}

