/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.invite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class OrderOnbrdConfirmEdit
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(OrderOnbrdConfirmEdit.class);
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String EXPORT_EXCEL = "exportexcel";
    private static final String FITPERSONID = "fitpersonid";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_OK, EXPORT_EXCEL});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Label allPersonLabel = (Label)formView.getControl("allperson");
        int allPersonCount = (Integer)formShowParameter.getCustomParam("allperson");
        allPersonLabel.setText(String.valueOf(allPersonCount));
        Label fitPersonLabel = (Label)formView.getControl("fitperson");
        int fitPersonCount = (Integer)formShowParameter.getCustomParam("fitperson");
        fitPersonLabel.setText(String.valueOf(fitPersonCount));
        Label noFitPersonLabel = (Label)formView.getControl("nofitperson");
        int noFitPersonCount = (Integer)formShowParameter.getCustomParam("nofitperson");
        noFitPersonLabel.setText(String.valueOf(noFitPersonCount));
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            Control control = (Control)evt.getSource();
            IFormView formView = this.getView();
            HashMap<String, String> dataMap = new HashMap<String, String>(3);
            switch (control.getKey()) {
                case "btnok": {
                    dataMap.put("result", "ok");
                    formView.returnDataToParent(dataMap);
                    formView.close();
                    break;
                }
                case "btncancel": {
                    dataMap.put("result", "cancel");
                    formView.returnDataToParent(dataMap);
                    formView.close();
                    break;
                }
                case "exportexcel": {
                    this.exportExcel();
                    break;
                }
            }
        }
    }

    private void exportExcel() {
        String excelName = (String)this.getView().getFormShowParameter().getCustomParam("excelname");
        List exportDataList = (List)this.getView().getFormShowParameter().getCustomParam("exportdatalist");
        List headDataLst = new ArrayList();
        try {
            headDataLst = (List)HRJSONUtils.cast((String)this.getView().getFormShowParameter().getCustomParam("headdatalist").toString(), List.class, (Class[])new Class[]{HRExportHeadObject.class});
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
            this.getView().showErrMessage(iOException.getMessage(), " Fail to cast json ! Reason: ");
        }
        String exportUrl = null;
        try {
            exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, (List)exportDataList, headDataLst);
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
            this.getView().showErrMessage(iOException.getMessage(), " Fail to get export Excel url ! Reason: ");
        }
        if (!HRStringUtils.isEmpty((String)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }
}

