/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hom.business.application.rule.IOnbrdCommonValidator;
import kd.hr.hom.business.application.utils.RuleCodeUtils;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.common.constant.EmpNoRuleCodeConstants;
import kd.hr.hom.common.entity.HomCommonWrapper;
import kd.hr.hom.common.enums.EmployeeNoSchemeEnum;

public class EmpNoRulePlugin
extends HRDataBaseList
implements EmpNoRuleCodeConstants {
    private static final Log LOGGER = LogFactory.getLog(EmpNoRulePlugin.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"EmpNoRulePlugin#&", (int)10, (int)1000);

    public void afterCreateNewData(EventObject event) {
        this.initDate();
    }

    private void initDate() {
        DynamicObject[] dys = this.getRowsCollection();
        this.setNumber(dys);
        this.setRows(dys);
        this.initVisible();
        Label label = (Label)this.getView().getControl("rehiretips");
        label.setText(ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u5171\u6709{0}\u4f4d\u5458\u5de5\u5df2\u751f\u6210\u5de5\u53f7\uff1a", (String)"EmpNoRulePlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[]{dys == null ? 0 : dys.length}));
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObjectCollection entryentityDys = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryentityDys.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryentityDys.get(i);
            String employeeNoScheme = dynamicObject.getString("onbrdbill.employeenoscheme");
            if (!EmployeeNoSchemeEnum.OLD_EMPLOYEE_NO.getValue().equals(employeeNoScheme)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"employeeno"});
        }
    }

    private void setRows(DynamicObject[] dys) {
        if (ArrayUtils.isEmpty((Object[])dys)) {
            return;
        }
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        EntryProp entryProp = (EntryProp)dataEntity.getDataEntityType().getProperties().get((Object)"entryentity");
        EntryType entryType = (EntryType)entryProp.getItemType();
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity");
        rows.remove(0);
        Arrays.stream(dys).forEach(dy -> {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set("onbrdbill", dy);
            row.set("aposition", (Object)this.getPositionName((DynamicObject)dy));
            row.set("employeeno", (Object)dy.getString("employeeno"));
            rows.add((Object)row);
        });
    }

    private DynamicObject[] getRowsCollection() {
        List<Long> ids = this.getIds();
        if (CollectionUtil.isEmpty(ids)) {
            return new DynamicObject[0];
        }
        return this.getRowsCollection(ids);
    }

    private List<Long> getIds() {
        JSONArray keys = (JSONArray)this.getView().getFormShowParameter().getCustomParam("select_ids");
        if (CollectionUtil.isEmpty((Collection)keys)) {
            return new ArrayList<Long>();
        }
        return keys.stream().map(key -> (Long)key).collect(Collectors.toList());
    }

    private DynamicObject[] getRowsCollection(List<Long> ids) {
        DynamicObject[] dys = HomCommonRepository.queryDynamicObjectByPks((String)"hom_onbrdbillbase", (String)"id,effectdate,org,employeeno,acompany,aadminorg,laborreltype,onbrdtype,candidatenumber,org,apositiontype,acompany,aadminorg,aposition.name,stdposition.name,ajob.name,employeenoscheme,isreplacenumber", (String)"effectdate asc", (Object[])ids.toArray(new Object[0]));
        return dys;
    }

    public String getPositionName(DynamicObject dy) {
        String type;
        switch (type = dy.getString("apositiontype") == null ? "1" : dy.getString("apositiontype")) {
            case "0": {
                return dy.getString("stdposition.name");
            }
            case "1": {
                return dy.getString("aposition.name");
            }
            case "2": {
                return dy.getString("ajob.name");
            }
        }
        return " ";
    }

    private void initVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"onbrdbill"});
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String fieldKey = event.getProperty().getName();
        if (HRStringUtils.equals((String)"employeeno", (String)fieldKey)) {
            ChangeData change = event.getChangeSet()[0];
            String newNo = (String)change.getNewValue();
            String oldNo = (String)change.getOldValue();
            DynamicObject dy = change.getDataEntity();
            DynamicObject onbrdDy = dy.getDynamicObject("onbrdbill");
            List<DynamicObject> collection = this.getEntityCollection();
            if (HRStringUtils.isNotEmpty((String)newNo) && this.checkEntityNum(collection)) {
                this.checkNumber(onbrdDy);
            }
            this.oldNoHand(oldNo, onbrdDy);
        }
    }

    private void setNumber(DynamicObject[] onbrds) {
        if (ArrayUtils.isEmpty((Object[])onbrds)) {
            return;
        }
        ConcurrentHashMap recycleMap = new ConcurrentHashMap();
        ArrayList futurelist = new ArrayList(onbrds.length);
        LOGGER.info("EmpNoRulePlugin_getNumber_start");
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        boolean match = Arrays.stream(onbrds).anyMatch(dy -> HRStringUtils.isEmpty((String)dy.getString("employeeno")));
        Arrays.stream(onbrds).filter(dy -> HRStringUtils.isEmpty((String)dy.getString("employeeno"))).forEach(dy -> {
            Future future = THREAD_POOL.submit(() -> {
                ArrayList codeList = new ArrayList(1);
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_employeeno");
                DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                dynamicObject.set("onbrdbill", dy);
                RuleCodeUtils.codeRuleHandler((DynamicObject)dynamicObject, codeList, (int)1, (int)1);
                if (CollectionUtil.isEmpty(codeList)) {
                    return " ";
                }
                atomicBoolean.set(true);
                dy.set("employeeno", codeList.get(0));
                recycleMap.put(codeList.get(0), dy.getString("id"));
                return (String)codeList.get(0);
            }, RequestContext.get());
            futurelist.add(future);
        });
        futurelist.stream().forEach(future -> {
            try {
                future.get();
            }
            catch (Exception ext) {
                LOGGER.error("EmpNoRulePlugin_setNumber_error", (Throwable)ext);
            }
        });
        LOGGER.info("EmpNoRulePlugin_getNumber_end");
        if (!atomicBoolean.get() && match) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5de5\u53f7\u751f\u6210\u89c4\u5219\uff0c\u987b\u624b\u52a8\u586b\u5199\u5de5\u53f7\u3002", (String)"EmpNoRulePlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        HRPageCache pageCache = new HRPageCache(this.getView());
        pageCache.put("recycleMap", recycleMap);
        pageCache.put("oldno", recycleMap.keySet());
    }

    public void checkNumber(DynamicObject onbrdDy) {
        Set<String> numlist = this.checkDataBase(new ArrayList<DynamicObject>(Collections.singletonList(onbrdDy)));
        if (CollectionUtil.isNotEmpty(numlist)) {
            String msg = numlist.toString();
            this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u7684\u5de5\u53f7\u5df2\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"EmpNoRulePlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[]{msg.substring(1, msg.length() - 1)}));
        } else {
            IPageCache pageCache = this.getPageCache();
            String warnMsg = pageCache.get(onbrdDy.getString("id"));
            if (StringUtils.isNotBlank((CharSequence)warnMsg)) {
                this.getView().showTipNotification(warnMsg);
            }
        }
    }

    public void oldNoHand(String oldNo, DynamicObject onbrdDy) {
        String dyId;
        HRPageCache cache = new HRPageCache(this.getView());
        Map map = (Map)cache.get("recycleMap", Map.class);
        if (Objects.isNull(map) || CollectionUtil.isEmpty(map.keySet())) {
            return;
        }
        Set numSet = map.keySet();
        if (!numSet.contains(oldNo)) {
            return;
        }
        String billId = onbrdDy.getString("id");
        if (HRStringUtils.equals((String)billId, (String)(dyId = String.valueOf(map.get(oldNo))))) {
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(Long.valueOf(dyId));
            Map<Long, DynamicObject> onbrdBillMap = this.getOnbrdBillMap(ids);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_employeeno");
            DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
            dynamicObject.set("onbrdbill", (Object)onbrdBillMap.get(Long.valueOf(dyId)));
            RuleCodeUtils.recycleNumber((DynamicObject)dynamicObject, (String)oldNo);
            map.remove(oldNo);
        }
        cache.put("recycleMap", (Object)map);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        List<DynamicObject> collection;
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)"donothing_save", (String)args.getOperateKey()) && this.saveCheck(collection = this.getEntityCollection())) {
            this.saveUpData(collection);
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f!", (String)"EmpNoRulePlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
        if (HRStringUtils.equals((String)"donothing_onbor", (String)args.getOperateKey())) {
            collection = this.getEntityCollection();
            if (this.checkNumberIsEmpty(collection)) {
                return;
            }
            if (this.saveCheck(collection)) {
                this.saveUpData(collection);
                this.getView().getParentView().invokeOperation("doconfirm");
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
            }
        }
    }

    public boolean checkNumberIsEmpty(List<DynamicObject> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return true;
        }
        boolean result = collection.stream().anyMatch(dy -> HRStringUtils.isEmpty((String)dy.getString("employeeno")));
        if (result) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u5165\u804c\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u5de5\u53f7\u4e3a\u7a7a\u7684\u6570\u636e\u3002", (String)"EmpNoRulePlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    private boolean saveCheck(List<DynamicObject> collection) {
        if (!this.checkEntityNum(collection)) {
            return false;
        }
        List numberList = collection.stream().map(dynamicObject -> dynamicObject.getString("employeeno")).collect(Collectors.toList());
        for (String number : numberList) {
            if (number.trim().length() <= 30) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u5de5\u53f7\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c30]\u3002", (String)"EmpNoRulePlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return false;
        }
        Set<String> list = this.checkDataBase(collection);
        if (CollectionUtil.isNotEmpty(list)) {
            String msg = list.toString();
            this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u7684\u5de5\u53f7\u5df2\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"EmpNoRulePlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[]{msg.substring(1, msg.length() - 1)}));
            return false;
        }
        return true;
    }

    private void saveUpData(List<DynamicObject> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return;
        }
        DynamicObject[] dys = this.getRowsCollection();
        Map<Long, String> map = collection.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("employeeno")));
        Map<Long, String> isreplacenumberMap = collection.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("isreplacenumber")));
        Arrays.stream(dys).forEach(dy -> {
            dy.set("employeeno", map.get(dy.getLong("id")));
            dy.set("isreplacenumber", isreplacenumberMap.get(dy.getLong("id")));
        });
        HomCommonRepository.updateDynamicObjects((String)"hom_onbrdbillbase", (DynamicObject[])dys);
        this.getView().getPageCache().remove("recycleMap");
    }

    public void cancel() {
        List<DynamicObject> collection = this.getEntityCollection();
        HRPageCache cache = new HRPageCache(this.getView());
        Map map = (Map)cache.get("recycleMap", Map.class);
        this.asynRecycleEmpNo(collection, map);
    }

    public List<DynamicObject> getEntityCollection() {
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("entryentity");
        return entryEntity.stream().map(dy -> {
            DynamicObject obrd = dy.getDynamicObject("onbrdbill");
            obrd.set("employeeno", (Object)dy.getString("employeeno"));
            return obrd;
        }).collect(Collectors.toList());
    }

    public void asynRecycleEmpNo(List<DynamicObject> collection, Map<String, String> map) {
        if (CollectionUtil.isEmpty(collection) || HRObjectUtils.isEmpty(map) || map.isEmpty()) {
            return;
        }
        List<Long> ids = collection.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Map<Long, DynamicObject> onbrdBillMap = this.getOnbrdBillMap(ids);
        THREAD_POOL.execute(() -> collection.stream().forEach(dy -> {
            String emId = (String)map.get(dy.getString("employeeno"));
            if (HRStringUtils.equals((String)dy.getString("id"), (String)emId)) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hom_employeeno");
                DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
                dynamicObject.set("onbrdbill", onbrdBillMap.get(dy.getLong("id")));
                RuleCodeUtils.recycleNumber((DynamicObject)dynamicObject, (String)dy.getString("employeeno"));
            }
        }));
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        IHomDataMutexService.getInstance().batchRelease(this.getIds(), "hom_personwaitonbrd", "getempno");
        this.cancel();
    }

    private boolean checkEntityNum(List<DynamicObject> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return true;
        }
        List<String> identicalName = this.getIdenticalName(collection);
        if (CollectionUtil.isNotEmpty(identicalName)) {
            String msg = identicalName.toString();
            this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u7684\u5de5\u53f7\u5df2\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"EmpNoRulePlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[]{msg.substring(1, msg.length() - 1)}));
            return false;
        }
        return true;
    }

    private Set<String> checkDataBase(List<DynamicObject> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return new HashSet<String>(0);
        }
        AtomicInteger num = new AtomicInteger();
        List rowDataWrapperList = collection.stream().map(entity -> new HomCommonWrapper(entity, entity, num.getAndIncrement(), (Object)this, null)).collect(Collectors.toList());
        IOnbrdCommonValidator onbrdCommonValidator = IOnbrdCommonValidator.getInstance();
        onbrdCommonValidator.judgeEmployeenoIfDuplicate(rowDataWrapperList);
        onbrdCommonValidator.judgeDuplicateByHrpiRpc(rowDataWrapperList, (List)ImmutableList.of((Object)"employeeno"));
        onbrdCommonValidator.validNumber(rowDataWrapperList);
        IPageCache pageCache = this.getPageCache();
        Map<Long, String> warningMap = rowDataWrapperList.stream().filter(rowData -> rowData.getWarningMsgs() != null && rowData.getWarningMsgs().peek() != null).collect(Collectors.toMap(rowData -> rowData.getBizData().getLong("id"), rowData -> rowData.getWarningMsgs().element().toString()));
        for (DynamicObject dynamicObject : collection) {
            String warnMsg = warningMap.get(dynamicObject.getLong("id"));
            if (!StringUtils.isNotBlank((CharSequence)warnMsg)) continue;
            pageCache.put(dynamicObject.getString("id"), warnMsg);
        }
        return rowDataWrapperList.stream().filter(rowData -> rowData.getErrorMsgNum() > 0).map(rowData -> rowData.getBizData().getString("name")).collect(Collectors.toSet());
    }

    private List<String> getIdenticalName(List<DynamicObject> onbrds) {
        if (CollectionUtil.isEmpty(onbrds)) {
            return new ArrayList<String>(0);
        }
        Map<String, List<DynamicObject>> listMap = onbrds.stream().filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString("employeeno"))).collect(Collectors.groupingBy(dy -> dy.getString("employeeno")));
        ArrayList<String> list = new ArrayList<String>();
        listMap.forEach((key, value) -> {
            if (CollectionUtil.isNotEmpty((Collection)value) && value.size() > 1) {
                this.getName((List<String>)list, (List<DynamicObject>)value);
            }
        });
        return list;
    }

    private void getName(List<String> list, List<DynamicObject> dys) {
        if (CollectionUtil.isEmpty(dys)) {
            return;
        }
        dys.stream().forEach(dy -> list.add(dy.getString("name")));
    }

    public Map<Long, DynamicObject> getOnbrdBillMap(List<Long> ids) {
        Object[] dys = this.getRowsCollection(ids);
        if (ArrayUtils.isEmpty((Object[])dys)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        return Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
    }
}

