/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.sdk.hr.hpfs.business.config.repository.DevParamConfigRepository;
import org.apache.commons.lang3.StringUtils;

public class OnboardCadreInfoEdit
extends HRDataBaseEdit {
    private static final String APP_DISPATCH_NUM_CHANGE = "prop_change_save";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String appNumChange;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (("save".equals(operateKey) || "submit".equals(operateKey) || "submiteffect".equals(operateKey)) && StringUtils.isNotBlank((CharSequence)(appNumChange = this.getPageCache().get(APP_DISPATCH_NUM_CHANGE)))) {
            args.setCancel(true);
            this.getPageCache().remove(APP_DISPATCH_NUM_CHANGE);
        }
    }

    public Boolean enableSihc() {
        Boolean enableSihc = (Boolean)HRMServiceHelper.invokeHRMPService((String)"soecs", (String)"SystemConfigMService", (String)"enableSihc", (Object[])new Object[0]);
        return enableSihc;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"appdispatchnum")) {
            if (!this.enableSihc().booleanValue()) {
                return;
            }
            String viewType = this.getModel().getDataEntity().getString("viewtype");
            if (HRStringUtils.equals((String)viewType, (String)"2")) {
                this.appDispatchNumChange(e.getChangeSet()[0]);
            }
        }
    }

    private void appDispatchNumChange(ChangeData changeData) {
        String newDispatchNum = (String)changeData.getNewValue();
        if (StringUtils.isNotBlank((CharSequence)newDispatchNum)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long employeeId = dataEntity.getLong("personfield.id");
            String appDispatchNum = dataEntity.getString("appdispatchnum");
            DynamicObject appointRemoveRelObj = this.getAppointRemoveRelObj(appDispatchNum, employeeId);
            if (appointRemoveRelObj != null) {
                long appRemRelId = appointRemoveRelObj.getLong("id");
                if (OnboardCadreInfoEdit.needConfirmAppointmentWritten()) {
                    this.getPageCache().put(APP_DISPATCH_NUM_CHANGE, "1");
                    this.getPageCache().put("appremoverel", String.valueOf(appRemRelId));
                    String tipContent = this.getAppDispatchNumChangeTip(appointRemoveRelObj, dataEntity);
                    ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("appremoverel", (IFormPlugin)this);
                    this.getView().showConfirm(tipContent, MessageBoxOptions.OKCancel, confirmCallBack);
                } else {
                    this.getModel().setValue("appremoverel", (Object)appRemRelId);
                }
            }
        }
    }

    private String getAppDispatchNumChangeTip(DynamicObject appointRemoveRelObj, DynamicObject dataEntity) {
        String positionName;
        String adminOrgName;
        StringBuilder tipContent = new StringBuilder();
        String personName = dataEntity.getString("personfield.person.name");
        String appDispatchNum = dataEntity.getString("appdispatchnum");
        tipContent.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230\u5458\u5de5(\u59d3\u540d\uff1a{0}\uff09\u5df2\u6709\u57fa\u4e8e\u53d1\u6587\u6587\u53f7\u201c{1}\u201d\u7684\u4efb\u547d\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u6839\u636e\u8be5\u4efb\u547d\u4fe1\u606f\u8fdb\u884c\u5165\u804c\u7533\u8bf7\uff1f", (String)"OnboardCadreInfoEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[]{personName, appDispatchNum}));
        tipContent.append("\r\n");
        tipContent.append(ResManager.loadKDString((String)"\u4efb\u547d\u4fe1\u606f\uff1a", (String)"OnboardCadreInfoEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        ArrayList appointRemoveInfoList = Lists.newArrayListWithExpectedSize((int)3);
        String companyName = appointRemoveRelObj.getString("company.name");
        if (StringUtils.isNotBlank((CharSequence)companyName)) {
            appointRemoveInfoList.add(companyName);
        }
        if (StringUtils.isNotBlank((CharSequence)(adminOrgName = appointRemoveRelObj.getString("adminorgvid.name")))) {
            appointRemoveInfoList.add(adminOrgName);
        }
        if (StringUtils.isNotBlank((CharSequence)(positionName = appointRemoveRelObj.getString("positionvid.name")))) {
            appointRemoveInfoList.add(positionName);
        }
        tipContent.append(String.join((CharSequence)"/", appointRemoveInfoList));
        return tipContent.toString();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("appremoverel".equals(messageBoxClosedEvent.getCallBackId())) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes == result) {
                String appRemRelIdStr = this.getPageCache().get("appremoverel");
                long appRemRelId = Long.parseLong(appRemRelIdStr);
                this.getModel().setValue("appremoverel", (Object)appRemRelId);
            }
            this.getPageCache().remove(APP_DISPATCH_NUM_CHANGE);
        }
    }

    private DynamicObject getAppointRemoveRelObj(String appDispatchNum, long employeeId) {
        DynamicObject[] dynamicObjects = IHomToHrpiAppService.getInstance().queryAppointRemovErels(Long.valueOf(employeeId), appDispatchNum);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        if (dynamicObjects.length > 1) {
            return null;
        }
        return dynamicObjects[0];
    }

    private static boolean needConfirmAppointmentWritten() {
        DynamicObject paramConfig = DevParamConfigRepository.queryConfigByBusinessKey((String)"confirm_appointment_written");
        return paramConfig.getBoolean("businessvalue");
    }
}

