/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.workflow.form.operate.flowchart.AbstractViewFlowchart;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hbp.IHrCertCommonAppService;
import kd.hr.hom.business.application.impl.onbrd.OnbrdBreakupAppServiceImpl;
import kd.hr.hom.business.application.impl.onbrd.OnbrdConfirmAppServiceImpl;
import kd.hr.hom.business.application.impl.onbrd.OnbrdStartUpAppServiceImpl;
import kd.hr.hom.business.application.impl.rule.OnbrdConfirmValidatorService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.business.domain.service.impl.onbrd.OnbrdInfoInitService;
import kd.hr.hom.business.domain.service.integrate.IIntegrateService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.OnbrdBlackListStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.SynchStatusEnum;
import kd.hr.hom.common.enums.VerifyCertTypeEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.formplugin.web.base.HomOnbrdDataBaseEdit;
import kd.sdk.hr.hom.business.onbrd.IConfirmOnbrdService;

public class OnbrdBodyHandleInfoPlugin
extends HomOnbrdDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(OnbrdBodyHandleInfoPlugin.class);
    private static final String KEY_BTN_START = "barstart";
    private static final String KEY_BTN_CONFIRM = "barconfirm";
    private static final String KEY_BTN_SYNCPERSON = "btn_syncperson";
    private static final String KEY_BTN_BREAKUP = "barbreakup";
    private static final String BTN_CLOSE = "barclose";
    private static final String OPKEY_START = "startupflow";
    private static final String OPKEY_CONFIRM = "doconfirm";
    private static final String OPKEY_BREAKUP = "breakup";
    private static final String KEY_BTN_BILLEDIT = "btn_billedit";
    private static final String KEY_BTN_BILLSAVE = "btn_billsave";
    private static final String KEY_SELECTTPLPRINT = "selecttplprint";
    private static final String KEY_BTN_BILLCANCEL = "btn_billcancel";
    private static final String LABELKEY_NEW_BILLTIPS = "new_billtips";
    private static final String TABPAGE_KEY_ACTIVITY = "tabactivity";
    private static final String FLEXPANELAP = "flexpanelap";
    private static final String BARSAVE = "barsave";
    private static final String BARPRINT = "barprint";
    private static final String TIP_NOTIFICATION = "tipNotification";
    private static final String ERROR_NOTIFICATION = "errorNotification";
    private static final String MODIFY = "modify";
    private static final String BARINFOVIEW = "barinfoview";
    private static final String VIEWFLOWCHART = "viewflowchart";
    private static final String BARUNSUBMITAP = "barunsubmitap";
    private static final String VIEWREASON = "viewreason";
    private static final String VIEWREASONERR = "viewreasonerr";
    public static final String EMPLOYEENO_CONNECTION_SWITCH = "employrity_connection_switch";
    private static final Map<String, String> CLOSE_MAP = ImmutableMap.builder().put((Object)"tipcloseap", (Object)"tipflexpanelap").put((Object)"warncloseap", (Object)"warnflexpanelap").put((Object)"cwarncloseap", (Object)"cwarningflexpanelap").put((Object)"cerrorcloseap", (Object)"cerrorflexpanelap").put((Object)"errorcloseap", (Object)"errorflexpanelap").put((Object)"rulewarncloseap", (Object)"rulewarnap").build();

    public void beforeBindData(EventObject eventObject) {
        String errorNotification;
        super.beforeBindData(eventObject);
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        IOnbrdBillDomainService.getInstance().generateViewForEnrollStatus(onbrdId, this.getView(), new String[]{FLEXPANELAP});
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_personinfoclose", "btn_personinfosave", "btn_contactclose", "btn_contactsave", "btn_checkclose", "btn_checksave", BARSAVE, BARUNSUBMITAP, "tipflexpanelap"});
        String tipNotification = (String)this.getView().getFormShowParameter().getCustomParam(TIP_NOTIFICATION);
        if (HRStringUtils.isNotEmpty((String)tipNotification)) {
            this.getView().showTipNotification(tipNotification);
        }
        if (HRStringUtils.isNotEmpty((String)(errorNotification = (String)this.getView().getFormShowParameter().getCustomParam(ERROR_NOTIFICATION)))) {
            this.getView().showErrorNotification(errorNotification);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdId);
        String selProp = "enrollstatus" + "," + "synchstatus";
        DynamicObject onbrdDyObj = IOnbrdBillDomainService.getInstance().findOnbrdBill(selProp, new QFilter[]{qFilter});
        if (HRObjectUtils.isEmpty((Object)onbrdDyObj)) {
            LOGGER.info("Can not find OnbrdBill By the PkId " + onbrdId);
            this.getView().getFormShowParameter().setCustomParam("onbrdid", (Object)"0");
            this.showPageForCreateOnbrdBill();
            this.getView().setVisible(Boolean.FALSE, new String[]{"activitypanel", VIEWFLOWCHART});
            return;
        }
        String enrollStatus = onbrdDyObj.getString("enrollstatus");
        this.getPageCache().put("enrollstatus", enrollStatus);
        if (OnbrdStatusEnum.WAIT_ONBRD.toString().equals(enrollStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_START});
            this.getView().setVisible(Boolean.TRUE, new String[]{BARUNSUBMITAP});
        } else if (OnbrdStatusEnum.HAS_ONBRD.toString().equals(enrollStatus) || OnbrdStatusEnum.BREAK_UP.toString().equals(enrollStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MODIFY, KEY_BTN_START, KEY_BTN_CONFIRM, KEY_BTN_BREAKUP, KEY_BTN_BILLEDIT});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap", "advcontoolbarap1", "advcontoolbarap1111121"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_CONFIRM, KEY_BTN_BREAKUP, TABPAGE_KEY_ACTIVITY});
        }
        if (OnbrdStatusEnum.WAIT_START.toString().equals(enrollStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{VIEWFLOWCHART});
        }
        String synchStatus = onbrdDyObj.getString("synchstatus");
        if (OnbrdStatusEnum.HAS_ONBRD.toString().equals(enrollStatus) && (SynchStatusEnum.SYNCH_FAIL.getValue().equals(synchStatus) || SynchStatusEnum.SYNCH_WAIT.getValue().equals(synchStatus))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_SYNCPERSON});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_SYNCPERSON});
        }
        this.showEntryBaseInfo("hom_onbrddetailhead", "persononbrdhead", onbrdId, "");
        Tuple<String, String> dataIds = this.getOnbrdId();
        this.showOnbrdInfo(dataIds, enrollStatus);
        if (!OnbrdStatusEnum.WAIT_START.toString().equals(enrollStatus)) {
            this.showActivityInfo(dataIds);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"activitypanel"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"lblcheckagain", VIEWREASON, VIEWREASONERR});
    }

    private void showPageForCreateOnbrdBill() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String message = (String)formShowParameter.getCustomParam("message");
        if (HRStringUtils.isNotEmpty((String)message)) {
            this.getView().showTipNotification(message);
        }
        if (HRStringUtils.isEmpty((String)((String)formShowParameter.getCustomParam("hasCheck")))) {
            this.certCheck();
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTN_START, BARSAVE, LABELKEY_NEW_BILLTIPS});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTN_CONFIRM, KEY_BTN_BREAKUP, KEY_BTN_BILLEDIT, TABPAGE_KEY_ACTIVITY, KEY_BTN_BILLCANCEL, BARPRINT, KEY_BTN_SYNCPERSON, "activitypanel", VIEWFLOWCHART, MODIFY});
        DynamicObject dataInfo = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hom_onbrdbillbase"));
        dataInfo.set("viewtype", this.getView().getFormShowParameter().getCustomParam("viewtype"));
        String[] billNos = new OnbrdInfoInitService().getNumberByCodeRules(dataInfo, "", 1);
        if (billNos != null && billNos.length > 0) {
            String billNo = billNos[0];
            this.getPageCache().put("billno", billNo);
            this.showEntryBaseInfo("hom_onbrddetailhead", "persononbrdhead", 0L, billNo);
            Tuple dataIds = Tuple.create((Object)"0", (Object)"0");
            this.showEmbedBillPage("hom_onbrdinfo", "onbrdpanel", (Tuple<String, String>)dataIds, OperationStatus.ADDNEW, billNo);
        } else {
            LOGGER.info("Cannot generate billNo!");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u89c4\u5219\u3002", (String)"OnbrdBodyHandleInfoPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        this.clickOnPageTopExtend(opKey);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)"donothing_close", (String)opKey)) {
            if (!this.checkDataChange()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u51fa\uff1f", (String)"OnbrdBodyInfoPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_CLOSE, (IFormPlugin)this));
            } else {
                this.getView().close();
            }
            this.invokeChildOperationResult("hom_onbrdinfo", "close");
            return;
        }
        if (HRStringUtils.equals((String)"donothing_view", (String)opKey)) {
            this.openOnbrdInfo();
        }
        Tuple<String, String> dataIds = this.getOnbrdId();
        this.clickOnPageTop(opKey, dataIds);
        this.clickOnOnbrdInfo(opKey, dataIds);
    }

    private void clickOnPageTopExtend(String opKey) {
        if ("donothing_viewflowchart".equals(opKey) || "unsubmit".equals(opKey) || "refreshactivity".equals(opKey)) {
            IFormView childView = this.getEmbedPageView("hom_onbrdinfo");
            if (childView == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"HomOnbrdDataBaseEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            switch (opKey) {
                case "donothing_viewflowchart": {
                    AbstractViewFlowchart vfc = new AbstractViewFlowchart();
                    vfc.showFlowchart(childView);
                    this.getView().sendFormAction(childView);
                    break;
                }
                case "unsubmit": {
                    OperationResult operationResult = childView.invokeOperation("unsubmit");
                    this.getView().sendFormAction(childView);
                    if (operationResult != null && !operationResult.isSuccess()) {
                        LOGGER.info("operationResult.isSuccess():{}", (Object)operationResult.isSuccess());
                        return;
                    }
                    this.reloadAllPage("hom_onbrdinfo", "", "");
                    break;
                }
                case "refreshactivity": {
                    Tuple<String, String> dataIds = this.getOnbrdId();
                    this.showActivityInfo(dataIds);
                    break;
                }
            }
        }
    }

    private void openOnbrdInfo() {
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        if (!onbrdCommonAppService.checkPermissionAndShowTips("hom_onbrdpersoninfo", "47150e89000000ac", this.getView())) {
            return;
        }
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        DynamicObject onbrdDyObj = IOnbrdBillDomainService.getInstance().findOnbrdBillById("id,name,candidate", (Object)onbrdId);
        IOnbrdCommonAppService.getInstance().openOnbrdCandidateInfoPage(this.getView(), onbrdDyObj);
    }

    private boolean checkDataChange() {
        IFormView childView = this.getEmbedPageView("hom_onbrdinfo");
        return this.childViewChange(childView);
    }

    private boolean childViewChange(IFormView childView) {
        try {
            if (childView != null && childView.getModel() != null && childView.getModel().getDataChanged()) {
                return false;
            }
        }
        catch (KDException exp) {
            LOGGER.warn((Throwable)exp);
        }
        return true;
    }

    private void setViewNotChange(IFormView iFormView) {
        try {
            if (iFormView != null && iFormView.getModel() != null) {
                iFormView.getModel().setDataChanged(false);
            }
        }
        catch (KDException exp) {
            LOGGER.warn((Throwable)exp);
        }
    }

    private void clickOnOnbrdInfo(String lblKey, Tuple<String, String> dataIds) {
        IOnbrdCommonAppService onbrdCommonAppService = IOnbrdCommonAppService.getInstance();
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)dataIds.item1);
        HashMap clickOnOnbrdInfoMap = Maps.newHashMapWithExpectedSize((int)6);
        clickOnOnbrdInfoMap.put(KEY_BTN_BILLSAVE, () -> this.keyBtnBillSave(onbrdCommonAppService, onbrdBillId));
        clickOnOnbrdInfoMap.put(KEY_SELECTTPLPRINT, () -> this.keySelectTplPrint());
        clickOnOnbrdInfoMap.put(KEY_BTN_BILLCANCEL, () -> this.updatePageStatusToEdit("hom_onbrdinfo", "onbrdpanel", dataIds, KEY_BTN_BILLEDIT, KEY_BTN_BILLSAVE, KEY_BTN_BILLCANCEL, false));
        clickOnOnbrdInfoMap.put(KEY_BTN_SYNCPERSON, () -> this.syncPerson(onbrdCommonAppService, onbrdBillId));
        clickOnOnbrdInfoMap.getOrDefault(lblKey, () -> {}).run();
    }

    private void keySelectTplPrint() {
        IFormView iFormView = this.getView();
        IFormView childView = this.getEmbedPageView("hom_onbrdinfo");
        if (childView == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"HomOnbrdDataBaseEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        if (HRObjectUtils.isEmpty((Object)childView.getModel().getDataEntity())) {
            String warnMsg = ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u5165\u804c\u529e\u7406\u5355\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"HomOnbrdDataBaseEdit_6", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            iFormView.showTipNotification(warnMsg);
            return;
        }
        childView.invokeOperation("refresh");
        iFormView.sendFormAction(childView);
        childView.invokeOperation(KEY_SELECTTPLPRINT);
        iFormView.sendFormAction(childView);
    }

    private void keyBtnBillSave(IOnbrdCommonAppService onbrdCommonAppService, Long onbrdBillId) {
        if (onbrdBillId == null || onbrdBillId == 0L ? !onbrdCommonAppService.checkPermissionAndShowTips("hom_personwaitstart", "47156aff000000ac", this.getView()) : !onbrdCommonAppService.checkPermissionAndShowTips("hom_onbrdinfo", "4715a0df000000ac", this.getView())) {
            return;
        }
        if (!this.checkEnableBeforeSave(onbrdBillId)) {
            return;
        }
        Tuple<Boolean, String> invokeResult = this.invokeChildOperationResult("hom_onbrdinfo", "save");
        if (((Boolean)invokeResult.item1).booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f!", (String)"ACCEPTMANAGE_8", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(msg);
            this.reloadAllPage("hom_onbrdinfo", (String)invokeResult.item2, "");
        }
    }

    private void syncPerson(IOnbrdCommonAppService onbrdCommonAppService, Long onbrdBillId) {
        DynamicObject dy = onbrdCommonAppService.getOnBrdDyo(onbrdBillId.longValue(), "synchstatus");
        if (dy == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"HomOnbrdDataBaseEdit_5", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        String syncStatus = dy.getString("synchstatus");
        if (SynchStatusEnum.SYNCH_SUCCESS.getValue().equals(syncStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u540c\u6b65\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"SyncPersonPlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        if (SynchStatusEnum.SYNCH_DOING.getValue().equals(syncStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SyncPersonPlugin_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            return;
        }
        IIntegrateService.getInstance().syncHpfs(new Long[]{onbrdBillId});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u89e6\u53d1\u540c\u6b65\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u540c\u6b65\u7ed3\u679c", (String)"SyncPersonPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]));
    }

    private boolean certCheck() {
        Map result = IHrCertCommonAppService.getInstance().validate(1);
        String infoType = (String)result.get("infoType");
        String message = (String)result.get("message");
        String showMessage = (String)result.get("showMessage");
        if (HRObjectUtils.equals((Object)infoType, (Object)VerifyCertTypeEnum.FORBIDDEN.getValue())) {
            this.getView().showConfirm(message, MessageBoxOptions.OK, new ConfirmCallBackListener("showMessage"));
            return true;
        }
        if (HRStringUtils.equals((String)showMessage, (String)Boolean.TRUE.toString())) {
            this.getView().showTipNotification(message);
        }
        return false;
    }

    private Tuple<String, String> getOnbrdId() {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        String candidateId = (String)this.getView().getFormShowParameter().getCustomParam("candidateid");
        return Tuple.create((Object)onbrdId.toString(), (Object)candidateId);
    }

    private void showOnbrdInfo(Tuple<String, String> dataIds, String enrollStatus) {
        this.showEmbedBillPage("hom_onbrdinfo", "onbrdpanel", dataIds, OperationStatus.VIEW, "");
    }

    private void showActivityInfo(Tuple<String, String> dataIds) {
        Long onbrdId = Long.valueOf((String)dataIds.item1);
        DynamicObject activityOverviewDy = IActivityDomainService.getInstance().findActivityInfo("id,activityscheme", new QFilter("onbrd", "=", (Object)onbrdId));
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        baseShowParameter.getOpenStyle().setTargetKey("activitypanel");
        baseShowParameter.setCustomParam("onbrdid", (Object)onbrdId);
        baseShowParameter.setFormId("hom_activityoverview");
        baseShowParameter.setStatus(OperationStatus.VIEW);
        if (!HRObjectUtils.isEmpty((Object)activityOverviewDy)) {
            baseShowParameter.setPkId((Object)activityOverviewDy.getLong("id"));
        }
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void showEntryBaseInfo(String pageNumber, String targetKey, Long onbrdId, String billNo) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        formShowParameter.setCustomParam("id", (Object)onbrdId);
        formShowParameter.setCustomParam("billno", (Object)billNo);
        formShowParameter.setCustomParam("viewtype", this.getView().getFormShowParameter().getCustomParam("viewtype"));
        formShowParameter.setFormId(pageNumber);
        formShowParameter.setStatus(OperationStatus.EDIT);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(pageNumber, formShowParameter.getPageId());
        this.getView().showForm(formShowParameter);
    }

    private void reloadAllPage(String pageNumber) {
        this.reloadAllPage(pageNumber, "", "");
    }

    private void reloadAllPage(String pageNumber, String tipNotification, String errorNotification) {
        IFormView childView = this.getEmbedPageView(pageNumber);
        if (childView == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"HomOnbrdDataBaseEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        IDataModel dataModel = childView.getModel();
        if (dataModel instanceof BillModel) {
            BillModel billModel = (BillModel)dataModel;
            Object onbrdId = billModel.getPKValue();
            if (onbrdId == null || Long.parseLong(onbrdId.toString()) == 0L) {
                IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                onbrdId = pageCache.get("id");
            }
            String name = billModel.getDataEntity().getString("name");
            DynamicObject candidate = billModel.getDataEntity().getDynamicObject("candidate");
            String candidateId = HRObjectUtils.isEmpty((Object)candidate) ? "0" : candidate.getString("id");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hom_persononbrdhandlebody");
            showParameter.setCustomParam("checkRightAppId", (Object)this.getView().getFormShowParameter().getAppId());
            String viewType = billModel.getDataEntity().getString("viewtype");
            if (ViewTypeEnum.AGAIN.getCode().equals(viewType)) {
                showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u518d\u5165\u804c\u529e\u7406\u5355-%s", (String)"OnbrdBodyInfoPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]), name));
            } else {
                showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5165\u804c\u529e\u7406\u5355-%s", (String)"OnbrdBodyInfoPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), name));
            }
            showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("onbrdid", (Object)String.valueOf(onbrdId));
            showParameter.setCustomParam("candidateid", (Object)candidateId);
            showParameter.setCustomParam(TIP_NOTIFICATION, (Object)tipNotification);
            showParameter.setCustomParam(ERROR_NOTIFICATION, (Object)errorNotification);
            this.getView().showForm(showParameter);
            this.setNoChange();
        }
    }

    private void clickOnPageTop(String opKey, Tuple<String, String> dataIds) {
        long id = Long.parseLong((String)dataIds.item1);
        DynamicObject onbrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBill("name", new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (!(HRStringUtils.equals((String)opKey, (String)OPKEY_START) || HRStringUtils.equals((String)opKey, (String)OPKEY_CONFIRM) || HRStringUtils.equals((String)opKey, (String)OPKEY_BREAKUP) || HRStringUtils.equals((String)opKey, (String)MODIFY))) {
            return;
        }
        HashMap clickOnPageTopMap = Maps.newHashMapWithExpectedSize((int)4);
        clickOnPageTopMap.put(MODIFY, () -> this.modify(dataIds, id, onbrdBill));
        clickOnPageTopMap.put(OPKEY_BREAKUP, () -> this.breakup(dataIds));
        clickOnPageTopMap.put(OPKEY_START, () -> this.startFlow(dataIds, id, onbrdBill));
        clickOnPageTopMap.put(OPKEY_CONFIRM, () -> this.confirm(dataIds));
        clickOnPageTopMap.getOrDefault(opKey, () -> {}).run();
    }

    private void confirm(Tuple<String, String> dataIds) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IConfirmOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IConfirmOnbrdService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.beforeConfirmOnbrds(new Object[]{HRJSONUtils.getLongValOfCustomParam((Object)dataIds.item1)});
            return null;
        });
        Long onbrdId = this.getOnbrdIdAfterSaveBill(dataIds);
        if (onbrdId == 0L) {
            LOGGER.info("Fail to get the id of onbrdBill");
            return;
        }
        if (new OnbrdConfirmValidatorService().checkCertCountForOnbrdConfirm(this.getView(), 1, OPKEY_CONFIRM)) {
            this.showOnBrdConfirmPage(onbrdId, null);
        }
    }

    private void startFlow(Tuple<String, String> dataIds, long id, DynamicObject onbrdBill) {
        Long onbrdId;
        boolean isGetLock = IOnbrdCommonAppService.getInstance().tryRequireLockWithOnbrdBill(Long.valueOf(id), null, "hom_onbrdinfo");
        if (!isGetLock) {
            if (onbrdBill != null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7684\u4fe1\u606f\u6b63\u5728\u88ab\u7f16\u8f91\uff0c\u4e0d\u80fd\u542f\u52a8\u5165\u804c\u6d41\u7a0b\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"OnbrdBodyInfoPlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]), onbrdBill.getString("name")));
                return;
            }
        } else {
            IHomDataMutexService.getInstance().release((String)dataIds.item1, "hom_onbrdinfo", MODIFY);
        }
        if ((onbrdId = this.getOnbrdIdAfterSaveBill(dataIds)) == 0L) {
            LOGGER.info("Fail to get the id of onbrdBill");
            return;
        }
        this.showStartupConfirmPage(onbrdId);
    }

    private void breakup(Tuple<String, String> dataIds) {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)dataIds.item1);
        this.showOnbrdBreakupPage(onbrdId);
    }

    private void modify(Tuple<String, String> dataIds, long id, DynamicObject onbrdBill) {
        boolean isGetLock = IOnbrdCommonAppService.getInstance().tryRequireLockWithOnbrdBill(Long.valueOf(id), this.getView(), "hom_onbrdinfo");
        if (isGetLock) {
            this.showEmbedBillPage("hom_onbrdinfo", "onbrdpanel", dataIds, OperationStatus.EDIT, "");
            IFormView childView = this.getEmbedPageView("hom_onbrddetailhead");
            if (childView != null) {
                childView.invokeOperation(MODIFY);
                this.getView().sendFormAction(childView);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{MODIFY});
            this.getView().setVisible(Boolean.TRUE, new String[]{BARSAVE});
        }
    }

    private Long getOnbrdIdAfterSaveBill(Tuple<String, String> dataIds) {
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)dataIds.item1);
        if (this.checkEnableBeforeSave(onbrdId)) {
            OperationResult result = this.getInvokeChildOperationResult("hom_onbrdinfo", "save");
            if (result == null || result.getAllErrorOrValidateInfo().size() > 0 || !result.isSuccess()) {
                this.showOperationResult(this.getView(), result);
                return 0L;
            }
            onbrdId = HRStringUtils.isEmpty((String)((String)dataIds.item1)) || Long.parseLong((String)dataIds.item1) == 0L ? Long.valueOf(Long.parseLong(result.getSuccessPkIds().get(0).toString())) : Long.valueOf(Long.parseLong((String)dataIds.item1));
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put("id", onbrdId.toString());
        return onbrdId;
    }

    private void showStartupConfirmPage(Long onbrdId) {
        HashSet onbrdIdSet = Sets.newHashSetWithExpectedSize((int)1);
        onbrdIdSet.add(onbrdId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_BTN_START);
        new OnbrdStartUpAppServiceImpl().showStartupConfirmPage((Collection)onbrdIdSet, this.getView(), closeCallBack);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String name = e.getName();
        String value = CLOSE_MAP.get(name);
        if (value != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{CLOSE_MAP.get(name)});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        List successIds;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object childViewDataObject = closedCallBackEvent.getReturnData();
        if (HRStringUtils.equals((String)actionId, (String)KEY_BTN_START) && childViewDataObject instanceof List && !CollectionUtils.isEmpty((Collection)(successIds = (List)closedCallBackEvent.getReturnData()))) {
            new OnbrdStartUpAppServiceImpl().closedCallBack(this.getView(), successIds);
        }
        String errorNotification = "";
        if (HRStringUtils.equals((String)actionId, (String)"hom_onbrdconfirmsingle") && childViewDataObject instanceof Map) {
            Map resultMap = (Map)childViewDataObject;
            Boolean isSuccess = (Boolean)resultMap.get("isSuccess");
            if (!isSuccess.booleanValue()) {
                errorNotification = resultMap.get("failReason").toString();
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u5165\u804c\u6210\u529f", (String)"OnbrdBodyHandleInfoPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                return;
            }
        }
        if (HRStringUtils.equals((String)actionId, (String)"hom_onbrdbreakup") || HRStringUtils.equals((String)actionId, (String)"hom_onbrdconfirmsingle") || HRStringUtils.equals((String)actionId, (String)KEY_BTN_START)) {
            this.reloadAllPage("hom_onbrdinfo", "", errorNotification);
        }
        if ("hom_blacklistvalidconfirm".equals(actionId)) {
            IFormView childView = this.getEmbedPageView("hom_onbrdinfo");
            if (HRObjectUtils.isEmpty((Object)childView) || HRObjectUtils.isEmpty((Object)childViewDataObject)) {
                return;
            }
            childView.getPageCache().remove("hasOpenValidBlackForm");
            Map returnDataMap = (Map)childViewDataObject;
            String btnKey = (String)returnDataMap.get("btnKey");
            String blackListId = (String)returnDataMap.get("blackListId");
            String ignoreReason = (String)returnDataMap.get("ignorereason");
            if ("btnok".equals(btnKey)) {
                childView.getPageCache().put(blackListId, ignoreReason);
                childView.getModel().getDataEntity().set("ignorereason", (Object)ignoreReason);
                childView.getModel().getDataEntity().set("passblackliststatus", (Object)OnbrdBlackListStatusEnum.PASS.getValue());
                this.getView().sendFormAction(childView);
                return;
            }
            if ("btnno".equals(btnKey) || "btncancel".equals(btnKey)) {
                childView.getModel().getDataEntity().set("ignorereason", null);
                childView.getModel().getDataEntity().set("passblackliststatus", (Object)OnbrdBlackListStatusEnum.NO_PASS.getValue());
                this.getView().sendFormAction(childView);
            }
        }
    }

    private void showOnBrdConfirmPage(Long onbrdId, String operateKey) {
        DynamicObject[] onbrdBillInfos = new OnbrdConfirmAppServiceImpl().getOnbrdBillsForShowPage(new Long[]{onbrdId});
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "hom_onbrdconfirmsingle");
        new OnbrdConfirmAppServiceImpl().showOnBrdConfirmPageWithOneData(this.getView(), onbrdBillInfos[0], closeCallBack, operateKey);
    }

    private void showOnbrdBreakupPage(Long onbrdId) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "hom_onbrdbreakup");
        new OnbrdBreakupAppServiceImpl().showOnbrdBreakupPage(this.getView(), new Long[]{onbrdId}, closeCallBack);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)actionId, (String)BTN_CLOSE) && MessageBoxResult.Yes == resultValue) {
            this.setNoChange();
            this.getView().close();
        } else if (HRStringUtils.equals((String)actionId, (String)KEY_BTN_START)) {
            String errorNotification = "";
            Long onbrdId = Long.parseLong((String)this.getOnbrdId().item1);
            if (MessageBoxResult.Yes == resultValue) {
                OperationResult operationResult;
                if (onbrdId == null || onbrdId == 0L) {
                    IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                    onbrdId = Long.parseLong(pageCache.get("id"));
                    LOGGER.info("onbrdId:", (Object)onbrdId);
                    if (onbrdId == 0L) {
                        return;
                    }
                }
                if ((operationResult = new OnbrdStartUpAppServiceImpl().closedCallBack(this.getView(), (List)ImmutableList.of((Object)onbrdId))) != null && !operationResult.isSuccess()) {
                    LOGGER.info("operationResult.isSuccess():{}", (Object)operationResult.isSuccess());
                    if (!operationResult.isSuccess() && !CollectionUtils.isEmpty((Collection)operationResult.getAllErrorOrValidateInfo())) {
                        errorNotification = ((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
                    }
                }
                this.reloadAllPage("hom_onbrdinfo", "", errorNotification);
            } else if (onbrdId == null || onbrdId == 0L) {
                this.reloadAllPage("hom_onbrdinfo");
            }
        } else if (HRStringUtils.equals((String)actionId, (String)"showMessage")) {
            this.getView().close();
        }
    }

    private void setNoChange() {
        IFormView childView = this.getEmbedPageView("hom_onbrdinfo");
        if (childView == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"HomOnbrdDataBaseEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        } else {
            this.setViewNotChange(childView);
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        super.beforeClosed(beforeClosedEvent);
        if (!this.checkDataChange()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u51fa\uff1f", (String)"OnbrdBodyInfoPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_CLOSE, (IFormPlugin)this));
            beforeClosedEvent.setCancel(true);
            return;
        }
        Long onbrdBillId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("onbrdid"));
        IOnbrdCommonAppService.getInstance().releaseLockWithOnbrdBill(onbrdBillId, "hom_onbrdinfo");
        this.invokeChildOperationResult("hom_onbrdinfo", "close");
    }

    private boolean checkEnableBeforeSave(Long onbrdBillId) {
        if (onbrdBillId == null || onbrdBillId == 0L) {
            return true;
        }
        String properties = "name" + "," + "enrollstatus";
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdBillId);
        DynamicObject onbrdBillDy = IOnbrdBillDomainService.getInstance().findOnbrdBill(properties, new QFilter[]{qFilter});
        if (HRObjectUtils.isEmpty((Object)onbrdBillDy)) {
            return true;
        }
        String enrollStatus = onbrdBillDy.getString("enrollstatus");
        if (HRStringUtils.equals((String)enrollStatus, (String)OnbrdStatusEnum.WAIT_START.getValue()) || HRStringUtils.equals((String)enrollStatus, (String)OnbrdStatusEnum.WAIT_ONBRD.getValue())) {
            return true;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5165\u804c\u6d41\u7a0b\u5df2\u7ed3\u675f\uff0c\u4e0d\u53ef\u7f16\u8f91\u5165\u804c\u4fe1\u606f\u3002", (String)"OnbrdBodyHandleInfoPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        return false;
    }
}

