/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.onbrd.IOnbrdBreakupAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.sdk.hr.common.entity.ValidResult;
import kd.sdk.hr.common.enums.TipTypeEnum;

public class OnbrdBreakupEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(OnbrdBreakupEdit.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btn_confirm"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("breakupreason");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        DynamicObject breakupReasonDynamicObject;
        if (!HRStringUtils.equals((String)"breakupreason", (String)event.getProperty().getName())) {
            return;
        }
        FormShowParameter formShowParameter = event.getFormShowParameter();
        ListShowParameter showParameter = (ListShowParameter)formShowParameter;
        IDataModel dataModel = this.getModel();
        DynamicObject breakupTypeDy = dataModel.getDataEntity().getDynamicObject("breakuptype");
        if (!HRObjectUtils.isEmpty((Object)breakupTypeDy)) {
            long breakupTypeId = breakupTypeDy.getLong("id");
            QFilter typeFilter = new QFilter("breakuptype", "=", (Object)breakupTypeId);
            showParameter.getListFilterParameter().getQFilters().add(typeFilter);
        }
        if (!HRObjectUtils.isEmpty((Object)(breakupReasonDynamicObject = dataModel.getDataEntity().getDynamicObject("breakupreason")))) {
            long breakupReasonId = breakupReasonDynamicObject.getLong("id");
            QFilter typeFilter = new QFilter("id", "!=", (Object)breakupReasonId);
            showParameter.getListFilterParameter().getQFilters().add(typeFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String name = propertyChangedArgs.getProperty().getName();
        if (HRStringUtils.equals((String)"breakuptype", (String)name)) {
            Object newValue = propertyChangedArgs.getChangeSet()[0].getNewValue();
            Object oldValue = propertyChangedArgs.getChangeSet()[0].getOldValue();
            DynamicObject breakupTypeDy = this.getModel().getDataEntity().getDynamicObject("breakuptype");
            if (HRObjectUtils.isEmpty((Object)breakupTypeDy)) {
                this.getModel().setValue("breakupreason", null);
                this.getView().setEnable(Boolean.FALSE, new String[]{"breakupreason"});
                return;
            }
            if (!newValue.equals(oldValue)) {
                this.getModel().setValue("breakupreason", null);
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"breakupreason"});
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getView().setEnable(Boolean.FALSE, new String[]{"breakupreason"});
        List personIds = (List)this.getView().getFormShowParameter().getCustomParam("breakup_onbrd_person_ids");
        if (CollectionUtils.isEmpty((Collection)personIds)) {
            return;
        }
        int personCount = personIds.size();
        if (personCount > 1) {
            String labelTips = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7ec8\u6b62\u5165\u804c\u540e\uff0c\u6240\u9009\u5165\u804c\u4eba\u5458\uff08%s\u4eba\uff09\u7684\u5165\u804c\u6d41\u7a0b\u5c06\u5168\u90e8\u7ec8\u6b62\uff0c\u4e14\u4e0d\u53ef\u64a4\u9500\u3002", (String)"OnbrdBreakupEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), personCount);
            Label lblMsgText = (Label)this.getView().getControl("label_tips");
            lblMsgText.setText(labelTips);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Object object = evt.getSource();
        if (!(object instanceof Button)) {
            return;
        }
        Button button = (Button)object;
        String key = button.getKey();
        if ("btn_confirm".equals(key)) {
            boolean checkPermResult = IOnbrdCommonAppService.getInstance().checkPermissionAndShowTips("hom_personwaitonbrd", "24IKE4ZWX1B7", this.getView());
            if (!checkPermResult) {
                evt.setCancel(true);
                return;
            }
            List breakupOnbrdBillIds = (List)this.getView().getFormShowParameter().getCustomParam("breakup_onbrd_person_ids");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Map validBreakupResult = IOnbrdBreakupAppService.getInstance().validateBreakupData(breakupOnbrdBillIds, dataEntity);
            if (!CollectionUtils.isEmpty((Map)validBreakupResult)) {
                List errors = validBreakupResult.values().stream().filter(validResult -> TipTypeEnum.ERROR.getName().equals(validResult.getTipType())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(errors)) {
                    this.getView().showErrorNotification(((ValidResult)errors.get(0)).getMessage());
                    return;
                }
                List warns = validBreakupResult.values().stream().filter(validResult -> TipTypeEnum.WARNING.getName().equals(validResult.getTipType())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(warns)) {
                    this.getView().showTipNotification(((ValidResult)warns.get(0)).getMessage());
                    return;
                }
            }
            List onbrdBillIds = breakupOnbrdBillIds.stream().map(breakupId -> Long.parseLong(breakupId.toString())).collect(Collectors.toList());
            IHomDataMutexService homDataMutexService = IHomDataMutexService.getInstance();
            Map batchRequireResult = homDataMutexService.batchRequire(onbrdBillIds, "hom_onbrdinfo", "breakup");
            List failLockIds = batchRequireResult.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
            List successLockIds = batchRequireResult.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            try {
                if (!CollectionUtils.isEmpty(failLockIds)) {
                    IOnbrdCommonAppService.getInstance().showMutexMsgWithOnbrdBill(this.getView(), failLockIds, ResManager.loadKDString((String)"\u7ec8\u6b62\u5165\u804c", (String)"OnbrdBreakupEdit_15", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }
            finally {
                homDataMutexService.batchRelease(successLockIds, "hom_onbrdinfo", "breakup");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object object = evt.getSource();
        if (!(object instanceof Button)) {
            return;
        }
        Button button = (Button)object;
        String key = button.getKey();
        if ("btn_confirm".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject breakupType = dataEntity.getDynamicObject("breakuptype");
            DynamicObject breakupReason = dataEntity.getDynamicObject("breakupreason");
            String breakupRemarks = dataEntity.getString("breakupremarks");
            List breakupOnbrdBillIds = (List)this.getView().getFormShowParameter().getCustomParam("breakup_onbrd_person_ids");
            IFormView parentView = this.getView().getParentView();
            OnbrdBreakupEdit formPlugin = parentView instanceof IListView ? this : null;
            logger.info("before breakupOnBrd");
            IOnbrdBreakupAppService.getInstance().doSomethingsWithBreakup(breakupOnbrdBillIds, breakupType, breakupReason, breakupRemarks, (AbstractFormPlugin)formPlugin);
            logger.info("after breakupOnBrd");
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("breakup_opkey", key);
            this.getView().returnDataToParent(result);
            if (parentView instanceof IListView) {
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
            }
            this.getView().close();
        }
    }
}

