/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.web.personmange;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hom.business.application.impl.rule.OnbrdConfirmValidatorService;
import kd.hr.hom.business.application.rule.IOnbrdConfirmValidatorService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.formplugin.common.PermissionHelper;
import org.apache.commons.lang3.time.DateUtils;

public class OnbrdConfirmMultiEdit
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(OnbrdConfirmMultiEdit.class);
    private static final String LBL_TOTALNUM = "totalnum";
    private static final String LBL_NOFITNUM = "nofitnum";
    private static final String LBL_DATEINVALIDNUM = "dateinvalidnum";
    private static final String LBL_TXT_INVALID_DATE = "lbltxt_invaliddate";
    private static final String LBL_DEPARTMENTINVALIDNUM = "departmentinvalidnum";
    private static final String LBL_TXT_INVALID_DEPARTMENT = "lbltxt_invaliddepartment";
    private static final String LBL_BUSINESSINVALIDNUM = "businessinvalidnum";
    private static final String LBL_TXT_INVALID_USINESS = "lbltxt_invalidbusiness";
    private static final String LBL_POSITIONINVALIDNUM = "positioninvalidnum";
    private static final String LBL_TXT_INVALID_POSITION = "lbltxt_invalidposition";
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String EXPORT_EXCEL = "exportexcel";
    private static final String CHECK_MESSAGE = "checkmessage";
    public static final String SELECT_PROPERTIES = "id,name,candidate,resumeno,employeeno,certificatetype.name,certificatenumber,effectdate,iseligibleonboard";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        DynamicObject[] dynamicObjects = this.getOnbrdPersonInfo();
        this.initEntry(dynamicObjects);
        int nofitnum = (Integer)this.getView().getFormShowParameter().getCustomParam(LBL_NOFITNUM);
        Label nofitNumLabel = (Label)this.getView().getControl(LBL_NOFITNUM);
        nofitNumLabel.setText(String.valueOf(nofitnum));
        this.updateLabel(dynamicObjects);
        this.initScopeForEffectDateControl();
    }

    private DynamicObject[] getOnbrdPersonInfo() {
        List fitIds = (List)this.getView().getFormShowParameter().getCustomParam("fitIds");
        QFilter idFilter = new QFilter("id", "in", (Object)fitIds);
        return IOnbrdBillDomainService.getInstance().findOnbrdBills(SELECT_PROPERTIES, new QFilter[]{idFilter});
    }

    private void initScopeForEffectDateControl() {
        DateEdit effectDateEdit = (DateEdit)this.getView().getControl("effectdate");
        effectDateEdit.setMaxDate(new Date());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_CONFIRM});
        this.addClickListeners(new String[]{EXPORT_EXCEL});
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            Control control = (Control)evt.getSource();
            switch (control.getKey()) {
                case "btn_confirm": {
                    if (PermissionHelper.getParentViewPerm(this.getView())) {
                        return;
                    }
                    if (!this.validateDataWithDB()) break;
                    this.doConfirm();
                    break;
                }
                case "exportexcel": {
                    this.exportExcel();
                    break;
                }
            }
        }
    }

    private boolean validateDataWithDB() {
        List fitIds = (List)this.getView().getFormShowParameter().getCustomParam("fitIds");
        QFilter idFilter = new QFilter("id", "in", (Object)fitIds);
        String peoperties = "effectdate" + ',' + "name";
        DynamicObject[] onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills(peoperties, new QFilter[]{idFilter});
        Map<Long, DynamicObject> onbrdBillMap = Stream.of(onbrdBills).collect(Collectors.toMap(onbrdBill -> onbrdBill.getLong("id"), onbrdBill -> onbrdBill, (olValue, newValue) -> newValue));
        boolean flag = true;
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int endIndex = entry.getEntryData().getEndIndex();
        StringBuilder nameUnEnable = new StringBuilder();
        StringBuilder nameEnable = new StringBuilder();
        for (int i = 0; i < endIndex; ++i) {
            DynamicObject onbrdBillFromPage = this.getModel().getEntryRowEntity(ENTRY_ENTITY, i);
            DynamicObject onbrdBillFromDB = onbrdBillMap.get(onbrdBillFromPage.getLong("id"));
            Date effectDateFromPage = onbrdBillFromPage.getDate("effectdate");
            Date effectDateFromDB = onbrdBillFromDB.getDate("effectdate");
            if (effectDateFromDB == null || HRDateTimeUtils.dayAfter((Date)HRDateTimeUtils.truncateDate((Date)effectDateFromDB), (Date)HRDateTimeUtils.truncateDate((Date)effectDateFromPage))) {
                nameUnEnable.append(onbrdBillFromDB.getString("name")).append('\uff0c');
                flag = false;
                continue;
            }
            if (!HRDateTimeUtils.dayBefore((Date)HRDateTimeUtils.truncateDate((Date)effectDateFromDB), (Date)HRDateTimeUtils.truncateDate((Date)effectDateFromPage))) continue;
            nameEnable.append(onbrdBillFromDB.getString("name")).append('\uff0c');
            flag = false;
        }
        if (HRStringUtils.isNotEmpty((String)nameUnEnable.toString())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7684\u5165\u804c\u65e5\u671f\u5df2\u88ab\u4fee\u6539\uff0c\u6682\u4e0d\u53ef\u786e\u8ba4\u5165\u804c\u3002", (String)"OnbrdConfirmMultiEdit_8", (String)"hr-hom-formplugin", (Object[])new Object[0]), nameUnEnable.substring(0, nameUnEnable.length() - 1)));
        }
        if (HRStringUtils.isNotEmpty((String)nameEnable.toString())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7684\u5165\u804c\u65e5\u671f\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"OnbrdConfirmMultiEdit_9", (String)"hr-hom-formplugin", (Object[])new Object[0]), nameEnable.substring(0, nameEnable.length() - 1)));
        }
        return flag;
    }

    private void doConfirm() {
        IFormView formView = this.getView();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        formView.returnDataToParent((Object)dynamicObjectCollection);
        formView.close();
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        Object[] changeDatas;
        String propertyName = propertyChangedArgs.getProperty().getName();
        if ("effectdate".equals(propertyName) && !HRArrayUtils.isEmpty((Object[])(changeDatas = propertyChangedArgs.getChangeSet()))) {
            int rowIndex = changeDatas[0].getRowIndex();
            DynamicObject simpleInfo = changeDatas[0].getDataEntity();
            OnbrdConfirmValidatorService onbrdConfirmValidatorService = new OnbrdConfirmValidatorService();
            ImmutableSet onbrdBillIdSet = ImmutableSet.of((Object)simpleInfo.getLong("id"));
            DynamicObject onbrdBillInfoForCheck = onbrdConfirmValidatorService.getOnbrdBillForCheckValid((Collection)onbrdBillIdSet)[0];
            onbrdConfirmValidatorService.takeConfirmPageInfoToTargetObject(simpleInfo, onbrdBillInfoForCheck);
            this.getModel().setValue(CHECK_MESSAGE, (Object)onbrdConfirmValidatorService.checkOnbrdBillInfo(onbrdBillInfoForCheck), rowIndex);
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
            this.updateLabel((DynamicObject[])dynamicObjectCollection.toArray((Object[])new DynamicObject[dynamicObjectCollection.size()]));
        }
    }

    private void initEntry(DynamicObject[] dynamicObjects) {
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        IDataModel dataModel = this.getModel();
        if (dataModel instanceof AbstractFormDataModel) {
            AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("id", new Object[0]);
            vs.addField("name", new Object[0]);
            vs.addField("resumeno", new Object[0]);
            vs.addField("employeeno", new Object[0]);
            vs.addField("certificatetype", new Object[0]);
            vs.addField("certificatenumber", new Object[0]);
            vs.addField("effectdate", new Object[0]);
            vs.addField(CHECK_MESSAGE, new Object[0]);
            OnbrdConfirmValidatorService onbrdConfirmValidatorService = new OnbrdConfirmValidatorService();
            Set onbrdBillIdSet = Arrays.stream(dynamicObjects).map(onbrdBill -> onbrdBill.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] onbrdBillsForCheckValid = onbrdConfirmValidatorService.getOnbrdBillForCheckValid(onbrdBillIdSet);
            Map<Long, String> validResultMap = Arrays.stream(onbrdBillsForCheckValid).collect(Collectors.toMap(onbrdBill -> onbrdBill.getLong("id"), arg_0 -> ((IOnbrdConfirmValidatorService)onbrdConfirmValidatorService).checkOnbrdBillInfo(arg_0), (oldValue, newValue) -> newValue));
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long onbrdBillId = dynamicObject.getLong("id");
                DynamicObject certificateType = dynamicObject.getDynamicObject("certificatetype");
                Long certificateTypeId = Objects.isNull(certificateType) ? null : Long.valueOf(certificateType.getLong("id"));
                vs.addRow(new Object[]{onbrdBillId, dynamicObject.get("name"), dynamicObject.get("candidate.number"), dynamicObject.get("employeeno"), certificateTypeId, dynamicObject.get("certificatenumber"), dynamicObject.get("effectdate"), validResultMap.get(onbrdBillId)});
            }
            model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
            model.endInit();
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        FormOperate formOperate;
        String operationKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        Object object = afterDoOperationEventArgs.getSource();
        if (object instanceof FormOperate && "deleteentry".equals(operationKey = (formOperate = (FormOperate)object).getOperateKey())) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
            this.updateLabel((DynamicObject[])dynamicObjectCollection.toArray((Object[])new DynamicObject[dynamicObjectCollection.size()]));
        }
    }

    private void updateLabel(DynamicObject[] onbrdBillInfos) {
        Label totalNumLabel = (Label)this.getView().getControl(LBL_TOTALNUM);
        Integer nofitNum = Integer.valueOf(this.getView().getFormShowParameter().getCustomParam(LBL_NOFITNUM).toString());
        totalNumLabel.setText(String.valueOf(onbrdBillInfos.length + nofitNum));
        int dateInvalidNum = 0;
        int departmentInvalidNum = 0;
        int positionInvalidNum = 0;
        if (HRArrayUtils.isEmpty((Object[])onbrdBillInfos)) {
            this.updateLabel(dateInvalidNum, departmentInvalidNum, positionInvalidNum);
            return;
        }
        Date currentDate = new Date();
        OnbrdConfirmValidatorService onbrdConfirmValidatorService = new OnbrdConfirmValidatorService();
        Set onbrdBillIdSet = Stream.of(onbrdBillInfos).map(simpleInfo -> simpleInfo.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] onbrdBillDetailInfos = onbrdConfirmValidatorService.getOnbrdBillForCheckValid(onbrdBillIdSet);
        Map<Long, DynamicObject> onbrdBillDetailInfoMap = Stream.of(onbrdBillDetailInfos).collect(Collectors.toMap(onbrdBillInfo -> onbrdBillInfo.getLong("id"), onbrdBillInfo -> onbrdBillInfo, (oldValue, newValue) -> newValue));
        for (DynamicObject simpleInfo2 : onbrdBillInfos) {
            DynamicObject onbrdBillDetailInfo = onbrdBillDetailInfoMap.get(simpleInfo2.getLong("id"));
            Date effectDate = simpleInfo2.getDate("effectdate");
            onbrdBillDetailInfo.set("effectdate", (Object)effectDate);
            if (Objects.isNull(effectDate) || !DateUtils.isSameDay((Date)currentDate, (Date)effectDate)) {
                ++dateInvalidNum;
            }
            if (onbrdConfirmValidatorService.checkIfInvalidWithField(onbrdBillDetailInfo, "aadminorg")) {
                ++departmentInvalidNum;
            }
            if (!onbrdConfirmValidatorService.checkIfInvalidWithField(onbrdBillDetailInfo, "ajob")) continue;
            ++positionInvalidNum;
        }
        this.updateLabel(dateInvalidNum, departmentInvalidNum, positionInvalidNum);
    }

    private void updateLabel(int dateInvalidNum, int departmentInvalidNum, int positionInvalidNum) {
        IFormView formView = this.getView();
        formView.setVisible(Boolean.TRUE, new String[]{LBL_DATEINVALIDNUM, LBL_TXT_INVALID_DATE, LBL_DEPARTMENTINVALIDNUM, LBL_TXT_INVALID_DEPARTMENT, LBL_BUSINESSINVALIDNUM, LBL_TXT_INVALID_USINESS, LBL_POSITIONINVALIDNUM, LBL_TXT_INVALID_POSITION});
        formView.setVisible(Boolean.FALSE, new String[]{LBL_BUSINESSINVALIDNUM, LBL_TXT_INVALID_USINESS});
        Label dateInvalidNumLabel = (Label)formView.getControl(LBL_DATEINVALIDNUM);
        dateInvalidNumLabel.setText(String.valueOf(dateInvalidNum));
        if (dateInvalidNum == 0) {
            formView.setVisible(Boolean.FALSE, new String[]{LBL_DATEINVALIDNUM, LBL_TXT_INVALID_DATE});
        }
        Label departmentInvalidNumLabel = (Label)formView.getControl(LBL_DEPARTMENTINVALIDNUM);
        departmentInvalidNumLabel.setText(String.valueOf(departmentInvalidNum));
        if (departmentInvalidNum == 0) {
            formView.setVisible(Boolean.FALSE, new String[]{LBL_DEPARTMENTINVALIDNUM, LBL_TXT_INVALID_DEPARTMENT});
        }
        Label positionInvalidNumLabel = (Label)formView.getControl(LBL_POSITIONINVALIDNUM);
        positionInvalidNumLabel.setText(String.valueOf(positionInvalidNum));
        if (positionInvalidNum == 0) {
            formView.setVisible(Boolean.FALSE, new String[]{LBL_POSITIONINVALIDNUM, LBL_TXT_INVALID_POSITION});
        }
    }

    private void exportExcel() {
        String excelName = ResManager.loadKDString((String)"\u6279\u91cf\u786e\u8ba4\u5165\u804c", (String)"OnbrdConfirmMultiEdit_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        List<Map<String, Object>> exportDataList = this.getTemplateExportDataList(this.getModel().getEntryEntity(ENTRY_ENTITY));
        List<HRExportHeadObject> headDataLst = this.getHeadDataList();
        String exportUrl = null;
        try {
            exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, exportDataList, headDataLst);
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
            this.getView().showErrMessage(iOException.getMessage(), " Fail to get export Excel url ! Reason: ");
        }
        if (!HRStringUtils.isEmpty((String)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }

    private List<HRExportHeadObject> getHeadDataList() {
        ArrayList<HRExportHeadObject> headdatalist = new ArrayList<HRExportHeadObject>(6);
        headdatalist.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"OnbrdConfirmMultiEdit_1", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("candidatenumber", ResManager.loadKDString((String)"\u5019\u9009\u4eba\u7f16\u53f7", (String)"OnbrdConfirmMultiEdit_2", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("employeeno", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"OnbrdConfirmMultiEdit_3", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("certificatetype.name", ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b", (String)"OnbrdConfirmMultiEdit_4", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("certificatenumber", ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801", (String)"OnbrdConfirmMultiEdit_5", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject("effectdate", ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f", (String)"OnbrdConfirmMultiEdit_6", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        headdatalist.add(new HRExportHeadObject(CHECK_MESSAGE, ResManager.loadKDString((String)"\u6821\u9a8c\u4fe1\u606f", (String)"OnbrdConfirmMultiEdit_7", (String)"hr-hom-formplugin", (Object[])new Object[0])));
        return headdatalist;
    }

    private List<Map<String, Object>> getTemplateExportDataList(DynamicObjectCollection dynamicObjects) {
        ArrayList<Map<String, Object>> exportdatalist = new ArrayList<Map<String, Object>>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> personInfoMap = new HashMap<String, Object>();
            personInfoMap.put("name", dynamicObject.getLocaleString("name").getLocaleValue());
            personInfoMap.put("candidatenumber", dynamicObject.get("resumeno"));
            personInfoMap.put("employeeno", dynamicObject.get("employeeno"));
            Object certificateType = dynamicObject.get("certificatetype");
            if (certificateType instanceof DynamicObject) {
                OrmLocaleValue certificateTypeName = (OrmLocaleValue)((DynamicObject)certificateType).get("name");
                String localName = certificateTypeName == null ? "" : certificateTypeName.getLocaleValue();
                personInfoMap.put("certificatetype.name", localName);
            } else {
                personInfoMap.put("certificatetype.name", certificateType);
            }
            personInfoMap.put("certificatenumber", dynamicObject.get("certificatenumber"));
            Date effectDate = dynamicObject.getDate("effectdate");
            if (Objects.nonNull(effectDate)) {
                personInfoMap.put("effectdate", HRDateTimeUtils.format((Date)effectDate, (String)"yyyy/MM/dd"));
            }
            personInfoMap.put(CHECK_MESSAGE, dynamicObject.get(CHECK_MESSAGE));
            exportdatalist.add(personInfoMap);
        }
        return exportdatalist;
    }
}

